/*
 * Copyright (C) 2005 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#ifndef _FBSD_OS_H_
#define _FBSD_OS_H_

// defines for options parameter of samp_load_image_notify_routine()
#define LOPTS_1ST_MODREC     0x1
#define LOPTS_GLOBAL_MODULE  0x2
#define LOPTS_EXE            0x4

#define FOR_EACH_TASK        for_each_process

#if defined(DRV_IA32)
#define FIND_VMA(mm, data)   find_vma ((mm), (U32)(data));
#endif
#if defined(DRV_EM64T)
#define FIND_VMA(mm, data)   find_vma ((mm), (U64)(data));
#endif

extern VOID
FBSD_OS_Install_Hooks (
    VOID
);

extern VOID
FBSD_OS_Uninstall_Hooks (
    VOID
);

extern OS_STATUS
FBSD_OS_Enum_Process_Modules (
    DRV_BOOL at_end
);

#endif
