/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.lib.impl;

import com.intellij.debugger.streams.core.lib.HandlerFactory;
import com.intellij.debugger.streams.core.lib.InterpreterFactory;
import com.intellij.debugger.streams.core.lib.LibrarySupport;
import com.intellij.debugger.streams.core.lib.ResolverFactory;
import com.intellij.debugger.streams.core.resolve.EmptyResolver;
import com.intellij.debugger.streams.core.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.core.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.core.trace.IntermediateCallHandler;
import com.intellij.debugger.streams.core.trace.TerminatorCallHandler;
import com.intellij.debugger.streams.core.trace.dsl.Dsl;
import com.intellij.debugger.streams.core.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.core.trace.impl.handler.unified.PeekTraceHandler;
import com.intellij.debugger.streams.core.trace.impl.handler.unified.TerminatorTraceHandler;
import com.intellij.debugger.streams.core.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.core.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.core.wrapper.StreamCallType;
import com.intellij.debugger.streams.core.wrapper.TerminatorStreamCall;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/streams/core/lib/impl/DefaultLibrarySupport;", "Lcom/intellij/debugger/streams/core/lib/LibrarySupport;", "<init>", "()V", "createHandlerFactory", "Lcom/intellij/debugger/streams/core/lib/HandlerFactory;", "dsl", "Lcom/intellij/debugger/streams/core/trace/dsl/Dsl;", "interpreterFactory", "Lcom/intellij/debugger/streams/core/lib/InterpreterFactory;", "getInterpreterFactory", "()Lcom/intellij/debugger/streams/core/lib/InterpreterFactory;", "resolverFactory", "Lcom/intellij/debugger/streams/core/lib/ResolverFactory;", "getResolverFactory", "()Lcom/intellij/debugger/streams/core/lib/ResolverFactory;", "intellij.debugger.streams.core"})
public final class DefaultLibrarySupport
implements LibrarySupport {
    @NotNull
    private final InterpreterFactory interpreterFactory = new InterpreterFactory(){

        public CallTraceInterpreter getInterpreter(String callName, StreamCallType callType) {
            Intrinsics.checkNotNullParameter((Object)callName, (String)"callName");
            Intrinsics.checkNotNullParameter((Object)((Object)callType), (String)"callType");
            return new SimplePeekCallTraceInterpreter();
        }
    };
    @NotNull
    private final ResolverFactory resolverFactory = new ResolverFactory(){

        public ValuesOrderResolver getResolver(String callName, StreamCallType callType) {
            Intrinsics.checkNotNullParameter((Object)callName, (String)"callName");
            Intrinsics.checkNotNullParameter((Object)((Object)callType), (String)"callType");
            return new EmptyResolver();
        }
    };

    @Override
    @NotNull
    public HandlerFactory createHandlerFactory(@NotNull Dsl dsl) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        return new HandlerFactory(dsl){
            final /* synthetic */ Dsl $dsl;
            {
                this.$dsl = $dsl;
            }

            public IntermediateCallHandler getForIntermediate(int number, IntermediateStreamCall call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                String string = call.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                GenericType genericType = call.getTypeBefore();
                Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getTypeBefore(...)");
                GenericType genericType2 = call.getTypeAfter();
                Intrinsics.checkNotNullExpressionValue((Object)genericType2, (String)"getTypeAfter(...)");
                return new PeekTraceHandler(number, string, genericType, genericType2, this.$dsl);
            }

            public TerminatorCallHandler getForTermination(TerminatorStreamCall call, String resultExpression) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)resultExpression, (String)"resultExpression");
                return new TerminatorTraceHandler(call, this.$dsl);
            }
        };
    }

    @Override
    @NotNull
    public InterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    @Override
    @NotNull
    public ResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }
}

