/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.ui.impl;

import com.intellij.CommonBundle;
import com.intellij.debugger.streams.core.StreamDebuggerBundle;
import com.intellij.debugger.streams.core.resolve.ResolvedStreamCall;
import com.intellij.debugger.streams.core.resolve.ResolvedStreamChain;
import com.intellij.debugger.streams.core.trace.CollectionTreeBuilder;
import com.intellij.debugger.streams.core.trace.DebuggerCommandLauncher;
import com.intellij.debugger.streams.core.trace.IntermediateState;
import com.intellij.debugger.streams.core.trace.NextAwareState;
import com.intellij.debugger.streams.core.trace.PrevAwareState;
import com.intellij.debugger.streams.core.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.ui.TraceController;
import com.intellij.debugger.streams.core.ui.impl.CollectionTree;
import com.intellij.debugger.streams.core.ui.impl.CollectionView;
import com.intellij.debugger.streams.core.ui.impl.ExceptionView;
import com.intellij.debugger.streams.core.ui.impl.FlatView;
import com.intellij.debugger.streams.core.ui.impl.StreamTracesMappingView;
import com.intellij.debugger.streams.core.ui.impl.TraceControllerImpl;
import com.intellij.debugger.streams.core.wrapper.QualifierExpression;
import com.intellij.debugger.streams.core.wrapper.StreamCall;
import com.intellij.debugger.streams.core.wrapper.StreamChain;
import com.intellij.debugger.streams.core.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.core.wrapper.TraceUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBDimension;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluationAwareTraceWindow
extends DialogWrapper {
    private static final String IS_FLAT_MODE_PROPERTY = "org.jetbrains.debugger.streams:isTraceWindowInFlatMode";
    private static final boolean IS_DEFAULT_MODE_FLAT = false;
    private static final int DEFAULT_WIDTH = 870;
    private static final int DEFAULT_HEIGHT = 400;
    private final MyCenterPane myCenterPane;
    private final List<MyPlaceholder> myTabContents;
    private final MyPlaceholder myFlatContent;
    private final JBTabsPaneImpl myTabsPane;
    private MyMode myMode;

    public EvaluationAwareTraceWindow(@NotNull XDebugSession session, @NotNull StreamChain chain) {
        if (session == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(0);
        }
        if (chain == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(1);
        }
        super(session.getProject(), true);
        this.myTabsPane = new JBTabsPaneImpl(session.getProject(), 1, this.getDisposable());
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(() -> EvaluationAwareTraceWindow.this.close(1));
            }
        }, this.myDisposable);
        this.setModal(false);
        this.setTitle(StreamDebuggerBundle.message("stream.debugger.dialog.title", new Object[0]));
        this.myCenterPane = new MyCenterPane();
        this.myCenterPane.add(MyMode.SPLIT.name(), this.myTabsPane.getComponent());
        this.myTabContents = new ArrayList<MyPlaceholder>();
        QualifierExpression qualifierExpression = chain.getQualifierExpression();
        MyPlaceholder firstTab = new MyPlaceholder();
        this.myTabsPane.insertTab(TraceUtil.formatQualifierExpression(qualifierExpression.getText(), 30), AllIcons.Debugger.Console, (Component)firstTab, qualifierExpression.getText(), 0);
        this.myTabContents.add(firstTab);
        int chainLength = chain.length();
        for (int i = 0; i < chainLength; ++i) {
            StreamCall call = chain.getCall(i);
            MyPlaceholder tab = new MyPlaceholder();
            String tabTitle = call.getTabTitle();
            String tabTooltip = call.getTabTooltip();
            this.myTabsPane.insertTab(tabTitle, AllIcons.Debugger.Console, (Component)tab, tabTooltip, i + 1);
            this.myTabContents.add(tab);
        }
        this.myFlatContent = new MyPlaceholder();
        this.myCenterPane.add(MyMode.FLAT.name(), this.myFlatContent);
        this.myCenterPane.setPreferredSize((Dimension)new JBDimension(870, 400));
        if (!PropertiesComponent.getInstance().isValueSet(IS_FLAT_MODE_PROPERTY)) {
            PropertiesComponent.getInstance().setValue(IS_FLAT_MODE_PROPERTY, false);
        }
        this.myMode = PropertiesComponent.getInstance().getBoolean(IS_FLAT_MODE_PROPERTY) ? MyMode.FLAT : MyMode.SPLIT;
        EvaluationAwareTraceWindow.updateWindowMode(this.myCenterPane, this.myMode);
        this.init();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.streams.ui.EvaluationAwareTraceWindow";
    }

    public void setTrace(@NotNull ResolvedTracingResult resolvedTrace, @NotNull DebuggerCommandLauncher launcher, @NotNull CollectionTreeBuilder builder) {
        if (resolvedTrace == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(2);
        }
        if (launcher == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(4);
        }
        if (Disposer.isDisposed((Disposable)this.myDisposable)) {
            return;
        }
        ResolvedStreamChain chain = resolvedTrace.getResolvedChain();
        assert (chain.length() == this.myTabContents.size());
        List<TraceControllerImpl> controllers = this.createControllers(resolvedTrace);
        if (controllers.isEmpty()) {
            return;
        }
        List<TraceElement> trace2 = controllers.get(0).getTrace();
        CollectionTree tree = CollectionTree.create(controllers.get(0).getStreamResult(), trace2, launcher, builder, "setTrace#Tree#0#");
        CollectionView sourceView = new CollectionView(tree);
        controllers.get(0).register(sourceView);
        this.myTabContents.get(0).setContent(sourceView, "Center");
        for (int i = 1; i < this.myTabContents.size() && (i != this.myTabContents.size() - 1 || !resolvedTrace.exceptionThrown() && !resolvedTrace.getSourceChain().getTerminationCall().returnsVoid().booleanValue()); ++i) {
            MyPlaceholder tab = this.myTabContents.get(i);
            TraceController previous = controllers.get(i - 1);
            TraceController current = controllers.get(i);
            StreamTracesMappingView view = new StreamTracesMappingView(launcher, previous, current, builder, "setTrace#MappingView#" + i + "#");
            tab.setContent(view, "Center");
        }
        TraceElement result = resolvedTrace.getResult();
        MyPlaceholder resultTab = this.myTabContents.get(this.myTabContents.size() - 1);
        if (resolvedTrace.exceptionThrown()) {
            label = new JBLabel(StreamDebuggerBundle.message("tab.content.exception.thrown", new Object[0]), 0);
            resultTab.setContent((JComponent)label, "Center");
            this.setTitle(StreamDebuggerBundle.message("stream.debugger.dialog.with.exception.title", new Object[0]));
            ExceptionView exceptionView = new ExceptionView(launcher, result, builder);
            Disposer.register((Disposable)this.myDisposable, (Disposable)exceptionView);
            this.myTabsPane.insertTab(StreamDebuggerBundle.message("exception.tab.name", new Object[0]), AllIcons.Nodes.ErrorIntroduction, (Component)exceptionView, "", 0);
            this.myTabsPane.setSelectedIndex(0);
        } else if (resolvedTrace.getSourceChain().getTerminationCall().returnsVoid().booleanValue()) {
            label = new JBLabel(StreamDebuggerBundle.message("tab.content.no.result", new Object[0]), 0);
            resultTab.setContent((JComponent)label, "Center");
        }
        FlatView flatView = new FlatView(controllers, launcher, builder, "setTrace#FlatView#");
        this.myFlatContent.setContent(flatView, "Center");
        this.myCenterPane.revalidate();
        this.myCenterPane.repaint();
    }

    public void setFailMessage(@NotNull @Nls String reason) {
        if (reason == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(5);
        }
        StreamEx.of(this.myTabContents).prepend((Object)this.myFlatContent).forEach(x -> x.setContent((JComponent)new JBLabel(reason, 0), "Center"));
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, CommonBundle.message((String)"action.text.close", (Object[])new Object[0]), 1)};
        if (actionArray == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = new Action[]{new MyToggleViewAction()};
        if (actionArray == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(7);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPane;
    }

    @NotNull
    private List<TraceControllerImpl> createControllers(@NotNull ResolvedTracingResult resolvedResult) {
        if (resolvedResult == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(8);
        }
        ArrayList<TraceControllerImpl> controllers = new ArrayList<TraceControllerImpl>();
        ResolvedStreamChain chain = resolvedResult.getResolvedChain();
        List<ResolvedStreamCall.Intermediate> intermediateCalls = chain.getIntermediateCalls();
        NextAwareState firstState = intermediateCalls.isEmpty() ? chain.getTerminator().getStateBefore() : intermediateCalls.get(0).getStateBefore();
        TraceControllerImpl firstController = new TraceControllerImpl(firstState);
        controllers.add(firstController);
        TraceControllerImpl prevController = firstController;
        for (ResolvedStreamCall.Intermediate intermediate : intermediateCalls) {
            PrevAwareState after = intermediate.getStateAfter();
            TraceControllerImpl controller = new TraceControllerImpl(after);
            prevController.setNextController(controller);
            controller.setPreviousController(prevController);
            prevController = controller;
            controllers.add(controller);
        }
        ResolvedStreamCall.Terminator terminator = chain.getTerminator();
        Object afterTerminationState = terminator.getStateAfter();
        if (afterTerminationState != null && !((TerminatorStreamCall)terminator.getCall()).returnsVoid().booleanValue()) {
            TraceControllerImpl terminationController = new TraceControllerImpl((IntermediateState)afterTerminationState);
            terminationController.setPreviousController(prevController);
            prevController.setNextController(terminationController);
            controllers.add(terminationController);
        }
        controllers.forEach(x -> Disposer.register((Disposable)this.myDisposable, (Disposable)x));
        ArrayList<TraceControllerImpl> arrayList = controllers;
        if (arrayList == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static void updateWindowMode(@NotNull MyCenterPane pane, @NotNull MyMode mode) {
        if (pane == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(10);
        }
        if (mode == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(11);
        }
        pane.getLayout().show((Container)pane, mode.name());
        PropertiesComponent.getInstance().setValue(IS_FLAT_MODE_PROPERTY, MyMode.FLAT.equals((Object)mode));
    }

    @NotNull
    @Nls
    private static String getButtonText(@NotNull MyMode currentState) {
        if (currentState == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(12);
        }
        String string = MyMode.SPLIT.equals((Object)currentState) ? StreamDebuggerBundle.message("stream.debugger.dialog.flat.mode.button", new Object[0]) : StreamDebuggerBundle.message("stream.debugger.dialog.split.mode.button", new Object[0]);
        if (string == null) {
            EvaluationAwareTraceWindow.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedTrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/core/ui/impl/EvaluationAwareTraceWindow";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedResult";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/core/ui/impl/EvaluationAwareTraceWindow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createControllers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTrace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFailMessage";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createControllers";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateWindowMode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getButtonText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 13 -> new IllegalStateException(string);
        };
    }

    private static class MyCenterPane
    extends JPanel {
        MyCenterPane() {
            super((LayoutManager)new JBCardLayout());
        }

        public JBCardLayout getLayout() {
            return (JBCardLayout)super.getLayout();
        }
    }

    private static enum MyMode {
        FLAT,
        SPLIT;

    }

    private static class MyPlaceholder
    extends JPanel {
        MyPlaceholder() {
            super(new BorderLayout());
            this.add((Component)new JBLabel(StreamDebuggerBundle.message("evaluation.in.progress", new Object[0]), 0), "Center");
        }

        void setContent(@NotNull JComponent view, String placement) {
            if (view == null) {
                MyPlaceholder.$$$reportNull$$$0(0);
            }
            Arrays.stream(this.getComponents()).forEach(this::remove);
            this.add((Component)view, placement);
            this.revalidate();
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/debugger/streams/core/ui/impl/EvaluationAwareTraceWindow$MyPlaceholder", "setContent"));
        }
    }

    private class MyToggleViewAction
    extends DialogWrapper.DialogWrapperAction {
        MyToggleViewAction() {
            super((DialogWrapper)EvaluationAwareTraceWindow.this, EvaluationAwareTraceWindow.getButtonText(EvaluationAwareTraceWindow.this.myMode));
        }

        protected void doAction(ActionEvent e) {
            JButton button = EvaluationAwareTraceWindow.this.getButton((Action)((Object)this));
            if (button != null) {
                EvaluationAwareTraceWindow.this.myMode = MyToggleViewAction.toggleMode(EvaluationAwareTraceWindow.this.myMode);
                button.setText(EvaluationAwareTraceWindow.getButtonText(EvaluationAwareTraceWindow.this.myMode));
            }
            EvaluationAwareTraceWindow.updateWindowMode(EvaluationAwareTraceWindow.this.myCenterPane, EvaluationAwareTraceWindow.this.myMode);
        }

        @NotNull
        private static MyMode toggleMode(@NotNull MyMode mode) {
            if (mode == null) {
                MyToggleViewAction.$$$reportNull$$$0(0);
            }
            MyMode myMode = MyMode.FLAT.equals((Object)mode) ? MyMode.SPLIT : MyMode.FLAT;
            if (myMode == null) {
                MyToggleViewAction.$$$reportNull$$$0(1);
            }
            return myMode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/streams/core/ui/impl/EvaluationAwareTraceWindow$MyToggleViewAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/streams/core/ui/impl/EvaluationAwareTraceWindow$MyToggleViewAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toggleMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toggleMode";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

