/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmReflectSymbols;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmDefaultParameterCleaner;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLowering;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.overrides.IrVisibilityUtilKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensions;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="SpecialAccess", prerequisite={JvmDefaultParameterCleaner.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020$H\u0016J\u0014\u0010)\u001a\u00020\u001c*\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u0010)\u001a\u00020\u001c*\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J\u001c\u0010/\u001a\u00020\u001c*\u00020*2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u000202H\u0002J\u0014\u00103\u001a\u00020\u001c*\u00020*2\u0006\u00104\u001a\u00020\u001cH\u0002J$\u00105\u001a\u00020\u001c*\u00020*2\u0006\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001cH\u0002J\u001c\u00109\u001a\u00020\u001c*\u00020*2\u0006\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u001cH\u0002J\u001c\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020=H\u0002J\"\u0010?\u001a\u00020\u001c*\u00020*2\u0006\u0010@\u001a\u00020,2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001c0BH\u0002J\u001c\u0010C\u001a\u00020\u001c*\u00020*2\u0006\u00100\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020EH\u0002J\u0014\u0010F\u001a\u00020\u001c*\u00020*2\u0006\u0010G\u001a\u00020\u001cH\u0002J*\u0010H\u001a\u00020\u001c*\u00020*2\u0006\u0010G\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u001c2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001c0BH\u0002J\u001c\u0010J\u001a\u00020\u001c*\u00020*2\u0006\u00100\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020EH\u0002J\u0014\u0010K\u001a\u00020\u001c*\u00020*2\u0006\u0010L\u001a\u00020\u001cH\u0002J\"\u0010M\u001a\u00020\u001c*\u00020*2\u0006\u0010L\u001a\u00020\u001c2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001c0BH\u0002J@\u0010N\u001a\u00020\u001c2\u0006\u00100\u001a\u00020,2\u0006\u0010D\u001a\u00020E2\b\u00107\u001a\u0004\u0018\u00010\u001c2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001c0B2\u0006\u0010O\u001a\u00020,2\u0006\u0010P\u001a\u00020\u0011H\u0002J\u0014\u0010Q\u001a\u00020\u0015*\u00020*2\u0006\u0010\u001a\u001a\u00020\u001cH\u0002J\u0012\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001c0B*\u00020SH\u0002J\u0010\u0010N\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020\u0015H\u0002J\u0010\u0010U\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020\u0015H\u0002J\u0010\u0010V\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020\"H\u0002J2\u0010W\u001a\u00020\u001c2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u0002022\u0006\u0010X\u001a\u00020,2\b\u0010Y\u001a\u0004\u0018\u00010\u001c2\u0006\u0010P\u001a\u00020\u0011H\u0002J\u001c\u0010Z\u001a\u00020\u0015*\u00020*2\u0006\u00108\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020,H\u0002J\u0010\u0010W\u001a\u00020\u001c2\u0006\u0010[\u001a\u00020\u001eH\u0002J:\u0010\\\u001a\u00020\u001c2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u0002022\u0006\u00108\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020,2\b\u0010Y\u001a\u0004\u0018\u00010\u001c2\u0006\u0010P\u001a\u00020\u0011H\u0002J\u0010\u0010\\\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020 H\u0002J\u0010\u0010^\u001a\u00020\u00102\u0006\u0010_\u001a\u00020`H\u0002J\u001e\u0010a\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010\u001c0b2\u0006\u0010T\u001a\u00020\u0015H\u0002J\u0010\u0010c\u001a\u00020,2\u0006\u0010T\u001a\u00020\u0015H\u0002J\u0010\u0010d\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020\u0015H\u0002J\u0010\u0010e\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020\u0015H\u0002J\u0010\u0010f\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020 H\u0002J\u0018\u0010g\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010h\u001a\u00020\u0016H\u0002J\u0010\u0010i\u001a\u00020\u001c2\u0006\u0010T\u001a\u00020$H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SpecialAccessLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "isAccessible", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "withSuper", "callsOnCompanionObjects", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getCallsOnCompanionObjects", "()Ljava/util/Map;", "recordCompanionObjectAsDispatchReceiver", "expression", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "reflectSymbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmReflectSymbols;", "javaClassObject", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "klass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "getDeclaredField", "declaringClass", "fieldName", "", "fieldSetAccessible", "field", "fieldSet", "fieldObject", "receiver", "value", "fieldGet", "createBuilder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "startOffset", "", "endOffset", "irVararg", "elementType", "values", "", "getDeclaredMethod", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "methodSetAccessible", "method", "methodInvoke", "arguments", "getDeclaredConstructor", "constructorSetAccessible", "constructor", "constructorNewInstance", "generateReflectiveMethodInvocation", "returnType", "symbol", "coerceToUnboxed", "getValueArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "call", "generateReflectiveStaticCall", "generateReflectiveConstructorInvocation", "generateReflectiveFieldGet", "fieldType", "instance", "coerceResult", "getField", "generateReflectiveFieldSet", "setField", "isPresentInBytecode", "accessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "fieldLocationAndReceiver", "Lkotlin/Pair;", "getDeclaredClassType", "generateReflectiveAccessForGetter", "generateReflectiveAccessForSetter", "generateThrowIllegalAccessException", "generateInvokeSpecialForCall", "superQualifier", "generateReflectiveAccessForCompanion", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nSpecialAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialAccess.kt\norg/jetbrains/kotlin/backend/jvm/lower/SpecialAccessLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 IrArrayBuilder.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilderKt\n*L\n1#1,575:1\n1563#2:576\n1634#2,3:577\n1563#2:580\n1634#2,3:581\n1563#2:584\n1634#2,3:585\n1563#2:588\n1634#2,3:589\n1563#2:606\n1634#2,3:607\n1563#2:611\n1634#2,3:612\n388#3,13:592\n388#3,13:616\n388#3,13:631\n388#3,13:646\n388#3,13:661\n134#4:605\n135#4:610\n134#4,2:629\n134#4,2:644\n134#4,2:659\n134#4,2:674\n1#5:615\n1#5:677\n20#6:676\n*S KotlinDebug\n*F\n+ 1 SpecialAccess.kt\norg/jetbrains/kotlin/backend/jvm/lower/SpecialAccessLowering\n*L\n234#1:576\n234#1:577,3\n252#1:580\n252#1:581,3\n263#1:584\n263#1:585,3\n277#1:588\n277#1:589,3\n301#1:606\n301#1:607,3\n314#1:611\n314#1:612,3\n292#1:592,13\n354#1:616,13\n376#1:631,13\n416#1:646,13\n525#1:661,13\n292#1:605\n292#1:610\n354#1:629,2\n376#1:644,2\n416#1:659,2\n525#1:674,2\n556#1:677\n556#1:676\n*E\n"})
public final class SpecialAccessLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    private IrInlineScopeResolver inlineScopeResolver;
    @NotNull
    private final Map<IrCall, IrClassSymbol> callsOnCompanionObjects;
    @NotNull
    private final JvmSymbols symbols;
    @NotNull
    private final JvmReflectSymbols reflectSymbols;

    public SpecialAccessLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.callsOnCompanionObjects = new LinkedHashMap();
        this.symbols = this.context.getIr().getSymbols();
        this.reflectSymbols = this.symbols.getJavaLangReflectSymbols();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getEvaluatorData() == null) {
            return;
        }
        this.inlineScopeResolver = IrInlineReferenceLocatorKt.findInlineCallSites(irFile, this.context);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
    }

    private final boolean isAccessible(IrSymbol $this$isAccessible, boolean withSuper) {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        IrInlineScopeResolver irInlineScopeResolver = this.inlineScopeResolver;
        if (irInlineScopeResolver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inlineScopeResolver");
            irInlineScopeResolver = null;
        }
        return SyntheticAccessorLowering.Companion.isAccessible($this$isAccessible, this.context, scopeWithIr, irInlineScopeResolver, withSuper, null, true);
    }

    static /* synthetic */ boolean isAccessible$default(SpecialAccessLowering specialAccessLowering, IrSymbol irSymbol, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return specialAccessLowering.isAccessible(irSymbol, bl);
    }

    @NotNull
    public final Map<IrCall, IrClassSymbol> getCallsOnCompanionObjects() {
        return this.callsOnCompanionObjects;
    }

    private final void recordCompanionObjectAsDispatchReceiver(IrCall expression2) {
        IrExpression irExpression = expression2.getDispatchReceiver();
        IrGetField irGetField = irExpression instanceof IrGetField ? (IrGetField)irExpression : null;
        if (irGetField == null) {
            return;
        }
        IrGetField dispatchReceiver = irGetField;
        IrType irType = ((IrField)dispatchReceiver.getSymbol().getOwner()).getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return;
        }
        IrSimpleType dispatchReceiverType = irSimpleType;
        IrClassSymbol klass = IrTypesKt.getClassOrNull((IrType)((IrType)dispatchReceiverType));
        if (klass != null && ((IrClass)klass.getOwner()).isCompanion()) {
            this.callsOnCompanionObjects.put(expression2, klass);
        }
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.recordCompanionObjectAsDispatchReceiver(expression2);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrClassSymbol superQualifier = expression2.getSuperQualifierSymbol();
        IrSimpleFunctionSymbol callee = expression2.getSymbol();
        if (this.isAccessible((IrSymbol)callee, superQualifier != null)) {
            return (IrExpression)expression2;
        }
        return AdditionalIrUtilsKt.isGetter((IrDeclaration)((IrDeclaration)expression2.getSymbol().getOwner())) ? this.generateReflectiveAccessForGetter(expression2) : (AdditionalIrUtilsKt.isSetter((IrDeclaration)((IrDeclaration)expression2.getSymbol().getOwner())) ? this.generateReflectiveAccessForSetter(expression2) : (expression2.getDispatchReceiver() == null && expression2.getExtensionReceiver() == null ? this.generateReflectiveStaticCall(expression2) : (superQualifier != null ? this.generateInvokeSpecialForCall(expression2, superQualifier) : this.generateReflectiveMethodInvocation(expression2))));
    }

    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrFieldSymbol field = expression2.getSymbol();
        return SpecialAccessLowering.isAccessible$default(this, (IrSymbol)field, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveFieldGet(expression2);
    }

    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        IrPropertySymbol irPropertySymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrFieldSymbol field = expression2.getSymbol();
        return SpecialAccessLowering.isAccessible$default(this, (IrSymbol)field, false, 1, null) ? (IrExpression)expression2 : (((irPropertySymbol = ((IrField)field.getOwner()).getCorrespondingPropertySymbol()) != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null ? irPropertySymbol.isConst() : false) || IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)field.getOwner())) && ((IrField)field.getOwner()).isFinal() ? this.generateThrowIllegalAccessException(expression2) : this.generateReflectiveFieldSet(expression2));
    }

    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrConstructorSymbol callee = expression2.getSymbol();
        return SpecialAccessLowering.isAccessible$default(this, (IrSymbol)callee, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveConstructorInvocation(expression2);
    }

    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        IrClassSymbol callee = expression2.getSymbol();
        return SpecialAccessLowering.isAccessible$default(this, (IrSymbol)callee, false, 1, null) ? (IrExpression)expression2 : this.generateReflectiveAccessForCompanion(expression2);
    }

    private final IrExpression javaClassObject(IrBuilderWithScope $this$javaClassObject, IrType klass) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression $this$javaClassObject_u24lambda_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$javaClassObject, (IrFunction)((IrFunction)this.symbols.getKClassJavaPropertyGetter()));
        boolean bl = false;
        $this$javaClassObject_u24lambda_u240.setExtensionReceiver((IrExpression)BuildersKt.IrClassReferenceImpl((int)$this$javaClassObject_u24lambda_u240.getStartOffset(), (int)$this$javaClassObject_u24lambda_u240.getEndOffset(), (IrType)((IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)$this$javaClassObject.getContext().getIrBuiltIns().getKClassClass())), (IrClassifierSymbol)((IrClassifierSymbol)$this$javaClassObject.getContext().getIrBuiltIns().getKClassClass()), (IrType)klass));
        return (IrExpression)irFunctionAccessExpression;
    }

    private final IrExpression javaClassObject(IrBuilderWithScope $this$javaClassObject, Type type) {
        IrCall irCall;
        IrCall $this$javaClassObject_u24lambda_u241 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$javaClassObject, (IrSimpleFunctionSymbol)this.symbols.getGetClassByDescriptor());
        boolean bl = false;
        String string = type.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptor(...)");
        $this$javaClassObject_u24lambda_u241.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)$this$javaClassObject, (String)string));
        return (IrExpression)irCall;
    }

    private final IrExpression getDeclaredField(IrBuilderWithScope $this$getDeclaredField, IrExpression declaringClass, String fieldName) {
        IrCall irCall;
        IrCall $this$getDeclaredField_u24lambda_u242 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$getDeclaredField, (IrSimpleFunctionSymbol)this.reflectSymbols.getGetDeclaredField());
        boolean bl = false;
        $this$getDeclaredField_u24lambda_u242.setDispatchReceiver(declaringClass);
        $this$getDeclaredField_u24lambda_u242.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)$this$getDeclaredField, (String)fieldName));
        return (IrExpression)irCall;
    }

    private final IrExpression fieldSetAccessible(IrBuilderWithScope $this$fieldSetAccessible, IrExpression field) {
        IrCall irCall;
        IrCall $this$fieldSetAccessible_u24lambda_u243 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$fieldSetAccessible, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectFieldSetAccessible());
        boolean bl = false;
        $this$fieldSetAccessible_u24lambda_u243.setDispatchReceiver(field);
        $this$fieldSetAccessible_u24lambda_u243.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)$this$fieldSetAccessible));
        return (IrExpression)irCall;
    }

    private final IrExpression fieldSet(IrBuilderWithScope $this$fieldSet, IrExpression fieldObject, IrExpression receiver, IrExpression value) {
        IrCall irCall;
        IrCall $this$fieldSet_u24lambda_u244 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$fieldSet, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectFieldSet());
        boolean bl = false;
        $this$fieldSet_u24lambda_u244.setDispatchReceiver(fieldObject);
        $this$fieldSet_u24lambda_u244.putValueArgument(0, receiver);
        $this$fieldSet_u24lambda_u244.putValueArgument(1, value);
        return (IrExpression)irCall;
    }

    private final IrExpression fieldGet(IrBuilderWithScope $this$fieldGet, IrExpression fieldObject, IrExpression receiver) {
        IrCall irCall;
        IrCall $this$fieldGet_u24lambda_u245 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$fieldGet, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectFieldGet());
        boolean bl = false;
        $this$fieldGet_u24lambda_u245.setDispatchReceiver(fieldObject);
        $this$fieldGet_u24lambda_u245.putValueArgument(0, receiver);
        return (IrExpression)irCall;
    }

    private final JvmIrBuilder createBuilder(int startOffset, int endOffset) {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        return JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr, startOffset, endOffset);
    }

    static /* synthetic */ JvmIrBuilder createBuilder$default(SpecialAccessLowering specialAccessLowering, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return specialAccessLowering.createBuilder(n, n2);
    }

    private final IrExpression irVararg(IrBuilderWithScope $this$irVararg, IrType elementType, List<? extends IrExpression> values) {
        Object object = new IrType[]{elementType};
        Object $this$irVararg_u24lambda_u246 = object = new IrArrayBuilder(SpecialAccessLowering.createBuilder$default(this, 0, 0, 3, null), (IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)$this$irVararg.getContext().getIrBuiltIns().getArrayClass()), (IrType[])object));
        boolean bl = false;
        for (IrExpression irExpression : values) {
            ((IrArrayBuilder)$this$irVararg_u24lambda_u246).unaryPlus(irExpression);
        }
        return ((IrArrayBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getDeclaredMethod(IrBuilderWithScope $this$getDeclaredMethod, IrExpression declaringClass, JvmMethodSignature signature) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$getDeclaredMethod_u24lambda_u248 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$getDeclaredMethod, (IrSimpleFunctionSymbol)this.reflectSymbols.getGetDeclaredMethod());
        boolean bl = false;
        $this$getDeclaredMethod_u24lambda_u248.setDispatchReceiver(declaringClass);
        String string = signature.getAsmMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $this$getDeclaredMethod_u24lambda_u248.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)$this$getDeclaredMethod, (String)string));
        IrType irType = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.symbols.getJavaLangClass()));
        List<JvmMethodParameterSignature> list = signature.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable iterable = list;
        IrType irType2 = irType;
        IrBuilderWithScope irBuilderWithScope = $this$getDeclaredMethod;
        SpecialAccessLowering specialAccessLowering = this;
        int n = 1;
        IrCall irCall2 = $this$getDeclaredMethod_u24lambda_u248;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmMethodParameterSignature jvmMethodParameterSignature = (JvmMethodParameterSignature)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Type type = it.getAsmType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getAsmType(...)");
            collection.add(this.javaClassObject($this$getDeclaredMethod, type));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, specialAccessLowering.irVararg(irBuilderWithScope, irType2, (List<? extends IrExpression>)collection));
        return (IrExpression)irCall;
    }

    private final IrExpression methodSetAccessible(IrBuilderWithScope $this$methodSetAccessible, IrExpression method) {
        IrCall irCall;
        IrCall $this$methodSetAccessible_u24lambda_u249 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$methodSetAccessible, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectMethodSetAccessible());
        boolean bl = false;
        $this$methodSetAccessible_u24lambda_u249.setDispatchReceiver(method);
        $this$methodSetAccessible_u24lambda_u249.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)$this$methodSetAccessible));
        return (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression methodInvoke(IrBuilderWithScope $this$methodInvoke, IrExpression method, IrExpression receiver, List<? extends IrExpression> arguments) {
        Collection<IrCall> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$methodInvoke_u24lambda_u2411 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$methodInvoke, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectMethodInvoke());
        boolean bl = false;
        $this$methodInvoke_u24lambda_u2411.setDispatchReceiver(method);
        $this$methodInvoke_u24lambda_u2411.putValueArgument(0, receiver);
        Iterable iterable = arguments;
        IrType irType = $this$methodInvoke.getContext().getIrBuiltIns().getAnyNType();
        IrBuilderWithScope irBuilderWithScope = $this$methodInvoke;
        SpecialAccessLowering specialAccessLowering = this;
        int n = 1;
        IrCall irCall2 = $this$methodInvoke_u24lambda_u2411;
        boolean $i$f$map = false;
        void var15_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrExpression irExpression = (IrExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.coerceToUnboxed($this$methodInvoke, (IrExpression)it));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, specialAccessLowering.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection));
        return (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression getDeclaredConstructor(IrBuilderWithScope $this$getDeclaredConstructor, IrExpression declaringClass, JvmMethodSignature signature) {
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$getDeclaredConstructor_u24lambda_u2413 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$getDeclaredConstructor, (IrSimpleFunctionSymbol)this.reflectSymbols.getGetDeclaredConstructor());
        boolean bl = false;
        $this$getDeclaredConstructor_u24lambda_u2413.setDispatchReceiver(declaringClass);
        IrType irType = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.symbols.getJavaLangClass()));
        List<JvmMethodParameterSignature> list = signature.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable iterable = list;
        IrType irType2 = irType;
        IrBuilderWithScope irBuilderWithScope = $this$getDeclaredConstructor;
        SpecialAccessLowering specialAccessLowering = this;
        int n = 0;
        IrCall irCall2 = $this$getDeclaredConstructor_u24lambda_u2413;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmMethodParameterSignature jvmMethodParameterSignature = (JvmMethodParameterSignature)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Type type = it.getAsmType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getAsmType(...)");
            collection.add(this.javaClassObject($this$getDeclaredConstructor, type));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, specialAccessLowering.irVararg(irBuilderWithScope, irType2, (List<? extends IrExpression>)collection));
        return (IrExpression)irCall;
    }

    private final IrExpression constructorSetAccessible(IrBuilderWithScope $this$constructorSetAccessible, IrExpression constructor) {
        IrCall irCall;
        IrCall $this$constructorSetAccessible_u24lambda_u2414 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$constructorSetAccessible, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectConstructorSetAccessible());
        boolean bl = false;
        $this$constructorSetAccessible_u24lambda_u2414.setDispatchReceiver(constructor);
        $this$constructorSetAccessible_u24lambda_u2414.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)$this$constructorSetAccessible));
        return (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression constructorNewInstance(IrBuilderWithScope $this$constructorNewInstance, IrExpression constructor, List<? extends IrExpression> arguments) {
        Collection<IrCall> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrCall irCall;
        IrCall $this$constructorNewInstance_u24lambda_u2416 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$constructorNewInstance, (IrSimpleFunctionSymbol)this.reflectSymbols.getJavaLangReflectConstructorNewInstance());
        boolean bl = false;
        $this$constructorNewInstance_u24lambda_u2416.setDispatchReceiver(constructor);
        Iterable iterable = arguments;
        IrType irType = $this$constructorNewInstance.getContext().getIrBuiltIns().getAnyNType();
        IrBuilderWithScope irBuilderWithScope = $this$constructorNewInstance;
        SpecialAccessLowering specialAccessLowering = this;
        int n = 0;
        IrCall irCall2 = $this$constructorNewInstance_u24lambda_u2416;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrExpression irExpression = (IrExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.coerceToUnboxed($this$constructorNewInstance, (IrExpression)it));
        }
        collection = (List)destination$iv$iv;
        irCall2.putValueArgument(n, specialAccessLowering.irVararg(irBuilderWithScope, irType, (List<? extends IrExpression>)collection));
        return (IrExpression)irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveMethodInvocation(IrType declaringClass, JvmMethodSignature signature, IrExpression receiver, List<? extends IrExpression> arguments, IrType returnType, IrSymbol symbol) {
        Collection<IrCall> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, returnType, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveMethodInvocation_u24lambda_u2418 = this_$iv$iv;
        boolean bl = false;
        IrVariable methodVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveMethodInvocation_u24lambda_u2418), (IrExpression)this.getDeclaredMethod((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418, declaringClass), signature), (String)"method", (boolean)false, null, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.reflectSymbols.getJavaLangReflectMethod())), (int)12, null);
        $this$generateReflectiveMethodInvocation_u24lambda_u2418.unaryPlus((IrStatement)this.methodSetAccessible((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418), (IrValueDeclaration)((IrValueDeclaration)methodVar))));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418;
        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418), (IrValueDeclaration)((IrValueDeclaration)methodVar));
        IrExpression irExpression2 = receiver;
        if (irExpression2 == null) {
            irExpression2 = (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418));
        }
        Iterable iterable = arguments;
        IrExpression irExpression3 = irExpression2;
        IrExpression irExpression4 = irExpression;
        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope2;
        SpecialAccessLowering specialAccessLowering = this;
        IrBuilderWithScope irBuilderWithScope4 = irBuilderWithScope;
        SpecialAccessLowering specialAccessLowering2 = this;
        void var24_24 = $this$generateReflectiveMethodInvocation_u24lambda_u2418;
        boolean $i$f$map = false;
        void var26_26 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrExpression irExpression5 = (IrExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.coerceToUnboxed((IrBuilderWithScope)$this$generateReflectiveMethodInvocation_u24lambda_u2418, (IrExpression)it));
        }
        collection = (List)destination$iv$iv;
        var24_24.unaryPlus((IrStatement)specialAccessLowering2.coerceResult(irBuilderWithScope4, specialAccessLowering.methodInvoke(irBuilderWithScope3, irExpression4, irExpression3, (List<? extends IrExpression>)collection), returnType));
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final IrCall coerceToUnboxed(IrBuilderWithScope $this$coerceToUnboxed, IrExpression expression2) {
        IrCall irCall;
        IrCall $this$coerceToUnboxed_u24lambda_u2419 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$coerceToUnboxed, (IrSimpleFunctionSymbol)this.symbols.getUnsafeCoerceIntrinsic());
        boolean bl = false;
        $this$coerceToUnboxed_u24lambda_u2419.getTypeArguments().set(0, expression2.getType());
        $this$coerceToUnboxed_u24lambda_u2419.getTypeArguments().set(1, InlineClassAbiKt.unboxInlineClass(expression2.getType()));
        $this$coerceToUnboxed_u24lambda_u2419.putValueArgument(0, expression2);
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrExpression> getValueArguments(IrFunctionAccessExpression $this$getValueArguments) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$getValueArguments.getValueArgumentsCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrExpression irExpression = $this$getValueArguments.getValueArgument((int)it);
            Intrinsics.checkNotNull((Object)irExpression);
            collection.add(irExpression);
        }
        return (List)destination$iv$iv;
    }

    private final IrExpression generateReflectiveMethodInvocation(IrCall call) {
        List arguments = new ArrayList();
        if (call.getExtensionReceiver() != null) {
            IrExpression irExpression = call.getExtensionReceiver();
            if (irExpression != null) {
                IrExpression it = irExpression;
                boolean bl = false;
                arguments.add(it);
            }
        } else if (call.getDispatchReceiver() != null && Intrinsics.areEqual((Object)((IrSimpleFunction)call.getSymbol().getOwner()).getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER())) {
            IrExpression irExpression = call.getDispatchReceiver();
            if (irExpression != null) {
                IrExpression it = irExpression;
                boolean bl = false;
                arguments.add(it);
            }
        }
        arguments.addAll((Collection)this.getValueArguments((IrFunctionAccessExpression)call));
        return this.generateReflectiveMethodInvocation(this.getDeclaredClassType(call), this.context.getDefaultMethodSignatureMapper().mapSignatureSkipGeneric(call.getSymbol().getOwner()), call.getDispatchReceiver(), arguments, call.getType(), (IrSymbol)call.getSymbol());
    }

    private final IrExpression generateReflectiveStaticCall(IrCall call) {
        boolean bl;
        boolean bl2 = bl = call.getDispatchReceiver() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assumed-to-be static call with a dispatch receiver";
            throw new AssertionError((Object)string);
        }
        return this.generateReflectiveMethodInvocation((IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)call.getSymbol().getOwner()))), this.context.getDefaultMethodSignatureMapper().mapSignatureSkipGeneric(call.getSymbol().getOwner()), null, this.getValueArguments((IrFunctionAccessExpression)call), call.getType(), (IrSymbol)call.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveConstructorInvocation(IrConstructorCall call) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, (IrSymbol)call.getSymbol(), 0, 0, 6, null);
        IrType resultType$iv = call.getType();
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveConstructorInvocation_u24lambda_u2424 = this_$iv$iv;
        boolean bl = false;
        IrVariable constructorVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveConstructorInvocation_u24lambda_u2424), (IrExpression)this.getDeclaredConstructor((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2424, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2424, (IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)call.getSymbol().getOwner())))), this.context.getDefaultMethodSignatureMapper().mapSignatureSkipGeneric(call.getSymbol().getOwner())), (String)"constructor", (boolean)false, null, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.reflectSymbols.getJavaLangReflectConstructor())), (int)12, null);
        $this$generateReflectiveConstructorInvocation_u24lambda_u2424.unaryPlus((IrStatement)this.constructorSetAccessible((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2424, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2424), (IrValueDeclaration)((IrValueDeclaration)constructorVar))));
        $this$generateReflectiveConstructorInvocation_u24lambda_u2424.unaryPlus((IrStatement)this.constructorNewInstance((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2424, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveConstructorInvocation_u24lambda_u2424), (IrValueDeclaration)((IrValueDeclaration)constructorVar)), this.getValueArguments((IrFunctionAccessExpression)call)));
        return (IrExpression)this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveFieldGet(IrType declaringClass, String fieldName, IrType fieldType, IrExpression instance2, IrSymbol symbol) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, fieldType, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveFieldGet_u24lambda_u2425 = this_$iv$iv;
        boolean bl = false;
        IrVariable classVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveFieldGet_u24lambda_u2425), (IrExpression)this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425, declaringClass), (String)"klass", (boolean)false, null, (IrType)this.symbols.getKClassJavaPropertyGetter().getReturnType(), (int)12, null);
        IrVariable fieldVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveFieldGet_u24lambda_u2425), (IrExpression)this.getDeclaredField((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425), (IrValueDeclaration)((IrValueDeclaration)classVar)), fieldName), (String)"field", (boolean)false, null, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.reflectSymbols.getJavaLangReflectField())), (int)12, null);
        $this$generateReflectiveFieldGet_u24lambda_u2425.unaryPlus((IrStatement)this.fieldSetAccessible((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425), (IrValueDeclaration)((IrValueDeclaration)fieldVar))));
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425;
        IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425;
        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425), (IrValueDeclaration)((IrValueDeclaration)fieldVar));
        IrExpression irExpression2 = instance2;
        if (irExpression2 == null) {
            irExpression2 = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldGet_u24lambda_u2425), (IrValueDeclaration)((IrValueDeclaration)classVar));
        }
        $this$generateReflectiveFieldGet_u24lambda_u2425.unaryPlus((IrStatement)this.coerceResult(irBuilderWithScope2, this.fieldGet(irBuilderWithScope3, irExpression, irExpression2), fieldType));
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final IrCall coerceResult(IrBuilderWithScope $this$coerceResult, IrExpression value, IrType type) {
        IrCall irCall;
        IrCall $this$coerceResult_u24lambda_u2426 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$coerceResult, (IrSimpleFunctionSymbol)this.symbols.getHandleResultOfReflectiveAccess());
        boolean bl = false;
        $this$coerceResult_u24lambda_u2426.putValueArgument(0, value);
        $this$coerceResult_u24lambda_u2426.getTypeArguments().set(0, type);
        return irCall;
    }

    private final IrExpression generateReflectiveFieldGet(IrGetField getField) {
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)getField.getSymbol().getOwner()));
        Intrinsics.checkNotNull((Object)irClass);
        IrType irType = (IrType)IrUtilsKt.getDefaultType((IrClass)irClass);
        String string = ((IrField)getField.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return this.generateReflectiveFieldGet(irType, string, getField.getType(), getField.getReceiver(), (IrSymbol)getField.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveFieldSet(IrType declaringClass, String fieldName, IrExpression value, IrType type, IrExpression instance2, IrSymbol symbol) {
        void this_$iv$iv;
        void $this$irBlock_u24default$iv;
        IrBuilderWithScope irBuilderWithScope = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, symbol, 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, type, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateReflectiveFieldSet_u24lambda_u2427 = this_$iv$iv;
        boolean bl = false;
        IrVariable fieldVar = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$generateReflectiveFieldSet_u24lambda_u2427), (IrExpression)this.getDeclaredField((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2427, this.javaClassObject((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2427, declaringClass), fieldName), (String)"field", (boolean)false, null, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)this.reflectSymbols.getJavaLangReflectField())), (int)12, null);
        $this$generateReflectiveFieldSet_u24lambda_u2427.unaryPlus((IrStatement)this.fieldSetAccessible((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2427, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2427), (IrValueDeclaration)((IrValueDeclaration)fieldVar))));
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2427;
        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2427), (IrValueDeclaration)((IrValueDeclaration)fieldVar));
        IrExpression irExpression2 = instance2;
        if (irExpression2 == null) {
            irExpression2 = (IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2427));
        }
        $this$generateReflectiveFieldSet_u24lambda_u2427.unaryPlus((IrStatement)this.fieldSet(irBuilderWithScope2, irExpression, irExpression2, (IrExpression)this.coerceToUnboxed((IrBuilderWithScope)$this$generateReflectiveFieldSet_u24lambda_u2427, value)));
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final IrExpression generateReflectiveFieldSet(IrSetField setField) {
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)setField.getSymbol().getOwner()));
        Intrinsics.checkNotNull((Object)irClass);
        IrType irType = (IrType)IrUtilsKt.getDefaultType((IrClass)irClass);
        String string = ((IrField)setField.getSymbol().getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return this.generateReflectiveFieldSet(irType, string, setField.getValue(), setField.getType(), setField.getReceiver(), (IrSymbol)setField.getSymbol());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPresentInBytecode(IrSimpleFunction accessor) {
        IrPropertySymbol irPropertySymbol = accessor.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrProperty property2 = (IrProperty)irPropertySymbol.getOwner();
        if (IrVisibilityUtilKt.isNonPrivate((IrDeclarationWithVisibility)((IrDeclarationWithVisibility)property2))) return true;
        if (property2.isDelegated()) return true;
        JvmGeneratorExtensions jvmGeneratorExtensions = this.context.getGeneratorExtensions();
        Intrinsics.checkNotNull((Object)jvmGeneratorExtensions, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.StubGeneratorExtensions");
        if (!((StubGeneratorExtensions)jvmGeneratorExtensions).isAccessorWithExplicitImplementation(accessor)) return false;
        return true;
    }

    private final Pair<IrType, IrExpression> fieldLocationAndReceiver(IrCall call) {
        IrClassSymbol irClassSymbol = this.callsOnCompanionObjects.get(call);
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            IrClass parentAsClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)it.getOwner()));
            if (!JvmIrUtilsKt.isJvmInterface(parentAsClass)) {
                return TuplesKt.to((Object)IrUtilsKt.getDefaultType((IrClass)parentAsClass), null);
            }
        }
        IrType type = this.getDeclaredClassType(call);
        return TuplesKt.to((Object)type, (Object)call.getDispatchReceiver());
    }

    private final IrType getDeclaredClassType(IrCall call) {
        IrClassSymbol irClassSymbol = call.getSuperQualifierSymbol();
        if (irClassSymbol == null || (irClassSymbol = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)irClassSymbol))) == null) {
            irClassSymbol = (IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)((IrOverridableDeclaration)call.getSymbol().getOwner())))));
        }
        return irClassSymbol;
    }

    private final IrExpression generateReflectiveAccessForGetter(IrCall call) {
        IrSimpleFunction realGetter = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)((IrOverridableDeclaration)call.getSymbol().getOwner()));
        if (this.isPresentInBytecode(realGetter)) {
            return this.generateReflectiveMethodInvocation((IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)realGetter))), this.context.getDefaultMethodSignatureMapper().mapSignatureSkipGeneric((IrFunction)realGetter), call.getDispatchReceiver(), CollectionsKt.listOfNotNull((Object)call.getExtensionReceiver()), realGetter.getReturnType(), (IrSymbol)realGetter.getSymbol());
        }
        Pair<IrType, IrExpression> pair = this.fieldLocationAndReceiver(call);
        IrType fieldLocation = (IrType)pair.component1();
        IrExpression instance2 = (IrExpression)pair.component2();
        IrPropertySymbol irPropertySymbol = realGetter.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        String string = ((IrProperty)irPropertySymbol.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return this.generateReflectiveFieldGet(fieldLocation, string, realGetter.getReturnType(), instance2, (IrSymbol)call.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateReflectiveAccessForSetter(IrCall call) {
        IrSimpleFunction realSetter = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)((IrOverridableDeclaration)call.getSymbol().getOwner()));
        if (this.isPresentInBytecode(realSetter)) {
            void $this$generateReflectiveAccessForSetter_u24lambda_u2430;
            List list;
            List list2 = list = (List)new ArrayList();
            IrExpression irExpression = call.getDispatchReceiver();
            JvmMethodSignature jvmMethodSignature = this.context.getDefaultMethodSignatureMapper().mapSignatureSkipGeneric((IrFunction)realSetter);
            IrType irType = (IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)realSetter)));
            SpecialAccessLowering specialAccessLowering = this;
            boolean bl = false;
            IrExpression irExpression2 = call.getExtensionReceiver();
            if (irExpression2 != null) {
                IrExpression it = irExpression2;
                boolean bl2 = false;
                $this$generateReflectiveAccessForSetter_u24lambda_u2430.add(it);
            }
            $this$generateReflectiveAccessForSetter_u24lambda_u2430.addAll((Collection)this.getValueArguments((IrFunctionAccessExpression)call));
            Unit unit = Unit.INSTANCE;
            return specialAccessLowering.generateReflectiveMethodInvocation(irType, jvmMethodSignature, irExpression, list, realSetter.getReturnType(), (IrSymbol)call.getSymbol());
        }
        Pair<IrType, IrExpression> pair = this.fieldLocationAndReceiver(call);
        IrType fieldLocation = (IrType)pair.component1();
        IrExpression receiver = (IrExpression)pair.component2();
        IrPropertySymbol irPropertySymbol = realSetter.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        String string = ((IrProperty)irPropertySymbol.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        IrExpression irExpression = call.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        return this.generateReflectiveFieldSet(fieldLocation, string, irExpression, call.getType(), receiver, (IrSymbol)call.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateThrowIllegalAccessException(IrSetField setField) {
        void $this$generateThrowIllegalAccessException_u24lambda_u2432_u24lambda_u2431;
        IrCall irCall;
        void this_$iv$iv;
        IrBuilderWithScope $this$irBlock_u24default$iv = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, (IrSymbol)setField.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$generateThrowIllegalAccessException_u24lambda_u2432 = this_$iv$iv;
        boolean bl = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$generateThrowIllegalAccessException_u24lambda_u2432), (IrSimpleFunctionSymbol)this.symbols.getThrowIllegalAccessException());
        void var14_14 = $this$generateThrowIllegalAccessException_u24lambda_u2432;
        boolean bl2 = false;
        $this$generateThrowIllegalAccessException_u24lambda_u2432_u24lambda_u2431.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$generateThrowIllegalAccessException_u24lambda_u2432), (String)"Can not set final field"));
        var14_14.unaryPlus((IrStatement)irCall);
        return (IrExpression)this_$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateInvokeSpecialForCall(IrCall expression2, IrClassSymbol superQualifier) {
        void $this$irArray$iv;
        IrArrayBuilder irArrayBuilder;
        IrCall irCall;
        JvmMethodSignature jvmSignature = this.context.getDefaultMethodSignatureMapper().mapSignatureSkipGeneric(expression2.getSymbol().getOwner());
        IrClass owner = (IrClass)superQualifier.getOwner();
        JvmIrBuilder builder = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, (IrSymbol)expression2.getSymbol(), 0, 0, 6, null);
        IrCall $this$generateInvokeSpecialForCall_u24lambda_u2435 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, (IrSimpleFunctionSymbol)this.symbols.getJvmDebuggerInvokeSpecialIntrinsic());
        boolean bl = false;
        $this$generateInvokeSpecialForCall_u24lambda_u2435.setDispatchReceiver(expression2.getDispatchReceiver());
        $this$generateInvokeSpecialForCall_u24lambda_u2435.setType(((IrSimpleFunction)expression2.getSymbol().getOwner()).getReturnType());
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)builder, (String)("" + AdditionalIrUtilsKt.getPackageFqName((IrClass)owner) + '/' + owner.getName())));
        IrBuilderWithScope irBuilderWithScope = builder;
        String string = jvmSignature.getAsmMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(1, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)irBuilderWithScope, (String)string));
        IrBuilderWithScope irBuilderWithScope2 = builder;
        String string2 = jvmSignature.getAsmMethod().getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescriptor(...)");
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(2, (IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)irBuilderWithScope2, (String)string2));
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(3, (IrExpression)ExpressionHelpersKt.irFalse((IrBuilderWithScope)builder));
        IrBuiltIns $this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434 = this.context.getIrBuiltIns();
        boolean bl2 = false;
        JvmIrBuilder jvmIrBuilder = builder;
        IrType[] irTypeArray = new IrType[]{$this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434.getAnyNType()};
        IrType arrayType$iv = (IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)$this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434.getArrayClass()), (IrType[])irTypeArray);
        boolean $i$f$irArray = false;
        IrArrayBuilder $this$irArray_u24lambda_u240$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
        boolean bl3 = false;
        IrArrayBuilder $this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433 = $this$irArray_u24lambda_u240$iv;
        boolean bl4 = false;
        int n = expression2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression irExpression = expression2.getValueArgument(i);
            Intrinsics.checkNotNull((Object)irExpression);
            $this$generateInvokeSpecialForCall_u24lambda_u2435_u24lambda_u2434_u24lambda_u2433.add(irExpression);
        }
        IrExpression args = irArrayBuilder.build();
        $this$generateInvokeSpecialForCall_u24lambda_u2435.putValueArgument(4, args);
        return (IrExpression)irCall;
    }

    private final IrExpression generateReflectiveAccessForCompanion(IrGetObjectValue call) {
        return this.generateReflectiveFieldGet((IrType)IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)call.getSymbol().getOwner()))), "Companion", call.getType(), null, (IrSymbol)call.getSymbol());
    }
}

