/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsComponentLoader;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.JpsProjectConfigurationLoading;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetSerializer;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsSerializationFormatException;
import org.jetbrains.jps.model.serialization.impl.TimingLog;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkTableSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleClasspathSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;
import org.jetbrains.jps.service.SharedThreadPool;

@ApiStatus.Internal
public final class JpsProjectLoader {
    public static final String MODULE_MANAGER_COMPONENT = "ProjectModuleManager";
    public static final String MODULES_TAG = "modules";
    public static final String MODULE_TAG = "module";
    public static final String FILE_PATH_ATTRIBUTE = "filepath";
    public static final String FILE_URL_ATTRIBUTE = "fileurl";
    public static final String GROUP_ATTRIBUTE = "group";
    public static final String CLASSPATH_ATTRIBUTE = "classpath";
    public static final String CLASSPATH_DIR_ATTRIBUTE = "classpath-dir";
    private static final Logger LOG = Logger.getInstance(JpsProjectLoader.class);
    public static final JpsModulePropertiesSerializer<JpsDummyElement> JAVA_MODULE_PROPERTIES_SERIALIZER = new JpsModulePropertiesSerializer<JpsDummyElement>((JpsModuleType)JpsJavaModuleType.INSTANCE, "JAVA_MODULE", null){

        @Override
        public JpsDummyElement loadProperties(@Nullable Element componentElement) {
            return JpsElementFactory.getInstance().createDummyElement();
        }
    };
    private final JpsProject project;
    private final Map<String, String> myPathVariables;
    private final JpsPathMapper myPathMapper;
    private final boolean myLoadUnloadedModules;
    private final JpsComponentLoader myComponentLoader;
    @Nullable
    private final Path externalConfigurationDirectory;

    private JpsProjectLoader(JpsProject project, Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, @NotNull Path baseDir, @Nullable Path externalConfigurationDirectory, boolean loadUnloadedModules) {
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            JpsProjectLoader.$$$reportNull$$$0(1);
        }
        JpsMacroExpander macroExpander = JpsProjectConfigurationLoading.createProjectMacroExpander(pathVariables, baseDir);
        this.externalConfigurationDirectory = externalConfigurationDirectory;
        this.myComponentLoader = new JpsComponentLoader(macroExpander, this.externalConfigurationDirectory);
        this.project = project;
        this.myPathVariables = pathVariables;
        this.myPathMapper = pathMapper;
        JpsProjectConfigurationLoading.setupSerializationExtension(this.project, baseDir);
        this.myLoadUnloadedModules = loadUnloadedModules;
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, Path projectPath) throws IOException {
        JpsProjectLoader.loadProject(project, pathVariables, JpsPathMapper.IDENTITY, projectPath, false);
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, Path projectPath, boolean loadUnloadedModules) throws IOException {
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(2);
        }
        Path externalConfigurationDirectory = JpsProjectConfigurationLoading.getExternalConfigurationDirectoryFromSystemProperty();
        JpsProjectLoader.loadProject(project, pathVariables, pathMapper, projectPath, loadUnloadedModules, externalConfigurationDirectory);
    }

    public static void loadProject(@NotNull JpsProject project, @NotNull Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, @NotNull Path projectPath, boolean loadUnloadedModules, @Nullable Path externalConfigurationDirectory) throws IOException {
        if (project == null) {
            JpsProjectLoader.$$$reportNull$$$0(3);
        }
        if (pathVariables == null) {
            JpsProjectLoader.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(5);
        }
        if (projectPath == null) {
            JpsProjectLoader.$$$reportNull$$$0(6);
        }
        JpsProjectLoader.loadProject(project, pathVariables, pathMapper, projectPath, externalConfigurationDirectory, DefaultExecutorHolder.threadPool, loadUnloadedModules);
    }

    public static void loadProject(JpsProject project, Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, @NotNull Path projectPath, @Nullable Path externalConfigurationDirectory, @NotNull Executor executor, boolean loadUnloadedModules) throws IOException {
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(7);
        }
        if (projectPath == null) {
            JpsProjectLoader.$$$reportNull$$$0(8);
        }
        if (executor == null) {
            JpsProjectLoader.$$$reportNull$$$0(9);
        }
        if (Files.isRegularFile(projectPath, new LinkOption[0]) && projectPath.toString().endsWith(".ipr")) {
            new JpsProjectLoader(project, pathVariables, pathMapper, projectPath.getParent(), null, loadUnloadedModules).loadFromIpr(projectPath, executor);
        } else {
            Path directory;
            Path dotIdea = projectPath.resolve(".idea");
            if (Files.isDirectory(dotIdea, new LinkOption[0])) {
                directory = dotIdea;
            } else if (Files.isDirectory(projectPath, new LinkOption[0]) && projectPath.endsWith(".idea")) {
                directory = projectPath;
            } else {
                throw new IOException("Cannot find IntelliJ IDEA project files at " + projectPath);
            }
            new JpsProjectLoader(project, pathVariables, pathMapper, directory.getParent(), externalConfigurationDirectory, loadUnloadedModules).loadFromDirectory(directory, executor);
        }
    }

    private void loadFromDirectory(@NotNull Path dir, @NotNull Executor executor) {
        Path externalConfigDir;
        if (dir == null) {
            JpsProjectLoader.$$$reportNull$$$0(10);
        }
        if (executor == null) {
            JpsProjectLoader.$$$reportNull$$$0(11);
        }
        this.project.setName(JpsProjectConfigurationLoading.getDirectoryBaseProjectName(dir.getParent(), dir));
        Path defaultConfigFile = dir.resolve("misc.xml");
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(this.myComponentLoader.loadRootElement(defaultConfigFile));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                this.myComponentLoader.loadComponents(dir, defaultConfigFile, jpsProjectExtensionSerializer, this.project);
            }
        }
        if (this.externalConfigurationDirectory == null) {
            externalConfigDir = null;
        } else {
            externalConfigDir = this.externalConfigurationDirectory.resolve("project");
            LOG.info("External project config dir is used: " + externalConfigDir);
        }
        Element moduleData = this.myComponentLoader.loadComponent(dir.resolve("modules.xml"), MODULE_MANAGER_COMPONENT);
        if (externalConfigDir != null) {
            Element externalModuleData;
            Element element = this.myComponentLoader.loadRootElement(externalConfigDir.resolve("modules.xml"));
            if (element == null) {
                externalModuleData = null;
            } else {
                externalModuleData = JDomSerializationUtil.findComponent(element, "ExternalProjectModuleManager");
                if (externalModuleData == null) {
                    externalModuleData = JDomSerializationUtil.findComponent(element, "ExternalModuleListStorage");
                }
                if (externalModuleData == null && element.getName().equals("component")) {
                    externalModuleData = element;
                }
            }
            if (externalModuleData != null) {
                String componentName = externalModuleData.getAttributeValue("name");
                LOG.assertTrue(componentName != null && componentName.startsWith("External"));
                externalModuleData.setAttribute("name", componentName.substring("External".length()));
                if (moduleData == null) {
                    moduleData = externalModuleData;
                } else {
                    JDOMUtil.deepMerge((Element)moduleData, (Element)externalModuleData);
                }
            }
        }
        Path workspaceFile = dir.resolve("workspace.xml");
        this.loadModules(moduleData, projectSdkType, workspaceFile, executor);
        Runnable runnable = TimingLog.startActivity("loading project libraries");
        for (Path libraryFile : JpsProjectConfigurationLoading.listXmlFiles(dir.resolve("libraries"))) {
            this.loadProjectLibraries(this.myComponentLoader.loadRootElement(libraryFile));
        }
        if (externalConfigDir != null) {
            this.loadProjectLibraries(this.myComponentLoader.loadRootElement(externalConfigDir.resolve("libraries.xml")));
        }
        runnable.run();
        JpsProjectConfigurationLoading.loadArtifactsFromDirectory(this.project, this.myComponentLoader, dir, externalConfigDir);
        JpsProjectConfigurationLoading.loadRunConfigurationsFromDirectory(this.project, this.myComponentLoader, dir, workspaceFile);
    }

    private void loadFromIpr(@NotNull Path iprFile, @NotNull Executor executor) {
        if (iprFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(12);
        }
        if (executor == null) {
            JpsProjectLoader.$$$reportNull$$$0(13);
        }
        Element iprRoot = this.myComponentLoader.loadRootElement(iprFile);
        String projectName = FileUtilRt.getNameWithoutExtension((String)iprFile.getFileName().toString());
        this.project.setName(projectName);
        Path iwsFile = iprFile.getParent().resolve(projectName + ".iws");
        Element iwsRoot = this.myComponentLoader.loadRootElement(iwsFile);
        JpsSdkType<?> projectSdkType = this.loadProjectRoot(iprRoot);
        JpsProjectConfigurationLoading.loadProjectExtensionsFromIpr(this.project, iprRoot, iwsRoot);
        this.loadModules(JDomSerializationUtil.findComponent(iprRoot, MODULE_MANAGER_COMPONENT), projectSdkType, iwsFile, executor);
        this.loadProjectLibraries(JDomSerializationUtil.findComponent(iprRoot, "libraryTable"));
        JpsProjectConfigurationLoading.loadArtifactsFromIpr(this.project, iprRoot);
        JpsProjectConfigurationLoading.loadRunConfigurationsFromIpr(this.project, iprRoot, iwsRoot);
    }

    @Nullable
    private JpsSdkType<?> loadProjectRoot(@Nullable Element root) {
        Pair<String, String> sdkTypeIdAndName = JpsProjectConfigurationLoading.readProjectSdkTypeAndName(root);
        if (sdkTypeIdAndName != null) {
            JpsSdkType<?> sdkType = JpsSdkTableSerializer.getSdkType((String)sdkTypeIdAndName.first);
            JpsSdkTableSerializer.setSdkReference(this.project.getSdkReferencesTable(), (String)sdkTypeIdAndName.second, sdkType);
            return sdkType;
        }
        return null;
    }

    private void loadProjectLibraries(@Nullable Element libraryTableElement) {
        JpsLibraryTableSerializer.loadLibraries(libraryTableElement, this.myPathMapper, this.project.getLibraryCollection());
    }

    private void loadModules(@Nullable Element componentElement, @Nullable JpsSdkType<?> projectSdkType, @NotNull Path workspaceFile, @NotNull Executor executor) {
        if (workspaceFile == null) {
            JpsProjectLoader.$$$reportNull$$$0(14);
        }
        if (executor == null) {
            JpsProjectLoader.$$$reportNull$$$0(15);
        }
        Runnable timingLog = TimingLog.startActivity("loading modules");
        if (componentElement == null) {
            return;
        }
        Set unloadedModules = this.myLoadUnloadedModules ? Set.of() : JpsProjectConfigurationLoading.readNamesOfUnloadedModules(workspaceFile, this.myComponentLoader);
        HashSet<Path> foundFiles = new HashSet<Path>();
        ArrayList<Path> moduleFiles = new ArrayList<Path>();
        for (Element moduleElement : JDOMUtil.getChildren((Element)componentElement.getChild(MODULES_TAG), (String)MODULE_TAG)) {
            Path file;
            String path = moduleElement.getAttributeValue(FILE_PATH_ATTRIBUTE);
            if (path == null || !foundFiles.add(file = Path.of(path, new String[0])) || unloadedModules.contains(JpsProjectLoader.getModuleName(file))) continue;
            moduleFiles.add(file);
        }
        List<JpsModule> modules = this.loadModules(moduleFiles, projectSdkType, this.myPathVariables, this.myPathMapper, executor);
        for (JpsModule module : modules) {
            this.project.addModule(module);
        }
        timingLog.run();
    }

    @NotNull
    private List<JpsModule> loadModules(@NotNull List<? extends Path> moduleFiles, @Nullable JpsSdkType<?> projectSdkType, @NotNull Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper, @Nullable Executor executor) {
        ArrayList<JpsModule> arrayList;
        Path externalModuleDir;
        if (moduleFiles == null) {
            JpsProjectLoader.$$$reportNull$$$0(16);
        }
        if (pathVariables == null) {
            JpsProjectLoader.$$$reportNull$$$0(17);
        }
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(18);
        }
        if (executor == null) {
            executor = DefaultExecutorHolder.threadPool;
        }
        ArrayList<JpsModule> modules = new ArrayList<JpsModule>();
        ArrayList<CompletableFuture<Pair>> futureModuleFilesContents = new ArrayList<CompletableFuture<Pair>>();
        if (this.externalConfigurationDirectory == null) {
            externalModuleDir = null;
        } else {
            externalModuleDir = this.externalConfigurationDirectory.resolve(MODULES_TAG);
            LOG.info("External project config dir is used for modules: " + externalModuleDir);
        }
        for (Path path : moduleFiles) {
            futureModuleFilesContents.add(CompletableFuture.supplyAsync(() -> {
                String externalName;
                Element externalData;
                JpsMacroExpander expander = JpsProjectConfigurationLoading.createModuleMacroExpander(pathVariables, path);
                Element data = JpsComponentLoader.loadRootElement(path, expander);
                if (externalModuleDir != null && (externalData = JpsComponentLoader.loadRootElement(externalModuleDir.resolve(externalName = FileUtilRt.getNameWithoutExtension((String)path.getFileName().toString()) + ".xml"), expander)) != null) {
                    if (data == null) {
                        data = externalData;
                    } else {
                        JDOMUtil.deepMergeWithAttributes((Element)data, (Element)externalData, List.of(new JDOMUtil.MergeAttribute("content", "url"), new JDOMUtil.MergeAttribute("component", "name")));
                    }
                }
                if (data == null) {
                    LOG.info("Module '" + JpsProjectLoader.getModuleName(path) + "' is skipped: " + path.toAbsolutePath() + " doesn't exist");
                } else {
                    List components = data.getChildren("component");
                    Element rootManager = null;
                    Element additionalElements = null;
                    for (Element component : components) {
                        String attributeValue = component.getAttributeValue("name");
                        if (attributeValue.equals("NewModuleRootManager")) {
                            rootManager = component;
                        }
                        if (attributeValue.equals("AdditionalModuleElements")) {
                            additionalElements = component;
                        }
                        if (rootManager == null || additionalElements == null) continue;
                        break;
                    }
                    if (rootManager != null && additionalElements != null) {
                        additionalElements.removeAttribute("name");
                        additionalElements.getChildren().forEach(o -> o.removeAttribute("dumb"));
                        JDOMUtil.deepMerge((Element)rootManager, additionalElements);
                    }
                }
                return new Pair((Object)path, (Object)data);
            }, executor));
        }
        try {
            ArrayList<String> classpathDirs = new ArrayList<String>();
            for (CompletableFuture completableFuture : futureModuleFilesContents) {
                String classpathDir;
                Element element = (Element)((Pair)completableFuture.join()).getSecond();
                if (element == null || (classpathDir = element.getAttributeValue(CLASSPATH_DIR_ATTRIBUTE)) == null) continue;
                classpathDirs.add(classpathDir);
            }
            ArrayList<CompletableFuture<JpsModule>> arrayList2 = new ArrayList<CompletableFuture<JpsModule>>();
            for (CompletableFuture completableFuture : futureModuleFilesContents) {
                Pair moduleFile = (Pair)completableFuture.join();
                if (moduleFile.getSecond() == null) continue;
                arrayList2.add(CompletableFuture.supplyAsync(() -> JpsProjectLoader.loadModule((Path)moduleFile.getFirst(), (Element)moduleFile.getSecond(), classpathDirs, projectSdkType, pathVariables, pathMapper), executor));
            }
            for (CompletableFuture completableFuture : arrayList2) {
                JpsModule module = (JpsModule)completableFuture.join();
                if (module == null) continue;
                modules.add(module);
            }
            arrayList = modules;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (arrayList == null) {
            JpsProjectLoader.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    private static JpsModule loadModule(@NotNull Path file, @NotNull Element moduleRoot, List<String> paths, @Nullable JpsSdkType<?> projectSdkType, Map<String, String> pathVariables, @NotNull JpsPathMapper pathMapper) {
        if (file == null) {
            JpsProjectLoader.$$$reportNull$$$0(20);
        }
        if (moduleRoot == null) {
            JpsProjectLoader.$$$reportNull$$$0(21);
        }
        if (pathMapper == null) {
            JpsProjectLoader.$$$reportNull$$$0(22);
        }
        String name = JpsProjectLoader.getModuleName(file);
        String typeId = moduleRoot.getAttributeValue("type");
        JpsModulePropertiesSerializer<?> serializer = JpsProjectLoader.getModulePropertiesSerializer(typeId);
        JpsModule module = JpsProjectLoader.createModule(name, moduleRoot, serializer);
        module.getContainer().setChild(JpsModuleSerializationDataExtensionImpl.ROLE, new JpsModuleSerializationDataExtensionImpl(file.getParent()));
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            extension.loadModuleOptions(module, moduleRoot);
        }
        String baseModulePath = FileUtilRt.toSystemIndependentName((String)file.getParent().toString());
        String classpath = moduleRoot.getAttributeValue(CLASSPATH_ATTRIBUTE);
        if (classpath == null) {
            try {
                JpsModuleRootModelSerializer.loadRootModel(module, JDomSerializationUtil.findComponent(moduleRoot, "NewModuleRootManager"), projectSdkType, pathMapper);
            }
            catch (JpsSerializationFormatException e) {
                LOG.warn("Failed to load module configuration from " + file + ": " + e.getMessage(), (Throwable)e);
            }
        } else {
            for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
                JpsModuleClasspathSerializer classpathSerializer = extension.getClasspathSerializer();
                if (classpathSerializer == null || !classpathSerializer.getClasspathId().equals(classpath)) continue;
                String classpathDir = moduleRoot.getAttributeValue(CLASSPATH_DIR_ATTRIBUTE);
                JpsMacroExpander expander = JpsProjectConfigurationLoading.createModuleMacroExpander(pathVariables, file);
                classpathSerializer.loadClasspath(module, classpathDir, baseModulePath, expander, paths, projectSdkType);
            }
        }
        Element facetsTag = JDomSerializationUtil.findComponent(moduleRoot, "FacetManager");
        Element externalFacetsTag = JDomSerializationUtil.findComponent(moduleRoot, "ExternalFacetManager");
        Element mergedFacetsTag = facetsTag == null ? externalFacetsTag : (externalFacetsTag != null ? JDOMUtil.deepMerge((Element)facetsTag, (Element)externalFacetsTag) : facetsTag);
        JpsFacetSerializer.loadFacets(module, mergedFacetsTag);
        JpsModule jpsModule = module;
        if (jpsModule == null) {
            JpsProjectLoader.$$$reportNull$$$0(23);
        }
        return jpsModule;
    }

    @NotNull
    private static String getModuleName(@NotNull Path file) {
        if (file == null) {
            JpsProjectLoader.$$$reportNull$$$0(24);
        }
        String string = FileUtilRt.getNameWithoutExtension((String)file.getFileName().toString());
        if (string == null) {
            JpsProjectLoader.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static <P extends JpsElement> JpsModule createModule(String name, Element moduleRoot, JpsModulePropertiesSerializer<P> loader) {
        String componentName = loader.getComponentName();
        Element component = componentName != null ? JDomSerializationUtil.findComponent(moduleRoot, componentName) : null;
        return JpsElementFactory.getInstance().createModule(name, (JpsModuleType)loader.getType(), loader.loadProperties(component));
    }

    private static JpsModulePropertiesSerializer<?> getModulePropertiesSerializer(@Nullable String typeId) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsModulePropertiesSerializer<?> loader : extension.getModulePropertiesSerializers()) {
                if (!loader.getTypeId().equals(typeId)) continue;
                return loader;
            }
        }
        return JAVA_MODULE_PROPERTIES_SERIALIZER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathVariables";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iprFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFiles";
                break;
            }
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsProjectLoader";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsProjectLoader";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModules";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadProject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDirectory";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadFromIpr";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadModules";
                break;
            }
            case 19: 
            case 23: 
            case 25: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DefaultExecutorHolder {
        static final ExecutorService threadPool = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"JpsProjectLoader Pool", (Executor)SharedThreadPool.getInstance(), (int)Runtime.getRuntime().availableProcessors());

        private DefaultExecutorHolder() {
        }
    }
}

