/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue.quickfix;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmProperties;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmPropertiesFile;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmCriteria;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleRecreateToolchainDownloadUrlsQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "externalProjectPath", "", "<init>", "(Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.gradle"})
public final class GradleRecreateToolchainDownloadUrlsQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String externalProjectPath;
    @NotNull
    private final String id;

    public GradleRecreateToolchainDownloadUrlsQuickFix(@NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        this.externalProjectPath = externalProjectPath2;
        this.id = "recreate_toolchain_download_urls";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Path path = Path.of(this.externalProjectPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        GradleDaemonJvmProperties daemonJvmProperties = GradleDaemonJvmPropertiesFile.INSTANCE.getProperties(path);
        Object object = daemonJvmProperties;
        if (object == null || (object = object.getCriteria()) == null) {
            object = GradleDaemonJvmCriteria.Companion.getANY();
        }
        Object daemonJvmCriteria = object;
        return GradleDaemonJvmHelper.updateProjectDaemonJvmCriteria(project2, this.externalProjectPath, (GradleDaemonJvmCriteria)daemonJvmCriteria);
    }
}

