/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesImpl;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.properties.models.PropertyKt;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J%\u0010\f\u001a\u00020\u00052\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\u000e\"\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradlePropertiesFile;", "", "<init>", "()V", "getProperties", "Lorg/jetbrains/plugins/gradle/properties/GradleProperties;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "Ljava/nio/file/Path;", "serviceDirectory", "", "loadAndMergeProperties", "possiblePropertiesFiles", "", "([Ljava/nio/file/Path;)Lorg/jetbrains/plugins/gradle/properties/GradleProperties;", "getGradlePropertiesPathInServiceDirectory", "getGradlePropertiesPathInUserHome", "getGradlePropertiesPathInProject", "resolveGradleProjectRoot", "loadGradleProperties", "propertiesPath", "mergeGradleProperties", "most", "other", "EMPTY_GRADLE_PROPERTIES", "Lorg/jetbrains/plugins/gradle/properties/GradlePropertiesImpl;", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradlePropertiesFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,121:1\n1288#2,3:122\n*S KotlinDebug\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n*L\n51#1:122,3\n*E\n"})
public final class GradlePropertiesFile {
    @NotNull
    public static final GradlePropertiesFile INSTANCE = new GradlePropertiesFile();
    @NotNull
    private static final GradlePropertiesImpl EMPTY_GRADLE_PROPERTIES = new GradlePropertiesImpl(null, null, null, null, null);

    private GradlePropertiesFile() {
    }

    @JvmStatic
    @NotNull
    public static final GradleProperties getProperties(@NotNull Project project2, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        String serviceDirectory = GradleLocalSettings.getInstance(project2).getGradleUserHome();
        return GradlePropertiesFile.getProperties(serviceDirectory, projectPath);
    }

    @JvmStatic
    @NotNull
    public static final GradleProperties getProperties(@Nullable String serviceDirectory, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Path[] pathArray = new Path[]{INSTANCE.getGradlePropertiesPathInServiceDirectory(serviceDirectory), INSTANCE.getGradlePropertiesPathInUserHome(), INSTANCE.getGradlePropertiesPathInProject(projectPath)};
        return INSTANCE.loadAndMergeProperties(pathArray);
    }

    /*
     * WARNING - void declaration
     */
    private final GradleProperties loadAndMergeProperties(Path ... possiblePropertiesFiles) {
        void $this$fold$iv;
        Sequence sequence = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)ArraysKt.asSequence((Object[])possiblePropertiesFiles)), (Function1)loadAndMergeProperties.1.INSTANCE), (Function1)loadAndMergeProperties.2.INSTANCE), (Function1)((Function1)new Function1<Path, GradleProperties>((Object)this){

            public final GradleProperties invoke(Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GradlePropertiesFile.access$loadGradleProperties((GradlePropertiesFile)this.receiver, p0);
            }
        })));
        GradlePropertiesImpl initial$iv = EMPTY_GRADLE_PROPERTIES;
        boolean $i$f$fold = false;
        GradleProperties accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            GradleProperties gradleProperties = (GradleProperties)element$iv;
            GradleProperties p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.mergeGradleProperties(p0, (GradleProperties)p1);
        }
        return accumulator$iv;
    }

    private final Path getGradlePropertiesPathInServiceDirectory(String serviceDirectory) {
        if (serviceDirectory != null) {
            String[] stringArray = new String[]{"gradle.properties"};
            return Paths.get(serviceDirectory, stringArray);
        }
        return null;
    }

    @Nullable
    public final Path getGradlePropertiesPathInUserHome() {
        String gradleUserHome = Environment.Companion.getVariable("GRADLE_USER_HOME");
        if (gradleUserHome != null) {
            String[] stringArray = new String[]{"gradle.properties"};
            return Paths.get(gradleUserHome, stringArray);
        }
        String userHome = Environment.Companion.getProperty("user.home");
        if (userHome != null) {
            String[] stringArray = new String[]{".gradle", "gradle.properties"};
            return Paths.get(userHome, stringArray);
        }
        return null;
    }

    private final Path getGradlePropertiesPathInProject(Path projectPath) {
        Path path = this.resolveGradleProjectRoot(projectPath).resolve("gradle.properties");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path resolveGradleProjectRoot(Path projectPath) {
        for (Path buildRoot = projectPath; buildRoot != null; buildRoot = buildRoot.getParent()) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])GradleConstants.KNOWN_GRADLE_SETTINGS_FILES);
            while (iterator.hasNext()) {
                String settingsFileName = (String)iterator.next();
                Path settingsFile = buildRoot.resolve(settingsFileName);
                Intrinsics.checkNotNull((Object)settingsFile);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(settingsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                return buildRoot;
            }
        }
        return projectPath;
    }

    private final GradleProperties loadGradleProperties(Path propertiesPath) {
        Properties properties = GradleUtil.readGradleProperties(propertiesPath);
        if (properties == null) {
            return null;
        }
        Properties properties2 = properties;
        return new GradlePropertiesImpl(PropertyKt.getStringProperty(properties2, "org.gradle.java.home", propertiesPath), PropertyKt.getStringProperty(properties2, "org.gradle.logging.level", propertiesPath), PropertyKt.getBooleanProperty(properties2, "org.gradle.parallel", propertiesPath), PropertyKt.getBooleanProperty(properties2, "org.gradle.unsafe.isolated-projects", propertiesPath), PropertyKt.getStringProperty(properties2, "org.gradle.jvmargs", propertiesPath));
    }

    private final GradleProperties mergeGradleProperties(GradleProperties most, GradleProperties other) {
        Property<String> property;
        Property<Boolean> property2;
        Property<Boolean> property3;
        Property<String> property4;
        Property<String> property5 = most.getJavaHomeProperty();
        if (property5 == null) {
            property5 = other.getJavaHomeProperty();
        }
        if ((property4 = most.getLogLevel()) == null) {
            property4 = other.getLogLevel();
        }
        if ((property3 = most.getParallel()) == null) {
            property3 = other.getParallel();
        }
        if ((property2 = most.getIsolatedProjects()) == null) {
            property2 = other.getIsolatedProjects();
        }
        if ((property = most.getJvmOptions()) == null) {
            property = other.getJvmOptions();
        }
        return new GradlePropertiesImpl(property5, property4, property3, property2, property);
    }

    public static final /* synthetic */ GradleProperties access$loadGradleProperties(GradlePropertiesFile $this, Path propertiesPath) {
        return $this.loadGradleProperties(propertiesPath);
    }
}

