/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.remote.impl;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleLibraryNamesMixer {
    private static final Map<String, Boolean> NON_UNIQUE_PATH_ENTRIES = new HashMap<String, Boolean>();
    private static final char NAME_SEPARATOR = '-';

    public void mixNames(@NotNull Collection<? extends DataNode<LibraryData>> libraries) {
        if (libraries == null) {
            GradleLibraryNamesMixer.$$$reportNull$$$0(0);
        }
        if (libraries.isEmpty()) {
            return;
        }
        HashMap<String, Wrapped> names = new HashMap<String, Wrapped>();
        ArrayList<Wrapped> data = new ArrayList<Wrapped>();
        for (DataNode<LibraryData> dataNode : libraries) {
            Wrapped wrapped = new Wrapped((LibraryData)dataNode.getData());
            data.add(wrapped);
        }
        boolean mixed = false;
        while (!mixed) {
            mixed = GradleLibraryNamesMixer.doMixNames(data, names);
        }
    }

    private static boolean doMixNames(@NotNull Collection<? extends Wrapped> libraries, @NotNull Map<String, Wrapped> cache2) {
        if (libraries == null) {
            GradleLibraryNamesMixer.$$$reportNull$$$0(1);
        }
        if (cache2 == null) {
            GradleLibraryNamesMixer.$$$reportNull$$$0(2);
        }
        cache2.clear();
        for (Wrapped wrapped : libraries) {
            Wrapped previous = cache2.remove(wrapped.library.getExternalName());
            if (previous == null) {
                cache2.put(wrapped.library.getExternalName(), wrapped);
                continue;
            }
            GradleLibraryNamesMixer.mixNames(wrapped, previous);
            return wrapped.library.getExternalName().equals(previous.library.getExternalName());
        }
        return true;
    }

    private static void mixNames(@NotNull Wrapped wrapped1, @NotNull Wrapped wrapped2) {
        if (wrapped1 == null) {
            GradleLibraryNamesMixer.$$$reportNull$$$0(3);
        }
        if (wrapped2 == null) {
            GradleLibraryNamesMixer.$$$reportNull$$$0(4);
        }
        if (!wrapped1.prepare() || !wrapped2.prepare()) {
            return;
        }
        Object wrapped1AltText = null;
        Object wrapped2AltText = null;
        File file1 = wrapped1.currentFile;
        for (File file2 = wrapped2.currentFile; file1 != null && file2 != null; file1 = file1.getParentFile(), file2 = file2.getParentFile()) {
            while (file1 != null && !StringUtil.isEmpty((String)file1.getName()) && NON_UNIQUE_PATH_ENTRIES.containsKey(file1.getName())) {
                if (NON_UNIQUE_PATH_ENTRIES.get(file1.getName()).booleanValue()) {
                    wrapped1AltText = StringUtil.isEmpty(wrapped1AltText) ? file1.getName() : (String)wrapped1AltText + "-" + file1.getName();
                }
                file1 = file1.getParentFile();
            }
            while (file2 != null && !StringUtil.isEmpty((String)file2.getName()) && NON_UNIQUE_PATH_ENTRIES.containsKey(file2.getName())) {
                if (NON_UNIQUE_PATH_ENTRIES.get(file2.getName()).booleanValue()) {
                    wrapped2AltText = StringUtil.isEmpty(wrapped2AltText) ? file2.getName() : (String)wrapped2AltText + "-" + file2.getName();
                }
                file2 = file2.getParentFile();
            }
            if (file1 == null) {
                wrapped1.nextFile();
            } else if (!wrapped1.library.getExternalName().startsWith(file1.getName())) {
                wrapped1.library.setExternalName(file1.getName() + "-" + wrapped1.library.getExternalName());
            }
            if (file2 == null) {
                wrapped2.nextFile();
            } else if (!wrapped2.library.getExternalName().startsWith(file2.getName())) {
                wrapped2.library.setExternalName(file2.getName() + "-" + wrapped2.library.getExternalName());
            }
            if (wrapped1.library.getExternalName().equals(wrapped2.library.getExternalName())) {
                if (wrapped1AltText != null) {
                    GradleLibraryNamesMixer.diversifyName((String)wrapped1AltText, wrapped1, file1);
                    return;
                }
                if (wrapped2AltText != null) {
                    GradleLibraryNamesMixer.diversifyName((String)wrapped2AltText, wrapped2, file1);
                    return;
                }
            } else {
                return;
            }
            if (file1 != null && file2 != null) continue;
            return;
        }
    }

    private static void diversifyName(@NotNull String changeText, @NotNull Wrapped wrapped, @Nullable File file) {
        if (changeText == null) {
            GradleLibraryNamesMixer.$$$reportNull$$$0(5);
        }
        if (wrapped == null) {
            GradleLibraryNamesMixer.$$$reportNull$$$0(6);
        }
        String name = wrapped.library.getExternalName();
        int i = file == null ? -1 : name.indexOf(file.getName());
        String newName = i >= 0 ? name.substring(0, i + file.getName().length()) + "-" + changeText + name.substring(i + file.getName().length()) : changeText + "-" + name;
        wrapped.library.setExternalName(newName);
    }

    static {
        NON_UNIQUE_PATH_ENTRIES.put("src", false);
        NON_UNIQUE_PATH_ENTRIES.put("main", false);
        NON_UNIQUE_PATH_ENTRIES.put("test", true);
        NON_UNIQUE_PATH_ENTRIES.put("resources", false);
        NON_UNIQUE_PATH_ENTRIES.put("java", false);
        NON_UNIQUE_PATH_ENTRIES.put("groovy", false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapped1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapped2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapped";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/remote/impl/GradleLibraryNamesMixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mixNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doMixNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "diversifyName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Wrapped {
        public final Set<File> files;
        public File currentFile;
        public LibraryData library;

        Wrapped(@NotNull LibraryData library) {
            if (library == null) {
                Wrapped.$$$reportNull$$$0(0);
            }
            this.files = new HashSet<File>();
            this.library = library;
            for (LibraryPathType pathType : LibraryPathType.values()) {
                for (String path : library.getPaths(pathType)) {
                    this.files.add(new File(path));
                }
            }
        }

        public boolean prepare() {
            if (this.currentFile != null) {
                return true;
            }
            return this.nextFile();
        }

        public boolean nextFile() {
            if (this.files.isEmpty()) {
                return false;
            }
            Iterator<File> iterator = this.files.iterator();
            this.currentFile = iterator.next();
            iterator.remove();
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/plugins/gradle/remote/impl/GradleLibraryNamesMixer$Wrapped", "<init>"));
        }
    }
}

