/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.task.TaskExecutionSpec;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmProperties;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmPropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmCriteria;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelperKt;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleDaemonJvmHelper;", "", "<init>", "()V", "isDaemonJvmCriteriaSupported", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "isDamonJvmVendorCriteriaSupported", "isDaemonJvmCriteriaRequired", "isProjectUsingDaemonJvmCriteria", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "externalProjectPath", "Ljava/nio/file/Path;", "isExecutingUpdateDaemonJvmTask", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "getGradleJvmForUpdateDaemonJvmTask", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "updateProjectDaemonJvmCriteria", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "daemonJvmCriteria", "Lorg/jetbrains/plugins/gradle/service/execution/GradleDaemonJvmCriteria;", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleDaemonJvmHelper {
    @NotNull
    public static final GradleDaemonJvmHelper INSTANCE = new GradleDaemonJvmHelper();

    private GradleDaemonJvmHelper() {
    }

    @JvmStatic
    public static final boolean isDaemonJvmCriteriaSupported(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return gradleVersion.compareTo(GradleDaemonJvmHelperKt.access$getMIN_VERSION_SUPPORTING_DAEMON_TOOLCHAIN_VERSION_CRITERIA$p()) >= 0;
    }

    @JvmStatic
    public static final boolean isDamonJvmVendorCriteriaSupported(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return gradleVersion.compareTo(GradleDaemonJvmHelperKt.access$getMIN_VERSION_SUPPORTING_DAEMON_TOOLCHAIN_VENDOR_CRITERIA$p()) >= 0;
    }

    @JvmStatic
    public static final boolean isDaemonJvmCriteriaRequired(@NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return false;
    }

    @JvmStatic
    public static final boolean isProjectUsingDaemonJvmCriteria(@NotNull GradleProjectSettings projectSettings) {
        Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
        GradleVersion gradleVersion = projectSettings.resolveGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"resolveGradleVersion(...)");
        GradleVersion gradleVersion2 = gradleVersion;
        Path externalProjectPath2 = Path.of(projectSettings.getExternalProjectPath(), new String[0]);
        Intrinsics.checkNotNull((Object)externalProjectPath2);
        return GradleDaemonJvmHelper.isProjectUsingDaemonJvmCriteria(externalProjectPath2, gradleVersion2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isProjectUsingDaemonJvmCriteria(@NotNull Path externalProjectPath2, @NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        if (!Registry.Companion.is("gradle.daemon.jvm.criteria")) return false;
        if (GradleDaemonJvmHelper.isDaemonJvmCriteriaRequired(gradleVersion)) {
            return true;
        }
        if (!GradleDaemonJvmHelper.isDaemonJvmCriteriaSupported(gradleVersion)) return false;
        GradleDaemonJvmProperties gradleDaemonJvmProperties = GradleDaemonJvmPropertiesFile.INSTANCE.getProperties(externalProjectPath2);
        if (gradleDaemonJvmProperties == null) return false;
        Property<String> property = gradleDaemonJvmProperties.getVersion();
        if (property == null) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isExecutingUpdateDaemonJvmTask(@NotNull GradleExecutionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        return Intrinsics.areEqual((Object)settings.getUserData(GradleDaemonJvmHelperKt.access$getUPDATE_DAEMON_JVM_TASK$p()), (Object)true);
    }

    @JvmStatic
    @Nullable
    public static final String getGradleJvmForUpdateDaemonJvmTask(@NotNull ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Project project2 = id.findProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project3);
        Sdk sdk = projectRootManager.getProjectSdk();
        return sdk != null ? sdk.getHomePath() : null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final CompletableFuture<Boolean> updateProjectDaemonJvmCriteria(@NotNull Project project2, @NotNull String externalProjectPath2, @NotNull GradleDaemonJvmCriteria daemonJvmCriteria) {
        JvmVendor vendor;
        void $this$updateProjectDaemonJvmCriteria_u24lambda_u241_u24lambda_u240;
        List list;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)daemonJvmCriteria, (String)"daemonJvmCriteria");
        ExternalSystemTaskExecutionSettings $this$updateProjectDaemonJvmCriteria_u24lambda_u241 = externalSystemTaskExecutionSettings = new ExternalSystemTaskExecutionSettings();
        boolean bl = false;
        $this$updateProjectDaemonJvmCriteria_u24lambda_u241.setExternalProjectPath(externalProjectPath2);
        $this$updateProjectDaemonJvmCriteria_u24lambda_u241.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        $this$updateProjectDaemonJvmCriteria_u24lambda_u241.setExecutionName(GradleBundle.message("gradle.execution.name.config.daemon.jvm.criteria", new Object[0]));
        List list2 = list = CollectionsKt.createListBuilder();
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings2 = $this$updateProjectDaemonJvmCriteria_u24lambda_u241;
        boolean bl2 = false;
        $this$updateProjectDaemonJvmCriteria_u24lambda_u241_u24lambda_u240.add("updateDaemonJvm");
        String version = daemonJvmCriteria.getVersion();
        if (version != null) {
            $this$updateProjectDaemonJvmCriteria_u24lambda_u241_u24lambda_u240.add("--jvm-version");
            $this$updateProjectDaemonJvmCriteria_u24lambda_u241_u24lambda_u240.add(StringUtil.wrapWithDoubleQuote((String)version));
        }
        if ((vendor = daemonJvmCriteria.getVendor()) != null) {
            $this$updateProjectDaemonJvmCriteria_u24lambda_u241_u24lambda_u240.add("--jvm-vendor");
            $this$updateProjectDaemonJvmCriteria_u24lambda_u241_u24lambda_u240.add(StringUtil.wrapWithDoubleQuote((String)vendor.getRawVendor()));
        }
        externalSystemTaskExecutionSettings2.setTaskNames(CollectionsKt.build((List)list));
        ExternalSystemTaskExecutionSettings taskSettings = externalSystemTaskExecutionSettings;
        ExternalSystemTaskExecutionSettings $this$updateProjectDaemonJvmCriteria_u24lambda_u242 = $this$updateProjectDaemonJvmCriteria_u24lambda_u241 = new UserDataHolderBase();
        boolean bl3 = false;
        $this$updateProjectDaemonJvmCriteria_u24lambda_u242.putUserData(GradleDaemonJvmHelperKt.access$getUPDATE_DAEMON_JVM_TASK$p(), (Object)true);
        ExternalSystemTaskExecutionSettings taskUserData = $this$updateProjectDaemonJvmCriteria_u24lambda_u241;
        CompletableFuture<Boolean> taskResult = new CompletableFuture<Boolean>();
        TaskCallback taskCallback2 = new TaskCallback(taskResult){
            final /* synthetic */ CompletableFuture<Boolean> $taskResult;
            {
                this.$taskResult = $taskResult;
            }

            public void onSuccess() {
                this.$taskResult.complete(true);
            }

            public void onFailure() {
                this.$taskResult.complete(false);
            }
        };
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        TaskExecutionSpec executionSpec = TaskExecutionSpec.Companion.create(project2, projectSystemId, "Run", taskSettings).withUserData((UserDataHolderBase)taskUserData).withCallback(taskCallback2).build();
        ExternalSystemUtil.runTask((TaskExecutionSpec)executionSpec);
        return taskResult;
    }
}

