/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleIdeManager;
import org.jetbrains.plugins.gradle.execution.target.GradleRuntimeType;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTasks;

public class GradleRunConfiguration
extends ExternalSystemRunConfiguration
implements SMRunnerConsolePropertiesProvider,
TargetEnvironmentAwareRunProfile {
    private static final String DEBUG_FLAG_NAME = "GradleScriptDebugEnabled";
    private static final String FORCE_TEST_NAME = "ForceTestExec";
    private static final String DEBUG_ALL_NAME = "DebugAllEnabled";
    private static final String RUN_AS_TEST_NAME = "RunAsTest";
    public static final Key<Boolean> DEBUG_ALL_KEY = Key.create((String)"DEBUG_ALL_TASKS");
    public static final Key<Boolean> RUN_AS_TEST_KEY = Key.create((String)"RUN_AS_TEST");
    public static final Key<Boolean> IS_TEST_TASK_RERUN_KEY = Key.create((String)"IS_TEST_TASK_RERUN");
    private boolean isDebugAllEnabled = false;
    private boolean isRunAsTest = false;

    public GradleRunConfiguration(Project project2, ConfigurationFactory factory, String name) {
        super(GradleConstants.SYSTEM_ID, project2, factory, name);
        this.setDebugServerProcess(true);
        this.setReattachDebugProcess(true);
    }

    public boolean isDebugAllEnabled() {
        return this.isDebugAllEnabled;
    }

    public void setDebugAllEnabled(boolean debugAllEnabled) {
        this.isDebugAllEnabled = debugAllEnabled;
        this.putUserData(DEBUG_ALL_KEY, debugAllEnabled);
    }

    public boolean isRunAsTest() {
        return this.isRunAsTest;
    }

    public void setRunAsTest(boolean runAsTest) {
        this.isRunAsTest = runAsTest;
        this.putUserData(RUN_AS_TEST_KEY, runAsTest);
        this.putUserData(IS_TEST_TASK_RERUN_KEY, runAsTest);
    }

    @NotNull
    public String getRawCommandLine() {
        String string = this.getCommandLine().getText();
        if (string == null) {
            GradleRunConfiguration.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setRawCommandLine(@NotNull String commandLine) {
        if (commandLine == null) {
            GradleRunConfiguration.$$$reportNull$$$0(1);
        }
        this.setCommandLine(GradleCommandLine.parse(commandLine));
    }

    public void setCommandLine(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleRunConfiguration.$$$reportNull$$$0(2);
        }
        this.getSettings().setTaskNames(commandLine.getTasks().getTokens());
        this.getSettings().setScriptParameters(commandLine.getOptions().getText());
    }

    @NotNull
    public GradleCommandLine getCommandLine() {
        GradleCommandLine gradleCommandLine = GradleCommandLineUtil.parseCommandLine((List<String>)this.getSettings().getTaskNames(), this.getSettings().getScriptParameters());
        if (gradleCommandLine == null) {
            GradleRunConfiguration.$$$reportNull$$$0(3);
        }
        return gradleCommandLine;
    }

    @ApiStatus.Internal
    @NotNull
    public LocatableRunConfigurationOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        if (locatableRunConfigurationOptions == null) {
            GradleRunConfiguration.$$$reportNull$$$0(4);
        }
        return locatableRunConfigurationOptions;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GradleRunConfiguration.$$$reportNull$$$0(5);
        }
        super.readExternal(element);
        GradleRunConfiguration.readExternalBoolean((Element)element, (String)DEBUG_FLAG_NAME, arg_0 -> ((GradleRunConfiguration)this).setDebugServerProcess(arg_0));
        GradleRunConfiguration.readExternalBoolean((Element)element, (String)FORCE_TEST_NAME, this::setRunAsTest);
        GradleRunConfiguration.readExternalBoolean((Element)element, (String)DEBUG_ALL_NAME, this::setDebugAllEnabled);
        if (!GradleRunConfiguration.readExternalBoolean((Element)element, (String)RUN_AS_TEST_NAME, this::setRunAsTest)) {
            GradleCommandLineTasks tasks2 = this.getCommandLine().getTasks();
            boolean isRunAsTest = ContainerUtil.exists((Iterable)tasks2, it -> !GradleCommandLineUtil.getTestPatterns(it).isEmpty());
            this.setRunAsTest(isRunAsTest);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GradleRunConfiguration.$$$reportNull$$$0(6);
        }
        super.writeExternal(element);
        GradleRunConfiguration.writeExternalBoolean((Element)element, (String)DEBUG_ALL_NAME, (boolean)this.isDebugAllEnabled());
        GradleRunConfiguration.writeExternalBoolean((Element)element, (String)RUN_AS_TEST_NAME, (boolean)this.isRunAsTest());
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            GradleRunConfiguration.$$$reportNull$$$0(7);
        }
        SMTRunnerConsoleProperties sMTRunnerConsoleProperties = GradleIdeManager.getInstance().createTestConsoleProperties(this.getProject(), executor, (RunConfiguration)this);
        if (sMTRunnerConsoleProperties == null) {
            GradleRunConfiguration.$$$reportNull$$$0(8);
        }
        return sMTRunnerConsoleProperties;
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        if (target == null) {
            GradleRunConfiguration.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return (LanguageRuntimeType)LanguageRuntimeType.EXTENSION_NAME.findExtension(GradleRuntimeType.class);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawCommandLine";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestConsoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRawCommandLine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 7, 9 -> new IllegalArgumentException(string);
        };
    }
}

