/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.telemetry;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.OtlpConfiguration;
import com.intellij.platform.diagnostic.telemetry.impl.agent.AgentConfiguration;
import com.intellij.platform.diagnostic.telemetry.impl.agent.TelemetryAgentProvider;
import com.intellij.platform.diagnostic.telemetry.impl.agent.TelemetryAgentResolver;
import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContext;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelperExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/telemetry/GradleTelemetryAgentProvidingExecutionHelperExtension;", "Lorg/jetbrains/plugins/gradle/service/project/GradleExecutionHelperExtension;", "<init>", "()V", "prepareForExecution", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "operation", "Lorg/gradle/tooling/LongRunningOperation;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "buildEnvironment", "Lorg/gradle/tooling/model/build/BuildEnvironment;", "intellij.gradle"})
public final class GradleTelemetryAgentProvidingExecutionHelperExtension
implements GradleExecutionHelperExtension {
    @Override
    public void prepareForExecution(@NotNull ExternalSystemTaskId id, @NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @Nullable BuildEnvironment buildEnvironment) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        if (!Registry.Companion.is("gradle.daemon.opentelemetry.agent.enabled", false)) {
            return;
        }
        URI uRI = OtlpConfiguration.getTraceEndpointURI();
        if (uRI == null) {
            return;
        }
        URI traceEndpoint = uRI;
        Path path = TelemetryAgentResolver.getAgentLocation();
        if (path == null) {
            return;
        }
        Path agentLocation = path;
        TelemetryContext telemetryContext = TelemetryContext.current();
        Intrinsics.checkNotNullExpressionValue((Object)telemetryContext, (String)"current(...)");
        AgentConfiguration configuration = AgentConfiguration.Companion.forService("Gradle", telemetryContext, traceEndpoint, agentLocation, AgentConfiguration.Settings.Companion.withoutMetrics());
        List jvmArgs = TelemetryAgentProvider.getJvmArgs((AgentConfiguration)configuration);
        operation.addJvmArguments((Iterable)jvmArgs);
    }
}

