/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.GradleLightBuild;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.service.execution.GradleUserHomeUtil;
import org.jetbrains.plugins.gradle.service.modelAction.GradleIdeaModelHolder;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverIndicator;
import org.jetbrains.plugins.gradle.service.project.MapBasedArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@ApiStatus.Internal
public class DefaultProjectResolverContext
extends UserDataHolderBase
implements ProjectResolverContext {
    @NotNull
    private final ExternalSystemTaskId myExternalSystemTaskId;
    @NotNull
    private final String myProjectPath;
    @NotNull
    private final GradleExecutionSettings mySettings;
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    @NotNull
    private final GradleProjectResolverIndicator myProjectResolverIndicator;
    @Nullable
    private GradleIdeaModelHolder myModels;
    private File myGradleUserHome;
    @Nullable
    private String myProjectGradleVersion;
    private final boolean myBuildSrcProject;
    @Nullable
    private String myBuildSrcGroup;
    @Nullable
    private BuildEnvironment myBuildEnvironment;
    @Nullable
    private final GradlePartialResolverPolicy myPolicy;
    @NotNull
    private final ArtifactMappingService myArtifactsMap;
    @Nullable
    private Boolean myPhasedSyncEnabled;
    @Nullable
    private Boolean myStreamingModelFetchingEnabled;
    private static final Logger LOG = Logger.getInstance(DefaultProjectResolverContext.class);

    public DefaultProjectResolverContext(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String projectPath, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable GradlePartialResolverPolicy resolverPolicy, @NotNull GradleProjectResolverIndicator projectResolverIndicator, boolean isBuildSrcProject) {
        if (externalSystemTaskId == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(3);
        }
        if (projectResolverIndicator == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(4);
        }
        this.myArtifactsMap = new MapBasedArtifactMappingService(CollectionFactory.createFilePathMap());
        this.myPhasedSyncEnabled = null;
        this.myStreamingModelFetchingEnabled = null;
        this.myExternalSystemTaskId = externalSystemTaskId;
        this.myProjectPath = projectPath;
        this.mySettings = settings;
        this.myListener = listener2;
        this.myPolicy = resolverPolicy;
        this.myProjectResolverIndicator = projectResolverIndicator;
        this.myBuildSrcProject = isBuildSrcProject;
    }

    public DefaultProjectResolverContext(@NotNull DefaultProjectResolverContext resolverContext, @NotNull String projectPath, @NotNull GradleExecutionSettings settings, boolean isBuildSrcProject) {
        if (resolverContext == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(5);
        }
        if (projectPath == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(7);
        }
        this(resolverContext.myExternalSystemTaskId, projectPath, settings, resolverContext.myListener, resolverContext.myPolicy, resolverContext.myProjectResolverIndicator, isBuildSrcProject);
        resolverContext.copyUserDataTo(this);
    }

    @Override
    @NotNull
    public ExternalSystemTaskId getExternalSystemTaskId() {
        ExternalSystemTaskId externalSystemTaskId = this.myExternalSystemTaskId;
        if (externalSystemTaskId == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(8);
        }
        return externalSystemTaskId;
    }

    @Override
    @Nullable
    public String getIdeProjectPath() {
        return this.mySettings.getIdeProjectPath();
    }

    @Override
    @NotNull
    public String getProjectPath() {
        String string = this.myProjectPath;
        if (string == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public GradleExecutionSettings getSettings() {
        GradleExecutionSettings gradleExecutionSettings = this.mySettings;
        if (gradleExecutionSettings == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(10);
        }
        return gradleExecutionSettings;
    }

    @NotNull
    public ProgressIndicator getProgressIndicator() {
        GradleProjectResolverIndicator gradleProjectResolverIndicator = this.myProjectResolverIndicator;
        if (gradleProjectResolverIndicator == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(11);
        }
        return gradleProjectResolverIndicator;
    }

    @NotNull
    public CancellationTokenSource getCancellationTokenSource() {
        GradleProjectResolverIndicator gradleProjectResolverIndicator = this.myProjectResolverIndicator;
        if (gradleProjectResolverIndicator == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(12);
        }
        return gradleProjectResolverIndicator;
    }

    @Override
    @NotNull
    public CancellationToken getCancellationToken() {
        CancellationToken cancellationToken = this.myProjectResolverIndicator.token();
        if (cancellationToken == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(13);
        }
        return cancellationToken;
    }

    public <R> R computeCancellable(@NotNull Supplier<R> action) {
        if (action == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(14);
        }
        Ref result = new Ref();
        this.runCancellable(() -> result.set(action.get()));
        return (R)result.get();
    }

    public void runCancellable(@NotNull Runnable action) {
        if (action == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(15);
        }
        try {
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                ProgressManager.checkCanceled();
                action.run();
            }, (ProgressIndicator)this.myProjectResolverIndicator);
        }
        catch (ProcessCanceledException e) {
            this.myProjectResolverIndicator.cancel();
            throw e;
        }
    }

    @Override
    @NotNull
    public ExternalSystemTaskNotificationListener getListener() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.myListener;
        if (externalSystemTaskNotificationListener == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(16);
        }
        return externalSystemTaskNotificationListener;
    }

    @Override
    public boolean isPhasedSyncEnabled() {
        if (this.myPhasedSyncEnabled == null) {
            this.myPhasedSyncEnabled = DefaultProjectResolverContext.isPhasedSyncEnabledImpl(this);
        }
        return this.myPhasedSyncEnabled;
    }

    private static boolean isPhasedSyncEnabledImpl(@NotNull ProjectResolverContext context) {
        if (context == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(17);
        }
        if (!Registry.is((String)"gradle.phased.sync.enabled")) {
            LOG.debug("The phased Gradle sync isn't applicable: disabled by registry");
            return false;
        }
        if (!context.isResolveModulePerSourceSet()) {
            LOG.debug("The phased Gradle sync isn't applicable: unsupported sync mode with isResolveModulePerSourceSet = false");
            return false;
        }
        if (!context.isUseQualifiedModuleNames()) {
            LOG.debug("The phased Gradle sync isn't applicable: unsupported sync mode with isUseQualifiedModuleNames = false");
            return false;
        }
        return true;
    }

    public boolean isStreamingModelFetchingEnabled() {
        if (this.myStreamingModelFetchingEnabled == null) {
            this.myStreamingModelFetchingEnabled = DefaultProjectResolverContext.isStreamingModelFetchingEnabledImpl(this);
        }
        return this.myStreamingModelFetchingEnabled;
    }

    private static boolean isStreamingModelFetchingEnabledImpl(@NotNull ProjectResolverContext context) {
        Path projectPath;
        GradleProperties properties;
        Property<Boolean> isolatedProjects;
        if (context == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(18);
        }
        if (!Registry.is((String)"gradle.phased.sync.enabled")) {
            LOG.debug("The streaming Gradle model fetching isn't applicable: disabled by registry");
            return false;
        }
        Project project2 = context.getExternalSystemTaskId().findProject();
        if (project2 == null) {
            String projectId = context.getExternalSystemTaskId().getIdeProjectId();
            LOG.debug("The streaming Gradle model fetching isn't applicable: project is closed: " + projectId);
            return false;
        }
        String gradleVersion = context.getProjectGradleVersion();
        if (gradleVersion == null) {
            LOG.debug("The streaming Gradle model fetching isn't applicable: Gradle version cannot be determined");
            return false;
        }
        if (GradleVersionUtil.isGradleOlderThan((String)gradleVersion, (String)"8.6")) {
            LOG.debug("The streaming Gradle model fetching isn't applicable: unsupported Gradle version: " + gradleVersion);
            return false;
        }
        if (GradleVersionUtil.isGradleOlderThan((String)gradleVersion, (String)"8.9") && (isolatedProjects = (properties = GradlePropertiesFile.getProperties(project2, projectPath = Path.of(context.getProjectPath(), new String[0]))).getIsolatedProjects()) != null && isolatedProjects.getValue().booleanValue()) {
            LOG.debug("The streaming Gradle model fetching isn't applicable: unsupported isolated-projects mode: " + isolatedProjects);
            return false;
        }
        return true;
    }

    @Override
    public boolean isResolveModulePerSourceSet() {
        return this.mySettings.isResolveModulePerSourceSet();
    }

    @Override
    public boolean isUseQualifiedModuleNames() {
        return this.mySettings.isUseQualifiedModuleNames();
    }

    @Override
    public boolean isDelegatedBuild() {
        return this.mySettings.isDelegatedBuild();
    }

    public File getGradleUserHome() {
        if (this.myGradleUserHome == null) {
            String serviceDirectory = this.mySettings.getServiceDirectory();
            this.myGradleUserHome = serviceDirectory != null ? new File(serviceDirectory) : GradleUserHomeUtil.gradleUserHomeDir();
        }
        return this.myGradleUserHome;
    }

    @NotNull
    public GradleIdeaModelHolder getModels() {
        assert (this.myModels != null);
        GradleIdeaModelHolder gradleIdeaModelHolder = this.myModels;
        if (gradleIdeaModelHolder == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(19);
        }
        return gradleIdeaModelHolder;
    }

    public void setModels(@NotNull GradleIdeaModelHolder models) {
        if (models == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(20);
        }
        this.myModels = models;
    }

    @Override
    @NotNull
    public GradleLightBuild getRootBuild() {
        GradleLightBuild gradleLightBuild = this.getModels().getRootBuild();
        if (gradleLightBuild == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(21);
        }
        return gradleLightBuild;
    }

    @Override
    @NotNull
    public Collection<? extends GradleLightBuild> getNestedBuilds() {
        List<GradleLightBuild> list = this.getModels().getNestedBuilds();
        if (list == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<? extends GradleLightBuild> getAllBuilds() {
        List<GradleLightBuild> list = this.getModels().getAllBuilds();
        if (list == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    @Nullable
    public <T> T getRootModel(@NotNull Class<T> modelClass) {
        if (modelClass == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(24);
        }
        return this.getModels().getRootModel(modelClass);
    }

    @Override
    @Nullable
    public <T> T getBuildModel(@NotNull BuildModel buildModel, @NotNull Class<T> modelClass) {
        if (buildModel == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(25);
        }
        if (modelClass == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(26);
        }
        return this.getModels().getBuildModel(buildModel, modelClass);
    }

    @Override
    @Nullable
    public <T> T getProjectModel(@NotNull ProjectModel projectModel, @NotNull Class<T> modelClass) {
        if (projectModel == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(27);
        }
        if (modelClass == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(28);
        }
        return this.getModels().getProjectModel(projectModel, modelClass);
    }

    @Override
    public boolean hasModulesWithModel(@NotNull Class<?> modelClass) {
        if (modelClass == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(29);
        }
        return this.getModels().hasModulesWithModel(modelClass);
    }

    @Override
    public String getProjectGradleVersion() {
        BuildEnvironment buildEnvironment;
        if (this.myProjectGradleVersion == null && (buildEnvironment = this.getBuildEnvironment()) != null) {
            this.myProjectGradleVersion = buildEnvironment.getGradle().getGradleVersion();
        }
        return this.myProjectGradleVersion;
    }

    public boolean isBuildSrcProject() {
        return this.myBuildSrcProject;
    }

    public void setBuildSrcGroup(@Nullable String groupId) {
        this.myBuildSrcGroup = groupId;
    }

    @Override
    @Nullable
    public String getBuildSrcGroup() {
        return this.myBuildSrcGroup;
    }

    @Override
    @Nullable
    public String getBuildSrcGroup(@NotNull String rootName, @NotNull BuildIdentifier buildIdentifier) {
        if (rootName == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(30);
        }
        if (buildIdentifier == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(31);
        }
        if (!"buildSrc".equals(rootName)) {
            return this.myBuildSrcGroup;
        }
        String parentRootDir = buildIdentifier.getRootDir().getParent();
        return this.getAllBuilds().stream().filter(b -> b.getBuildIdentifier().getRootDir().toString().equals(parentRootDir)).findFirst().map(model -> model.getName()).orElse(this.myBuildSrcGroup);
    }

    @Override
    public void report(@NotNull MessageEvent.Kind kind, @NotNull BuildIssue buildIssue) {
        if (kind == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(32);
        }
        if (buildIssue == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(33);
        }
        BuildIssueEventImpl buildIssueEvent = new BuildIssueEventImpl((Object)this.myExternalSystemTaskId, buildIssue, kind);
        this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(this.myExternalSystemTaskId, (BuildEvent)buildIssueEvent));
    }

    void setBuildEnvironment(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(34);
        }
        this.myBuildEnvironment = buildEnvironment;
    }

    @Override
    @Nullable
    public BuildEnvironment getBuildEnvironment() {
        if (this.myBuildEnvironment == null && this.myModels != null) {
            this.myBuildEnvironment = this.myModels.getBuildEnvironment();
        }
        return this.myBuildEnvironment;
    }

    @Override
    @Nullable
    public GradlePartialResolverPolicy getPolicy() {
        return this.myPolicy;
    }

    @Override
    @NotNull
    public ArtifactMappingService getArtifactsMap() {
        ArtifactMappingService artifactMappingService = this.myArtifactsMap;
        if (artifactMappingService == null) {
            DefaultProjectResolverContext.$$$reportNull$$$0(35);
        }
        return artifactMappingService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 16, 19, 21, 22, 23, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemTaskId";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/DefaultProjectResolverContext";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildIdentifier";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildIssue";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/DefaultProjectResolverContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemTaskId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancellationTokenSource";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancellationToken";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootBuild";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedBuilds";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuilds";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 35: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeCancellable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runCancellable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPhasedSyncEnabledImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isStreamingModelFetchingEnabledImpl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setModels";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRootModel";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getBuildModel";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getProjectModel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasModulesWithModel";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getBuildSrcGroup";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setBuildEnvironment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 16, 19, 21, 22, 23, 35 -> new IllegalStateException(string);
        };
    }
}

