/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.linkage.partial;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.linkage.partial.PartialLinkageConfig;
import org.jetbrains.kotlin.ir.linkage.partial.PartialLinkageLogLevel;
import org.jetbrains.kotlin.ir.linkage.partial.PartialLinkageMode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aN\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\r\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"partialLinkageConfig", "Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageConfig;", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getPartialLinkageConfig", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageConfig;", "setupPartialLinkageConfig", "", "mode", "", "logLevel", "compilerModeAllowsUsingPartialLinkage", "", "onWarning", "Lkotlin/Function1;", "onError", "config", "ir.tree"})
public final class PartialLinkageConfigKt {
    @NotNull
    public static final PartialLinkageConfig getPartialLinkageConfig(@NotNull CompilerConfiguration $this$partialLinkageConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$partialLinkageConfig, (String)"<this>");
        PartialLinkageConfig partialLinkageConfig = (PartialLinkageConfig)$this$partialLinkageConfig.get(PartialLinkageConfig.Companion.getKEY());
        if (partialLinkageConfig == null) {
            partialLinkageConfig = PartialLinkageConfig.Companion.getDEFAULT();
        }
        return partialLinkageConfig;
    }

    public static final void setupPartialLinkageConfig(@NotNull CompilerConfiguration $this$setupPartialLinkageConfig, @Nullable String mode, @Nullable String logLevel, boolean compilerModeAllowsUsingPartialLinkage, @NotNull Function1<? super String, Unit> onWarning, @NotNull Function1<? super String, Unit> onError) {
        PartialLinkageLogLevel partialLinkageLogLevel;
        PartialLinkageMode resolvedMode;
        PartialLinkageMode partialLinkageMode;
        Intrinsics.checkNotNullParameter((Object)$this$setupPartialLinkageConfig, (String)"<this>");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        if (mode != null) {
            PartialLinkageMode partialLinkageMode2 = PartialLinkageMode.Companion.resolveMode(mode);
            if (partialLinkageMode2 == null) {
                onError.invoke((Object)("Unknown partial linkage mode '" + mode + '\''));
                return;
            }
            PartialLinkageMode resolvedMode2 = partialLinkageMode2;
            if (!compilerModeAllowsUsingPartialLinkage && resolvedMode2.isEnabled()) {
                onWarning.invoke((Object)("Current compiler configuration does not allow using partial linkage mode '" + mode + "'. The partial linkage will be disabled."));
                partialLinkageMode = PartialLinkageMode.DISABLE;
            } else {
                partialLinkageMode = resolvedMode2;
            }
        } else {
            partialLinkageMode = resolvedMode = !compilerModeAllowsUsingPartialLinkage ? PartialLinkageMode.DISABLE : PartialLinkageMode.Companion.getDEFAULT();
        }
        if (logLevel != null) {
            partialLinkageLogLevel = PartialLinkageLogLevel.Companion.resolveLogLevel(logLevel);
            if (partialLinkageLogLevel == null) {
                onError.invoke((Object)("Unknown partial linkage compile-time log level '" + logLevel + '\''));
                return;
            }
        } else {
            partialLinkageLogLevel = PartialLinkageLogLevel.Companion.getDEFAULT();
        }
        PartialLinkageLogLevel resolvedLogLevel = partialLinkageLogLevel;
        PartialLinkageConfigKt.setupPartialLinkageConfig($this$setupPartialLinkageConfig, new PartialLinkageConfig(resolvedMode, resolvedLogLevel));
    }

    public static final void setupPartialLinkageConfig(@NotNull CompilerConfiguration $this$setupPartialLinkageConfig, @NotNull PartialLinkageConfig config) {
        Intrinsics.checkNotNullParameter((Object)$this$setupPartialLinkageConfig, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        $this$setupPartialLinkageConfig.put(PartialLinkageConfig.Companion.getKEY(), (Object)config);
    }
}

