/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyModel;

import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicy;
import com.intellij.gradle.toolingExtension.impl.model.dependencyDownloadPolicyModel.GradleDependencyDownloadPolicyCache;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary.AuxiliaryArtifactResolver;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary.AuxiliaryConfigurationArtifacts;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary.ExperimentalAuxiliaryArtifactResolver;
import com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary.LegacyAuxiliaryArtifactResolver;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex.GradleSourceSetArtifactIndex;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.specs.Spec;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

public final class GradleDependencyResolver {
    private static final boolean IS_83_OR_BETTER = GradleVersionUtil.isCurrentGradleAtLeast((String)"8.3");
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDependencyDownloadPolicy myDownloadPolicy;
    @NotNull
    private final GradleSourceSetArtifactIndex mySourceSetArtifactIndex;

    public GradleDependencyResolver(@NotNull ModelBuilderContext context, @NotNull Project project, @NotNull GradleDependencyDownloadPolicy downloadPolicy) {
        if (context == null) {
            GradleDependencyResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleDependencyResolver.$$$reportNull$$$0(1);
        }
        if (downloadPolicy == null) {
            GradleDependencyResolver.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDownloadPolicy = downloadPolicy;
        this.mySourceSetArtifactIndex = GradleSourceSetArtifactIndex.getInstance(context);
    }

    public GradleDependencyResolver(@NotNull ModelBuilderContext context, @NotNull Project project) {
        if (context == null) {
            GradleDependencyResolver.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleDependencyResolver.$$$reportNull$$$0(4);
        }
        this(context, project, GradleDependencyDownloadPolicyCache.getInstance(context).getDependencyDownloadPolicy(project));
    }

    @NotNull
    private static Set<ResolvedArtifactResult> resolveConfigurationDependencies(@NotNull Configuration configuration, final Set<String> allowedDependencyGroups) {
        Set set;
        if (configuration == null) {
            GradleDependencyResolver.$$$reportNull$$$0(5);
        }
        try {
            ArtifactView artifactView = configuration.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(){

                public void execute(@NotNull ArtifactView.ViewConfiguration configuration) {
                    if (configuration == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    configuration.setLenient(true);
                    if (!allowedDependencyGroups.isEmpty()) {
                        configuration.componentFilter((Spec)new Spec<ComponentIdentifier>(){

                            public boolean isSatisfiedBy(ComponentIdentifier componentIdentifier) {
                                if (componentIdentifier instanceof ModuleComponentIdentifier) {
                                    return allowedDependencyGroups.contains(((ModuleComponentIdentifier)componentIdentifier).getGroup());
                                }
                                return false;
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/GradleDependencyResolver$1", "execute"));
                }
            });
            set = artifactView.getArtifacts().getArtifacts();
        }
        catch (Exception exception) {
            Set<ResolvedArtifactResult> set2 = Collections.emptySet();
            if (set2 == null) {
                GradleDependencyResolver.$$$reportNull$$$0(7);
            }
            return set2;
        }
        if (set == null) {
            GradleDependencyResolver.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Collection<ExternalDependency> resolveDependencies(@Nullable Configuration configuration) {
        Collection<ExternalDependency> collection = this.resolveDependencies(configuration, Collections.emptySet());
        if (collection == null) {
            GradleDependencyResolver.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Collection<ExternalDependency> resolveDependencies(@Nullable Configuration configuration, Set<String> allowedDependencyGroups) {
        if (configuration == null) {
            Set<ExternalDependency> set = Collections.emptySet();
            if (set == null) {
                GradleDependencyResolver.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<ResolvedArtifactResult> configurationDependencies = GradleDependencyResolver.resolveConfigurationDependencies(configuration, allowedDependencyGroups);
        LenientConfiguration lenientConfiguration = configuration.getResolvedConfiguration().getLenientConfiguration();
        LinkedHashMap<ResolvedDependency, Set<ResolvedArtifact>> resolvedArtifacts = new LinkedHashMap<ResolvedDependency, Set<ResolvedArtifact>>();
        boolean hasFailedToTransformDependencies = false;
        for (Object dependency : lenientConfiguration.getAllModuleDependencies()) {
            try {
                if (!allowedDependencyGroups.isEmpty() && !allowedDependencyGroups.contains(dependency.getModuleGroup())) continue;
                resolvedArtifacts.put((ResolvedDependency)dependency, dependency.getModuleArtifacts());
            }
            catch (GradleException e) {
                hasFailedToTransformDependencies = true;
                resolvedArtifacts.put((ResolvedDependency)dependency, Collections.emptySet());
            }
            catch (Exception e) {}
        }
        HashMap<ModuleVersionIdentifier, ResolvedDependencyResult> transformedProjectDependenciesResultMap = new HashMap<ModuleVersionIdentifier, ResolvedDependencyResult>();
        if (hasFailedToTransformDependencies) {
            for (DependencyResult dependencyResult : configuration.getIncoming().getResolutionResult().getAllDependencies()) {
                ComponentSelector resultRequested = dependencyResult.getRequested();
                if (!(dependencyResult instanceof ResolvedDependencyResult) || !(resultRequested instanceof ProjectComponentSelector)) continue;
                ResolvedComponentResult resolvedComponentResult = ((ResolvedDependencyResult)dependencyResult).getSelected();
                ModuleVersionIdentifier selectedResultVersion = resolvedComponentResult.getModuleVersion();
                transformedProjectDependenciesResultMap.put(selectedResultVersion, (ResolvedDependencyResult)dependencyResult);
            }
        }
        AuxiliaryConfigurationArtifacts auxiliaryArtifacts = this.resolveAuxiliaryArtifacts(configuration, resolvedArtifacts, allowedDependencyGroups);
        HashSet<String> resolvedFiles = new HashSet<String>();
        Collection<ExternalDependency> artifactDependencies = this.resolveArtifactDependencies(resolvedFiles, resolvedArtifacts, auxiliaryArtifacts, transformedProjectDependenciesResultMap);
        Collection<FileCollectionDependency> otherFileDependencies = GradleDependencyResolver.resolveOtherFileDependencies(resolvedFiles, configurationDependencies);
        Collection<ExternalDependency> unresolvedDependencies = GradleDependencyResolver.collectUnresolvedDependencies(lenientConfiguration, allowedDependencyGroups);
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        result.addAll(otherFileDependencies);
        result.addAll(artifactDependencies);
        result.addAll(unresolvedDependencies);
        int order = 0;
        for (ExternalDependency dependency : result) {
            ((AbstractExternalDependency)dependency).setClasspathOrder(++order);
        }
        LinkedHashSet<ExternalDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleDependencyResolver.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<ExternalDependency> resolveArtifactDependencies(@NotNull Set<String> resolvedFiles, @NotNull Map<ResolvedDependency, Set<ResolvedArtifact>> resolvedArtifacts, @NotNull AuxiliaryConfigurationArtifacts auxiliaryArtifacts, @NotNull Map<ModuleVersionIdentifier, ResolvedDependencyResult> transformedProjectDependenciesResultMap) {
        if (resolvedFiles == null) {
            GradleDependencyResolver.$$$reportNull$$$0(11);
        }
        if (resolvedArtifacts == null) {
            GradleDependencyResolver.$$$reportNull$$$0(12);
        }
        if (auxiliaryArtifacts == null) {
            GradleDependencyResolver.$$$reportNull$$$0(13);
        }
        if (transformedProjectDependenciesResultMap == null) {
            GradleDependencyResolver.$$$reportNull$$$0(14);
        }
        LinkedHashSet<ExternalDependency> artifactDependencies = new LinkedHashSet<ExternalDependency>();
        HashMap<String, DefaultExternalProjectDependency> resolvedProjectDependencies = new HashMap<String, DefaultExternalProjectDependency>();
        for (Map.Entry<ResolvedDependency, Set<ResolvedArtifact>> resolvedDependencySetEntry : resolvedArtifacts.entrySet()) {
            ExternalProjectDependency dependency;
            ResolvedDependency resolvedDependency = resolvedDependencySetEntry.getKey();
            Set<ResolvedArtifact> artifacts = resolvedDependencySetEntry.getValue();
            for (ResolvedArtifact artifact : artifacts) {
                AbstractExternalDependency dependency2;
                File artifactFile = this.resolveArtifactFile(resolvedFiles, artifact);
                if (artifactFile == null) continue;
                ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
                if (componentIdentifier instanceof ProjectComponentIdentifier) {
                    dependency2 = this.resolveProjectDependency(resolvedProjectDependencies, resolvedDependency, artifactFile, (ProjectComponentIdentifier)componentIdentifier);
                    if (dependency2 == null) continue;
                    artifactDependencies.add(dependency2);
                    continue;
                }
                dependency2 = GradleDependencyResolver.resolveLibraryDependency(artifact, artifactFile, auxiliaryArtifacts);
                artifactDependencies.add(dependency2);
            }
            if (!artifacts.isEmpty() || (dependency = this.resolveFailedToTransformProjectDependency(resolvedProjectDependencies, resolvedDependency, transformedProjectDependenciesResultMap)) == null) continue;
            artifactDependencies.add((ExternalDependency)dependency);
        }
        LinkedHashSet<ExternalDependency> linkedHashSet = artifactDependencies;
        if (linkedHashSet == null) {
            GradleDependencyResolver.$$$reportNull$$$0(15);
        }
        return linkedHashSet;
    }

    @Nullable
    private File resolveArtifactFile(@NotNull Set<String> resolvedFiles, @NotNull ResolvedArtifact artifact) {
        File artifactFile;
        if (resolvedFiles == null) {
            GradleDependencyResolver.$$$reportNull$$$0(16);
        }
        if (artifact == null) {
            GradleDependencyResolver.$$$reportNull$$$0(17);
        }
        if (resolvedFiles.contains((artifactFile = artifact.getFile()).getPath())) {
            return null;
        }
        resolvedFiles.add(artifactFile.getPath());
        String artifactPath = this.mySourceSetArtifactIndex.findArtifactBySourceSetOutputDir(artifactFile.getPath());
        if (artifactPath != null) {
            artifactFile = new File(artifactPath);
            if (resolvedFiles.contains(artifactFile.getPath())) {
                return null;
            }
            resolvedFiles.add(artifactFile.getPath());
        }
        return artifactFile;
    }

    @NotNull
    private static String getProjectDependencyKey(@NotNull ResolvedDependency resolvedDependency, @NotNull ProjectComponentIdentifier projectComponentIdentifier) {
        if (resolvedDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(18);
        }
        if (projectComponentIdentifier == null) {
            GradleDependencyResolver.$$$reportNull$$$0(19);
        }
        String buildName = GradleDependencyResolver.getBuildName(projectComponentIdentifier);
        String projectPath = projectComponentIdentifier.getProjectPath();
        String string = buildName + "_" + projectPath + "_" + resolvedDependency.getConfiguration();
        if (string == null) {
            GradleDependencyResolver.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String getProjectDependencyKey(@NotNull ResolvedDependency resolvedDependency, @NotNull ResolvedDependencyResult resolvedDependencyResult) {
        if (resolvedDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(21);
        }
        if (resolvedDependencyResult == null) {
            GradleDependencyResolver.$$$reportNull$$$0(22);
        }
        ProjectComponentSelector dependencyResultRequested = (ProjectComponentSelector)resolvedDependencyResult.getRequested();
        String projectPath = dependencyResultRequested.getProjectPath();
        String string = projectPath + "_" + resolvedDependency.getConfiguration();
        if (string == null) {
            GradleDependencyResolver.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    private DefaultExternalProjectDependency resolveProjectDependency(@NotNull Map<String, DefaultExternalProjectDependency> resolvedProjectDependencies, @NotNull ResolvedDependency resolvedDependency, @NotNull File artifactFile, @NotNull ProjectComponentIdentifier projectComponentIdentifier) {
        String key;
        DefaultExternalProjectDependency cachedProjectDependency;
        if (resolvedProjectDependencies == null) {
            GradleDependencyResolver.$$$reportNull$$$0(24);
        }
        if (resolvedDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(25);
        }
        if (artifactFile == null) {
            GradleDependencyResolver.$$$reportNull$$$0(26);
        }
        if (projectComponentIdentifier == null) {
            GradleDependencyResolver.$$$reportNull$$$0(27);
        }
        if ((cachedProjectDependency = resolvedProjectDependencies.get(key = GradleDependencyResolver.getProjectDependencyKey(resolvedDependency, projectComponentIdentifier))) != null) {
            LinkedHashSet<File> projectDependencyArtifacts = new LinkedHashSet<File>(cachedProjectDependency.getProjectDependencyArtifacts());
            projectDependencyArtifacts.add(artifactFile);
            cachedProjectDependency.setProjectDependencyArtifacts(projectDependencyArtifacts);
            LinkedHashSet<File> artifactSources = new LinkedHashSet<File>(cachedProjectDependency.getProjectDependencyArtifactsSources());
            artifactSources.addAll(this.mySourceSetArtifactIndex.findArtifactSources(artifactFile));
            cachedProjectDependency.setProjectDependencyArtifactsSources(artifactSources);
            return null;
        }
        DefaultExternalProjectDependency projectDependency = new DefaultExternalProjectDependency();
        resolvedProjectDependencies.put(key, projectDependency);
        projectDependency.setName(projectComponentIdentifier.getProjectName());
        projectDependency.setGroup(resolvedDependency.getModuleGroup());
        projectDependency.setVersion(resolvedDependency.getModuleVersion());
        projectDependency.setProjectPath(projectComponentIdentifier.getProjectPath());
        projectDependency.setConfigurationName(resolvedDependency.getConfiguration());
        projectDependency.setProjectDependencyArtifacts(Collections.singleton(artifactFile));
        projectDependency.setProjectDependencyArtifactsSources(this.mySourceSetArtifactIndex.findArtifactSources(artifactFile));
        return projectDependency;
    }

    @NotNull
    private static DefaultExternalLibraryDependency resolveLibraryDependency(@NotNull ResolvedArtifact artifact, @NotNull File artifactFile, @NotNull AuxiliaryConfigurationArtifacts auxiliaryArtifacts) {
        File javadocFile;
        if (artifact == null) {
            GradleDependencyResolver.$$$reportNull$$$0(28);
        }
        if (artifactFile == null) {
            GradleDependencyResolver.$$$reportNull$$$0(29);
        }
        if (auxiliaryArtifacts == null) {
            GradleDependencyResolver.$$$reportNull$$$0(30);
        }
        DefaultExternalLibraryDependency libraryDependency = new DefaultExternalLibraryDependency();
        ModuleVersionIdentifier moduleVersionIdentifier = artifact.getModuleVersion().getId();
        libraryDependency.setName(moduleVersionIdentifier.getName());
        libraryDependency.setGroup(moduleVersionIdentifier.getGroup());
        libraryDependency.setVersion(moduleVersionIdentifier.getVersion());
        libraryDependency.setFile(artifactFile);
        ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
        File sourcesFile = auxiliaryArtifacts.getSources(componentIdentifier, artifactFile);
        if (sourcesFile != null) {
            libraryDependency.setSource(sourcesFile);
        }
        if ((javadocFile = auxiliaryArtifacts.getJavadoc(componentIdentifier, artifactFile)) != null) {
            libraryDependency.setJavadoc(javadocFile);
        }
        if (artifact.getExtension() != null) {
            libraryDependency.setPackaging(artifact.getExtension());
        }
        libraryDependency.setClassifier(artifact.getClassifier());
        DefaultExternalLibraryDependency defaultExternalLibraryDependency = libraryDependency;
        if (defaultExternalLibraryDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(31);
        }
        return defaultExternalLibraryDependency;
    }

    @Nullable
    private ExternalProjectDependency resolveFailedToTransformProjectDependency(@NotNull Map<String, DefaultExternalProjectDependency> resolvedProjectDependencies, @NotNull ResolvedDependency resolvedDependency, @NotNull Map<ModuleVersionIdentifier, ResolvedDependencyResult> transformedProjectDependenciesResultMap) {
        ModuleVersionIdentifier moduleVersionIdentifier;
        ResolvedDependencyResult resolvedDependencyResult;
        if (resolvedProjectDependencies == null) {
            GradleDependencyResolver.$$$reportNull$$$0(32);
        }
        if (resolvedDependency == null) {
            GradleDependencyResolver.$$$reportNull$$$0(33);
        }
        if (transformedProjectDependenciesResultMap == null) {
            GradleDependencyResolver.$$$reportNull$$$0(34);
        }
        if ((resolvedDependencyResult = transformedProjectDependenciesResultMap.get(moduleVersionIdentifier = resolvedDependency.getModule().getId())) == null) {
            return null;
        }
        String key = GradleDependencyResolver.getProjectDependencyKey(resolvedDependency, resolvedDependencyResult);
        DefaultExternalProjectDependency cachedProjectDependency = resolvedProjectDependencies.get(key);
        if (cachedProjectDependency != null) {
            return null;
        }
        DefaultExternalProjectDependency projectDependency = new DefaultExternalProjectDependency();
        resolvedProjectDependencies.put(key, projectDependency);
        ProjectComponentSelector dependencyResultRequested = (ProjectComponentSelector)resolvedDependencyResult.getRequested();
        String projectPath = dependencyResultRequested.getProjectPath();
        String projectName = Path.path((String)projectPath).getName();
        projectDependency.setName(projectName);
        projectDependency.setGroup(resolvedDependency.getModuleGroup());
        projectDependency.setVersion(resolvedDependency.getModuleVersion());
        projectDependency.setProjectPath(projectPath);
        projectDependency.setConfigurationName(resolvedDependency.getConfiguration());
        Project project = this.myProject.findProject(projectPath);
        if (project == null) {
            return null;
        }
        Configuration configuration = (Configuration)project.getConfigurations().findByName(resolvedDependency.getConfiguration());
        if (configuration == null) {
            return null;
        }
        Set projectArtifacts = configuration.getArtifacts().getFiles().getFiles();
        projectDependency.setProjectDependencyArtifacts(projectArtifacts);
        projectDependency.setProjectDependencyArtifactsSources(this.mySourceSetArtifactIndex.findArtifactSources(projectArtifacts));
        return projectDependency;
    }

    @NotNull
    private AuxiliaryConfigurationArtifacts resolveAuxiliaryArtifacts(@NotNull Configuration configuration, @NotNull Map<ResolvedDependency, Set<ResolvedArtifact>> resolvedArtifacts, Set<String> allowedDependencyGroups) {
        if (configuration == null) {
            GradleDependencyResolver.$$$reportNull$$$0(35);
        }
        if (resolvedArtifacts == null) {
            GradleDependencyResolver.$$$reportNull$$$0(36);
        }
        String experimentalResolverPropertyValue = System.getProperty("idea.experimental.gradle.dependency.resolver", "false");
        boolean useExperimentalResolver = Boolean.parseBoolean(experimentalResolverPropertyValue);
        AuxiliaryArtifactResolver resolver = GradleVersionUtil.isCurrentGradleAtLeast((String)"7.3") && useExperimentalResolver ? new ExperimentalAuxiliaryArtifactResolver(this.myProject, this.myDownloadPolicy, allowedDependencyGroups) : new LegacyAuxiliaryArtifactResolver(this.myProject, this.myDownloadPolicy, resolvedArtifacts);
        AuxiliaryConfigurationArtifacts auxiliaryConfigurationArtifacts = resolver.resolve(configuration);
        if (auxiliaryConfigurationArtifacts == null) {
            GradleDependencyResolver.$$$reportNull$$$0(37);
        }
        return auxiliaryConfigurationArtifacts;
    }

    @NotNull
    private static Collection<FileCollectionDependency> resolveOtherFileDependencies(@NotNull Set<String> resolvedFiles, @NotNull Set<ResolvedArtifactResult> configurationDependencies) {
        if (resolvedFiles == null) {
            GradleDependencyResolver.$$$reportNull$$$0(38);
        }
        if (configurationDependencies == null) {
            GradleDependencyResolver.$$$reportNull$$$0(39);
        }
        LinkedHashSet<FileCollectionDependency> result = new LinkedHashSet<FileCollectionDependency>();
        for (ResolvedArtifactResult dependency : configurationDependencies) {
            File file;
            String path;
            ComponentIdentifier identifier = dependency.getId().getComponentIdentifier();
            if (identifier instanceof LibraryBinaryIdentifier || identifier instanceof ModuleComponentIdentifier || identifier instanceof ProjectComponentIdentifier || !resolvedFiles.add(path = (file = dependency.getFile()).getPath())) continue;
            result.add(new DefaultFileCollectionDependency(Collections.singleton(file)));
        }
        LinkedHashSet<FileCollectionDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleDependencyResolver.$$$reportNull$$$0(40);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<ExternalDependency> collectUnresolvedDependencies(@NotNull LenientConfiguration lenientConfiguration, Set<String> allowedDependencyGroups) {
        if (lenientConfiguration == null) {
            GradleDependencyResolver.$$$reportNull$$$0(41);
        }
        LinkedHashSet<ExternalDependency> result = new LinkedHashSet<ExternalDependency>();
        Set unresolvedModuleDependencies = lenientConfiguration.getUnresolvedModuleDependencies();
        for (UnresolvedDependency unresolvedDependency : unresolvedModuleDependencies) {
            if (!allowedDependencyGroups.isEmpty() && !allowedDependencyGroups.contains(unresolvedDependency.getSelector().getGroup())) continue;
            MyModuleVersionSelector moduleVersionSelector = null;
            Throwable problem = unresolvedDependency.getProblem();
            if (problem.getCause() != null) {
                problem = problem.getCause();
            }
            try {
                ComponentSelector componentSelector;
                if (problem instanceof ModuleVersionResolveException && (componentSelector = ((ModuleVersionResolveException)problem).getSelector()) instanceof ModuleComponentSelector) {
                    ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)componentSelector;
                    moduleVersionSelector = new MyModuleVersionSelector(moduleComponentSelector.getModule(), moduleComponentSelector.getGroup(), moduleComponentSelector.getVersion());
                }
            }
            catch (Throwable componentSelector) {
                // empty catch block
            }
            if (moduleVersionSelector == null) {
                problem = unresolvedDependency.getProblem();
                ModuleVersionSelector selector = unresolvedDependency.getSelector();
                moduleVersionSelector = new MyModuleVersionSelector(selector.getName(), selector.getGroup(), selector.getVersion());
            }
            DefaultUnresolvedExternalDependency dependency = new DefaultUnresolvedExternalDependency();
            dependency.setName(moduleVersionSelector.name);
            dependency.setGroup(moduleVersionSelector.group);
            dependency.setVersion(moduleVersionSelector.version);
            dependency.setFailureMessage(problem.getMessage());
            result.add(dependency);
        }
        LinkedHashSet<ExternalDependency> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleDependencyResolver.$$$reportNull$$$0(42);
        }
        return linkedHashSet;
    }

    @NotNull
    private static String getBuildName(@NotNull ProjectComponentIdentifier projectComponentIdentifier) {
        if (projectComponentIdentifier == null) {
            GradleDependencyResolver.$$$reportNull$$$0(43);
        }
        BuildIdentifier buildIdentifier = projectComponentIdentifier.getBuild();
        if (IS_83_OR_BETTER) {
            String string = buildIdentifier.getBuildPath();
            if (string == null) {
                GradleDependencyResolver.$$$reportNull$$$0(44);
            }
            return string;
        }
        String string = buildIdentifier.getName();
        if (string == null) {
            GradleDependencyResolver.$$$reportNull$$$0(45);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadPolicy";
                break;
            }
            case 5: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/GradleDependencyResolver";
                break;
            }
            case 11: 
            case 16: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFiles";
                break;
            }
            case 12: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedArtifacts";
                break;
            }
            case 13: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auxiliaryArtifacts";
                break;
            }
            case 14: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedProjectDependenciesResultMap";
                break;
            }
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 18: 
            case 21: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedDependency";
                break;
            }
            case 19: 
            case 27: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectComponentIdentifier";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedDependencyResult";
                break;
            }
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedProjectDependencies";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFile";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationDependencies";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lenientConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/GradleDependencyResolver";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConfigurationDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifactDependencies";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDependencyKey";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLibraryDependency";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAuxiliaryArtifacts";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveOtherFileDependencies";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnresolvedDependencies";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveConfigurationDependencies";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactDependencies";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactFile";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDependencyKey";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectDependency";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveLibraryDependency";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveFailedToTransformProjectDependency";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveAuxiliaryArtifacts";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveOtherFileDependencies";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectUnresolvedDependencies";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getBuildName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 23: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyModuleVersionSelector {
        private final String name;
        private final String group;
        private final String version;

        private MyModuleVersionSelector(String name, String group, String version) {
            this.name = name;
            this.group = group;
            this.version = version;
        }
    }
}

