/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.customization.console;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.analysis.customization.console.LogConsoleLogHandlerCollectors;
import com.intellij.analysis.customization.console.LogVisitor;
import com.intellij.analysis.customization.console.ProbableClassName;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/analysis/customization/console/LogFinderHyperlinkHandler;", "Lcom/intellij/execution/filters/HyperlinkInfoFactory$HyperlinkHandler;", "probableClassName", "Lcom/intellij/analysis/customization/console/ProbableClassName;", "<init>", "(Lcom/intellij/analysis/customization/console/ProbableClassName;)V", "onLinkFollowed", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetEditor", "Lcom/intellij/openapi/editor/Editor;", "originalEditor", "navigateToCalls", "visitor", "Lcom/intellij/analysis/customization/console/LogVisitor;", "getContainerText", "", "Lcom/intellij/openapi/util/NlsSafe;", "element", "Lcom/intellij/psi/PsiElement;", "getText", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nLogFinderHyperlinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogFinderHyperlinkHandler.kt\ncom/intellij/analysis/customization/console/LogFinderHyperlinkHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,177:1\n2318#2,14:178\n1611#2,9:192\n1863#2:201\n1864#2:203\n1620#2:204\n1#3:202\n18#4:205\n18#4:206\n*S KotlinDebug\n*F\n+ 1 LogFinderHyperlinkHandler.kt\ncom/intellij/analysis/customization/console/LogFinderHyperlinkHandler\n*L\n39#1:178,14\n63#1:192,9\n63#1:201\n63#1:203\n63#1:204\n63#1:202\n85#1:205\n86#1:206\n*E\n"})
public final class LogFinderHyperlinkHandler
implements HyperlinkInfoFactory.HyperlinkHandler {
    @NotNull
    private final ProbableClassName probableClassName;

    public LogFinderHyperlinkHandler(@NotNull ProbableClassName probableClassName) {
        Intrinsics.checkNotNullParameter((Object)probableClassName, (String)"probableClassName");
        this.probableClassName = probableClassName;
    }

    public void onLinkFollowed(@NotNull Project project, @NotNull VirtualFile file, @NotNull Editor targetEditor, @Nullable Editor originalEditor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)targetEditor, (String)"targetEditor");
        LogConsoleLogHandlerCollectors.INSTANCE.logHandleClass(project, 1);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)psiFile));
        if (uElement == null) {
            return;
        }
        String string = CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        LogVisitor visitor2 = (LogVisitor)((Object)ActionUtil.underModalProgress((Project)project, (String)string, () -> LogFinderHyperlinkHandler.onLinkFollowed$lambda$0(this, psiFile)));
        if (!((Collection)visitor2.getSimilarClasses()).isEmpty()) {
            PsiElement sourcePsi;
            Object t;
            Iterable $this$minBy$iv = visitor2.getSimilarClasses();
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                UClass it = (UClass)minElem$iv;
                boolean bl = false;
                PsiElement psiElement = it.getSourcePsi();
                int minValue$iv = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : Integer.MAX_VALUE;
                do {
                    int v$iv;
                    Object e$iv = iterator$iv.next();
                    UClass it2 = (UClass)e$iv;
                    $i$a$-minByOrThrow-LogFinderHyperlinkHandler$onLinkFollowed$uClass$1 = false;
                    PsiElement psiElement2 = it2.getSourcePsi();
                    int n = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getStartOffset() : (v$iv = Integer.MAX_VALUE);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            UClass uClass = (UClass)t;
            UElement uElement2 = uClass.getUastAnchor();
            Object object = sourcePsi = uElement2 != null ? uElement2.getSourcePsi() : null;
            if (sourcePsi != null) {
                EditSourceUtil.navigateToPsiElement((PsiElement)sourcePsi);
            }
        } else {
            return;
        }
        if (!visitor2.getSimilarCalls().isEmpty()) {
            Intrinsics.checkNotNull((Object)((Object)visitor2));
            this.navigateToCalls(visitor2, project, targetEditor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void navigateToCalls(LogVisitor visitor2, Project project, Editor targetEditor) {
        if (visitor2.getSimilarCalls().size() == 1) {
            PsiElement psiElement = ((UCallExpression)CollectionsKt.first((Iterable)visitor2.getSimilarCalls())).getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            EditSourceUtil.navigateToPsiElement((PsiElement)sourcePsi);
            LogConsoleLogHandlerCollectors.INSTANCE.logHandleLogCalls(project, 1);
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = visitor2.getSimilarCalls();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UCallExpression it = (UCallExpression)element$iv$iv;
                boolean bl2 = false;
                if (it.getSourcePsi() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List targetElements = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            new PsiTargetNavigator(targetElements).presentationProvider(arg_0 -> LogFinderHyperlinkHandler.navigateToCalls$lambda$3(this, arg_0)).elementsConsumer(LogFinderHyperlinkHandler::navigateToCalls$lambda$4).navigate(targetEditor, null, arg_0 -> LogFinderHyperlinkHandler.navigateToCalls$lambda$5(project, targetElements, arg_0));
        }
    }

    private final String getContainerText(PsiElement element) {
        UElement method;
        boolean $i$f$getParentOfType;
        boolean strict$iv;
        UElement $this$getParentOfType_u24default$iv;
        UElement uElement;
        block6: {
            block5: {
                uElement = UastContextKt.toUElement((PsiElement)element);
                if (uElement == null) break block5;
                $this$getParentOfType_u24default$iv = uElement;
                strict$iv = true;
                $i$f$getParentOfType = false;
                uElement = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
                if (uElement != null) break block6;
            }
            return "";
        }
        $this$getParentOfType_u24default$iv = method = uElement;
        strict$iv = true;
        $i$f$getParentOfType = false;
        Object object = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        if (object == null || (object = object.getJavaPsi()) == null || (object = object.getName()) == null) {
            object = "";
        }
        Object className = object;
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        if (document == null) {
            return "";
        }
        Document document2 = document;
        int lineNumber = document2.getLineNumber(element.getTextRange().getEndOffset());
        String container = (String)className + "." + method.getName() + "(): " + (lineNumber + 1);
        String string = StringUtil.shortenTextWithEllipsis((String)container, (int)40, (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        return string;
    }

    @NlsSafe
    private final String getText(PsiElement element) {
        String text = element.getText();
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        if (document == null) {
            Intrinsics.checkNotNull((Object)text);
            return text;
        }
        Document document2 = document;
        int lineNumber = document2.getLineNumber(element.getTextRange().getEndOffset());
        TextRange textRange = element.getTextRange().intersection(new TextRange(document2.getLineStartOffset(lineNumber), document2.getLineEndOffset(lineNumber)));
        if (textRange == null) {
            textRange = element.getTextRange();
        }
        TextRange textRange2 = textRange;
        String string = document2.getText(textRange2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String trimmedText = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string2 = StringUtil.shortenTextWithEllipsis((String)trimmedText, (int)30, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortenTextWithEllipsis(...)");
        return string2;
    }

    private static final LogVisitor onLinkFollowed$lambda$0(LogFinderHyperlinkHandler this$0, PsiFile $psiFile) {
        LogVisitor logVisitor = new LogVisitor(this$0.probableClassName);
        $psiFile.accept((PsiElementVisitor)logVisitor);
        return logVisitor;
    }

    private static final TargetPresentation navigateToCalls$lambda$3(LogFinderHyperlinkHandler this$0, PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this$0.getText(element)).containerText(this$0.getContainerText(element)).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    private static final void navigateToCalls$lambda$4(Collection elements, PsiTargetNavigator navigator) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        if (!elements.isEmpty()) {
            String message = JvmAnalysisBundle.message("jvm.class.filter.choose.calls", new Object[0]);
            navigator.title(message);
            navigator.tabTitle(message);
        }
    }

    private static final boolean navigateToCalls$lambda$5(Project $project, List $targetElements, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LogConsoleLogHandlerCollectors.INSTANCE.logHandleLogCalls($project, $targetElements.size());
        return EditSourceUtil.navigateToPsiElement((PsiElement)it);
    }
}

