/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.uast.UastVisitorAdapter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "runForWholeFile", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "MissingDeprecatedAnnotationOnSFRVisitor", "intellij.jvm.analysis.impl"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nMissingDeprecatedAnnotationOnScheduledForRemovalApiInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection.kt\ncom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection\n+ 2 MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection.kt\ncom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspectionKt\n*L\n1#1,80:1\n14#2:81\n*S KotlinDebug\n*F\n+ 1 MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection.kt\ncom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection\n*L\n26#1:81\n*E\n"})
public final class MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection
extends LocalInspectionTool {
    public boolean runForWholeFile() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        boolean $i$f$getSCHEDULED_FOR_REMOVAL_ANNOTATION_NAME = false;
        String string = ApiStatus.ScheduledForRemoval.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME>(...)");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (!AnnotatedApiUsageUtil.INSTANCE.canAnnotationBeUsedInFile(string, psiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new UastVisitorAdapter((AbstractUastNonRecursiveVisitor)new MissingDeprecatedAnnotationOnSFRVisitor(holder), true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection$MissingDeprecatedAnnotationOnSFRVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "DEPRECATED_ANNOTATION_NAME", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "KOTLIN_DEPRECATED_ANNOTATION_NAME", "SCALA_DEPRECATED_ANNOTATION_NAME", "visitClass", "", "node", "Lorg/jetbrains/uast/UClass;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "visitField", "Lorg/jetbrains/uast/UField;", "checkMissingDeprecatedAnnotationOnScheduledForRemovalApi", "", "Lorg/jetbrains/uast/UDeclaration;", "createAnnotationFix", "Lcom/intellij/codeInsight/intention/AddAnnotationFix;", "hasDeprecatedAnnotation", "Lorg/jetbrains/uast/UAnnotated;", "isScheduledForRemoval", "annotated", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nMissingDeprecatedAnnotationOnScheduledForRemovalApiInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection.kt\ncom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection$MissingDeprecatedAnnotationOnSFRVisitor\n+ 2 MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection.kt\ncom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspectionKt\n*L\n1#1,80:1\n14#2:81\n*S KotlinDebug\n*F\n+ 1 MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection.kt\ncom/intellij/codeInspection/MissingDeprecatedAnnotationOnScheduledForRemovalApiInspection$MissingDeprecatedAnnotationOnSFRVisitor\n*L\n75#1:81\n*E\n"})
    private static final class MissingDeprecatedAnnotationOnSFRVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder problemsHolder;
        private final String DEPRECATED_ANNOTATION_NAME;
        private final String KOTLIN_DEPRECATED_ANNOTATION_NAME;
        @NotNull
        private final String SCALA_DEPRECATED_ANNOTATION_NAME;

        public MissingDeprecatedAnnotationOnSFRVisitor(@NotNull ProblemsHolder problemsHolder) {
            Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
            this.problemsHolder = problemsHolder;
            this.DEPRECATED_ANNOTATION_NAME = Deprecated.class.getCanonicalName();
            this.KOTLIN_DEPRECATED_ANNOTATION_NAME = kotlin.Deprecated.class.getCanonicalName();
            this.SCALA_DEPRECATED_ANNOTATION_NAME = "scala.deprecated";
        }

        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkMissingDeprecatedAnnotationOnScheduledForRemovalApi((UDeclaration)node);
            return true;
        }

        public boolean visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkMissingDeprecatedAnnotationOnScheduledForRemovalApi((UDeclaration)node);
            return true;
        }

        public boolean visitField(@NotNull UField node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.checkMissingDeprecatedAnnotationOnScheduledForRemovalApi((UDeclaration)node);
            return true;
        }

        private final void checkMissingDeprecatedAnnotationOnScheduledForRemovalApi(UDeclaration node) {
            if (this.isScheduledForRemoval((UAnnotated)node) && !this.hasDeprecatedAnnotation((UAnnotated)node)) {
                String string = JvmAnalysisBundle.message("jvm.inspections.missing.deprecated.annotation.on.scheduled.for.removal.api.description", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                LocalQuickFix[] localQuickFixArray = LocalQuickFix.notNullElements((LocalQuickFix)((LocalQuickFix)this.createAnnotationFix(node)));
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.problemsHolder, (UDeclaration)node, (String)string, (LocalQuickFix[])Arrays.copyOf(localQuickFixArray, localQuickFixArray.length), null, (int)8, null);
            }
        }

        private final AddAnnotationFix createAnnotationFix(UDeclaration node) {
            PsiElement psiElement = node.getSourcePsi();
            PsiModifierListOwner psiModifierListOwner = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
            if (psiModifierListOwner == null) {
                return null;
            }
            PsiModifierListOwner modifierListOwner = psiModifierListOwner;
            return new AddAnnotationFix(this.DEPRECATED_ANNOTATION_NAME, modifierListOwner, new String[0]);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasDeprecatedAnnotation(UAnnotated node) {
            String string = this.DEPRECATED_ANNOTATION_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DEPRECATED_ANNOTATION_NAME");
            if (node.findAnnotation(string) != null) return true;
            String string2 = this.KOTLIN_DEPRECATED_ANNOTATION_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"KOTLIN_DEPRECATED_ANNOTATION_NAME");
            if (node.findAnnotation(string2) != null) return true;
            if (node.findAnnotation(this.SCALA_DEPRECATED_ANNOTATION_NAME) == null) return false;
            return true;
        }

        private final boolean isScheduledForRemoval(UAnnotated annotated) {
            boolean $i$f$getSCHEDULED_FOR_REMOVAL_ANNOTATION_NAME = false;
            String string = ApiStatus.ScheduledForRemoval.class.getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-SCHEDULED_FOR_REMOVAL_ANNOTATION_NAME>(...)");
            return annotated.findAnnotation(string) != null;
        }
    }
}

