/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AnnotatedApiUsageUtil;
import com.intellij.codeInspection.AnnotatedContainingDeclaration;
import com.intellij.codeInspection.DefaultUnstableApiUsageMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UnstableApiUsageMessageProvider;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.deprecation.DeprecationInspection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J,\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001cH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\f2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010(\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u0005H\u0002J \u0010*\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u0005H\u0002J \u0010+\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u0005H\u0002J\u001c\u0010,\u001a\u00020\u00052\b\u0010-\u001a\u0004\u0018\u00010'2\b\u0010.\u001a\u0004\u0018\u00010'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/codeInspection/UnstableApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "ignoreInsideImports", "", "ignoreApiDeclaredInThisProject", "unstableApiAnnotations", "", "", "knownAnnotationMessageProviders", "", "Lcom/intellij/codeInspection/UnstableApiUsageMessageProvider;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;ZZLjava/util/List;Ljava/util/Map;)V", "processImportReference", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "processReference", "qualifier", "Lorg/jetbrains/uast/UExpression;", "processConstructorInvocation", "instantiatedClass", "Lcom/intellij/psi/PsiClass;", "constructor", "Lcom/intellij/psi/PsiMethod;", "subclassDeclaration", "Lorg/jetbrains/uast/UClass;", "processMethodOverriding", "method", "Lorg/jetbrains/uast/UMethod;", "overriddenMethod", "getMessageProvider", "psiAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "getElementToHighlight", "Lcom/intellij/psi/PsiElement;", "checkUnstableApiUsage", "isMethodOverriding", "checkTargetIsUnstableItself", "checkTargetReferencesUnstableTypeInSignature", "arePsiElementsFromTheSameFile", "one", "two", "Companion", "intellij.jvm.analysis.impl"})
final class UnstableApiUsageProcessor
implements ApiUsageProcessor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ProblemsHolder problemsHolder;
    private final boolean ignoreInsideImports;
    private final boolean ignoreApiDeclaredInThisProject;
    @NotNull
    private final List<String> unstableApiAnnotations;
    @NotNull
    private final Map<String, UnstableApiUsageMessageProvider> knownAnnotationMessageProviders;

    public UnstableApiUsageProcessor(@NotNull ProblemsHolder problemsHolder, boolean ignoreInsideImports, boolean ignoreApiDeclaredInThisProject, @NotNull List<String> unstableApiAnnotations, @NotNull Map<String, ? extends UnstableApiUsageMessageProvider> knownAnnotationMessageProviders) {
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter(unstableApiAnnotations, (String)"unstableApiAnnotations");
        Intrinsics.checkNotNullParameter(knownAnnotationMessageProviders, (String)"knownAnnotationMessageProviders");
        this.problemsHolder = problemsHolder;
        this.ignoreInsideImports = ignoreInsideImports;
        this.ignoreApiDeclaredInThisProject = ignoreApiDeclaredInThisProject;
        this.unstableApiAnnotations = unstableApiAnnotations;
        this.knownAnnotationMessageProviders = knownAnnotationMessageProviders;
    }

    public void processImportReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target) {
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.ignoreInsideImports) {
            this.checkUnstableApiUsage(target, sourceNode, false);
        }
    }

    public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.checkUnstableApiUsage(target, sourceNode, false);
    }

    public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter((Object)instantiatedClass, (String)"instantiatedClass");
        if (constructor != null) {
            this.checkUnstableApiUsage((PsiModifierListOwner)constructor, sourceNode, false);
        }
    }

    public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod overriddenMethod) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)overriddenMethod, (String)"overriddenMethod");
        this.checkUnstableApiUsage((PsiModifierListOwner)overriddenMethod, (UElement)method, true);
    }

    private final UnstableApiUsageMessageProvider getMessageProvider(PsiAnnotation psiAnnotation) {
        String string = psiAnnotation.getQualifiedName();
        if (string == null) {
            return null;
        }
        String annotationName = string;
        UnstableApiUsageMessageProvider unstableApiUsageMessageProvider = this.knownAnnotationMessageProviders.get(annotationName);
        if (unstableApiUsageMessageProvider == null) {
            unstableApiUsageMessageProvider = DefaultUnstableApiUsageMessageProvider.INSTANCE;
        }
        return unstableApiUsageMessageProvider;
    }

    private final PsiElement getElementToHighlight(UElement sourceNode) {
        UDeclaration uDeclaration = sourceNode instanceof UDeclaration ? (UDeclaration)sourceNode : null;
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)(uDeclaration != null ? uDeclaration.getUastAnchor() : null));
        if (psiElement == null) {
            psiElement = sourceNode.getSourcePsi();
        }
        return psiElement;
    }

    private final void checkUnstableApiUsage(PsiModifierListOwner target, UElement sourceNode, boolean isMethodOverriding) {
        if (this.ignoreApiDeclaredInThisProject && !Companion.isLibraryElement((PsiElement)target)) {
            return;
        }
        if (this.checkTargetIsUnstableItself(target, sourceNode, isMethodOverriding)) {
            return;
        }
        this.checkTargetReferencesUnstableTypeInSignature(target, sourceNode, isMethodOverriding);
    }

    private final boolean checkTargetIsUnstableItself(PsiModifierListOwner target, UElement sourceNode, boolean isMethodOverriding) {
        AnnotatedContainingDeclaration annotatedContainingDeclaration = AnnotatedApiUsageUtil.findAnnotatedContainingDeclaration$default(AnnotatedApiUsageUtil.INSTANCE, target, this.unstableApiAnnotations, true, null, 8, null);
        if (annotatedContainingDeclaration != null) {
            UnstableApiUsageMessageProvider unstableApiUsageMessageProvider = this.getMessageProvider(annotatedContainingDeclaration.getPsiAnnotation());
            if (unstableApiUsageMessageProvider == null) {
                return false;
            }
            UnstableApiUsageMessageProvider messageProvider = unstableApiUsageMessageProvider;
            String message = isMethodOverriding ? messageProvider.buildMessageUnstableMethodOverridden(annotatedContainingDeclaration) : messageProvider.buildMessage(annotatedContainingDeclaration);
            PsiElement psiElement = this.getElementToHighlight(sourceNode);
            if (psiElement == null) {
                return false;
            }
            PsiElement elementToHighlight = psiElement;
            LocalQuickFix fix = DeprecationInspection.getReplacementQuickFix((PsiModifierListOwner)target, (PsiElement)elementToHighlight);
            if (fix != null) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                this.problemsHolder.registerProblem(elementToHighlight, message, messageProvider.getProblemHighlightType(), localQuickFixArray);
            } else {
                this.problemsHolder.registerProblem(elementToHighlight, message, messageProvider.getProblemHighlightType(), new LocalQuickFix[0]);
            }
            return true;
        }
        return false;
    }

    private final void checkTargetReferencesUnstableTypeInSignature(PsiModifierListOwner target, UElement sourceNode, boolean isMethodOverriding) {
        if (!isMethodOverriding && !this.arePsiElementsFromTheSameFile(sourceNode.getSourcePsi(), (PsiElement)target.getContainingFile())) {
            UDeclaration declaration = (UDeclaration)UastContextKt.toUElement((PsiElement)((PsiElement)target), UDeclaration.class);
            if (!(declaration instanceof UClass || declaration instanceof UMethod || declaration instanceof UField)) {
                return;
            }
            AnnotatedContainingDeclaration unstableTypeUsedInSignature = AnnotatedApiUsageUtil.INSTANCE.findAnnotatedTypeUsedInDeclarationSignature(declaration, (Collection<String>)this.unstableApiAnnotations);
            if (unstableTypeUsedInSignature != null) {
                UnstableApiUsageMessageProvider unstableApiUsageMessageProvider = this.getMessageProvider(unstableTypeUsedInSignature.getPsiAnnotation());
                if (unstableApiUsageMessageProvider == null) {
                    return;
                }
                UnstableApiUsageMessageProvider messageProvider = unstableApiUsageMessageProvider;
                String message = messageProvider.buildMessageUnstableTypeIsUsedInSignatureOfReferencedApi(target, unstableTypeUsedInSignature);
                PsiElement psiElement = this.getElementToHighlight(sourceNode);
                if (psiElement == null) {
                    return;
                }
                PsiElement elementToHighlight = psiElement;
                this.problemsHolder.registerProblem(elementToHighlight, message, messageProvider.getProblemHighlightType(), new LocalQuickFix[0]);
            }
        }
    }

    private final boolean arePsiElementsFromTheSameFile(PsiElement one, PsiElement two) {
        PsiElement psiElement;
        PsiElement psiElement2 = one;
        return Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getContainingFile()) != null ? psiElement2.getVirtualFile() : null), (psiElement = two) != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInspection/UnstableApiUsageProcessor$Companion;", "", "<init>", "()V", "isLibraryElement", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.jvm.analysis.impl"})
    private static final class Companion {
        private Companion() {
        }

        public final boolean isLibraryElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return true;
            }
            VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(containingVirtualFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

