/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.ProjectTaskContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleImprovedHotswapOutput;
import org.jetbrains.plugins.gradle.execution.build.GradleProjectTaskRunner;

@ApiStatus.Experimental
public final class GradleImprovedHotswapDetection {
    private GradleImprovedHotswapDetection() {
    }

    public static String getInitScript(File outputPathsFile) {
        String path = FileUtil.toCanonicalPath((String)outputPathsFile.getAbsolutePath());
        return String.format(InitScriptResourceHolder.INIT_SCRIPT_TEMPLATE, path);
    }

    public static String getInitScriptUsingService(File outputPathsFile) {
        String path = FileUtil.toCanonicalPath((String)outputPathsFile.getAbsolutePath());
        return String.format(InitScriptResourceHolder.INIT_SCRIPT_TEMPLATE_USING_SERVICE, path);
    }

    public static void processInitScriptOutput(ProjectTaskContext context, @Nullable File outputPathsFile) {
        if (outputPathsFile == null || !context.isCollectionOfGeneratedFilesEnabled()) {
            return;
        }
        Collection<GradleImprovedHotswapOutput> outputs = GradleImprovedHotswapOutput.parseOutputFile(outputPathsFile);
        outputs.stream().filter(output -> !StringUtil.isEmpty((String)output.getPath())).forEach(output -> context.fileGenerated(output.getRoot(), output.getPath()));
        Set dirtyRoots = outputs.stream().filter(output -> StringUtil.isEmpty((String)output.getPath())).map(GradleImprovedHotswapOutput::getRoot).collect(Collectors.toSet());
        context.addDirtyOutputPathsProvider(() -> dirtyRoots);
    }

    public static boolean isEnabled() {
        return Registry.is((String)"gradle.improved.hotswap.detection", (boolean)false);
    }

    private static final class InitScriptResourceHolder {
        private static final String PATH_SIMPLE = "/org/jetbrains/plugins/gradle/GradleImprovedHotswapDetectionInitScript.groovy";
        private static final String PATH_USING_SERVICE = "/org/jetbrains/plugins/gradle/GradleImprovedHotswapDetectionInitScriptUsingService.groovy";
        private static final String COMMON_HASH_UTILS = "/org/jetbrains/plugins/gradle/GradleImprovedHotswapDetectionUtils.groovy";
        static final String COMMON_HASH_UTILS_CLASS = InitScriptResourceHolder.loadResource("/org/jetbrains/plugins/gradle/GradleImprovedHotswapDetectionUtils.groovy");
        static final String INIT_SCRIPT_TEMPLATE = InitScriptResourceHolder.loadResource("/org/jetbrains/plugins/gradle/GradleImprovedHotswapDetectionInitScript.groovy") + COMMON_HASH_UTILS_CLASS;
        static final String INIT_SCRIPT_TEMPLATE_USING_SERVICE = InitScriptResourceHolder.loadResource("/org/jetbrains/plugins/gradle/GradleImprovedHotswapDetectionInitScriptUsingService.groovy") + COMMON_HASH_UTILS_CLASS;

        private InitScriptResourceHolder() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private static String loadResource(String path) {
            try (InputStream stream = GradleProjectTaskRunner.class.getResourceAsStream(path);){
                String string;
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    string = StreamUtil.readText((Reader)reader);
                }
                return string;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not load resource '%s'", path), e);
            }
        }
    }
}

