/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FileColorManager;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PopupUtilsKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import icons.ExternalSystemIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.TasksToRun;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002JH\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\"\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u00130\u0012JP\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0019\u0012\u0004\u0012\u0002H\u00170\u00142\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u0013\u0012\u0004\u0012\u00020\t0\u001aH\u0016J>\u0010\u001b\u001a\"\u0012\b\u0012\u00060\u0007j\u0002`\u0019\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002JP\u0010\u001e\u001a\u00020\t\"\u0004\b\u0000\u0010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\u0019\u0012\u0004\u0012\u0002H\u00170\u00142\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u0013\u0012\u0004\u0012\u00020\t0\u001aH\u0014J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0003\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser;", "", "<init>", "()V", "error", "", "message", "", "chooseTestTasks", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "consumer", "Ljava/util/function/Consumer;", "", "", "Lorg/jetbrains/plugins/gradle/execution/test/runner/SourcePath;", "Lorg/jetbrains/plugins/gradle/util/TasksToRun;", "T", "testTasks", "Lorg/jetbrains/plugins/gradle/execution/test/runner/TestName;", "Lkotlin/Function1;", "findAllTestsTaskToRun", "sources", "Lcom/intellij/openapi/vfs/VirtualFile;", "showTestTasksPopupChooser", "showTestTasksNotFoundWarning", "suggestPopupTitle", "TestTaskListCellRenderer", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nTestTasksChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestTasksChooser.kt\norg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1557#2:168\n1628#2,3:169\n1187#2,2:172\n1261#2,2:174\n1202#2,2:176\n1230#2,4:178\n1264#2:182\n1279#2,2:189\n1293#2,4:191\n1062#2:195\n1611#2,9:196\n1863#2:205\n1864#2:207\n1620#2:208\n77#3:183\n97#3,5:184\n1#4:206\n*S KotlinDebug\n*F\n+ 1 TestTasksChooser.kt\norg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser\n*L\n48#1:168\n48#1:169,3\n71#1:172,2\n71#1:174,2\n71#1:176,2\n71#1:178,4\n71#1:182\n73#1:189,2\n73#1:191,4\n86#1:195\n98#1:196,9\n98#1:205\n98#1:207\n98#1:208\n72#1:183\n72#1:184,5\n98#1:206\n*E\n"})
public class TestTasksChooser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String TEST_TASK_NAME = "test";
    @JvmField
    @NotNull
    public static final DataKey<String> LOCATION;

    private final Void error(String message) {
        LOG.error(message);
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - void declaration
     */
    public final void chooseTestTasks(@NotNull Project project, @NotNull DataContext context, @NotNull Iterable<? extends PsiElement> elements, @NotNull Consumer<List<Map<String, TasksToRun>>> consumer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable<? extends PsiElement> $this$map$iv = elements;
        boolean $i$f$map = false;
        Iterable<? extends PsiElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = TestGradleConfigurationProducerUtilKt.getSourceFile((PsiElement)it);
            if (virtualFile == null) {
                this.error("Can not find source file for " + (PsiElement)it);
                throw new KotlinNothingValueException();
            }
            collection.add(virtualFile);
        }
        List sources = (List)destination$iv$iv;
        Map<String, Map<String, TasksToRun>> testTasks = this.findAllTestsTaskToRun(sources, project);
        this.chooseTestTasks(project, context, testTasks, (Function1)new Function1<List<? extends Map<String, ? extends TasksToRun>>, Unit>(consumer){

            public final void invoke(List<? extends Map<String, ? extends TasksToRun>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((Consumer)this.receiver).accept(p0);
            }
        });
    }

    public <T> void chooseTestTasks(@NotNull Project project, @NotNull DataContext context, @NotNull Map<String, ? extends T> testTasks, @NotNull Function1<? super List<? extends T>, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(testTasks, (String)"testTasks");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (testTasks.isEmpty()) {
            this.showTestTasksNotFoundWarning(project, context);
        } else if (testTasks.size() == 1) {
            consumer.invoke((Object)CollectionsKt.toList((Iterable)testTasks.values()));
        } else {
            this.showTestTasksPopupChooser(project, context, testTasks, consumer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<String, TasksToRun>> findAllTestsTaskToRun(List<? extends VirtualFile> sources, Project project) {
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Map testTasks;
        Object element$iv$iv3;
        Map $this$associateTo$iv$iv;
        Iterable $this$associate$iv = sources;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator<Object> iterator = $this$associateTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            element$iv$iv3 = iterator.next();
            Map map = destination$iv$iv;
            VirtualFile source = (VirtualFile)element$iv$iv3;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)source.getPath(), (String)"getPath(...)");
            List<TasksToRun> list = GradleTestRunConfigurationProducer.findAllTestsTaskToRun(source, project);
            Intrinsics.checkNotNullExpressionValue(list, (String)"findAllTestsTaskToRun(...)");
            Iterable iterable2 = list;
            boolean $i$f$associateBy = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var19_22 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                void it;
                TasksToRun tasksToRun = (TasksToRun)element$iv$iv2;
                Map map2 = destination$iv$iv2;
                boolean bl2 = false;
                map2.put(it.getTestName(), element$iv$iv2);
            }
            source = TuplesKt.to((Object)string, (Object)destination$iv$iv2);
            map.put(source.getFirst(), source.getSecond());
        }
        Map $this$flatMap$iv = testTasks = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$associateTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it = element$iv$iv3 = (Map.Entry)iterator.next();
            boolean bl = false;
            list$iv$iv = ((Map)it.getValue()).keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set testTaskNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$associateWith$iv = testTaskNames;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv3 : $this$associateWithTo$iv$iv) {
            void name;
            list$iv$iv = (String)element$iv$iv3;
            Object object = element$iv$iv3;
            Map map = result$iv;
            boolean bl = false;
            Map map3 = TestTasksChooser.Companion.mapNotNullValues(testTasks, arg_0 -> TestTasksChooser.findAllTestsTaskToRun$lambda$5$lambda$4((String)name, arg_0));
            map.put(object, map3);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    protected <T> void showTestTasksPopupChooser(@NotNull Project project, @NotNull DataContext context, @NotNull Map<String, ? extends T> testTasks, @NotNull Function1<? super List<? extends T>, Unit> consumer) {
        void $this$sortedByDescending$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(testTasks, (String)"testTasks");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        boolean bl2 = bl = !ApplicationManager.getApplication().isCommandLine();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable iterable = CollectionsKt.toList((Iterable)testTasks.keySet());
        boolean $i$f$sortedByDescending = false;
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)"test"));
                it = (String)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)"test")));
            }
        })).setRenderer((ListCellRenderer)new TestTaskListCellRenderer(project)).setTitle(this.suggestPopupTitle(context)).setAutoselectOnMouseMove(false).setNamerForFiltering(FunctionUtil.id()).setMovable(true).setAdText(GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.hint", (Object[])new Object[0])).setResizable(false).setRequestFocus(true).setMinSize((Dimension)JBUI.size((int)270, (int)55)).setItemsChosenCallback(arg_0 -> TestTasksChooser.showTestTasksPopupChooser$lambda$8(arg_0 -> TestTasksChooser.showTestTasksPopupChooser$lambda$7(testTasks, this, project, context, consumer, arg_0), arg_0)).createPopup().show(PopupUtilsKt.getBestPopupPosition((DataContext)context));
    }

    protected void showTestTasksNotFoundWarning(@NotNull Project project, @NotNull DataContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl2 = bl = !ApplicationManager.getApplication().isCommandLine();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(GradleBundle.message((String)"gradle.tests.tasks.choosing.warning.text", (Object[])new Object[0]))).setFillColor(IdeTooltipManager.Companion.getInstance().getTextBackground(false)).createBalloon().show(PopupUtilsKt.getBestBalloonPosition((DataContext)context), Balloon.Position.above);
    }

    @NlsContexts.PopupTitle
    private final String suggestPopupTitle(DataContext context) {
        String string;
        String locationName = (String)context.getData(LOCATION);
        if (locationName == null) {
            String string2 = GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.title.common", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{locationName};
            String string3 = GradleBundle.message((String)"gradle.tests.tasks.choosing.popup.title", (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private static final TasksToRun findAllTestsTaskToRun$lambda$5$lambda$4(String $name, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (TasksToRun)((Map)it.getValue()).get($name);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showTestTasksPopupChooser$lambda$7(Map $testTasks, TestTasksChooser this$0, Project $project, DataContext $context, Function1 $consumer, Set it) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$mapNotNull$iv = it;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if ($testTasks.get(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List choosesTestTasks = (List)destination$iv$iv;
        if (choosesTestTasks.isEmpty()) {
            this$0.showTestTasksNotFoundWarning($project, $context);
        } else {
            $consumer.invoke((Object)choosesTestTasks);
        }
        return Unit.INSTANCE;
    }

    private static final void showTestTasksPopupChooser$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final DataContext contextWithLocationName(@NotNull DataContext context, @Nullable String locationName) {
        return Companion.contextWithLocationName(context, locationName);
    }

    static {
        Logger logger = Logger.getInstance(TestTasksChooser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        LOCATION = DataKey.Companion.create("org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser.LOCATION");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0007JX\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0013\"\u0004\b\u0002\u0010\u0012*\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\u00102 \u0010\u0014\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\u0015H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TEST_TASK_NAME", "", "LOCATION", "Lcom/intellij/openapi/actionSystem/DataKey;", "contextWithLocationName", "Lcom/intellij/openapi/actionSystem/DataContext;", "context", "locationName", "mapNotNullValues", "", "K", "R", "V", "transform", "Lkotlin/Function1;", "", "intellij.gradle.java"})
    @SourceDebugExtension(value={"SMAP\nTestTasksChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestTasksChooser.kt\norg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n136#2,9:168\n216#2:177\n217#2:180\n145#2:181\n1#3:178\n1#3:179\n*S KotlinDebug\n*F\n+ 1 TestTasksChooser.kt\norg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$Companion\n*L\n165#1:168,9\n165#1:177\n165#1:180\n165#1:181\n165#1:179\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataContext contextWithLocationName(@NotNull DataContext context, @Nullable String locationName) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (locationName == null) {
                return context;
            }
            DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)context, arg_0 -> Companion.contextWithLocationName$lambda$0(locationName, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"withSnapshot(...)");
            return dataContext;
        }

        /*
         * WARNING - void declaration
         */
        private final <K, V, R> Map<K, R> mapNotNullValues(Map<K, ? extends V> $this$mapNotNullValues, Function1<? super Map.Entry<? extends K, ? extends V>, ? extends R> transform) {
            void $this$mapNotNullTo$iv$iv;
            Map<K, ? extends V> $this$mapNotNull$iv = $this$mapNotNullValues;
            boolean $i$f$mapNotNull = false;
            Map<K, ? extends V> map = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry entry = element$iv$iv;
                boolean bl2 = false;
                if (transform.invoke(entry) != null) {
                    Object it;
                    boolean bl3 = false;
                    pair = TuplesKt.to(entry.getKey(), (Object)it);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        private static final void contextWithLocationName$lambda$0(String $locationName, DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            sink.set(LOCATION, (Object)$locationName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/execution/test/runner/TestTasksChooser$TestTaskListCellRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cellInsets", "Lcom/intellij/util/ui/JBInsets;", "Lorg/jetbrains/annotations/NotNull;", "colorManager", "Lcom/intellij/ui/FileColorManager;", "kotlin.jvm.PlatformType", "Lcom/intellij/ui/FileColorManager;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "", "index", "", "isSelected", "", "cellHasFocus", "intellij.gradle.java"})
    private static final class TestTaskListCellRenderer
    extends DefaultListCellRenderer {
        @NotNull
        private final JBInsets cellInsets;
        private final FileColorManager colorManager;

        public TestTaskListCellRenderer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            JBInsets jBInsets = JBUI.insets((int)1, (int)5);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            this.cellInsets = jBInsets;
            this.colorManager = FileColorManager.getInstance((Project)project);
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(String.valueOf(value));
            this.setIcon(ExternalSystemIcons.Task);
            this.setIconTextGap(this.cellInsets.left);
            this.setBorder(new EmptyBorder((Insets)this.cellInsets));
            if (!isSelected) {
                this.setBackground(this.colorManager.getScopeColor("Tests"));
            }
            return this;
        }
    }
}

