/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.MethodTextOccurrenceProcessor;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleManagedPropertySetterReferenceSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "intellij.gradle.java"})
public final class GradleManagedPropertySetterReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public GradleManagedPropertySetterReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiMethod psiMethod = queryParameters.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"getMethod(...)");
        PsiMethod method = psiMethod;
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        String string = PropertyUtilKt.getPropertyName((PropertyKind)PropertyKind.GETTER, (PsiMethod)method);
        if (string == null) {
            return;
        }
        String propertyName = string;
        String setterName = PropertyUtilKt.getAccessorName((PropertyKind)PropertyKind.SETTER, (String)propertyName);
        PsiMethod[] psiMethodArray = new PsiMethod[]{method};
        queryParameters.getOptimizer().searchWord(setterName, queryParameters.getEffectiveSearchScope(), (short)1, true, (PsiElement)method, (RequestResultProcessor)new MethodTextOccurrenceProcessor(containingClass, queryParameters.isStrictSignatureSearch(), psiMethodArray));
    }
}

