/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;

    @NotNull
    public static String getHomePath() {
        String string2 = PathManager.getHomePath(true);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result2 = ourHomePath;
        if (result2 != null) {
            return result2;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result2 = ourHomePath;
            if (result2 != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result2;
            }
            String explicit = PathManager.getExplicitPath("idea.home.path");
            if (explicit == null) {
                explicit = PathManager.getExplicitPath("idea.home");
            }
            if (explicit != null) {
                result2 = explicit;
                if (!Files.isDirectory(Paths.get(result2, new String[0]), new LinkOption[0])) {
                    ourHomePath = result2;
                    throw new RuntimeException("Invalid home path '" + result2 + "'");
                }
            } else if (insideIde && (result2 = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result2 != null && SystemInfoRt.isWindows) {
                try {
                    result2 = Paths.get(result2, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException advice) {
                    // empty catch block
                }
            }
            if (result2 == null) {
                ourBinDirectories = Collections.emptyList();
            } else {
                Path root = Paths.get(result2, new String[0]);
                if (Boolean.getBoolean("idea.use.dev.build.server")) {
                    root = root.resolve("../../../..").normalize();
                }
                ourBinDirectories = PathManager.getBinDirectories(root);
            }
            ourHomePath = result2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result2;
        }
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        Path result2;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        return (result2 = PathManager.getHomeDirFor(aClass)) == null ? null : result2.toString();
    }

    @Nullable
    public static Path getHomeDirFor(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        Path result2 = null;
        String rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class");
        if (rootPath != null) {
            Path root = Paths.get(rootPath, new String[0]).toAbsolutePath();
            while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root)) {
            }
            result2 = root;
        }
        return result2;
    }

    private static boolean isIdeaHome(Path root) {
        return Files.isRegularFile(root.resolve("product-info.json"), new LinkOption[0]) || Files.isRegularFile(root.resolve("bin").resolve("idea.properties"), new LinkOption[0]) || Files.isRegularFile(root.resolve("intellij.idea.community.main.iml"), new LinkOption[0]) || Files.isRegularFile(root.resolve(".ultimate.root.marker"), new LinkOption[0]);
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        Path[] candidates = new Path[]{root.resolve("bin"), Paths.get(PathManager.getCommunityHomePath(root.toString()), "bin")};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (Path dir2 : candidates) {
            String arch;
            if (binDirs.contains(dir2) || !Files.isDirectory(dir2, new LinkOption[0])) continue;
            binDirs.add(dir2);
            dir2 = dir2.resolve(osSuffix);
            if (!Files.isDirectory(dir2, new LinkOption[0])) continue;
            binDirs.add(dir2);
            if (!SystemInfoRt.isWindows && !SystemInfoRt.isLinux) continue;
            String string2 = CpuArch.isIntel64() ? "amd64" : (arch = CpuArch.isArm64() ? "aarch64" : null);
            if (arch == null || !Files.isDirectory(dir2 = dir2.resolve(arch), new LinkOption[0])) continue;
            binDirs.add(dir2);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        String string2 = PathManager.getHomePath() + '/' + "bin";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public static Path getConfigDir() {
        Path path = Paths.get(PathManager.getConfigPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return path;
    }

    @NotNull
    public static String getConfigPath() {
        String path = ourConfigPath;
        if (path == null) {
            String explicit = PathManager.getExplicitPath("idea.config.path");
            path = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + "config");
            ourConfigPath = path;
        }
        String string2 = path;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        String string2 = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @NotNull
    public static String getSystemPath() {
        String path = ourSystemPath;
        if (path == null) {
            String explicit = PathManager.getExplicitPath("idea.system.path");
            path = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + "system");
            ourSystemPath = path;
        }
        String string2 = path;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return string2;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        String string2 = PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        return string2;
    }

    @NotNull
    public static Path getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        Path path = Paths.get(indexRootPath, new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        return path;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context2, @NotNull String path) {
        URL url;
        if (context2 == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        if (path == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        if ((url = context2.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.isEmpty() || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            File result2;
            try {
                result2 = new File(resourceURL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException("URL='" + resourceURL + "'", e2);
            }
            String path = result2.getPath();
            String testPath = path.replace('\\', '/');
            String testResourcePath = resourcePath.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase(testPath, testResourcePath)) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            String jarPath = PathManager.splitJarUrl(resourceURL.getFile());
            if (jarPath != null) {
                resultPath = jarPath;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @Nullable
    private static String splitJarUrl(@NotNull String url) {
        int pivot;
        if (url == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        if ((pivot = url.indexOf("!/")) < 0) {
            return null;
        }
        String jarPath = url.substring(0, pivot);
        boolean startsWithConcatenation = true;
        int offset = 0;
        for (String prefix : new String[]{"jar", ":"}) {
            int prefixLen = prefix.length();
            if (!jarPath.regionMatches(offset, prefix, 0, prefixLen)) {
                startsWithConcatenation = false;
                break;
            }
            offset += prefixLen;
        }
        if (startsWithConcatenation) {
            jarPath = jarPath.substring("jar".length() + 1);
        }
        if (!jarPath.startsWith("file")) {
            return jarPath;
        }
        try {
            File result2;
            URL parsedUrl = new URL(jarPath);
            try {
                result2 = new File(parsedUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException("URL='" + parsedUrl + "'", e2);
            }
            return result2.getPath().replace('\\', '/');
        }
        catch (Exception e3) {
            jarPath = jarPath.substring("file".length());
            if (jarPath.startsWith("://")) {
                return jarPath.substring("://".length());
            }
            if (!jarPath.isEmpty() && jarPath.charAt(0) == ':') {
                return jarPath.substring(1);
            }
            return jarPath;
        }
    }

    @NotNull
    public static String getCommunityHomePath() {
        return PathManager.getCommunityHomePath(PathManager.getHomePath());
    }

    private static boolean isDevServer() {
        return Boolean.getBoolean("idea.use.dev.build.server");
    }

    @NotNull
    private static String getCommunityHomePath(@NotNull String homePath) {
        boolean isRunningFromSources;
        if (homePath == null) {
            PathManager.$$$reportNull$$$0(49);
        }
        if (!(isRunningFromSources = Files.isDirectory(Paths.get(homePath, ".idea"), new LinkOption[0])) && !PathManager.isDevServer()) {
            String string2 = homePath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(50);
            }
            return string2;
        }
        ArrayList<Path> possibleCommunityPathList = new ArrayList<Path>();
        possibleCommunityPathList.add(Paths.get(homePath, "community"));
        possibleCommunityPathList.add(Paths.get(homePath, "..", "..", "..", "community"));
        possibleCommunityPathList.add(Paths.get(homePath, "..", "..", "..", "..", "community"));
        for (Path possibleCommunityPath : possibleCommunityPathList) {
            if (!Files.isRegularFile(possibleCommunityPath.resolve("intellij.idea.community.main.iml"), new LinkOption[0])) continue;
            String string3 = possibleCommunityPath.normalize().toString();
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(51);
            }
            return string3;
        }
        String string4 = homePath;
        if (string4 == null) {
            PathManager.$$$reportNull$$$0(52);
        }
        return string4;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        Path resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(53);
        }
        return (resourceRoot = PathManager.getJarForClass(aClass)) == null ? null : resourceRoot.toString();
    }

    @Nullable
    public static Path getJarForClass(@NotNull Class<?> aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(54);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null ? null : Paths.get(resourceRoot, new String[0]).toAbsolutePath();
    }

    private static void log(String x2) {
        System.err.println(x2);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(55);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        String string2 = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(56);
        }
        return string2;
    }

    @Nullable
    private static String getExplicitPath(@NotNull String property2) {
        String path;
        if (property2 == null) {
            PathManager.$$$reportNull$$$0(57);
        }
        if ((path = System.getProperty(property2)) == null) {
            return null;
        }
        boolean quoted = path.length() > 1 && '\"' == path.charAt(0) && '\"' == path.charAt(path.length() - 1);
        return PathManager.getAbsolutePath(quoted ? path.substring(1, path.length() - 1) : path);
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = System.getProperty("user.home");
        String vendorName = PathManager.vendorName();
        if (SystemInfoRt.isMac) {
            String dir2 = userHome + "/Library/" + macDir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir2 = dir2 + '/' + selector;
            }
            if (!macSub.isEmpty()) {
                dir2 = dir2 + '/' + macSub;
            }
            return dir2;
        }
        if (SystemInfoRt.isWindows) {
            String dir3 = System.getenv(winVar);
            if (dir3 == null || dir3.isEmpty()) {
                dir3 = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir3 = dir3 + '\\' + vendorName;
            if (!selector.isEmpty()) {
                dir3 = dir3 + '\\' + selector;
            }
            if (!winSub.isEmpty()) {
                dir3 = dir3 + '\\' + winSub;
            }
            return dir3;
        }
        if (SystemInfoRt.isUnix) {
            return PathManager.getUnixPlatformPath(userHome, selector, xdgVar, xdgDfl, xdgSub);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static String getUnixPlatformPath(String userHome, String selector, @Nullable String xdgVar, String xdgDfl, String xdgSub) {
        String dir2;
        String string2 = dir2 = xdgVar != null ? System.getenv(xdgVar) : null;
        if (dir2 == null || dir2.isEmpty()) {
            dir2 = userHome + '/' + xdgDfl;
        }
        dir2 = dir2 + '/' + PathManager.vendorName();
        if (!selector.isEmpty()) {
            dir2 = dir2 + '/' + selector;
        }
        if (!xdgSub.isEmpty()) {
            dir2 = dir2 + '/' + xdgSub;
        }
        return dir2;
    }

    private static String vendorName() {
        String property2 = System.getProperty("idea.vendor.name");
        if (property2 == null) {
            try {
                Class<?> ex = Class.forName("com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object instance2 = lookup.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property2 = lookup.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.setProperty("idea.vendor.name", property2 != null ? property2 : "JetBrains");
        }
        return property2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 42: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 4: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: 
            case 23: 
            case 27: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHome";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledRuntimePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonDataPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsDir";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDir";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixSystemPath";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDir";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLogPathFor";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupScriptDir";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHomeDirFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUnixSystemPath";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLogPathFor";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCommunityHomePath";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getJarForClass";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

