/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.xml.dom.XmlElement;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    private static volatile ApplicationInfoImpl instance;
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName;
    private String myCopyrightStart;
    private String myShortCompanyName;
    private String myCompanyUrl;
    private String mySplashImageUrl;
    private String myEapSplashImageUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myWelcomeScreenLogoUrl;
    private ZonedDateTime buildTime;
    private ZonedDateTime majorReleaseBuildDate;
    private String myProductUrl;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String channelListUrl;
    private String pluginDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private boolean myShowWhatsNewOnUpdate;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp;
    private boolean myHasContextHelp;
    private String myWebHelpUrl;
    private final List<PluginId> essentialPluginIds;
    private String myJetBrainsTvUrl;
    private String mySubscriptionFormId;
    private boolean mySubscriptionTipsAvailable;
    private String myDefaultLightLaf;
    private String myDefaultClassicLightLaf;
    private String myDefaultDarkLaf;
    private String myDefaultClassicDarkLaf;
    private static final Logger LOG;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    ApplicationInfoImpl(@NotNull XmlElement element) {
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        this.myCompanyName = "JetBrains s.r.o.";
        this.myCopyrightStart = "2000";
        this.myCompanyUrl = "https://www.jetbrains.com/";
        this.myHasHelp = true;
        this.myHasContextHelp = true;
        this.myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
        this.essentialPluginIds = new ArrayList<PluginId>();
        block48: for (XmlElement child : element.children) {
            switch (child.name) {
                case "version": {
                    this.myMajorVersion = child.getAttributeValue("major");
                    this.myMinorVersion = child.getAttributeValue("minor");
                    this.myMicroVersion = child.getAttributeValue("micro");
                    this.myPatchVersion = child.getAttributeValue("patch");
                    this.myFullVersionFormat = child.getAttributeValue("full");
                    this.myCodeName = child.getAttributeValue("codename");
                    this.myEAP = Boolean.parseBoolean(child.getAttributeValue("eap"));
                    this.myVersionSuffix = child.getAttributeValue("suffix", this.myEAP ? "EAP" : null);
                    break;
                }
                case "company": {
                    this.myCompanyName = child.getAttributeValue("name", this.myCompanyName);
                    this.myShortCompanyName = child.getAttributeValue("shortName", this.myCompanyName == null ? null : ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
                    this.myCompanyUrl = child.getAttributeValue("url", this.myCompanyUrl);
                    this.myCopyrightStart = child.getAttributeValue("copyrightStart", this.myCopyrightStart);
                    break;
                }
                case "build": {
                    this.readBuildInfo(child);
                    break;
                }
                case "logo": {
                    this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(child, "url");
                    break;
                }
                case "logo-eap": {
                    this.myEapSplashImageUrl = ApplicationInfoImpl.getAttributeValue(child, "url");
                    break;
                }
                case "icon": {
                    this.mySvgIconUrl = child.getAttributeValue("svg");
                    this.mySmallSvgIconUrl = child.getAttributeValue("svg-small");
                    break;
                }
                case "icon-eap": {
                    this.mySvgEapIconUrl = child.getAttributeValue("svg");
                    this.mySmallSvgEapIconUrl = child.getAttributeValue("svg-small");
                    break;
                }
                case "welcome-screen": {
                    this.myWelcomeScreenLogoUrl = child.getAttributeValue("logo-url");
                    break;
                }
                case "productUrl": {
                    this.myProductUrl = child.getAttributeValue("url");
                    break;
                }
                case "help": {
                    String attValue;
                    String webHelpUrl = ApplicationInfoImpl.getAttributeValue(child, "webhelp-url");
                    if (webHelpUrl != null) {
                        this.myWebHelpUrl = webHelpUrl;
                    }
                    this.myHasHelp = (attValue = child.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
                    attValue = child.getAttributeValue("has-context-help");
                    this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
                    break;
                }
                case "update-urls": {
                    this.myUpdateUrls = new UpdateUrlsImpl(child);
                    break;
                }
                case "documentation": {
                    this.myDocumentationUrl = child.getAttributeValue("url");
                    break;
                }
                case "support": {
                    this.mySupportUrl = child.getAttributeValue("url");
                    break;
                }
                case "youtrack": {
                    this.myYoutrackUrl = child.getAttributeValue("url");
                    break;
                }
                case "feedback": {
                    this.myFeedbackUrl = child.getAttributeValue("url");
                    break;
                }
                case "whatsnew": {
                    this.myWhatsNewUrl = child.getAttributeValue("url");
                    this.myShowWhatsNewOnUpdate = Boolean.parseBoolean(child.getAttributeValue("show-on-update"));
                    break;
                }
                case "plugins": {
                    this.readPluginInfo(child);
                    break;
                }
                case "keymap": {
                    this.myWinKeymapUrl = child.getAttributeValue("win");
                    this.myMacKeymapUrl = child.getAttributeValue("mac");
                    break;
                }
                case "essential-plugin": {
                    String id = child.content;
                    if (id == null || id.isEmpty()) continue block48;
                    this.essentialPluginIds.add(PluginId.getId(id));
                    break;
                }
                case "jetbrains-tv": {
                    this.myJetBrainsTvUrl = child.getAttributeValue("url");
                    break;
                }
                case "subscriptions": {
                    this.mySubscriptionFormId = child.getAttributeValue("formid");
                    this.mySubscriptionTipsAvailable = Boolean.parseBoolean(child.getAttributeValue("tips-available"));
                    break;
                }
                case "default-laf": {
                    String laf = ApplicationInfoImpl.getAttributeValue(child, "light");
                    if (laf != null) {
                        this.myDefaultLightLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child, "light-classic")) != null) {
                        this.myDefaultClassicLightLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child, "dark")) != null) {
                        this.myDefaultDarkLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child, "dark-classic")) == null) break;
                    this.myDefaultClassicDarkLaf = laf.trim();
                }
            }
        }
        if (this.myPluginManagerUrl == null) {
            this.readPluginInfo(null);
        }
        Objects.requireNonNull(this.mySvgIconUrl, "Missing attribute: //icon@svg");
        Objects.requireNonNull(this.mySmallSvgIconUrl, "Missing attribute: //icon@svg-small");
        this.overrideFromProperties();
        this.essentialPluginIds.sort(null);
    }

    private void overrideFromProperties() {
        String youTrackUrlOverride = System.getProperty("application.info.youtrack.url");
        if (youTrackUrlOverride != null) {
            this.myYoutrackUrl = youTrackUrlOverride;
        }
    }

    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        return ApplicationInfoImpl.getShadowInstanceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static ApplicationInfoImpl getShadowInstanceImpl() {
        ApplicationInfoImpl result2 = instance;
        if (result2 != null) {
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(1);
            }
            return applicationInfoImpl;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result2 = instance;
            if (result2 == null) {
                Activity activity = StartUpMeasurer.startActivity("app info loading");
                try {
                    instance = result2 = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(2);
            }
            return applicationInfoImpl;
        }
    }

    @NotNull
    public BuildNumber getBuild() {
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString(this.myBuildNumber));
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(6);
        }
        return buildNumber;
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber build2 = this.getBuild();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getApiVersionAsNumber: build=" + build2.asString());
        }
        if (this.myApiVersion != null) {
            BuildNumber api;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getApiVersionAsNumber: myApiVersion=" + build2.asString());
            }
            if ((api = BuildNumber.fromStringWithProductCode(this.myApiVersion, build2.getProductCode())) != null) {
                BuildNumber buildNumber = api;
                if (buildNumber == null) {
                    ApplicationInfoImpl.$$$reportNull$$$0(8);
                }
                return buildNumber;
            }
        }
        BuildNumber buildNumber = build2;
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        return buildNumber;
    }

    @Nullable
    private static String getAttributeValue(XmlElement element, String name2) {
        String value2 = element.getAttributeValue(name2);
        return value2 == null || value2.isEmpty() ? null : value2;
    }

    private void readBuildInfo(XmlElement element) {
        String majorReleaseDateString;
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element, "number");
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element, "apiVersion");
        String dateString = element.getAttributeValue("date");
        if (dateString != null && !dateString.equals("__BUILD_DATE__")) {
            this.buildTime = ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element.getAttributeValue("majorReleaseDate")) != null) {
            this.majorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable XmlElement element) {
        String pluginHost;
        String pluginManagerUrl = "https://plugins.jetbrains.com";
        String pluginListUrl = null;
        this.channelListUrl = null;
        this.pluginDownloadUrl = null;
        if (element != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url = element.getAttributeValue("url");
            if (url != null) {
                String string2 = pluginManagerUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            }
            if ((listUrl = element.getAttributeValue("list-url")) != null) {
                pluginListUrl = listUrl;
            }
            if ((channelListUrl = element.getAttributeValue("channel-list-url")) != null) {
                this.channelListUrl = channelListUrl;
            }
            if ((downloadUrl = element.getAttributeValue("download-url")) != null) {
                this.pluginDownloadUrl = downloadUrl;
            }
            if ((builtinPluginsUrl = element.getAttributeValue("builtin-url")) != null && !builtinPluginsUrl.isEmpty()) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginHost = System.getProperty("idea.plugins.host")) != null) {
            pluginManagerUrl = pluginHost.endsWith("/") ? pluginHost.substring(0, pluginHost.length() - 1) : pluginHost;
            this.pluginDownloadUrl = null;
            this.channelListUrl = null;
            pluginListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string3 = this.myPluginsListUrl = pluginListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginListUrl;
        if (this.channelListUrl == null) {
            this.channelListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.pluginDownloadUrl == null) {
            this.pluginDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    private static String shortenCompanyName(String name2) {
        if (name2.endsWith(" s.r.o.")) {
            name2 = name2.substring(0, name2.length() - " s.r.o.".length());
        }
        if (name2.endsWith(" Inc.")) {
            name2 = name2.substring(0, name2.length() - " Inc.".length());
        }
        return name2;
    }

    @Nullable
    private static ZonedDateTime parseDate(@NotNull String dateString) {
        if (dateString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(21);
        }
        try {
            int minute;
            int hour;
            int year = Integer.parseInt(dateString.substring(0, 4));
            int month = Integer.parseInt(dateString.substring(4, 6));
            int dayOfMonth = Integer.parseInt(dateString.substring(6, 8));
            if (dateString.length() > 8) {
                hour = Integer.parseInt(dateString.substring(8, 10));
                minute = Integer.parseInt(dateString.substring(10, 12));
            } else {
                hour = 0;
                minute = 0;
            }
            return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, 0, 0, ZoneOffset.UTC);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Override
    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(23);
        }
        return PluginManagerCore.CORE_ID.equals(pluginId) || Collections.binarySearch(this.essentialPluginIds, pluginId) >= 0;
    }

    static {
        LOG = Logger.getInstance(ApplicationInfoImpl.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateString";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstanceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "orFromPluginCompatibleBuild";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorReleaseBuildDate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersionAsNumber";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictVersion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationSvgIconUrl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallApplicationSvgIconUrl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginManagerUrl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsListUrl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDownloadUrl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginCompatibleBuild";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginCompatibleBuildAsNumber";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getEssentialPluginIds";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(XmlElement element) {
            this.myCheckingUrl = element.getAttributeValue("check");
            this.myPatchesUrl = element.getAttributeValue("patches");
        }
    }
}

