/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.NotNull;

public final class LineTokenizer {
    private int myOffset;
    private int myLength;
    private int myLineSeparatorLength;
    private boolean atEnd;
    private final CharSequence myText;

    public LineTokenizer(@NotNull CharSequence text) {
        if (text == null) {
            LineTokenizer.$$$reportNull$$$0(9);
        }
        this.myText = text;
        this.myOffset = 0;
        this.advance();
    }

    public boolean atEnd() {
        return this.atEnd;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c2;
        int i2 = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i2 >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i2 < textLength && (c2 = this.myText.charAt(i2)) != '\r' && c2 != '\n') {
            ++i2;
        }
        this.myOffset += this.myLength + this.myLineSeparatorLength;
        this.myLength = i2 - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i2 == textLength) {
            return;
        }
        char first = this.myText.charAt(i2);
        if (first == '\r' || first == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i2 == textLength) {
            return;
        }
        char second = this.myText.charAt(i2);
        if (first == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/LineTokenizer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenizeIntoList";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/LineTokenizer";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcLineCount";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stringEndsWithSeparator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

