/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    @NotNull
    public static StringPattern string() {
        StringPattern stringPattern = StringPattern.STRING_PATTERN;
        if (stringPattern == null) {
            StandardPatterns.$$$reportNull$$$0(0);
        }
        return stringPattern;
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> instanceOf(@NotNull Class<T> aClass) {
        if (aClass == null) {
            StandardPatterns.$$$reportNull$$$0(1);
        }
        return new ObjectPattern.Capture<T>(aClass);
    }

    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        if (patterns == null) {
            StandardPatterns.$$$reportNull$$$0(6);
        }
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.accepts(o2, context2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$3", "append"));
            }
        });
    }

    @NotNull
    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                return !pattern.accepts(o2, context2);
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    5.$$$reportNull$$$0(0);
                }
                pattern.getCondition().append(builder.append("not("), indent + "  ");
                builder.append(")");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$5", "append"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/StandardPatterns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "string";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/StandardPatterns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "object";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysFalse";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "object";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(@Nullable Object o2) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(@Nullable Object o2, ProcessingContext context2) {
                    return false;
                }
            });
        }
    }
}

