/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.ObjectUtilsRt;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.ui.EDT;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class DocumentCommitThread
implements Disposable,
DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance(DocumentCommitThread.class);
    private final ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor("Document Commit Pool", AppExecutorUtil.getAppExecutorService(), 1, this);
    private volatile boolean isDisposed;

    DocumentCommitThread() {
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
    }

    @Override
    public void commitAsynchronously(@NotNull Project project, @NotNull PsiDocumentManagerBase documentManager, @NotNull Document document, @NonNls @NotNull Object reason, @NotNull ModalityState modality, @NotNull FileViewProvider cachedViewProvider) {
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(0);
        }
        if (documentManager == null) {
            DocumentCommitThread.$$$reportNull$$$0(1);
        }
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(2);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(3);
        }
        if (modality == null) {
            DocumentCommitThread.$$$reportNull$$$0(4);
        }
        if (cachedViewProvider == null) {
            DocumentCommitThread.$$$reportNull$$$0(5);
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project.isInitialized()) {
            return;
        }
        if (documentManager.myProject != project) {
            throw new IllegalArgumentException("Wrong project: " + project + "; expected: " + documentManager.myProject);
        }
        assert (cachedViewProvider.isEventSystemEnabled()) : "Asynchronous commit is only supported for physical PSI, document=" + document + ", cachedViewProvider=" + cachedViewProvider + " (" + cachedViewProvider.getClass() + ")";
        TransactionGuard.getInstance().assertWriteSafeContext(modality);
        CommitTask task = new CommitTask(project, document, reason, modality, documentManager.getLastCommittedText(document), cachedViewProvider);
        ReadAction.nonBlocking(() -> this.commitUnderProgress(task, false, documentManager)).expireWhen(() -> project.isDisposed() || this.isDisposed || !documentManager.isInUncommittedSet(document) || !task.isStillValid()).coalesceBy(task).finishOnUiThread(modality, Runnable::run).submit(this.executor);
    }

    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(6);
        }
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            DocumentCommitThread.$$$reportNull$$$0(8);
        }
        assert (!this.isDisposed);
        if (!project.isInitialized() && !project.isDefault()) {
            throw new IllegalArgumentException("Must not call sync commit with unopened project: " + project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen());
        }
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
        CommitTask task = new CommitTask(project, document, "Sync commit", ModalityState.defaultModalityState(), documentManager.getLastCommittedText(document), psiFile.getViewProvider());
        this.commitUnderProgress(task, true, documentManager).run();
    }

    @NotNull
    private Runnable commitUnderProgress(@NotNull CommitTask task, boolean synchronously, @NotNull PsiDocumentManagerBase documentManager) {
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(9);
        }
        if (documentManager == null) {
            DocumentCommitThread.$$$reportNull$$$0(10);
        }
        Document document = task.document;
        Project project = task.project;
        SmartList<BooleanRunnable> finishProcessors = new SmartList<BooleanRunnable>();
        SmartList reparseInjectedProcessors = new SmartList();
        FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
        if (viewProvider == null) {
            finishProcessors.add(DocumentCommitThread.handleCommitWithoutPsi(task, documentManager));
        } else {
            task.cachedViewProvider = viewProvider;
            for (PsiFile file2 : viewProvider.getAllFiles()) {
                FileASTNode oldFileNode = file2.getNode();
                if (oldFileNode == null) {
                    throw new AssertionError((Object)("No node for " + file2.getClass() + " in " + file2.getViewProvider().getClass() + " of size " + StringUtil.formatFileSize(document.getTextLength()) + " (is too large = " + SingleRootFileViewProvider.isTooLargeForIntelligence(viewProvider.getVirtualFile(), Long.valueOf(document.getTextLength())) + ")"));
                }
                ProperTextRange changedPsiRange = ChangedPsiRangeUtil.getChangedPsiRange(file2, document, task.myLastCommittedText, document.getImmutableCharSequence());
                if (changedPsiRange == null) continue;
                BooleanRunnable finishProcessor = DocumentCommitThread.doCommit(task, file2, oldFileNode, changedPsiRange, reparseInjectedProcessors, documentManager);
                finishProcessors.add(finishProcessor);
            }
        }
        Runnable runnable = () -> {
            if (project.isDisposed()) {
                return;
            }
            boolean success = documentManager.finishCommit(document, finishProcessors, reparseInjectedProcessors, synchronously, task.reason);
            if (synchronously) assert (success);
            if (synchronously || success) assert (!documentManager.isInUncommittedSet(document));
            if (!success && viewProvider != null && viewProvider.isEventSystemEnabled()) {
                this.commitAsynchronously(project, documentManager, document, "Re-added back", task.myCreationModality, viewProvider);
            }
        };
        if (runnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    private static BooleanRunnable handleCommitWithoutPsi(@NotNull CommitTask task, @NotNull PsiDocumentManagerBase documentManager) {
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(12);
        }
        if (documentManager == null) {
            DocumentCommitThread.$$$reportNull$$$0(13);
        }
        BooleanRunnable booleanRunnable = () -> {
            if (!task.isStillValid() || documentManager.getCachedViewProvider(task.document) != null) {
                return false;
            }
            documentManager.handleCommitWithoutPsi(task.document);
            return true;
        };
        if (booleanRunnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(14);
        }
        return booleanRunnable;
    }

    public String toString() {
        return "Document commit thread; application: " + ApplicationManager.getApplication() + "; isDisposed: " + this.isDisposed;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public void waitForAllCommits(long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void timeUnit2;
        if (timeUnit == null) {
            DocumentCommitThread.$$$reportNull$$$0(15);
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            while (!((BoundedTaskExecutor)this.executor).isEmpty()) {
                ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(timeout, (TimeUnit)timeUnit2);
            }
            return;
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        EDT.dispatchAllInvocationEvents();
        while (!((BoundedTaskExecutor)this.executor).isEmpty()) {
            ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(timeout, (TimeUnit)timeUnit2);
            EDT.dispatchAllInvocationEvents();
        }
    }

    @NotNull
    private static BooleanRunnable doCommit(@NotNull CommitTask task, @NotNull PsiFile file2, @NotNull FileASTNode oldFileNode, @NotNull ProperTextRange changedPsiRange, @NotNull List<? super BooleanRunnable> outReparseInjectedProcessors, @NotNull PsiDocumentManagerBase documentManager) {
        DiffLog diffLog;
        ProgressIndicator indicator;
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(17);
        }
        if (oldFileNode == null) {
            DocumentCommitThread.$$$reportNull$$$0(18);
        }
        if (changedPsiRange == null) {
            DocumentCommitThread.$$$reportNull$$$0(19);
        }
        if (outReparseInjectedProcessors == null) {
            DocumentCommitThread.$$$reportNull$$$0(20);
        }
        if (documentManager == null) {
            DocumentCommitThread.$$$reportNull$$$0(21);
        }
        Document document = task.document;
        CharSequence newDocumentText = document.getImmutableCharSequence();
        Boolean data = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data);
        }
        if ((indicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            BlockSupportImpl.ReparseResult result2 = BlockSupportImpl.reparse(file2, oldFileNode, changedPsiRange, newDocumentText, indicator, task.myLastCommittedText);
            diffLog = result2.log;
            List<BooleanRunnable> injectedRunnables = documentManager.reparseChangedInjectedFragments(document, file2, changedPsiRange, indicator, result2.oldRoot, result2.newRoot);
            outReparseInjectedProcessors.addAll(injectedRunnables);
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            LOG.error(e3);
            BooleanRunnable booleanRunnable = () -> {
                documentManager.forceReload(file2.getViewProvider().getVirtualFile(), file2.getViewProvider());
                return true;
            };
            if (booleanRunnable == null) {
                DocumentCommitThread.$$$reportNull$$$0(22);
            }
            return booleanRunnable;
        }
        BooleanRunnable booleanRunnable = () -> {
            FileViewProvider viewProvider = file2.getViewProvider();
            if (!task.isStillValid() || documentManager.getCachedViewProvider(document) != viewProvider) {
                return false;
            }
            if (!ApplicationManager.getApplication().isWriteAccessAllowed() && documentManager.isEventSystemEnabled(document)) {
                VirtualFile vFile = viewProvider.getVirtualFile();
                LOG.error("Write action expected; document=" + document + "; file=" + file2 + " of " + file2.getClass() + "; file.valid=" + file2.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; viewProvider=" + viewProvider + " of " + viewProvider.getClass() + "; language=" + file2.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + AbstractFileViewProvider.isFreeThreaded(viewProvider));
            }
            diffLog.doActualPsiChange(file2);
            DocumentCommitThread.assertAfterCommit(document, file2, oldFileNode);
            ObjectUtilsRt.reachabilityFence(task.cachedViewProvider);
            return true;
        };
        if (booleanRunnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(23);
        }
        return booleanRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file2, @NotNull FileASTNode oldFileNode) {
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(25);
        }
        if (oldFileNode == null) {
            DocumentCommitThread.$$$reportNull$$$0(26);
        }
        if (oldFileNode.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file2.getText();
            boolean sameText = Objects.equals(fileText, documentText);
            String errorMessage = "commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency(file2, document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text; file name:" + file2.getName() + "; type:" + file2.getFileType() + "; lang:" + file2.getLanguage();
            PluginException.logPluginError(LOG, errorMessage, null, file2.getLanguage().getClass());
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file2.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file2, file2.getNode(), new TextRange(0, documentText.length()), documentText, new StandardProgressIndicatorBase(), oldFileNode.getText());
                diffLog.doActualPsiChange(file2);
                if (oldFileNode.getTextLength() != document.getTextLength()) {
                    PluginException.logPluginError(LOG, "PSI is broken beyond repair in: " + file2, null, file2.getLanguage().getClass());
                }
            }
            finally {
                file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 22: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 22: 
            case 23: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 2: 
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedViewProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: 
            case 14: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/DocumentCommitThread";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedPsiRange";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outReparseInjectedProcessors";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/DocumentCommitThread";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "commitUnderProgress";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCommitWithoutPsi";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doCommit";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commitAsynchronously";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "commitSynchronously";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "commitUnderProgress";
                break;
            }
            case 11: 
            case 14: 
            case 22: 
            case 23: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitWithoutPsi";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "waitForAllCommits";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "assertAfterCommit";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 14: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommitTask {
        @NotNull
        private final Document document;
        @NotNull
        final Project project;
        private final int modificationSequence;
        @NotNull
        private volatile FileViewProvider cachedViewProvider;
        @NotNull
        final Object reason;
        @NotNull
        final ModalityState myCreationModality;
        private final CharSequence myLastCommittedText;

        CommitTask(@NotNull Project project, @NotNull Document document, @NotNull @NonNls Object reason, @NotNull ModalityState modality, @NotNull CharSequence lastCommittedText, @NotNull FileViewProvider cachedViewProvider) {
            if (project == null) {
                CommitTask.$$$reportNull$$$0(0);
            }
            if (document == null) {
                CommitTask.$$$reportNull$$$0(1);
            }
            if (reason == null) {
                CommitTask.$$$reportNull$$$0(2);
            }
            if (modality == null) {
                CommitTask.$$$reportNull$$$0(3);
            }
            if (lastCommittedText == null) {
                CommitTask.$$$reportNull$$$0(4);
            }
            if (cachedViewProvider == null) {
                CommitTask.$$$reportNull$$$0(5);
            }
            this.document = document;
            this.project = project;
            this.reason = reason;
            this.myCreationModality = modality;
            this.myLastCommittedText = lastCommittedText;
            this.modificationSequence = ((DocumentEx)document).getModificationSequence();
            this.cachedViewProvider = cachedViewProvider;
        }

        @NonNls
        public String toString() {
            String reasonInfo = " task reason: " + StringUtil.first(String.valueOf(this.reason), 180, true) + (this.isStillValid() ? "" : "; changed: old seq=" + this.modificationSequence + ", new seq=" + ((DocumentEx)this.document).getModificationSequence());
            String contextInfo = " modality: " + this.myCreationModality;
            return System.identityHashCode(this) + "; " + contextInfo + reasonInfo;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o2;
            return Comparing.equal(this.document, task.document) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result2 = this.document.hashCode();
            result2 = 31 * result2 + this.project.hashCode();
            return result2;
        }

        boolean isStillValid() {
            return ((DocumentEx)this.document).getModificationSequence() == this.modificationSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reason";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modality";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lastCommittedText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cachedViewProvider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/DocumentCommitThread$CommitTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

