/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.Domination;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public class StaticImportResolveProcessor
implements NameHint,
PsiScopeProcessor {
    private final PsiImportStaticReferenceElement myReference;
    private final String myName;
    private final List<JavaResolveResult> myFieldResults;
    private final List<JavaResolveResult> myClassResult;
    private final List<JavaResolveResult> myResults;

    public StaticImportResolveProcessor(@NotNull PsiImportStaticReferenceElement reference2) {
        if (reference2 == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(0);
        }
        this.myFieldResults = new SmartList<JavaResolveResult>();
        this.myClassResult = new SmartList<JavaResolveResult>();
        this.myResults = new SmartList<JavaResolveResult>();
        this.myReference = reference2;
        this.myName = this.myReference.getReferenceName();
    }

    @Override
    public boolean execute(@NotNull PsiElement candidate2, @NotNull ResolveState state) {
        if (candidate2 == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(1);
        }
        if (state == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(2);
        }
        if (candidate2 instanceof PsiMember && ((PsiModifierListOwner)candidate2).hasModifierProperty("static")) {
            if (candidate2 instanceof PsiField) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate2, this.myFieldResults)) {
                    return true;
                }
                this.myFieldResults.add(new OurResolveResult(candidate2, this.myReference));
            } else if (candidate2 instanceof PsiClass) {
                if (StaticImportResolveProcessor.checkDomination((PsiMember)candidate2, this.myClassResult)) {
                    return true;
                }
                this.myClassResult.add(new OurResolveResult(candidate2, this.myReference));
            } else {
                this.myResults.add(new OurResolveResult(candidate2, this.myReference));
            }
        }
        return true;
    }

    private static boolean checkDomination(PsiMember candidate2, List<JavaResolveResult> results) {
        if (!results.isEmpty()) {
            ListIterator<JavaResolveResult> i2 = results.listIterator(results.size());
            while (i2.hasPrevious()) {
                Domination domination = StaticImportResolveProcessor.dominates(candidate2, (PsiMember)i2.previous().getElement());
                if (domination == Domination.DOMINATED_BY) {
                    return true;
                }
                if (domination != Domination.DOMINATES) continue;
                i2.remove();
            }
        }
        return false;
    }

    private static Domination dominates(PsiMember member1, PsiMember member2) {
        PsiClass class1 = member1.getContainingClass();
        PsiClass class2 = member2.getContainingClass();
        if (class1 != null && class2 != null) {
            if (class1.isInheritor(class2, true)) {
                return Domination.DOMINATES;
            }
            if (class2.isInheritor(class1, true)) {
                return Domination.DOMINATED_BY;
            }
        }
        return Domination.EQUAL;
    }

    @Override
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(3);
        }
        return this.myName;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(4);
        }
        if (hintKey == NameHint.KEY) {
            return (T)this;
        }
        return null;
    }

    public JavaResolveResult @NotNull [] getResults() {
        if (this.myResults.size() + this.myFieldResults.size() + this.myClassResult.size() > 1) {
            StaticImportResolveProcessor.filterInvalid(this.myResults);
            StaticImportResolveProcessor.filterInvalid(this.myFieldResults);
            StaticImportResolveProcessor.filterInvalid(this.myClassResult);
        }
        if (!this.myFieldResults.isEmpty()) {
            this.myResults.addAll(this.myFieldResults);
        }
        if (!this.myClassResult.isEmpty()) {
            this.myResults.addAll(this.myClassResult);
        }
        JavaResolveResult[] javaResolveResultArray = this.myResults.toArray(JavaResolveResult.EMPTY_ARRAY);
        if (javaResolveResultArray == null) {
            StaticImportResolveProcessor.$$$reportNull$$$0(5);
        }
        return javaResolveResultArray;
    }

    private static void filterInvalid(List<JavaResolveResult> resultList) {
        if (resultList.isEmpty()) {
            return;
        }
        ListIterator<JavaResolveResult> i2 = resultList.listIterator(resultList.size());
        while (i2.hasPrevious()) {
            if (i2.previous().isValidResult()) continue;
            i2.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OurResolveResult
    extends CandidateInfo {
        private final PsiImportStaticReferenceElement myReference;

        OurResolveResult(@NotNull PsiElement candidate2, PsiImportStaticReferenceElement reference2) {
            if (candidate2 == null) {
                OurResolveResult.$$$reportNull$$$0(0);
            }
            super(candidate2, PsiSubstitutor.EMPTY);
            this.myReference = reference2;
        }

        @Override
        public boolean isAccessible() {
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(this.myReference.getProject()).getResolveHelper();
            PsiElement element = this.getElement();
            return element instanceof PsiMember && resolveHelper.isAccessible((PsiMember)element, this.myReference, null);
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return true;
        }

        @Override
        public boolean isValidResult() {
            return super.isValidResult() && this.checkStaticInterfaceMethodCallQualifier();
        }

        private boolean checkStaticInterfaceMethodCallQualifier() {
            PsiElement element = this.getElement();
            if (!(element instanceof PsiMethod)) {
                return true;
            }
            PsiElement qualifier = this.myReference.getQualifier();
            if (!(qualifier instanceof PsiReference)) {
                return true;
            }
            PsiElement resolved = ((PsiReference)((Object)qualifier)).resolve();
            if (!(resolved instanceof PsiClass)) {
                return true;
            }
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass == null || !containingClass.isInterface() || containingClass.getManager().areElementsEquivalent(resolved, containingClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/source/resolve/StaticImportResolveProcessor$OurResolveResult", "<init>"));
        }
    }
}

