/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaModulePresentationProvider
implements ItemPresentationProvider<PsiJavaModule> {
    private static final Pattern JAR_NAME = Pattern.compile(".+/([^/]+\\.jar)!/.*");

    @Override
    public ItemPresentation getPresentation(final @NotNull PsiJavaModule item) {
        if (item == null) {
            JavaModulePresentationProvider.$$$reportNull$$$0(0);
        }
        return new ItemPresentation(){

            public String getPresentableText() {
                return item.getName();
            }

            @Override
            @Nullable
            public String getLocationString() {
                Module module2;
                VirtualFile file2 = PsiImplUtil.getModuleVirtualFile(item);
                FileIndexFacade index = FileIndexFacade.getInstance(item.getProject());
                if (index.isInLibraryClasses(file2)) {
                    Matcher matcher = JAR_NAME.matcher(file2.getPath());
                    if (matcher.find()) {
                        return matcher.group(1);
                    }
                } else if (index.isInSource(file2) && (module2 = index.getModuleForFile(file2)) != null) {
                    return '[' + module2.getName() + ']';
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean unused2) {
                return IconManager.getInstance().getPlatformIcon(item instanceof LightJavaModule ? PlatformIcons.ArchiveFileType : PlatformIcons.JavaModule);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/psi/presentation/java/JavaModulePresentationProvider", "getPresentation"));
    }
}

