/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiConcatenationUtil {
    public static String buildUnescapedFormatString(PsiExpression concatenation, boolean printfFormat, List<? super PsiExpression> formatParameters) {
        StringBuilder result2 = new StringBuilder();
        PsiConcatenationUtil.buildFormatString(concatenation, result2, formatParameters, printfFormat, false);
        return result2.toString();
    }

    private static void buildFormatString(PsiExpression expression2, StringBuilder formatString, List<? super PsiExpression> formatParameters, boolean printfFormat, boolean escape) {
        if (expression2 instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
            String value2 = String.valueOf(literalExpression.getValue());
            String text = escape ? StringUtil.escapeStringCharacters(value2) : value2;
            String formatText = PsiConcatenationUtil.formatString(text, printfFormat);
            formatString.append(formatText);
        } else if (expression2 instanceof PsiPolyadicExpression) {
            PsiType type2 = expression2.getType();
            if (type2 != null && type2.equalsToText("java.lang.String")) {
                boolean stringStarted;
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression2;
                PsiExpression[] operands = binaryExpression.getOperands();
                PsiType first = operands[0].getType();
                PsiType second = operands[1].getType();
                boolean bl = stringStarted = first != null && first.equalsToText("java.lang.String") || second != null && second.equalsToText("java.lang.String");
                if (stringStarted) {
                    PsiConcatenationUtil.buildFormatString(operands[0], formatString, formatParameters, printfFormat, escape);
                }
                for (int i2 = 1; i2 < operands.length; ++i2) {
                    PsiExpression op = operands[i2];
                    PsiType optype = op.getType();
                    PsiType r2 = TypeConversionUtil.calcTypeForBinaryExpression(first, optype, binaryExpression.getOperationTokenType(), true);
                    if (r2 != null && r2.equalsToText("java.lang.String") && !stringStarted) {
                        stringStarted = true;
                        PsiElement element = binaryExpression.getTokenBeforeOperand(op);
                        assert (element != null);
                        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
                            element = element.getPrevSibling();
                        }
                        String text = binaryExpression.getText().substring(0, element.getStartOffsetInParent());
                        PsiExpression subExpression = JavaPsiFacade.getElementFactory(binaryExpression.getProject()).createExpressionFromText(text, binaryExpression);
                        PsiConcatenationUtil.addFormatParameter(subExpression, formatString, formatParameters, printfFormat);
                    }
                    if (stringStarted) {
                        if (optype != null && (optype.equalsToText("java.lang.String") || PsiTypes.charType().equals(optype))) {
                            PsiConcatenationUtil.buildFormatString(op, formatString, formatParameters, printfFormat, escape);
                        } else {
                            PsiConcatenationUtil.addFormatParameter(op, formatString, formatParameters, printfFormat);
                        }
                    }
                    first = r2;
                }
            } else {
                PsiConcatenationUtil.addFormatParameter(expression2, formatString, formatParameters, printfFormat);
            }
        } else {
            PsiConcatenationUtil.addFormatParameter(expression2, formatString, formatParameters, printfFormat);
        }
    }

    @NotNull
    public static String formatString(String text, boolean printfFormat) {
        if (printfFormat) {
            String string2 = text.replace("%", "%%").replace("\\'", "'");
            if (string2 == null) {
                PsiConcatenationUtil.$$$reportNull$$$0(0);
            }
            return string2;
        }
        String string3 = text.replace("'", "''").replaceAll("([{}]+)", "'$1'");
        if (string3 == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(1);
        }
        return string3;
    }

    private static void addFormatParameter(@NotNull PsiExpression expression2, StringBuilder formatString, List<? super PsiExpression> formatParameters, boolean printfFormat) {
        if (expression2 == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(2);
        }
        PsiType type2 = expression2.getType();
        if (!printfFormat) {
            formatString.append("{").append(formatParameters.size()).append("}");
        } else if (type2 != null && (type2.equalsToText("long") || type2.equalsToText("int") || type2.equalsToText("java.lang.Long") || type2.equalsToText("java.lang.Integer"))) {
            formatString.append("%d");
        } else {
            formatString.append("%s");
        }
        formatParameters.add(PsiConcatenationUtil.getBoxedArgument(expression2));
    }

    private static PsiExpression getBoxedArgument(@NotNull PsiExpression arg) {
        if (arg == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(3);
        }
        if (PsiUtil.isLanguageLevel5OrHigher(arg = ObjectUtils.coalesce(PsiConcatenationUtil.unwrapExpression(arg), arg))) {
            return arg;
        }
        PsiType type2 = arg.getType();
        if (!(type2 instanceof PsiPrimitiveType) || type2.equals(PsiTypes.nullType())) {
            return arg;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)type2;
        String boxedQName = primitiveType.getBoxedTypeName();
        if (boxedQName == null) {
            return arg;
        }
        GlobalSearchScope resolveScope = arg.getResolveScope();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(arg.getProject());
        PsiJavaCodeReferenceElement ref = factory.createReferenceElementByFQClassName(boxedQName, resolveScope);
        PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText("new A(b)", null);
        PsiJavaCodeReferenceElement classRef = newExpr.getClassReference();
        assert (classRef != null);
        classRef.replace(ref);
        PsiExpressionList argumentList = newExpr.getArgumentList();
        assert (argumentList != null);
        argumentList.getExpressions()[0].replace(arg);
        return newExpr;
    }

    @Nullable
    private static PsiExpression unwrapExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(4);
        }
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiTypeCastExpression)) break;
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            PsiType castType = typeCastExpression.getType();
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                return expression2;
            }
            if (TypeConversionUtil.isNumericType(castType)) {
                int operandRank;
                PsiType operandType = operand.getType();
                if (operandType == null) {
                    return expression2;
                }
                int castRank = TypeConversionUtil.getTypeRank(castType);
                if (castRank < (operandRank = TypeConversionUtil.getTypeRank(operandType)) || castRank == 3 && operandRank != castRank) {
                    return expression2;
                }
            }
            expression2 = operand;
        }
        return expression2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiConcatenationUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiConcatenationUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFormatParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedArgument";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unwrapExpression";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

