/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFormatUtil
extends PsiFormatUtilBase {
    public static String formatSimple(@NotNull PsiNamedElement element) {
        if (element == null) {
            PsiFormatUtil.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiMethod) {
            return PsiFormatUtil.formatMethod((PsiMethod)element, PsiSubstitutor.EMPTY, 1, 0);
        }
        if (element instanceof PsiVariable) {
            return PsiFormatUtil.formatVariable((PsiVariable)element, 1, PsiSubstitutor.EMPTY);
        }
        if (element instanceof PsiClass) {
            return PsiFormatUtil.formatClass((PsiClass)element, 1);
        }
        return element.getName();
    }

    public static String formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor2) {
        if (variable == null) {
            PsiFormatUtil.$$$reportNull$$$0(1);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatVariable(variable, options, substitutor2, buffer);
        return buffer.toString();
    }

    private static void formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor2, @NotNull StringBuilder buffer) {
        PsiExpression initializer;
        String name2;
        if (variable == null) {
            PsiFormatUtil.$$$reportNull$$$0(2);
        }
        if (buffer == null) {
            PsiFormatUtil.$$$reportNull$$$0(3);
        }
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if (BitUtil.isSet(options, 2) && !BitUtil.isSet(options, 4)) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatTypeSafe(variable, variable.getType(), options, substitutor2));
        }
        if (variable instanceof PsiField && BitUtil.isSet(options, 4096)) {
            String className;
            PsiClass aClass = ((PsiField)variable).getContainingClass();
            if (aClass != null && (className = aClass.getName()) != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                if (BitUtil.isSet(options, 2048)) {
                    buffer.append(ObjectUtils.notNull(aClass.getQualifiedName(), className));
                } else {
                    buffer.append(className);
                }
                buffer.append('.');
            }
            if (BitUtil.isSet(options, 1)) {
                buffer.append(variable.getName());
            }
        } else if (BitUtil.isSet(options, 1) && StringUtil.isNotEmpty(name2 = variable.getName())) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(name2);
        }
        if (BitUtil.isSet(options, 2) && BitUtil.isSet(options, 4)) {
            if (BitUtil.isSet(options, 1) && variable.getName() != null) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatTypeSafe(variable, variable.getType(), options, substitutor2));
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if (BitUtil.isSet(options, 128) && (initializer = variable.getInitializer()) != null) {
            int index2;
            buffer.append(" = ");
            String text = PsiExpressionTrimRenderer.render(initializer);
            int index1 = text.lastIndexOf(10);
            if (index1 < 0) {
                index1 = text.length();
            }
            if ((index2 = text.lastIndexOf(13)) < 0) {
                index2 = text.length();
            }
            int index = Math.min(index1, index2);
            buffer.append(text, 0, index);
            if (index < text.length()) {
                buffer.append(" ...");
            }
        }
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions) {
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(4);
        }
        if (substitutor2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(5);
        }
        return PsiFormatUtil.formatMethod(method, substitutor2, options, parameterOptions, 7);
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow) {
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(6);
        }
        if (substitutor2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(7);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatMethod(method, substitutor2, options, parameterOptions, maxParametersToShow, buffer);
        return buffer.toString();
    }

    private static void formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow, StringBuilder buffer) {
        String throwsText;
        PsiType type2;
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(8);
        }
        if (substitutor2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(9);
        }
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if (BitUtil.isSet(options, 2) && !BitUtil.isSet(options, 4) && (type2 = method.getReturnType()) != null) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatTypeSafe(method, type2, options, substitutor2));
        }
        if (BitUtil.isSet(options, 4096)) {
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                String name2 = aClass.getName();
                if (name2 != null) {
                    if (BitUtil.isSet(options, 2048)) {
                        buffer.append(ObjectUtils.notNull(aClass.getQualifiedName(), name2));
                    } else {
                        buffer.append(name2);
                    }
                    buffer.append('.');
                }
            }
            if (BitUtil.isSet(options, 1)) {
                buffer.append(method.getName());
            }
        } else if (BitUtil.isSet(options, 1)) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(method.getName());
        }
        buffer.append('(');
        if (BitUtil.isSet(options, 256)) {
            PsiParameter[] params = method.getParameterList().getParameters();
            for (int i2 = 0; i2 < Math.min(params.length, maxParametersToShow); ++i2) {
                if (i2 > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatVariable(params[i2], parameterOptions, substitutor2));
            }
            if (params.length > maxParametersToShow) {
                buffer.append(", ...");
            }
        }
        buffer.append(')');
        if (BitUtil.isSet(options, 2) && BitUtil.isSet(options, 4) && (type2 = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatTypeSafe(method, type2, options, substitutor2));
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if (BitUtil.isSet(options, 512) && !(throwsText = PsiFormatUtil.formatReferenceList(method.getThrowsList(), options)).isEmpty()) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append("throws ").append(throwsText);
        }
    }

    private static String formatTypeSafe(PsiElement parent2, PsiType type2, int options, PsiSubstitutor substitutor2) {
        try {
            return PsiFormatUtil.formatType(type2, options, substitutor2);
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            if (ExceptionUtil.getRootCause(e3) instanceof PsiInvalidElementAccessException) {
                throw new RuntimeException("Invalid type in " + parent2.getClass(), e3);
            }
            throw e3;
        }
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, @FormatClassOptions int options) {
        if (aClass == null) {
            PsiFormatUtil.$$$reportNull$$$0(10);
        }
        StringBuilder buffer = new StringBuilder();
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if (BitUtil.isSet(options, 1)) {
            if (aClass instanceof PsiAnonymousClass && BitUtil.isSet(options, 32768)) {
                PsiClassType baseClassReference = ((PsiAnonymousClass)aClass).getBaseClassType();
                PsiClass baseClass = baseClassReference.resolve();
                String name2 = baseClass == null ? baseClassReference.getPresentableText() : PsiFormatUtil.formatClass(baseClass, options);
                buffer.append(JavaPsiBundle.message("anonymous.class.derived.display", name2));
            } else {
                String name3;
                String string2 = name3 = aClass instanceof PsiImplicitClass ? aClass.getQualifiedName() : aClass.getName();
                if (name3 != null) {
                    PsiFormatUtil.appendSpaceIfNeeded(buffer);
                    if (BitUtil.isSet(options, 2048)) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(aClass.getName());
                        }
                    } else {
                        buffer.append(aClass.getName());
                    }
                }
            }
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if (BitUtil.isSet(options, 1024)) {
            String implementsText;
            PsiReferenceList implementsList;
            String extendsText;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null && !(extendsText = PsiFormatUtil.formatReferenceList(extendsList, options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("extends ").append(extendsText);
            }
            if ((implementsList = aClass.getImplementsList()) != null && !(implementsText = PsiFormatUtil.formatReferenceList(implementsList, options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("implements ").append(implementsText);
            }
        }
        String string3 = buffer.toString();
        if (string3 == null) {
            PsiFormatUtil.$$$reportNull$$$0(11);
        }
        return string3;
    }

    @NotNull
    public static String formatModifiers(@NotNull PsiModifierListOwner element, int options) {
        if (element == null) {
            PsiFormatUtil.$$$reportNull$$$0(12);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatModifiers(element, options, buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(13);
        }
        return string2;
    }

    private static void formatModifiers(PsiModifierListOwner element, int options, StringBuilder buffer) {
        boolean isInterface;
        PsiModifierList list = element.getModifierList();
        if (list == null) {
            return;
        }
        if (!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("public") : list.hasModifierProperty("public")) {
            PsiFormatUtil.appendModifier(buffer, "public");
        }
        if (list.hasModifierProperty("protected")) {
            PsiFormatUtil.appendModifier(buffer, "protected");
        }
        if (list.hasModifierProperty("private")) {
            PsiFormatUtil.appendModifier(buffer, "private");
        }
        if (!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("packageLocal") : list.hasModifierProperty("packageLocal")) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiDeclarationStatement) {
                PsiFormatUtil.append(buffer, JavaPsiBundle.message("local.class.preposition", new Object[0]));
            } else {
                PsiFormatUtil.appendModifier(buffer, "packageLocal");
            }
        }
        if (!(!(!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("static") : list.hasModifierProperty("static")) || BitUtil.isSet(options, 16384) && element instanceof PsiClass && ((PsiClass)element).isEnum())) {
            PsiFormatUtil.appendModifier(buffer, "static");
        }
        boolean bl = isInterface = element instanceof PsiClass && ((PsiClass)element).isInterface();
        if (!isInterface && (!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("abstract") : list.hasModifierProperty("abstract"))) {
            PsiFormatUtil.appendModifier(buffer, "abstract");
        }
        if (!(!(!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("final") : list.hasModifierProperty("final")) || BitUtil.isSet(options, 16384) && element instanceof PsiClass && ((PsiClass)element).isEnum())) {
            PsiFormatUtil.appendModifier(buffer, "final");
        }
        if (list.hasModifierProperty("native") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "native");
        }
        if (list.hasModifierProperty("synchronized") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "synchronized");
        }
        if (list.hasModifierProperty("strictfp") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "strictfp");
        }
        if (list.hasModifierProperty("transient") && element instanceof PsiVariable) {
            PsiFormatUtil.appendModifier(buffer, "transient");
        }
        if (list.hasModifierProperty("volatile")) {
            PsiFormatUtil.appendModifier(buffer, "volatile");
        }
    }

    private static void appendModifier(StringBuilder buffer, @PsiModifier.ModifierConstant @NotNull String modifier) {
        if (modifier == null) {
            PsiFormatUtil.$$$reportNull$$$0(14);
        }
        PsiFormatUtil.append(buffer, VisibilityUtil.toPresentableText(modifier));
    }

    private static void append(StringBuilder buffer, String modifier) {
        PsiFormatUtil.appendSpaceIfNeeded(buffer);
        buffer.append(modifier);
    }

    private static String formatReferenceList(PsiReferenceList list, int options) {
        StringJoiner buffer = new StringJoiner(", ");
        if (BitUtil.isSet(options, 65536)) {
            PsiClassType[] types2;
            for (PsiClassType type2 : types2 = list.getReferencedTypes()) {
                buffer.add(PsiFormatUtil.formatType(type2, options, PsiSubstitutor.EMPTY));
            }
        } else {
            PsiJavaCodeReferenceElement[] refs;
            for (PsiJavaCodeReferenceElement ref : refs = list.getReferenceElements()) {
                buffer.add(PsiFormatUtil.formatReference(ref, options));
            }
        }
        return buffer.toString();
    }

    public static String formatType(@Nullable PsiType type2, int options, @NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(15);
        }
        type2 = substitutor2.substitute(type2);
        if (BitUtil.isSet(options, 65536)) {
            type2 = TypeConversionUtil.erasure(type2);
        } else if (BitUtil.isSet(options, 131072) && !(PsiUtil.resolveClassInType(type2) instanceof PsiTypeParameter)) {
            boolean preserveEllipsis = type2 instanceof PsiEllipsisType;
            type2 = TypeConversionUtil.erasure(type2);
            if (preserveEllipsis && type2 instanceof PsiArrayType) {
                type2 = new PsiEllipsisType(((PsiArrayType)type2).getComponentType());
            }
        }
        if (type2 == null) {
            return "null";
        }
        return !BitUtil.isSet(options, 8192) ? type2.getPresentableText(false) : (!BitUtil.isSet(options, 262144) ? type2.getCanonicalText(false) : type2.getInternalCanonicalText());
    }

    public static String formatReference(PsiJavaCodeReferenceElement ref, int options) {
        return BitUtil.isSet(options, 8192) ? ref.getCanonicalText() : ref.getText();
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner) {
        return PsiFormatUtil.getExternalName(owner, true);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName) {
        return PsiFormatUtil.getExternalName(owner, showParamName, 7);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName, int maxParamsToShow) {
        if (owner instanceof PsiPackage) {
            return ((PsiPackage)owner).getQualifiedName();
        }
        StringBuilder builder = new StringBuilder();
        if (owner instanceof PsiClass) {
            ClassUtil.formatClassName((PsiClass)owner, builder);
            return builder.toString();
        }
        PsiClass psiClass = PsiTreeUtil.getContextOfType((PsiElement)owner, PsiClass.class, false);
        if (psiClass == null) {
            return null;
        }
        ClassUtil.formatClassName(psiClass, builder);
        if (owner instanceof PsiMethod) {
            builder.append(' ');
            int options = 10499;
            int parameterOptions = showParamName ? 8195 : 8194;
            PsiFormatUtil.formatMethod((PsiMethod)owner, PsiSubstitutor.EMPTY, options, parameterOptions, maxParamsToShow, builder);
        } else if (owner instanceof PsiField) {
            builder.append(' ').append(((PsiField)owner).getName());
        } else if (owner instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)owner).getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            builder.append(' ');
            int options = 10499;
            int parameterOptions = showParamName ? 8195 : 8194;
            PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, options, parameterOptions, maxParamsToShow, builder);
            builder.append(' ');
            if (showParamName) {
                PsiFormatUtil.formatVariable((PsiVariable)owner, 1, PsiSubstitutor.EMPTY, builder);
            } else {
                builder.append(psiMethod.getParameterList().getParameterIndex((PsiParameter)owner));
            }
        } else {
            return null;
        }
        return builder.toString();
    }

    public static String getPackageDisplayName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiFormatUtil.$$$reportNull$$$0(16);
        }
        if (psiClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)psiClass).getOwner();
            String ownerName = null;
            if (owner instanceof PsiClass) {
                ownerName = ((PsiClass)owner).getQualifiedName();
                if (ownerName == null) {
                    ownerName = owner.getName();
                }
            } else if (owner instanceof PsiMethod) {
                ownerName = owner.getName();
            }
            return ownerName == null ? "type parameter" : "type parameter of " + ownerName;
        }
        if (PsiUtil.isLocalClass(psiClass)) {
            return "local class";
        }
        String packageName2 = psiClass.getQualifiedName();
        String string2 = packageName2 = packageName2 == null || packageName2.lastIndexOf(46) <= 0 ? "" : packageName2.substring(0, packageName2.lastIndexOf(46));
        if (packageName2.isEmpty()) {
            packageName2 = "default package";
        }
        return packageName2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiFormatUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiFormatUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "formatModifiers";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatSimple";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatVariable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "formatModifiers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendModifier";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPackageDisplayName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface FormatClassOptions {
    }

    public static @interface FormatMethodOptions {
    }

    public static @interface FormatVariableOptions {
    }
}

