/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.JBIterableClassTraverser;
import com.intellij.util.ReflectionUtilRt;
import com.intellij.util.SmartList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtil {
    private static final Logger LOG;
    private static final Object unsafe;

    private ReflectionUtil() {
    }

    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(0);
        }
        ArrayList<Field> result2 = new ArrayList<Field>();
        for (Class clazz2 : JBIterableClassTraverser.classTraverser(clazz)) {
            Collections.addAll(result2, clazz2.getDeclaredFields());
        }
        ArrayList<Field> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<?> fieldType, @NotNull @NonNls String fieldName) throws NoSuchFieldException {
        Field result2;
        if (clazz == null) {
            ReflectionUtil.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(6);
        }
        if ((result2 = ReflectionUtil.findFieldInHierarchy(clazz, field -> fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType())))) != null) {
            Field field2 = result2;
            if (field2 == null) {
                ReflectionUtil.$$$reportNull$$$0(7);
            }
            return field2;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    @Nullable
    public static Field findFieldInHierarchy(@NotNull Class<?> rootClass, @NotNull Predicate<? super Field> checker) {
        if (rootClass == null) {
            ReflectionUtil.$$$reportNull$$$0(8);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(9);
        }
        for (Class<?> aClass = rootClass; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return ReflectionUtil.processInterfaces(rootClass.getInterfaces(), new HashSet(), checker);
    }

    @Nullable
    private static Field processInterfaces(Class<?> @NotNull [] interfaces, @NotNull Set<? super Class<?>> visited2, @NotNull Predicate<? super Field> checker) {
        if (visited2 == null) {
            ReflectionUtil.$$$reportNull$$$0(10);
        }
        if (checker == null) {
            ReflectionUtil.$$$reportNull$$$0(11);
        }
        if (interfaces == null) {
            ReflectionUtil.$$$reportNull$$$0(12);
        }
        for (Class<?> anInterface : interfaces) {
            if (!visited2.add(anInterface)) continue;
            for (Field field : anInterface.getDeclaredFields()) {
                if (!checker.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Field field = ReflectionUtil.processInterfaces(anInterface.getInterfaces(), visited2, checker);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    @Nullable
    public static Method getMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name2, Class<?> ... parameters) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(21);
        }
        if (name2 == null) {
            ReflectionUtil.$$$reportNull$$$0(22);
        }
        if (parameters == null) {
            ReflectionUtil.$$$reportNull$$$0(23);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getMethod(name2, parameters));
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
    }

    @Deprecated
    @Nullable
    public static Method getDeclaredMethod(@NotNull Class<?> aClass, @NonNls @NotNull String name2, Class<?> ... parameters) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(24);
        }
        if (name2 == null) {
            ReflectionUtil.$$$reportNull$$$0(25);
        }
        if (parameters == null) {
            ReflectionUtil.$$$reportNull$$$0(26);
        }
        try {
            return ReflectionUtil.makeAccessible(aClass.getDeclaredMethod(name2, parameters));
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
    }

    @Nullable
    public static Class<?> getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class<?> ... parameters) {
        if (instanceClass == null) {
            ReflectionUtil.$$$reportNull$$$0(33);
        }
        if (methodName == null) {
            ReflectionUtil.$$$reportNull$$$0(34);
        }
        if (parameters == null) {
            ReflectionUtil.$$$reportNull$$$0(35);
        }
        try {
            return instanceClass.getMethod(methodName, parameters).getDeclaringClass();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            while (instanceClass != null) {
                try {
                    return instanceClass.getDeclaredMethod(methodName, parameters).getDeclaringClass();
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    instanceClass = instanceClass.getSuperclass();
                }
            }
            return null;
        }
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(36);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(37);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            return ReflectionUtil.getFieldValue(field, object);
        }
        catch (NoSuchFieldException e2) {
            LOG.debug(e2);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class<?> objectClass, @Nullable(value="null means any type") @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            ReflectionUtil.$$$reportNull$$$0(38);
        }
        if (fieldName == null) {
            ReflectionUtil.$$$reportNull$$$0(39);
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (ReflectionUtil.isInstanceField(field)) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            return ReflectionUtil.getFieldValue(field, null);
        }
        catch (NoSuchFieldException e2) {
            LOG.debug(e2);
            return null;
        }
    }

    @Nullable
    public static <T> T getFieldValue(@NotNull Field field, @Nullable Object object) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(40);
        }
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException e2) {
            LOG.debug(e2);
            return null;
        }
    }

    public static boolean isInstanceField(@NotNull Field field) {
        if (field == null) {
            ReflectionUtil.$$$reportNull$$$0(41);
        }
        return !Modifier.isStatic(field.getModifiers());
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(46);
        }
        return ReflectionUtil.newInstance(aClass, true);
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass, boolean isKotlinDataClassesSupported) {
        T t2;
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(47);
        }
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            t2 = constructor.newInstance(new Object[0]);
        }
        catch (Exception e2) {
            T t3;
            Throwable targetException;
            if (e2 instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e2).getTargetException()) instanceof ControlFlowException && targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (isKotlinDataClassesSupported && (t3 = ReflectionUtil.createAsDataClass(aClass)) != null) {
                T t4 = t3;
                if (t4 == null) {
                    ReflectionUtil.$$$reportNull$$$0(49);
                }
                return t4;
            }
            ExceptionUtilRt.rethrowUnchecked(e2);
            throw new RuntimeException(e2);
        }
        if (t2 == null) {
            ReflectionUtil.$$$reportNull$$$0(48);
        }
        return t2;
    }

    @Nullable
    private static <T> T createAsDataClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ReflectionUtil.$$$reportNull$$$0(50);
        }
        for (Annotation annotation : aClass.getAnnotations()) {
            String name2 = annotation.annotationType().getName();
            if (!name2.equals("kotlin.Metadata") && !name2.equals("kotlin.jvm.internal.KotlinClass")) continue;
            Constructor<?>[] constructors2 = aClass.getDeclaredConstructors();
            Exception exception = null;
            SmartList defaultCtors = new SmartList();
            for (Constructor<?> constructor : constructors2) {
                try {
                    block15: {
                        Class<?>[] parameterTypes;
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (constructor.getParameterCount() == 0) {
                            return (T)constructor.newInstance(new Object[0]);
                        }
                        for (Class<?> type2 : parameterTypes = constructor.getParameterTypes()) {
                            if (!type2.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) {
                                continue;
                            }
                            break block15;
                        }
                        return (T)constructor.newInstance(new Object[parameterTypes.length]);
                    }
                    defaultCtors.add(constructor);
                }
                catch (Exception e2) {
                    exception = e2;
                }
            }
            for (Constructor constructor : defaultCtors) {
                try {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e3) {
                    exception = e3;
                }
            }
            if (exception == null) continue;
            ExceptionUtil.rethrow(exception);
        }
        return null;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t2;
        if (constructor == null) {
            ReflectionUtil.$$$reportNull$$$0(51);
        }
        if (args == null) {
            ReflectionUtil.$$$reportNull$$$0(52);
        }
        try {
            t2 = constructor.newInstance(args);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        if (t2 == null) {
            ReflectionUtil.$$$reportNull$$$0(53);
        }
        return t2;
    }

    public static Class<?> getCallerClass(int stackFrameCount) {
        Class<?> callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        int depth = stackFrameCount + 1;
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(depth);
            ++depth;
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(stackFrameCount - 1);
        }
        return callerClass;
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static Object getUnsafe() {
        Object object = unsafe;
        if (object == null) {
            ReflectionUtil.$$$reportNull$$$0(75);
        }
        return object;
    }

    public static Class<?> findCallerClass(int framesToSkip) {
        return ReflectionUtilRt.findCallerClass(framesToSkip + 1);
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            ReflectionUtil.$$$reportNull$$$0(76);
        }
        if (descendant == null) {
            ReflectionUtil.$$$reportNull$$$0(77);
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    @NotNull
    public static <T> T proxy(@NotNull Class<? extends T> superInterface, @NotNull InvocationHandler handler2) {
        if (superInterface == null) {
            ReflectionUtil.$$$reportNull$$$0(79);
        }
        if (handler2 == null) {
            ReflectionUtil.$$$reportNull$$$0(80);
        }
        T t2 = superInterface.cast(Proxy.newProxyInstance(superInterface.getClassLoader(), new Class[]{superInterface}, handler2));
        if (t2 == null) {
            ReflectionUtil.$$$reportNull$$$0(81);
        }
        return t2;
    }

    static {
        Class<?> unsafeClass;
        LOG = Logger.getInstance(ReflectionUtil.class);
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        unsafe = ReflectionUtil.getStaticFieldValue(unsafeClass, unsafeClass, "theUnsafe");
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the Unsafe class");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ReflectionUtil";
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 17: 
            case 40: 
            case 41: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 18: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 44: 
            case 46: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceClass";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 36: 
            case 38: 
            case 42: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 54: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 55: 
            case 58: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superInterface";
                break;
            }
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ReflectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssignableField";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRealMethods";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructor";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "forName";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsafe";
                break;
            }
            case 81: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "proxy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAssignableField";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFieldInHierarchy";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processInterfaces";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resetField";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredMethod";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredField";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getClassPublicMethods";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getClassDeclaredMethods";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "filterRealMethods";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDeclaringClass";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFieldValue";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFieldValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceField";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setField";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createAsDataClass";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "copyFields";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "comparePublicNonFinalFields";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldValue";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isPublic";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "forName";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyVolatileInstanceFieldOfClass";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "dumpFields";
                break;
            }
            case 79: 
            case 80: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "proxy";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 32: 
            case 45: 
            case 48: 
            case 49: 
            case 53: 
            case 68: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 81: 
            case 84: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

