/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.keyStorage;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOCancellationCallbackHolder;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.MappedFileInputStream;
import com.intellij.util.io.keyStorage.NoDataException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppendableStorageBackedByResizableMappedFile<Data>
implements AppendableObjectStorage<Data> {
    private static final ThreadLocal<MyDataIS> TLOCAL_READ_STREAMS = ThreadLocal.withInitial(() -> new MyDataIS());
    private final ResizeableMappedFile storage;
    private volatile int fileLength;
    @Nullable
    private volatile AppendMemoryBuffer appendBuffer;
    @NotNull
    private final DataExternalizer<Data> dataDescriptor;
    private static final InputStream TOMBSTONE = new InputStream(){

        @Override
        public int read() {
            throw new IllegalStateException("should not happen");
        }
    };

    public AppendableStorageBackedByResizableMappedFile(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, @NotNull DataExternalizer<Data> dataDescriptor) throws IOException {
        if (file2 == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(0);
        }
        if (dataDescriptor == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(1);
        }
        this.storage = new ResizeableMappedFile(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned);
        this.dataDescriptor = dataDescriptor;
        this.fileLength = Math.toIntExact(this.storage.length());
    }

    private void flushAppendBuffer() throws IOException {
        if (AppendMemoryBuffer.hasChanges(this.appendBuffer)) {
            int bufferPosition = this.appendBuffer.getBufferPosition();
            this.storage.put(this.fileLength, this.appendBuffer.getAppendBuffer(), 0, bufferPosition);
            this.fileLength += bufferPosition;
            this.appendBuffer = this.appendBuffer.rewind(this.fileLength);
        }
    }

    @Override
    public Data read(int valueId, boolean checkAccess) throws IOException {
        int offset = valueId;
        AppendMemoryBuffer buffer = this.appendBuffer;
        if (buffer != null && (long)offset >= (long)buffer.startingOffsetInFile) {
            AppendMemoryBuffer copyForRead = buffer.copy();
            int bufferOffset = offset - copyForRead.startingOffsetInFile;
            if (bufferOffset > copyForRead.bufferPosition) {
                throw new NoDataException("Requested address(=" + offset + ") points to un-existed data: " + this.appendBuffer);
            }
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(copyForRead.getAppendBuffer(), bufferOffset, copyForRead.getBufferPosition());
            return this.dataDescriptor.read(new DataInputStream(is));
        }
        if (offset >= this.fileLength) {
            throw new NoDataException("Requested address(=" + offset + ") points to un-existed data (file length: " + this.fileLength + ")");
        }
        MyDataIS rs = TLOCAL_READ_STREAMS.get();
        rs.setup(this.storage, offset, this.fileLength, checkAccess);
        return this.dataDescriptor.read(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAll(@NotNull AppendableObjectStorage.StorageObjectProcessor<? super Data> processor) throws IOException {
        int fileLengthLocal;
        if (processor == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(2);
        }
        this.storage.getStorageLockContext().checkReadLockNotHeld();
        this.lockWrite();
        try {
            this.force();
            fileLengthLocal = this.fileLength;
            if (fileLengthLocal == 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.unlockWrite();
        }
        IOCancellationCallbackHolder.checkCancelled();
        return this.storage.readInputStream(is -> {
            LimitedInputStream lis = new LimitedInputStream(new BufferedInputStream((InputStream)is), fileLengthLocal){

                @Override
                public int available() {
                    return this.remainingLimit();
                }
            };
            DataInputStream valuesStream = new DataInputStream(lis);
            try {
                Data value2;
                int offset;
                while (processor.process(offset = lis.getBytesRead(), (Data)(value2 = this.dataDescriptor.read(valuesStream)))) {
                }
                return false;
            }
            catch (EOFException eOFException) {
                return true;
            }
        });
    }

    @Override
    public int getCurrentLength() {
        return AppendMemoryBuffer.getBufferPosition(this.appendBuffer) + this.fileLength;
    }

    @Override
    public int append(Data value2) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.dataDescriptor.save(out, value2);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        int currentLength = this.getCurrentLength();
        if (size > 4096) {
            this.flushAppendBuffer();
            this.storage.put(currentLength, buffer, 0, size);
            this.fileLength += size;
            if (this.appendBuffer != null) {
                this.appendBuffer = this.appendBuffer.rewind(this.fileLength);
            }
        } else {
            if (size > 4096 - AppendMemoryBuffer.getBufferPosition(this.appendBuffer)) {
                this.flushAppendBuffer();
            }
            if (this.appendBuffer == null) {
                this.appendBuffer = new AppendMemoryBuffer(this.fileLength);
            }
            this.appendBuffer.append(buffer, size);
        }
        return currentLength;
    }

    @Override
    public boolean checkBytesAreTheSame(int valueId, Data value2) throws IOException {
        int offset = valueId;
        try (CheckerOutputStream comparer = this.buildOldComparerStream(offset);){
            DataOutputStream out = new DataOutputStream(comparer);
            this.dataDescriptor.save(out, value2);
            boolean bl = comparer.same;
            return bl;
        }
    }

    @Override
    public void clear() throws IOException {
        this.storage.clear();
        this.fileLength = 0;
        this.appendBuffer = null;
    }

    @Override
    public boolean isDirty() {
        return AppendMemoryBuffer.hasChanges(this.appendBuffer) || this.storage.isDirty();
    }

    @Override
    public void force() throws IOException {
        this.flushAppendBuffer();
        this.storage.force();
    }

    @Override
    public void close() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = this::force;
        throwableRunnableArray[1] = this.storage::close;
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't .close() appendable storage [" + this.storage.getPagedFileStorage().getFile() + "]"), throwableRunnableArray);
    }

    public void lockWrite() {
        this.storage.lockWrite();
    }

    public void unlockWrite() {
        this.storage.unlockWrite();
    }

    @NotNull
    private CheckerOutputStream buildOldComparerStream(final int startingOffsetInFile) throws IOException {
        final PagedFileStorage storage = this.storage.getPagedFileStorage();
        if (this.fileLength <= startingOffsetInFile) {
            return new CheckerOutputStream(){
                private int address;
                {
                    this.address = startingOffsetInFile - AppendableStorageBackedByResizableMappedFile.this.fileLength;
                }

                @Override
                public void write(int b2) {
                    if (this.same) {
                        this.same = this.address < AppendMemoryBuffer.getBufferPosition(AppendableStorageBackedByResizableMappedFile.this.appendBuffer) && AppendableStorageBackedByResizableMappedFile.this.appendBuffer.getAppendBuffer()[this.address++] == (byte)b2;
                    }
                }
            };
        }
        return new CheckerOutputStream(){
            private int offsetInFile;
            private int offsetInPage;
            private DirectBufferWrapper buffer;
            private final int pageSize;
            {
                this.offsetInFile = startingOffsetInFile;
                this.offsetInPage = storage.getOffsetInPage(startingOffsetInFile);
                this.buffer = storage.getByteBuffer(startingOffsetInFile, false);
                this.pageSize = storage.getPageSize();
            }

            @Override
            public void write(int b2) throws IOException {
                if (this.same) {
                    if (this.offsetInPage == this.pageSize) {
                        this.offsetInFile = (this.offsetInFile / this.pageSize + 1) * this.pageSize;
                        if (this.offsetInFile >= AppendableStorageBackedByResizableMappedFile.this.fileLength) {
                            this.same = false;
                            return;
                        }
                        this.buffer.unlock();
                        this.buffer = storage.getByteBuffer(this.offsetInFile, false);
                        this.offsetInPage = 0;
                    }
                    this.same = this.buffer.get(this.offsetInPage, true) == (byte)b2;
                    ++this.offsetInPage;
                }
            }

            @Override
            public void close() {
                this.buffer.unlock();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/keyStorage/AppendableStorageBackedByResizableMappedFile";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AppendMemoryBuffer {
        private final byte[] buffer;
        private int bufferPosition;
        private final int startingOffsetInFile;

        private AppendMemoryBuffer(int startingOffsetInFile) {
            this(new byte[4096], 0, startingOffsetInFile);
        }

        private AppendMemoryBuffer(byte[] buffer, int bufferPosition, int startingOffsetInFile) {
            this.buffer = buffer;
            this.startingOffsetInFile = startingOffsetInFile;
            this.bufferPosition = bufferPosition;
        }

        private synchronized byte[] getAppendBuffer() {
            return this.buffer;
        }

        private synchronized int getBufferPosition() {
            return this.bufferPosition;
        }

        public synchronized void append(byte[] buffer, int size) {
            System.arraycopy(buffer, 0, this.buffer, this.bufferPosition, size);
            this.bufferPosition += size;
        }

        @NotNull
        public synchronized AppendMemoryBuffer copy() {
            return new AppendMemoryBuffer((byte[])this.buffer.clone(), this.bufferPosition, this.startingOffsetInFile);
        }

        @NotNull
        public synchronized AppendMemoryBuffer rewind(int offsetInFile) {
            return new AppendMemoryBuffer(this.buffer, 0, offsetInFile);
        }

        public String toString() {
            return "AppendMemoryBuffer[" + this.startingOffsetInFile + ".." + (this.startingOffsetInFile + this.bufferPosition) + "]";
        }

        private static int getBufferPosition(@Nullable AppendMemoryBuffer buffer) {
            return buffer != null ? buffer.bufferPosition : 0;
        }

        private static boolean hasChanges(@Nullable AppendMemoryBuffer buffer) {
            return buffer != null && buffer.getBufferPosition() > 0;
        }
    }

    private static final class MyDataIS
    extends DataInputStream {
        private MyDataIS() {
            super(new MyBufferedIS());
        }

        void setup(ResizeableMappedFile is, long pos, long limit, boolean checkAccess) {
            ((MyBufferedIS)this.in).setup(is, pos, limit, checkAccess);
        }
    }

    private static abstract class CheckerOutputStream
    extends OutputStream {
        boolean same = true;

        private CheckerOutputStream() {
        }
    }

    private static final class MyBufferedIS
    extends BufferedInputStream {
        MyBufferedIS() {
            super(TOMBSTONE, 512);
        }

        void setup(ResizeableMappedFile in, long pos, long limit, boolean checkAccess) {
            this.pos = 0;
            this.count = 0;
            this.in = new MappedFileInputStream(in, pos, limit, checkAccess);
        }
    }
}

