/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public class Topic<L> {
    private final String myDisplayName;
    private final Class<L> myListenerClass;
    private final BroadcastDirection myBroadcastDirection;
    private final boolean myImmediateDelivery;

    public Topic(@NonNls @NotNull String name2, @NotNull Class<L> listenerClass) {
        if (name2 == null) {
            Topic.$$$reportNull$$$0(0);
        }
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(1);
        }
        this(name2, listenerClass, BroadcastDirection.TO_CHILDREN);
    }

    public Topic(@NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection) {
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(3);
        }
        if (broadcastDirection == null) {
            Topic.$$$reportNull$$$0(4);
        }
        this(listenerClass.getSimpleName(), listenerClass, broadcastDirection);
    }

    public Topic(@NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection, boolean immediateDelivery) {
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(5);
        }
        if (broadcastDirection == null) {
            Topic.$$$reportNull$$$0(6);
        }
        this.myDisplayName = listenerClass.getSimpleName();
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
        this.myImmediateDelivery = immediateDelivery;
    }

    public Topic(@NonNls @NotNull String name2, @NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection) {
        if (name2 == null) {
            Topic.$$$reportNull$$$0(7);
        }
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(8);
        }
        if (broadcastDirection == null) {
            Topic.$$$reportNull$$$0(9);
        }
        this.myDisplayName = name2;
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
        this.myImmediateDelivery = false;
    }

    @NonNls
    @NotNull
    public String getDisplayName() {
        String string2 = this.myDisplayName;
        if (string2 == null) {
            Topic.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public Class<L> getListenerClass() {
        Class<L> clazz = this.myListenerClass;
        if (clazz == null) {
            Topic.$$$reportNull$$$0(11);
        }
        return clazz;
    }

    public String toString() {
        return "Topic('" + this.myDisplayName + "'" + (this.myBroadcastDirection == BroadcastDirection.NONE ? "" : ", direction=" + (Object)((Object)this.myBroadcastDirection)) + (this.myImmediateDelivery ? ", immediateDelivery" : "") + ", listenerClass=" + this.myListenerClass + ')';
    }

    @NotNull
    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        if (displayName == null) {
            Topic.$$$reportNull$$$0(12);
        }
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(13);
        }
        return new Topic<L>(displayName, listenerClass);
    }

    @NotNull
    public BroadcastDirection getBroadcastDirection() {
        BroadcastDirection broadcastDirection = this.myBroadcastDirection;
        if (broadcastDirection == null) {
            Topic.$$$reportNull$$$0(17);
        }
        return broadcastDirection;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public boolean isImmediateDelivery() {
        return this.myImmediateDelivery;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "broadcastDirection";
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/Topic";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/Topic";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getListenerClass";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBroadcastDirection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum BroadcastDirection {
        TO_CHILDREN,
        TO_DIRECT_CHILDREN,
        NONE,
        TO_PARENT;

    }
}

