/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrFileValidator;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00120\u0010\u0006\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R;\u0010\u0006\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrValidator;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "validatorConfig", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "reportError", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "", "", "Lorg/jetbrains/kotlin/backend/common/ReportIrValidationError;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lkotlin/jvm/functions/Function4;)V", "getValidatorConfig", "()Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getReportError", "()Lkotlin/jvm/functions/Function4;", "visitElement", "", "element", "visitFile", "declaration", "visitModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "ir.backend.common"})
final class IrValidator
extends IrVisitorVoid {
    @NotNull
    private final IrValidatorConfig validatorConfig;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> reportError;

    public IrValidator(@NotNull IrValidatorConfig validatorConfig, @NotNull IrBuiltIns irBuiltIns, @NotNull Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError) {
        Intrinsics.checkNotNullParameter(validatorConfig, "validatorConfig");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(reportError, "reportError");
        this.validatorConfig = validatorConfig;
        this.irBuiltIns = irBuiltIns;
        this.reportError = reportError;
    }

    @NotNull
    public final IrValidatorConfig getValidatorConfig() {
        return this.validatorConfig;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> getReportError() {
        return this.reportError;
    }

    @NotNull
    public Void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException("IR validation must start from files, modules, or declarations");
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        CheckerContext context2 = new CheckerContext(this.irBuiltIns, this.validatorConfig.getCheckInlineFunctionUseSites(), declaration, this.reportError);
        IrFileValidator fileValidator = new IrFileValidator(this.validatorConfig, context2);
        IrVisitorsKt.acceptVoid((IrElement)declaration, fileValidator);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrVisitorsKt.acceptChildrenVoid((IrElement)declaration, this);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        CheckerContext context2 = new CheckerContext(this.irBuiltIns, this.validatorConfig.getCheckInlineFunctionUseSites(), IrUtilsKt.getFile(declaration), this.reportError);
        IrFileValidator fileValidator = new IrFileValidator(this.validatorConfig, context2);
        IrVisitorsKt.acceptVoid((IrElement)declaration, fileValidator);
    }
}

