/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.backend.common.lower.ClosureAnnotator;
import org.jetbrains.kotlin.backend.common.lower.ConstructorDelegationKind;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VisibilityPolicy;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RemapTypesKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SetDeclarationsParentVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 F2\u00020\u0001:\fFGHIJKLMNOPQBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J:\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&J\u0016\u0010.\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"JD\u0010/\u001a\u00020\u001c2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203012\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u000205012\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020701H\u0014J\u0012\u00108\u001a\b\u0012\u0004\u0012\u00020:09*\u00020'H\u0014J\u0014\u0010@\u001a\u00020A*\u00020B2\u0006\u0010C\u001a\u00020AH\u0002J\u0014\u0010D\u001a\u00020\u001c*\u00020B2\u0006\u0010E\u001a\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0018\u0010;\u001a\u00020<*\u00020=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "localNameSanitizer", "Lkotlin/Function1;", "", "visibilityPolicy", "Lorg/jetbrains/kotlin/backend/common/lower/VisibilityPolicy;", "suggestUniqueNames", "", "compatibilityModeForInlinedLocalDelegatedPropertyAccessors", "forceFieldsForInlineCaptures", "remapTypesInExtractedLocalFunctions", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/backend/common/lower/VisibilityPolicy;ZZZZ)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "getLocalNameSanitizer", "()Lkotlin/jvm/functions/Function1;", "getVisibilityPolicy", "()Lorg/jetbrains/kotlin/backend/common/lower/VisibilityPolicy;", "getSuggestUniqueNames", "()Z", "getCompatibilityModeForInlinedLocalDelegatedPropertyAccessors", "getForceFieldsForInlineCaptures", "getRemapTypesInExtractedLocalFunctions", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "classesToLower", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "closestParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "functionsToSkip", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "lowerWithoutActualChange", "postLocalDeclarationLoweringCallback", "localFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalFunctionContext;", "newParameterToOld", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "newParameterToCaptured", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getConstructorsThatCouldCaptureParamsWithoutFieldCreating", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "scopeWithCounter", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$ScopeWithCounter;", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getScopeWithCounter", "(Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;)Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$ScopeWithCounter;", "remapType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "type", "remapTypes", "body", "Companion", "ScopeWithCounter", "LocalScopeWithCounterMap", "LocalContext", "LocalContextWithClosureAsParameters", "OwnerForLoweredDeclaration", "LocalFunctionContext", "LocalClassConstructorContext", "PotentiallyUnusedField", "LocalClassContext", "LocalClassMemberContext", "LocalDeclarationsTransformer", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1158:1\n1617#2,9:1159\n1869#2:1168\n1870#2:1170\n1626#2:1171\n774#2:1172\n865#2,2:1173\n1869#2,2:1175\n1#3:1169\n384#4,7:1177\n*S KotlinDebug\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering\n*L\n105#1:1159,9\n105#1:1168\n105#1:1170\n105#1:1171\n108#1:1172\n108#1:1173,2\n109#1:1175,2\n105#1:1169\n134#1:1177,7\n*E\n"})
public class LocalDeclarationsLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoweringContext context;
    @NotNull
    private final Function1<String, String> localNameSanitizer;
    @NotNull
    private final VisibilityPolicy visibilityPolicy;
    private final boolean suggestUniqueNames;
    private final boolean compatibilityModeForInlinedLocalDelegatedPropertyAccessors;
    private final boolean forceFieldsForInlineCaptures;
    private final boolean remapTypesInExtractedLocalFunctions;
    @NotNull
    private static final IrDeclarationOriginImpl DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE = new IrDeclarationOriginImpl("FIELD_FOR_CAPTURED_VALUE", true);
    @NotNull
    private static final IrDeclarationOriginImpl DECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE = new IrDeclarationOriginImpl("FIELD_FOR_CROSSINLINE_CAPTURED_VALUE", true);

    public LocalDeclarationsLowering(@NotNull LoweringContext context2, @NotNull Function1<? super String, String> localNameSanitizer, @NotNull VisibilityPolicy visibilityPolicy, boolean suggestUniqueNames, boolean compatibilityModeForInlinedLocalDelegatedPropertyAccessors, boolean forceFieldsForInlineCaptures, boolean remapTypesInExtractedLocalFunctions) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(localNameSanitizer, "localNameSanitizer");
        Intrinsics.checkNotNullParameter(visibilityPolicy, "visibilityPolicy");
        this.context = context2;
        this.localNameSanitizer = localNameSanitizer;
        this.visibilityPolicy = visibilityPolicy;
        this.suggestUniqueNames = suggestUniqueNames;
        this.compatibilityModeForInlinedLocalDelegatedPropertyAccessors = compatibilityModeForInlinedLocalDelegatedPropertyAccessors;
        this.forceFieldsForInlineCaptures = forceFieldsForInlineCaptures;
        this.remapTypesInExtractedLocalFunctions = remapTypesInExtractedLocalFunctions;
    }

    public /* synthetic */ LocalDeclarationsLowering(LoweringContext loweringContext, Function1 function1, VisibilityPolicy visibilityPolicy, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            function1 = LocalDeclarationsLowering::_init_$lambda$0;
        }
        if ((n2 & 4) != 0) {
            visibilityPolicy = VisibilityPolicy.Companion.getDEFAULT();
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl4 = true;
        }
        this(loweringContext, function1, visibilityPolicy, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final LoweringContext getContext() {
        return this.context;
    }

    @NotNull
    public final Function1<String, String> getLocalNameSanitizer() {
        return this.localNameSanitizer;
    }

    @NotNull
    public final VisibilityPolicy getVisibilityPolicy() {
        return this.visibilityPolicy;
    }

    public final boolean getSuggestUniqueNames() {
        return this.suggestUniqueNames;
    }

    public final boolean getCompatibilityModeForInlinedLocalDelegatedPropertyAccessors() {
        return this.compatibilityModeForInlinedLocalDelegatedPropertyAccessors;
    }

    public final boolean getForceFieldsForInlineCaptures() {
        return this.forceFieldsForInlineCaptures;
    }

    public final boolean getRemapTypesInExtractedLocalFunctions() {
        return this.remapTypesInExtractedLocalFunctions;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        LowerKt.runOnFilePostfix$default(this, irFile, false, 2, null);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        new LocalDeclarationsTransformer(this, irBody, container, null, null, null, 28, null).lowerLocalDeclarations();
    }

    public final void lower(@NotNull IrElement irElement, @NotNull IrDeclaration container, @NotNull Set<? extends IrClass> classesToLower) {
        Intrinsics.checkNotNullParameter(irElement, "irElement");
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(classesToLower, "classesToLower");
        new LocalDeclarationsTransformer(this, irElement, container, null, classesToLower, null, 16, null).lowerLocalDeclarations();
    }

    public final void lower(@NotNull IrBlock irBlock, @NotNull IrDeclaration container, @NotNull IrDeclarationParent closestParent, @NotNull Set<? extends IrClass> classesToLower, @NotNull Set<? extends IrSimpleFunction> functionsToSkip) {
        Intrinsics.checkNotNullParameter(irBlock, "irBlock");
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(closestParent, "closestParent");
        Intrinsics.checkNotNullParameter(classesToLower, "classesToLower");
        Intrinsics.checkNotNullParameter(functionsToSkip, "functionsToSkip");
        new LocalDeclarationsTransformer(this, irBlock, container, closestParent, classesToLower, functionsToSkip).lowerLocalDeclarations();
    }

    /*
     * WARNING - void declaration
     */
    public final void lowerWithoutActualChange(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        Iterable iterable = this.context.getMapping().getCapturedConstructors().getKeys();
        boolean $i$f$mapNotNull = false;
        Iterator iterator2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            IrConstructor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            IrConstructor it = (IrConstructor)element$iv$iv;
            boolean bl2 = false;
            if (this.context.getMapping().getCapturedConstructors().get((IrConstructor)((IrDeclaration)it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List oldCapturedConstructors = (List)destination$iv$iv;
        new LocalDeclarationsTransformer(this, irBody, container, null, null, null, 28, null).cacheLocalConstructors();
        $this$mapNotNull$iv = oldCapturedConstructors;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrConstructor it = (IrConstructor)element$iv$iv;
            boolean bl = false;
            if (!(this.context.getMapping().getCapturedConstructors().get((IrConstructor)((IrDeclaration)it)) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructor it = (IrConstructor)element$iv;
            boolean bl = false;
            this.context.getMapping().getCapturedConstructors().set((IrConstructor)((IrDeclaration)it), null);
        }
    }

    protected void postLocalDeclarationLoweringCallback(@NotNull Map<IrFunction, LocalFunctionContext> localFunctions, @NotNull Map<IrValueParameter, ? extends IrValueParameter> newParameterToOld, @NotNull Map<IrValueParameter, ? extends IrValueSymbol> newParameterToCaptured) {
        Intrinsics.checkNotNullParameter(localFunctions, "localFunctions");
        Intrinsics.checkNotNullParameter(newParameterToOld, "newParameterToOld");
        Intrinsics.checkNotNullParameter(newParameterToCaptured, "newParameterToCaptured");
    }

    @NotNull
    protected Iterable<IrConstructor> getConstructorsThatCouldCaptureParamsWithoutFieldCreating(@NotNull IrClass $this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating) {
        Intrinsics.checkNotNullParameter($this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating, "<this>");
        return CollectionsKt.listOfNotNull(IrUtilsKt.getPrimaryConstructor($this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating));
    }

    private final ScopeWithCounter getScopeWithCounter(IrSymbolOwner $this$scopeWithCounter) {
        ScopeWithCounter scopeWithCounter;
        Map<IrSymbolOwner, ScopeWithCounter> $this$getOrPut$iv = this.context.getIr().getLocalScopeWithCounterMap$ir_backend_common().getScopeMap();
        boolean $i$f$getOrPut = false;
        ScopeWithCounter value$iv = $this$getOrPut$iv.get($this$scopeWithCounter);
        if (value$iv == null) {
            boolean bl = false;
            ScopeWithCounter answer$iv = new ScopeWithCounter($this$scopeWithCounter);
            $this$getOrPut$iv.put($this$scopeWithCounter, answer$iv);
            scopeWithCounter = answer$iv;
        } else {
            scopeWithCounter = value$iv;
        }
        return scopeWithCounter;
    }

    private final IrType remapType(LocalContext $this$remapType, IrType type2) {
        if ($this$remapType.getCapturedTypeParameterToTypeParameter().isEmpty()) {
            return type2;
        }
        return $this$remapType.getTypeRemapper().remapType(type2);
    }

    private final void remapTypes(LocalContext $this$remapTypes, IrBody body2) {
        if ($this$remapTypes.getCapturedTypeParameterToTypeParameter().isEmpty()) {
            return;
        }
        RemapTypesKt.remapTypes(body2, $this$remapTypes.getTypeRemapper());
    }

    private static final String _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it;
    }

    public static final /* synthetic */ ScopeWithCounter access$getScopeWithCounter(LocalDeclarationsLowering $this, IrSymbolOwner $receiver) {
        return $this.getScopeWithCounter($receiver);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$Companion;", "", "<init>", "()V", "DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getDECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "DECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE", "getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getDECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE() {
            return DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE;
        }

        @NotNull
        public final IrDeclarationOriginImpl getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE() {
            return DECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassConstructorContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "inInlineFunctionScope", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;Z)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getInInlineFunctionScope", "()Z", "transformedDeclaration", "getTransformedDeclaration", "setTransformedDeclaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)V", "ir.backend.common"})
    private static final class LocalClassConstructorContext
    extends LocalContextWithClosureAsParameters {
        @NotNull
        private final IrConstructor declaration;
        private final boolean inInlineFunctionScope;
        public IrConstructor transformedDeclaration;

        public LocalClassConstructorContext(@NotNull IrConstructor declaration, boolean inInlineFunctionScope) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.declaration = declaration;
            this.inInlineFunctionScope = inInlineFunctionScope;
        }

        @Override
        @NotNull
        public IrConstructor getDeclaration() {
            return this.declaration;
        }

        public final boolean getInInlineFunctionScope() {
            return this.inInlineFunctionScope;
        }

        @Override
        @NotNull
        public IrConstructor getTransformedDeclaration() {
            IrConstructor irConstructor = this.transformedDeclaration;
            if (irConstructor != null) {
                return irConstructor;
            }
            Intrinsics.throwUninitializedPropertyAccessException("transformedDeclaration");
            return null;
        }

        public void setTransformedDeclaration(@NotNull IrConstructor irConstructor) {
            Intrinsics.checkNotNullParameter(irConstructor, "<set-?>");
            this.transformedDeclaration = irConstructor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0017H\u0016J\f\u0010!\u001a\u00020\u0005*\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "inInlineFunctionScope", "", "constructorContext", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;ZLorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInInlineFunctionScope", "()Z", "getConstructorContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getClosure", "()Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "setClosure", "(Lorg/jetbrains/kotlin/backend/common/lower/Closure;)V", "capturedValueToField", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$PotentiallyUnusedField;", "getCapturedValueToField", "()Ljava/util/Map;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "isInlineDeclaration", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1158:1\n1#2:1159\n*E\n"})
    private final class LocalClassContext
    extends LocalContext {
        @NotNull
        private final IrClass declaration;
        private final boolean inInlineFunctionScope;
        @Nullable
        private final LocalContext constructorContext;
        public Closure closure;
        @NotNull
        private final Map<IrValueDeclaration, PotentiallyUnusedField> capturedValueToField;

        public LocalClassContext(IrClass declaration, @Nullable boolean inInlineFunctionScope, LocalContext constructorContext) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.declaration = declaration;
            this.inInlineFunctionScope = inInlineFunctionScope;
            this.constructorContext = constructorContext;
            this.capturedValueToField = new LinkedHashMap();
        }

        @NotNull
        public final IrClass getDeclaration() {
            return this.declaration;
        }

        public final boolean getInInlineFunctionScope() {
            return this.inInlineFunctionScope;
        }

        @Nullable
        public final LocalContext getConstructorContext() {
            return this.constructorContext;
        }

        @NotNull
        public final Closure getClosure() {
            Closure closure = this.closure;
            if (closure != null) {
                return closure;
            }
            Intrinsics.throwUninitializedPropertyAccessException("closure");
            return null;
        }

        public final void setClosure(@NotNull Closure closure) {
            Intrinsics.checkNotNullParameter(closure, "<set-?>");
            this.closure = closure;
        }

        @NotNull
        public final Map<IrValueDeclaration, PotentiallyUnusedField> getCapturedValueToField() {
            return this.capturedValueToField;
        }

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            IrExpression irExpression;
            LocalContext localContext;
            Intrinsics.checkNotNullParameter(valueDeclaration, "valueDeclaration");
            if (!(LocalDeclarationsLowering.this.getForceFieldsForInlineCaptures() && this.isInlineDeclaration(valueDeclaration) || (localContext = this.constructorContext) == null || (irExpression = localContext.irGet(startOffset, endOffset, valueDeclaration)) == null)) {
                IrExpression it = irExpression;
                boolean bl = false;
                return it;
            }
            PotentiallyUnusedField potentiallyUnusedField = this.capturedValueToField.get(valueDeclaration);
            if (potentiallyUnusedField == null) {
                return null;
            }
            PotentiallyUnusedField field = potentiallyUnusedField;
            IrValueParameter irValueParameter = this.declaration.getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter);
            IrValueParameter receiver = irValueParameter;
            return BuildersKt.IrGetFieldImpl$default(startOffset, endOffset, field.getSymbol(), valueDeclaration.getType(), BuildersKt.IrGetValueImpl$default(startOffset, endOffset, receiver.getType(), receiver.getSymbol(), null, 16, null), null, null, 96, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInlineDeclaration(IrValueDeclaration $this$isInlineDeclaration) {
            if (!($this$isInlineDeclaration instanceof IrValueParameter)) return false;
            IrDeclarationParent it = ((IrValueParameter)$this$isInlineDeclaration).getParent();
            boolean bl = false;
            if (!(it instanceof IrFunction)) return false;
            if (!((IrFunction)it).isInline()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            if (!IrInlineUtilsKt.isInlineParameter((IrValueParameter)$this$isInlineDeclaration)) return false;
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassMemberContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "member", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "classContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;)V", "getMember", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getClassContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "ir.backend.common"})
    private static final class LocalClassMemberContext
    extends LocalContext {
        @NotNull
        private final IrDeclaration member;
        @NotNull
        private final LocalClassContext classContext;

        public LocalClassMemberContext(@NotNull IrDeclaration member, @NotNull LocalClassContext classContext) {
            Intrinsics.checkNotNullParameter(member, "member");
            Intrinsics.checkNotNullParameter(classContext, "classContext");
            this.member = member;
            this.classContext = classContext;
        }

        @NotNull
        public final IrDeclaration getMember() {
            return this.member;
        }

        @NotNull
        public final LocalClassContext getClassContext() {
            return this.classContext;
        }

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter(valueDeclaration, "valueDeclaration");
            PotentiallyUnusedField potentiallyUnusedField = this.classContext.getCapturedValueToField().get(valueDeclaration);
            if (potentiallyUnusedField == null) {
                return null;
            }
            PotentiallyUnusedField field = potentiallyUnusedField;
            IrValueParameter irValueParameter = this.member instanceof IrFunction ? ((IrFunction)this.member).getDispatchReceiverParameter() : this.classContext.getDeclaration().getThisReceiver();
            if (irValueParameter == null) {
                throw new IllegalStateException(("No dispatch receiver parameter for " + RenderIrElementKt.render$default(this.member, null, 1, null)).toString());
            }
            IrValueParameter receiver = irValueParameter;
            return BuildersKt.IrGetFieldImpl$default(startOffset, endOffset, field.getSymbol(), valueDeclaration.getType(), BuildersKt.IrGetValueImpl$default(startOffset, endOffset, receiver.getType(), receiver.getSymbol(), null, 16, null), null, null, 96, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H&R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "", "<init>", "()V", "capturedTypeParameterToTypeParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "getCapturedTypeParameterToTypeParameter", "()Ljava/util/Map;", "typeRemapper", "Lorg/jetbrains/kotlin/ir/util/IrTypeParameterRemapper;", "getTypeRemapper", "()Lorg/jetbrains/kotlin/ir/util/IrTypeParameterRemapper;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "ir.backend.common"})
    public static abstract class LocalContext {
        @NotNull
        private final Map<IrTypeParameter, IrTypeParameter> capturedTypeParameterToTypeParameter = new LinkedHashMap();
        @NotNull
        private final IrTypeParameterRemapper typeRemapper = new IrTypeParameterRemapper(this.capturedTypeParameterToTypeParameter);

        @NotNull
        public final Map<IrTypeParameter, IrTypeParameter> getCapturedTypeParameterToTypeParameter() {
            return this.capturedTypeParameterToTypeParameter;
        }

        @NotNull
        public final IrTypeParameterRemapper getTypeRemapper() {
            return this.typeRemapper;
        }

        @Nullable
        public abstract IrExpression irGet(int var1, int var2, @NotNull IrValueDeclaration var3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "<init>", "()V", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "transformedDeclaration", "getTransformedDeclaration", "capturedValueToParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "getCapturedValueToParameter", "()Ljava/util/Map;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "ir.backend.common"})
    public static abstract class LocalContextWithClosureAsParameters
    extends LocalContext {
        @NotNull
        private final Map<IrValueDeclaration, IrValueParameter> capturedValueToParameter = new LinkedHashMap();

        @NotNull
        public abstract IrFunction getDeclaration();

        @NotNull
        public abstract IrFunction getTransformedDeclaration();

        @NotNull
        public final Map<IrValueDeclaration, IrValueParameter> getCapturedValueToParameter() {
            return this.capturedValueToParameter;
        }

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter(valueDeclaration, "valueDeclaration");
            IrValueParameter irValueParameter = this.capturedValueToParameter.get(valueDeclaration);
            if (irValueParameter == null) {
                return null;
            }
            IrValueParameter parameter = irValueParameter;
            return BuildersKt.IrGetValueImpl$default(startOffset, endOffset, parameter.getType(), parameter.getSymbol(), null, 16, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001~BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u000205J\b\u00107\u001a\u000205H\u0002J\u001a\u00108\u001a\u0002052\u0006\u00109\u001a\u00020\u00032\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u001c\u0010<\u001a\u0002052\u0006\u0010=\u001a\u00020\n2\n\u0010>\u001a\u00060\u001fR\u00020 H\u0002J\b\u0010?\u001a\u000205H\u0002J\u0018\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\fH\u0002J\u0018\u0010@\u001a\u00020E2\u0006\u0010B\u001a\u00020F2\u0006\u0010D\u001a\u00020#H\u0002J\u0018\u0010G\u001a\u000205*\u0006\u0012\u0002\b\u00030H2\u0006\u0010I\u001a\u00020\u001aH\u0002J\b\u0010J\u001a\u000205H\u0002J\u0010\u0010K\u001a\u0002052\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002J\u0018\u0010R\u001a\u00020S2\u0006\u0010P\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u0007H\u0002J\u0010\u0010U\u001a\u0002052\u0006\u0010V\u001a\u00020\u001bH\u0002JH\u0010W\u001a\u0012\u0012\u0004\u0012\u00020-0Xj\b\u0012\u0004\u0012\u00020-`Y2\f\u0010Z\u001a\b\u0012\u0004\u0012\u0002020[2\u0006\u0010V\u001a\u00020;2\u0006\u0010\\\u001a\u00020\u001a2\u0006\u0010]\u001a\u00020\u001a2\b\b\u0002\u0010^\u001a\u00020_H\u0002J\u0014\u0010`\u001a\u000205*\u00020\u001a2\u0006\u0010:\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u0002052\u0006\u0010c\u001a\u00020$H\u0002J\u001a\u0010d\u001a\b\u0012\u0004\u0012\u00020e0[2\n\u0010>\u001a\u00060\u001fR\u00020 H\u0002J9\u0010f\u001a\u000205\"\u0004\b\u0000\u0010g\"\u0004\b\u0001\u0010h*\u000e\u0012\u0004\u0012\u0002Hg\u0012\u0004\u0012\u0002Hh0\u00192\u0006\u0010i\u001a\u0002Hg2\u0006\u0010j\u001a\u0002HhH\u0002\u00a2\u0006\u0002\u0010kJ(\u0010l\u001a\u00020S2\u0006\u0010P\u001a\u00020m2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020O0o2\b\b\u0002\u0010^\u001a\u00020_H\u0002J3\u0010p\u001a\u00020S2\u0006\u0010q\u001a\u00020O2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020O0o2\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00020t\u0012\u0004\u0012\u00020O0sH\u0082\bJ\f\u0010u\u001a\u00020_*\u00020-H\u0002J\f\u0010v\u001a\u00020_*\u00020-H\u0002J\f\u0010x\u001a\u00020_*\u00020-H\u0002J\b\u0010|\u001a\u000205H\u0002J\b\u0010}\u001a\u000205H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u001fR\u00020 0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u001d\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001dR\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00050\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001dR\u0017\u0010)\u001a\u0004\u0018\u00010\u001a*\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001d\u0010,\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001dR\u001d\u0010/\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001dR\u001d\u00101\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u0002020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001dR\u000e\u0010w\u001a\u00020OX\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010y\u001a\u00020O*\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bz\u0010{\u00a8\u0006\u007f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer;", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "closestParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "classesToLower", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "functionsToSkip", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Ljava/util/Set;Ljava/util/Set;)V", "getIrElement", "()Lorg/jetbrains/kotlin/ir/IrElement;", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getClosestParent", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "getClassesToLower", "()Ljava/util/Set;", "getFunctionsToSkip", "localFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalFunctionContext;", "getLocalFunctions", "()Ljava/util/Map;", "localClasses", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "getLocalClasses", "localClassConstructors", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassConstructorContext;", "getLocalClassConstructors", "transformedDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getTransformedDeclarations", "transformed", "getTransformed", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "newParameterToOld", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "getNewParameterToOld", "oldParameterToNew", "getOldParameterToNew", "newParameterToCaptured", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getNewParameterToCaptured", "cacheLocalConstructors", "", "lowerLocalDeclarations", "insertLoweredDeclarationForLocalFunctions", "rewriteFunctionBody", "irDeclaration", "localContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "rewriteClassMembers", "irClass", "localClassContext", "rewriteDeclarations", "createNewCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "oldCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "newCallee", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstructorCallImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "setLocalTypeArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "callee", "transformDeclarations", "cleanUpLocalFunctionsForUnboundSymbols", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "suggestLocalName", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "generateNameForLiftedDeclaration", "Lorg/jetbrains/kotlin/name/Name;", "newOwner", "createLiftedDeclaration", "localFunctionContext", "createTransformedValueParameters", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "capturedValues", "", "oldDeclaration", "newDeclaration", "isExplicitLocalFunction", "", "recordTransformedValueParameters", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "createTransformedConstructorDeclaration", "constructorContext", "createFieldsForCapturedValues", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "putAbsentOrSame", "K", "V", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "suggestNameForCapturedValue", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "usedNames", "", "findFirstUnusedName", "initialName", "nextName", "Lkotlin/Function1;", "", "isDispatchReceiver", "isExtensionReceiver", "CAPTURED_RECEIVER_PREFIX", "isCapturedReceiver", "parentNameSuffixForExtensionReceiver", "getParentNameSuffixForExtensionReceiver", "(Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;)Ljava/lang/String;", "collectClosureForLocalDeclarations", "collectLocalDeclarations", "FunctionBodiesRewriter", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 8 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,1158:1\n988#1,5:1294\n988#1,5:1299\n988#1,5:1304\n988#1,5:1309\n988#1,5:1314\n1869#2,2:1159\n1869#2:1161\n1870#2:1163\n808#2,11:1164\n1869#2,2:1202\n1869#2:1204\n808#2,11:1205\n1869#2,2:1216\n1870#2:1218\n1869#2,2:1219\n1869#2,2:1221\n1869#2:1223\n1267#2,4:1224\n1870#2:1228\n1869#2,2:1229\n669#2,11:1231\n1869#2:1246\n1634#2,3:1248\n1870#2:1251\n1634#2,2:1252\n1636#2:1258\n1634#2,3:1259\n1869#2,2:1262\n1869#2,2:1264\n1869#2,2:1266\n1869#2,2:1268\n1#3:1162\n1#3:1199\n1#3:1284\n996#4:1175\n1025#4,3:1176\n1028#4,3:1186\n384#5,7:1179\n384#5,7:1287\n136#6,9:1189\n216#6:1198\n217#6:1200\n145#6:1201\n136#6,9:1274\n216#6:1283\n217#6:1285\n145#6:1286\n216#6,2:1319\n216#6,2:1321\n238#7,4:1242\n332#7,4:1254\n284#7,4:1270\n16#8:1247\n*S KotlinDebug\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer\n*L\n954#1:1294,5\n959#1:1299,5\n964#1:1304,5\n977#1:1309,5\n981#1:1314,5\n288#1:1159,2\n309#1:1161\n309#1:1163\n580#1:1164,11\n625#1:1202,2\n629#1:1204\n635#1:1205,11\n636#1:1216,2\n629#1:1218\n639#1:1219,2\n679#1:1221,2\n687#1:1223\n689#1:1224,4\n687#1:1228\n694#1:1229,2\n707#1:1231,11\n782#1:1246\n783#1:1248,3\n782#1:1251\n820#1:1252,2\n820#1:1258\n837#1:1259,3\n850#1:1262,2\n857#1:1264,2\n876#1:1266,2\n879#1:1268,2\n610#1:1199\n920#1:1284\n589#1:1175\n589#1:1176,3\n589#1:1186,3\n589#1:1179,7\n944#1:1287,7\n610#1:1189,9\n610#1:1198\n610#1:1200\n610#1:1201\n920#1:1274,9\n920#1:1283\n920#1:1285\n920#1:1286\n1032#1:1319,2\n1036#1:1321,2\n764#1:1242,4\n822#1:1254,4\n886#1:1270,4\n783#1:1247\n*E\n"})
    private final class LocalDeclarationsTransformer {
        @NotNull
        private final IrElement irElement;
        @NotNull
        private final IrDeclaration container;
        @Nullable
        private final IrDeclarationParent closestParent;
        @Nullable
        private final Set<IrClass> classesToLower;
        @Nullable
        private final Set<IrSimpleFunction> functionsToSkip;
        @NotNull
        private final Map<IrFunction, LocalFunctionContext> localFunctions;
        @NotNull
        private final Map<IrClass, LocalClassContext> localClasses;
        @NotNull
        private final Map<IrConstructor, LocalClassConstructorContext> localClassConstructors;
        @NotNull
        private final Map<IrSymbolOwner, IrDeclaration> transformedDeclarations;
        @NotNull
        private final Map<IrValueParameter, IrValueParameter> newParameterToOld;
        @NotNull
        private final Map<IrValueParameter, IrValueParameter> oldParameterToNew;
        @NotNull
        private final Map<IrValueParameter, IrValueSymbol> newParameterToCaptured;
        @NotNull
        private final String CAPTURED_RECEIVER_PREFIX;
        final /* synthetic */ LocalDeclarationsLowering this$0;

        public LocalDeclarationsTransformer(@NotNull LocalDeclarationsLowering this$0, @NotNull IrElement irElement, @Nullable IrDeclaration container, @Nullable IrDeclarationParent closestParent, @Nullable Set<? extends IrClass> classesToLower, Set<? extends IrSimpleFunction> functionsToSkip) {
            Intrinsics.checkNotNullParameter(irElement, "irElement");
            Intrinsics.checkNotNullParameter(container, "container");
            this.this$0 = this$0;
            this.irElement = irElement;
            this.container = container;
            this.closestParent = closestParent;
            this.classesToLower = classesToLower;
            this.functionsToSkip = functionsToSkip;
            this.localFunctions = new LinkedHashMap();
            this.localClasses = new LinkedHashMap();
            this.localClassConstructors = new LinkedHashMap();
            this.transformedDeclarations = new LinkedHashMap();
            this.newParameterToOld = new LinkedHashMap();
            this.oldParameterToNew = new LinkedHashMap();
            this.newParameterToCaptured = new LinkedHashMap();
            this.CAPTURED_RECEIVER_PREFIX = "$this$";
        }

        public /* synthetic */ LocalDeclarationsTransformer(LocalDeclarationsLowering localDeclarationsLowering, IrElement irElement, IrDeclaration irDeclaration2, IrDeclarationParent irDeclarationParent, Set set, Set set2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                irDeclarationParent = null;
            }
            if ((n2 & 8) != 0) {
                set = null;
            }
            if ((n2 & 0x10) != 0) {
                set2 = null;
            }
            this(localDeclarationsLowering, irElement, irDeclaration2, irDeclarationParent, set, set2);
        }

        @NotNull
        public final IrElement getIrElement() {
            return this.irElement;
        }

        @NotNull
        public final IrDeclaration getContainer() {
            return this.container;
        }

        @Nullable
        public final IrDeclarationParent getClosestParent() {
            return this.closestParent;
        }

        @Nullable
        public final Set<IrClass> getClassesToLower() {
            return this.classesToLower;
        }

        @Nullable
        public final Set<IrSimpleFunction> getFunctionsToSkip() {
            return this.functionsToSkip;
        }

        @NotNull
        public final Map<IrFunction, LocalFunctionContext> getLocalFunctions() {
            return this.localFunctions;
        }

        @NotNull
        public final Map<IrClass, LocalClassContext> getLocalClasses() {
            return this.localClasses;
        }

        @NotNull
        public final Map<IrConstructor, LocalClassConstructorContext> getLocalClassConstructors() {
            return this.localClassConstructors;
        }

        @NotNull
        public final Map<IrSymbolOwner, IrDeclaration> getTransformedDeclarations() {
            return this.transformedDeclarations;
        }

        @Nullable
        public final IrFunction getTransformed(@NotNull IrFunction $this$transformed) {
            Intrinsics.checkNotNullParameter($this$transformed, "<this>");
            return (IrFunction)this.transformedDeclarations.get($this$transformed);
        }

        @NotNull
        public final Map<IrValueParameter, IrValueParameter> getNewParameterToOld() {
            return this.newParameterToOld;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueParameter> getOldParameterToNew() {
            return this.oldParameterToNew;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueSymbol> getNewParameterToCaptured() {
            return this.newParameterToCaptured;
        }

        public final void cacheLocalConstructors() {
            this.collectLocalDeclarations();
            this.collectClosureForLocalDeclarations();
            Iterable $this$forEach$iv = this.localClassConstructors.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LocalClassConstructorContext it = (LocalClassConstructorContext)element$iv;
                boolean bl = false;
                this.createTransformedConstructorDeclaration(it);
            }
        }

        public final void lowerLocalDeclarations() {
            this.collectLocalDeclarations();
            if (this.localFunctions.isEmpty() && this.localClasses.isEmpty()) {
                return;
            }
            this.collectClosureForLocalDeclarations();
            this.transformDeclarations();
            this.rewriteDeclarations();
            this.insertLoweredDeclarationForLocalFunctions();
            this.this$0.postLocalDeclarationLoweringCallback(this.localFunctions, this.newParameterToOld, this.newParameterToCaptured);
        }

        /*
         * WARNING - void declaration
         */
        private final void insertLoweredDeclarationForLocalFunctions() {
            void $this$forEach$iv;
            Iterable iterable = this.localFunctions.values();
            LocalDeclarationsLowering localDeclarationsLowering = this.this$0;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrSimpleFunction irSimpleFunction;
                LocalFunctionContext localContext = (LocalFunctionContext)element$iv;
                boolean bl = false;
                IrSimpleFunction $this$insertLoweredDeclarationForLocalFunctions_u24lambda_u243_u24lambda_u242 = irSimpleFunction = localContext.getTransformedDeclaration();
                boolean bl2 = false;
                IrSimpleFunction original = localContext.getDeclaration();
                $this$insertLoweredDeclarationForLocalFunctions_u24lambda_u243_u24lambda_u242.setBody(original.getBody());
                if (localDeclarationsLowering.getRemapTypesInExtractedLocalFunctions()) {
                    if ($this$insertLoweredDeclarationForLocalFunctions_u24lambda_u243_u24lambda_u242.getBody() != null) {
                        IrBody it;
                        boolean bl3 = false;
                        localDeclarationsLowering.remapTypes(localContext, it);
                    }
                }
                for (IrValueParameter argument : original.getValueParameters()) {
                    IrExpressionBody body2;
                    if (argument.getDefaultValue() == null) continue;
                    if (localDeclarationsLowering.getRemapTypesInExtractedLocalFunctions()) {
                        localDeclarationsLowering.remapTypes(localContext, body2);
                    }
                    IrValueParameter irValueParameter = this.oldParameterToNew.get(argument);
                    Intrinsics.checkNotNull(irValueParameter);
                    irValueParameter.setDefaultValue(body2);
                }
                $this$insertLoweredDeclarationForLocalFunctions_u24lambda_u243_u24lambda_u242.acceptChildren(SetDeclarationsParentVisitor.INSTANCE, $this$insertLoweredDeclarationForLocalFunctions_u24lambda_u243_u24lambda_u242);
                localContext.getOwnerForLoweredDeclaration().addChild(localContext.getTransformedDeclaration());
            }
        }

        private final void rewriteFunctionBody(IrElement irDeclaration2, LocalContext localContext) {
            IrElementTransformerVoidKt.transformChildrenVoid(irDeclaration2, new FunctionBodiesRewriter(localContext));
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteClassMembers(IrClass irClass, LocalClassContext localClassContext) {
            List<LocalClassConstructorContext> constructorsCallingSuper;
            LocalClassConstructorContext it;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            LocalDeclarationsLowering $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
            boolean $i$f$filterIsInstance232 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo232 = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof IrConstructor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List constructors2 = (List)destination$iv$iv;
            IrElementTransformerVoidKt.transformChildrenVoid(irClass, new FunctionBodiesRewriter(localClassContext));
            Sequence<LocalClassConstructorContext> $i$f$filterIsInstance232 = SequencesKt.map(CollectionsKt.asSequence(constructors2), arg_0 -> LocalDeclarationsTransformer.rewriteClassMembers$lambda$4(this, arg_0));
            $this$filterIsInstanceTo$iv$iv = this.this$0;
            boolean $i$f$groupBy = false;
            void $i$f$filterIsInstanceTo232 = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo22 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (LocalClassConstructorContext)element$iv$iv;
                boolean bl = false;
                ConstructorDelegationKind key$iv$iv = LowerUtilsKt.delegationKind(it.getDeclaration(), $this$filterIsInstanceTo$iv$iv.getContext().getIrBuiltIns());
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map constructorsByDelegationKinds = destination$iv$iv2;
            List<LocalClassConstructorContext> list = (List<LocalClassConstructorContext>)constructorsByDelegationKinds.get((Object)ConstructorDelegationKind.CALLS_SUPER);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            boolean bl = $this$filterIsInstanceTo$iv$iv = !((Collection)(constructorsCallingSuper = list)).isEmpty() || constructorsByDelegationKinds.get((Object)ConstructorDelegationKind.PARTIAL_LINKAGE_ERROR) != null;
            if (_Assertions.ENABLED && !$this$filterIsInstanceTo$iv$iv) {
                boolean bl3 = false;
                String string2 = "Expected at least one constructor calling super; class: " + irClass;
                throw new AssertionError((Object)string2);
            }
            List<IrField> usedCaptureFields = this.createFieldsForCapturedValues(localClassContext);
            CollectionsKt.addAll((Collection)irClass.getDeclarations(), (Iterable)usedCaptureFields);
            Collection collection = MappingsKt.getCapturedFields(irClass);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            MappingsKt.setCapturedFields(irClass, CollectionsKt.plus(collection, (Iterable)usedCaptureFields));
            for (LocalClassConstructorContext constructorContext : constructorsCallingSuper) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                IrBlockBody blockBody;
                Object object = constructorContext.getDeclaration().getBody();
                if ((object instanceof IrBlockBody ? (IrBlockBody)object : null) == null) {
                    throw new AssertionError((Object)("Unexpected constructor body: " + constructorContext.getDeclaration().getBody()));
                }
                blockBody = blockBody;
                Map<IrValueDeclaration, PotentiallyUnusedField> $i$f$groupByTo22 = localClassContext.getCapturedValueToField();
                object = this.this$0;
                int n2 = 0;
                List<IrStatement> list2 = blockBody.getStatements();
                boolean $i$f$mapNotNull = false;
                it = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    IrSetFieldImpl irSetFieldImpl;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl4 = false;
                    Map.Entry entry = element$iv$iv;
                    boolean bl5 = false;
                    IrValueDeclaration capturedValue = (IrValueDeclaration)entry.getKey();
                    PotentiallyUnusedField field = (PotentiallyUnusedField)entry.getValue();
                    if (field.getSymbolIfUsed() == null) {
                        irSetFieldImpl = null;
                    } else {
                        IrFieldSymbol symbol;
                        IrValueParameter irValueParameter = irClass.getThisReceiver();
                        Intrinsics.checkNotNull(irValueParameter);
                        IrExpression irExpression = BuildersKt.IrGetValueImpl$default(-1, -1, irValueParameter.getSymbol(), null, 8, null);
                        IrExpression irExpression2 = constructorContext.irGet(-1, -1, capturedValue);
                        Intrinsics.checkNotNull(irExpression2);
                        irSetFieldImpl = BuildersKt.IrSetFieldImpl$default(-1, -1, symbol, irExpression, irExpression2, ((LocalDeclarationsLowering)object).getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getSTATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE(), null, 128, null);
                    }
                    if (irSetFieldImpl == null) continue;
                    IrSetFieldImpl it$iv$iv = irSetFieldImpl;
                    boolean bl6 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                List list3 = (List)destination$iv$iv3;
                list2.addAll(n2, list3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteDeclarations() {
            LocalContext it;
            Iterable $this$forEach$iv = this.localFunctions.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalFunctionContext)element$iv;
                boolean bl = false;
                this.rewriteFunctionBody(((LocalFunctionContext)it).getDeclaration(), it);
            }
            $this$forEach$iv = this.localClassConstructors.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                LocalClassConstructorContext constructorContext = (LocalClassConstructorContext)element$iv;
                boolean bl = false;
                this.rewriteFunctionBody(constructorContext.getDeclaration(), constructorContext);
                if (!constructorContext.getDeclaration().isPrimary()) continue;
                Iterable iterable = AdditionalIrUtilsKt.getConstructedClass(constructorContext.getDeclaration()).getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterator iterator2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    IrAnonymousInitializer it2 = (IrAnonymousInitializer)element$iv2;
                    boolean bl2 = false;
                    this.rewriteFunctionBody(it2, constructorContext);
                }
            }
            $this$forEach$iv = this.localClasses.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalClassContext)element$iv;
                boolean bl = false;
                this.rewriteClassMembers(((LocalClassContext)it).getDeclaration(), (LocalClassContext)it);
            }
            this.rewriteFunctionBody(this.irElement, null);
        }

        private final IrCallImpl createNewCall(IrCall oldCall, IrSimpleFunction newCallee) {
            IrCallImpl irCallImpl;
            IrCallImpl it = irCallImpl = BuildersKt.IrCallImpl(oldCall.getStartOffset(), oldCall.getEndOffset(), oldCall.getType(), newCallee.getSymbol(), newCallee.getTypeParameters().size(), oldCall.getOrigin(), oldCall.getSuperQualifierSymbol());
            boolean bl = false;
            this.setLocalTypeArguments(it, (IrFunction)oldCall.getSymbol().getOwner());
            IrExpressionsKt.copyTypeArgumentsFrom(it, oldCall, newCallee.getTypeParameters().size() - oldCall.getTypeArguments().size());
            return irCallImpl;
        }

        private final IrConstructorCallImpl createNewCall(IrConstructorCall oldCall, IrConstructor newCallee) {
            IrConstructorCallImpl irConstructorCallImpl;
            IrConstructorCallImpl it = irConstructorCallImpl = BuildersKt.fromSymbolOwner(IrConstructorCallImpl.Companion, oldCall.getStartOffset(), oldCall.getEndOffset(), oldCall.getType(), newCallee.getSymbol(), IrUtilsKt.getParentAsClass(newCallee).getTypeParameters().size(), oldCall.getOrigin());
            boolean bl = false;
            IrExpressionsKt.copyTypeArgumentsFrom$default(it, oldCall, 0, 2, null);
            return irConstructorCallImpl;
        }

        private final void setLocalTypeArguments(IrMemberAccessExpression<?> $this$setLocalTypeArguments, IrFunction callee) {
            LocalFunctionContext localFunctionContext = this.localFunctions.get(callee);
            if (localFunctionContext == null) {
                return;
            }
            LocalFunctionContext context2 = localFunctionContext;
            for (Map.Entry<IrTypeParameter, IrTypeParameter> entry : context2.getCapturedTypeParameterToTypeParameter().entrySet()) {
                IrTypeParameter outerTypeParameter = entry.getKey();
                IrTypeParameter innerTypeParameter = entry.getValue();
                $this$setLocalTypeArguments.getTypeArguments().set(innerTypeParameter.getIndex(), IrTypesKt.getDefaultType(outerTypeParameter));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void transformDeclarations() {
            LocalContextWithClosureAsParameters it;
            Iterable $this$forEach$iv = this.localFunctions.values();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalFunctionContext)element$iv;
                boolean bl = false;
                this.createLiftedDeclaration((LocalFunctionContext)it);
            }
            IrFile irFile = IrUtilsKt.getFileOrNull(this.container);
            if (irFile != null) {
                IrFile it2 = irFile;
                boolean bl = false;
                this.cleanUpLocalFunctionsForUnboundSymbols(it2);
            }
            $this$forEach$iv = this.localClasses.values();
            LocalDeclarationsLowering $i$f$forEach22 = this.this$0;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$associateTo$iv;
                LocalClassContext it3 = (LocalClassContext)element$iv;
                boolean bl = false;
                it3.getDeclaration().setVisibility($i$f$forEach22.getVisibilityPolicy().forClass(it3.getDeclaration(), it3.getInInlineFunctionScope()));
                Iterable iterable = it3.getClosure().getCapturedValues();
                Map<IrValueDeclaration, PotentiallyUnusedField> destination$iv = it3.getCapturedValueToField();
                boolean $i$f$associateTo = false;
                for (Object element$iv2 : $this$associateTo$iv) {
                    Map<IrValueDeclaration, PotentiallyUnusedField> map = destination$iv;
                    IrValueSymbol capturedValue = (IrValueSymbol)element$iv2;
                    boolean bl2 = false;
                    Pair<IrValueDeclaration, PotentiallyUnusedField> pair = TuplesKt.to(capturedValue.getOwner(), new PotentiallyUnusedField());
                    map.put(pair.getFirst(), pair.getSecond());
                }
            }
            $this$forEach$iv = this.localClassConstructors.values();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalClassConstructorContext)element$iv;
                boolean bl = false;
                this.createTransformedConstructorDeclaration((LocalClassConstructorContext)it);
            }
        }

        private final void cleanUpLocalFunctionsForUnboundSymbols(IrFile irFile) {
            Object v0;
            block3: {
                Iterable $this$singleOrNull$iv = irFile.getDeclarations();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof IrClass && IrUtilsKt.isFacadeClass((IrDeclarationParent)((Object)it)))) continue;
                    if (found$iv) {
                        v0 = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            Object var3_10 = v0;
            IrClass irClass = var3_10 instanceof IrClass ? (IrClass)var3_10 : null;
            if (irClass == null) {
                return;
            }
            IrClass fileClass = irClass;
            CollectionsKt.removeAll(fileClass.getDeclarations(), LocalDeclarationsTransformer::cleanUpLocalFunctionsForUnboundSymbols$lambda$20);
        }

        private final String suggestLocalName(IrDeclarationWithName declaration) {
            Function1<String, String> function1 = this.this$0.getLocalNameSanitizer();
            String string2 = declaration.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String declarationName = function1.invoke(string2);
            LocalFunctionContext localFunctionContext = this.localFunctions.get(declaration);
            if (localFunctionContext != null) {
                String baseName;
                LocalFunctionContext localFunctionContext2 = localFunctionContext;
                LocalDeclarationsLowering localDeclarationsLowering = this.this$0;
                LocalFunctionContext it = localFunctionContext2;
                boolean bl = false;
                String string3 = baseName = declaration.getName().isSpecial() ? "lambda" : declarationName;
                if (it.getIndex() >= 0) {
                    if (!localDeclarationsLowering.getSuggestUniqueNames()) {
                        return baseName;
                    }
                    String separator = localDeclarationsLowering.getCompatibilityModeForInlinedLocalDelegatedPropertyAccessors() && Intrinsics.areEqual(declaration.getOrigin(), IrDeclarationOrigin.Companion.getDELEGATED_PROPERTY_ACCESSOR()) && this.container instanceof IrFunction && ((IrFunction)this.container).isInline() ? "-" : "$";
                    return baseName + separator + it.getIndex();
                }
            }
            return declarationName;
        }

        private final Name generateNameForLiftedDeclaration(IrDeclaration declaration, IrDeclarationParent newOwner) {
            Name name2;
            List parents2 = CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.takeWhile(IrUtilsKt.getParentsWithSelf(declaration), arg_0 -> LocalDeclarationsTransformer.generateNameForLiftedDeclaration$lambda$22(newOwner, arg_0))));
            String nameFromParents = CollectionsKt.joinToString$default(parents2, "$", null, null, 0, null, arg_0 -> LocalDeclarationsTransformer.generateNameForLiftedDeclaration$lambda$23(this, arg_0), 30, null);
            if (parents2.size() == 1 && declaration.getParent() instanceof IrClass) {
                Name name3 = Name.identifier("_init_$" + nameFromParents);
                name2 = name3;
                Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
            } else {
                Name name4 = Name.identifier(nameFromParents);
                name2 = name4;
                Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
            }
            return name2;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLiftedDeclaration(LocalFunctionContext localFunctionContext) {
            IrDeclarationBase irDeclarationBase;
            IrDeclarationBase tp;
            void $this$forEach$iv;
            DescriptorVisibility descriptorVisibility;
            IrSimpleFunction oldDeclaration = localFunctionContext.getDeclaration();
            if (oldDeclaration.getDispatchReceiverParameter() != null) {
                throw new AssertionError((Object)"local functions must not have dispatch receiver");
            }
            OwnerForLoweredDeclaration owner = localFunctionContext.getOwnerForLoweredDeclaration();
            IrDeclarationParent ownerParent = owner.closestDeclarationParent();
            Name newName = this.generateNameForLiftedDeclaration(oldDeclaration, ownerParent);
            Closure closure = localFunctionContext.getClosure();
            List<IrValueSymbol> capturedValues = closure.component1();
            List<IrTypeParameter> capturedTypeParameters = closure.component2();
            IrFactory $this$buildFun$iv = this.this$0.getContext().getIrFactory();
            boolean $i$f$buildFun22 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean bl = false;
            Object $this$createLiftedDeclaration_u24lambda_u2424 = $this$buildFun_u24lambda_u2420$iv;
            boolean bl2 = false;
            ((IrFunctionBuilder)$this$createLiftedDeclaration_u24lambda_u2424).updateFrom(oldDeclaration);
            ((IrDeclarationBuilder)$this$createLiftedDeclaration_u24lambda_u2424).setName(newName);
            if (owner.isLocal()) {
                DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.LOCAL;
                descriptorVisibility = descriptorVisibility2;
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "LOCAL");
            } else {
                DescriptorVisibility descriptorVisibility3 = DescriptorVisibilities.PRIVATE;
                descriptorVisibility = descriptorVisibility3;
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility3, "PRIVATE");
            }
            ((IrDeclarationBuilder)$this$createLiftedDeclaration_u24lambda_u2424).setVisibility(descriptorVisibility);
            ((IrFunctionBuilder)$this$createLiftedDeclaration_u24lambda_u2424).setModality(Modality.FINAL);
            IrSimpleFunction newDeclaration = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
            localFunctionContext.setTransformedDeclaration(newDeclaration);
            List newTypeParameters = IrUtilsKt.copyTypeParameters$default(newDeclaration, capturedTypeParameters, null, null, 6, null);
            MapsKt.putAll(localFunctionContext.getCapturedTypeParameterToTypeParameter(), CollectionsKt.zip((Iterable)capturedTypeParameters, newTypeParameters));
            IrUtilsKt.copyTypeParametersFrom$default(newDeclaration, oldDeclaration, null, localFunctionContext.getCapturedTypeParameterToTypeParameter(), 2, null);
            MapsKt.putAll(localFunctionContext.getCapturedTypeParameterToTypeParameter(), CollectionsKt.zip((Iterable)oldDeclaration.getTypeParameters(), CollectionsKt.drop((Iterable)newDeclaration.getTypeParameters(), newTypeParameters.size())));
            Iterable $i$f$buildFun22 = CollectionsKt.drop((Iterable)newDeclaration.getTypeParameters(), newTypeParameters.size());
            Map<IrValueParameter, IrValueParameter> map = this.this$0;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                void $this$memoryOptimizedMap$iv;
                tp = (IrTypeParameter)element$iv;
                boolean bl3 = false;
                Collection collection = tp.getSuperTypes();
                IrTypeParameter irTypeParameter = tp;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrType irType = (IrType)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    collection2.add(((LocalDeclarationsLowering)((Object)map)).remapType(localFunctionContext, (IrType)it));
                }
                irTypeParameter.setSuperTypes(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv));
            }
            newDeclaration.setParent(ownerParent);
            newDeclaration.setReturnType(this.this$0.remapType(localFunctionContext, oldDeclaration.getReturnType()));
            newDeclaration.setDispatchReceiverParameter(null);
            IrSimpleFunction irSimpleFunction = newDeclaration;
            IrValueParameter irValueParameter = oldDeclaration.getExtensionReceiverParameter();
            if (irValueParameter != null) {
                void $this$createLiftedDeclaration_u24lambda_u2428;
                map = irValueParameter;
                LocalDeclarationsLowering $i$f$forEach2 = this.this$0;
                $this$createLiftedDeclaration_u24lambda_u2424 = map;
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                boolean bl5 = false;
                IrDeclarationBase it = tp = IrUtilsKt.copyTo$default((IrValueParameter)$this$createLiftedDeclaration_u24lambda_u2428, newDeclaration, null, 0, 0, null, null, $i$f$forEach2.remapType(localFunctionContext, $this$createLiftedDeclaration_u24lambda_u2428.getType()), null, null, false, false, false, null, 8126, null);
                boolean bl6 = false;
                this.putAbsentOrSame(this.newParameterToOld, it, $this$createLiftedDeclaration_u24lambda_u2428);
                irDeclarationBase = tp;
                irSimpleFunction = irSimpleFunction2;
            } else {
                irDeclarationBase = null;
            }
            irSimpleFunction.setExtensionReceiverParameter((IrValueParameter)irDeclarationBase);
            IrDeclarationsKt.copyAttributes(newDeclaration, (IrElement)oldDeclaration);
            newDeclaration.setValueParameters(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(newDeclaration.getValueParameters(), (List)this.createTransformedValueParameters(capturedValues, localFunctionContext, oldDeclaration, newDeclaration, Intrinsics.areEqual(oldDeclaration.getOrigin(), IrDeclarationOrigin.Companion.getLOCAL_FUNCTION()))));
            this.recordTransformedValueParameters(newDeclaration, localFunctionContext);
            Map<IrValueParameter, IrValueParameter> $this$createLiftedDeclaration_u24lambda_u2430 = map = MapsKt.createMapBuilder();
            boolean bl7 = false;
            IrValueParameter irValueParameter2 = oldDeclaration.getExtensionReceiverParameter();
            if (irValueParameter2 != null) {
                IrValueParameter it = irValueParameter2;
                boolean bl8 = false;
                IrValueParameter irValueParameter3 = newDeclaration.getExtensionReceiverParameter();
                Intrinsics.checkNotNull(irValueParameter3);
                $this$createLiftedDeclaration_u24lambda_u2430.put(it, irValueParameter3);
            }
            MapsKt.putAll($this$createLiftedDeclaration_u24lambda_u2430, CollectionsKt.zip((Iterable)oldDeclaration.getValueParameters(), (Iterable)CollectionsKt.takeLast(newDeclaration.getValueParameters(), oldDeclaration.getValueParameters().size())));
            Map parametersMapping = MapsKt.build(map);
            this.this$0.getContext().remapMultiFieldValueClassStructure(oldDeclaration, newDeclaration, parametersMapping);
            newDeclaration.setAnnotations(oldDeclaration.getAnnotations());
            this.transformedDeclarations.put(oldDeclaration, newDeclaration);
        }

        /*
         * WARNING - void declaration
         */
        private final ArrayList<IrValueParameter> createTransformedValueParameters(List<? extends IrValueSymbol> capturedValues, LocalContext localFunctionContext, IrFunction oldDeclaration, IrFunction newDeclaration, boolean isExplicitLocalFunction) {
            IrAnnotationContainer irAnnotationContainer;
            IrValueParameter capturedValue;
            Collection collection;
            ArrayList<IrValueParameter> arrayList = new ArrayList<IrValueParameter>(capturedValues.size() + oldDeclaration.getValueParameters().size());
            LocalDeclarationsLowering localDeclarationsLowering = this.this$0;
            ArrayList<IrValueParameter> $this$createTransformedValueParameters_u24lambda_u2437 = arrayList;
            boolean bl = false;
            Set generatedNames = new LinkedHashSet();
            Iterable $this$mapTo$iv = capturedValues;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                IrValueSymbol irValueSymbol = (IrValueSymbol)item$iv;
                collection = $this$createTransformedValueParameters_u24lambda_u2437;
                boolean bl2 = false;
                IrValueDeclaration p2 = capturedValue.getOwner();
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
                boolean bl3 = false;
                IrValueParameterBuilder $this$createTransformedValueParameters_u24lambda_u2437_u24lambda_u2433_u24lambda_u2431 = $this$buildValueParameter_u24lambda_u2430$iv;
                boolean bl4 = false;
                $this$createTransformedValueParameters_u24lambda_u2437_u24lambda_u2433_u24lambda_u2431.setStartOffset(p2.getStartOffset());
                $this$createTransformedValueParameters_u24lambda_u2437_u24lambda_u2433_u24lambda_u2431.setEndOffset(p2.getEndOffset());
                $this$createTransformedValueParameters_u24lambda_u2437_u24lambda_u2433_u24lambda_u2431.setOrigin(p2 instanceof IrValueParameter && ((IrValueParameter)p2).getIndexInOldValueParameters() < 0 && newDeclaration instanceof IrConstructor ? (IrDeclarationOrigin)LocalDeclarationsLoweringKt.getBOUND_RECEIVER_PARAMETER() : (IrDeclarationOrigin)LocalDeclarationsLoweringKt.getBOUND_VALUE_PARAMETER());
                $this$createTransformedValueParameters_u24lambda_u2437_u24lambda_u2433_u24lambda_u2431.setName(this.suggestNameForCapturedValue(p2, generatedNames, isExplicitLocalFunction));
                $this$createTransformedValueParameters_u24lambda_u2437_u24lambda_u2433_u24lambda_u2431.setType(localDeclarationsLowering.remapType(localFunctionContext, p2.getType()));
                Object object = capturedValue instanceof IrValueParameterSymbol ? (IrValueParameterSymbol)((Object)capturedValue) : null;
                $this$createTransformedValueParameters_u24lambda_u2437_u24lambda_u2433_u24lambda_u2431.setCrossInline(object != null && (object = (IrValueParameter)object.getOwner()) != null ? ((IrValueParameter)object).isCrossinline() : false);
                Object object2 = capturedValue instanceof IrValueParameterSymbol ? (IrValueParameterSymbol)((Object)capturedValue) : null;
                $this$createTransformedValueParameters_u24lambda_u2437_u24lambda_u2433_u24lambda_u2431.setNoinline(object2 != null && (object2 = (IrValueParameter)object2.getOwner()) != null ? ((IrValueParameter)object2).isNoinline() : false);
                IrAnnotationContainer it = irAnnotationContainer = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)newDeclaration).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)newDeclaration)));
                boolean bl5 = false;
                this.newParameterToCaptured.put((IrValueParameter)it, (IrValueSymbol)((Object)capturedValue));
                collection.add(irAnnotationContainer);
            }
            $this$mapTo$iv = oldDeclaration.getValueParameters();
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                IrValueParameter irValueParameter;
                IrType irType;
                void v2;
                capturedValue = (IrValueParameter)item$iv;
                collection = $this$createTransformedValueParameters_u24lambda_u2437;
                boolean bl6 = false;
                void v22 = v2;
                IrFunction irFunction = newDeclaration;
                IrDeclarationOrigin irDeclarationOrigin = null;
                int n2 = 0;
                int n3 = 0;
                Name name2 = null;
                Map map = null;
                IrType irType2 = localDeclarationsLowering.remapType(localFunctionContext, v2.getType());
                if (v2.getVarargElementType() != null) {
                    void it;
                    irAnnotationContainer = irType2;
                    Map map2 = map;
                    Name name3 = name2;
                    int n4 = n3;
                    int n5 = n2;
                    IrDeclarationOrigin irDeclarationOrigin2 = irDeclarationOrigin;
                    IrFunction irFunction2 = irFunction;
                    void var26_32 = v22;
                    boolean bl7 = false;
                    IrType irType3 = localDeclarationsLowering.remapType(localFunctionContext, (IrType)it);
                    v22 = var26_32;
                    irFunction = irFunction2;
                    irDeclarationOrigin = irDeclarationOrigin2;
                    n2 = n5;
                    n3 = n4;
                    name2 = name3;
                    map = map2;
                    irType2 = irAnnotationContainer;
                    irType = irType3;
                } else {
                    irType = null;
                }
                IrValueParameter it = irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)v22, irFunction, irDeclarationOrigin, n2, n3, name2, map, irType2, irType, null, false, false, false, null, 7998, null);
                boolean bl8 = false;
                this.putAbsentOrSame(this.newParameterToOld, it, v2);
                collection.add(irValueParameter);
            }
            return arrayList;
        }

        static /* synthetic */ ArrayList createTransformedValueParameters$default(LocalDeclarationsTransformer localDeclarationsTransformer, List list, LocalContext localContext, IrFunction irFunction, IrFunction irFunction2, boolean bl, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                bl = false;
            }
            return localDeclarationsTransformer.createTransformedValueParameters(list, localContext, irFunction, irFunction2, bl);
        }

        private final void recordTransformedValueParameters(IrFunction $this$recordTransformedValueParameters, LocalContextWithClosureAsParameters localContext) {
            IrValueParameter it;
            Object element$iv;
            Object $this$forEach$iv = (IrValueParameter[])$this$recordTransformedValueParameters.getValueParameters();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (IrValueParameter)element$iv;
                boolean bl = false;
                IrValueSymbol capturedValue = this.newParameterToCaptured.get(it);
                if (capturedValue == null) continue;
                localContext.getCapturedValueToParameter().put(capturedValue.getOwner(), it);
            }
            $this$forEach$iv = new IrValueParameter[]{$this$recordTransformedValueParameters.getDispatchReceiverParameter(), $this$recordTransformedValueParameters.getExtensionReceiverParameter()};
            $this$forEach$iv = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull($this$forEach$iv), (Iterable)$this$recordTransformedValueParameters.getValueParameters());
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it = (IrValueParameter)element$iv;
                boolean bl = false;
                IrValueParameter oldParameter = this.newParameterToOld.get(it);
                if (oldParameter == null) continue;
                this.putAbsentOrSame(this.oldParameterToNew, oldParameter, it);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void createTransformedConstructorDeclaration(LocalClassConstructorContext constructorContext) {
            void $this$buildConstructor$iv;
            IrConstructor oldDeclaration = constructorContext.getDeclaration();
            LocalClassContext localClassContext = this.localClasses.get(oldDeclaration.getParent());
            Intrinsics.checkNotNull(localClassContext);
            LocalClassContext localClassContext2 = localClassContext;
            List<IrValueSymbol> capturedValues = localClassContext2.getClosure().getCapturedValues();
            IrConstructor irConstructor = this.this$0.getContext().getMapping().getCapturedConstructors().get((IrConstructor)((IrDeclaration)oldDeclaration));
            if (irConstructor != null) {
                Pair pair;
                IrConstructor newDeclaration = irConstructor;
                boolean bl = false;
                this.transformedDeclarations.put(oldDeclaration, newDeclaration);
                constructorContext.setTransformedDeclaration(newDeclaration);
                Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)newDeclaration.getValueParameters(), (Iterable)capturedValues);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    pair = (Pair)element$iv;
                    boolean bl2 = false;
                    IrValueParameter it = (IrValueParameter)pair.component1();
                    IrValueSymbol capturedValue = (IrValueSymbol)pair.component2();
                    this.newParameterToCaptured.put(it, capturedValue);
                }
                $this$forEach$iv = CollectionsKt.zip((Iterable)oldDeclaration.getValueParameters(), (Iterable)newDeclaration.getValueParameters());
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    pair = (Pair)element$iv;
                    boolean bl3 = false;
                    IrValueParameter v2 = (IrValueParameter)pair.component1();
                    IrValueParameter it = (IrValueParameter)pair.component2();
                    this.putAbsentOrSame(this.newParameterToOld, it, v2);
                }
                this.recordTransformedValueParameters(newDeclaration, constructorContext);
                return;
            }
            Object object = this.this$0.getContext().getIrFactory();
            LocalDeclarationsLowering localDeclarationsLowering = this.this$0;
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$createTransformedConstructorDeclaration_u24lambda_u2443 = $this$buildConstructor_u24lambda_u2424$iv;
            boolean bl4 = false;
            $this$createTransformedConstructorDeclaration_u24lambda_u2443.updateFrom(oldDeclaration);
            $this$createTransformedConstructorDeclaration_u24lambda_u2443.setVisibility(localDeclarationsLowering.getVisibilityPolicy().forConstructor(oldDeclaration, constructorContext.getInInlineFunctionScope()));
            $this$createTransformedConstructorDeclaration_u24lambda_u2443.setReturnType(oldDeclaration.getReturnType());
            IrConstructor newDeclaration = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2424$iv);
            constructorContext.setTransformedDeclaration(newDeclaration);
            newDeclaration.setParent(localClassContext2.getDeclaration());
            IrUtilsKt.copyTypeParametersFrom$default(newDeclaration, oldDeclaration, null, null, 6, null);
            object = oldDeclaration.getDispatchReceiverParameter();
            if (object != null) {
                Object $this$createTransformedConstructorDeclaration_u24lambda_u2444 = object;
                boolean bl5 = false;
                throw new AssertionError((Object)("Local class constructor can't have dispatch receiver: " + IrUtilsKt.ir2string(oldDeclaration)));
            }
            object = oldDeclaration.getExtensionReceiverParameter();
            if (object != null) {
                Object $this$createTransformedConstructorDeclaration_u24lambda_u2445 = object;
                boolean bl6 = false;
                throw new AssertionError((Object)("Local class constructor can't have extension receiver: " + IrUtilsKt.ir2string(oldDeclaration)));
            }
            newDeclaration.setValueParameters(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(newDeclaration.getValueParameters(), (List)LocalDeclarationsTransformer.createTransformedValueParameters$default(this, capturedValues, localClassContext2, oldDeclaration, newDeclaration, false, 16, null)));
            this.recordTransformedValueParameters(newDeclaration, constructorContext);
            newDeclaration.setAnnotations(oldDeclaration.getAnnotations());
            newDeclaration.setMetadata(oldDeclaration.getMetadata());
            this.transformedDeclarations.put(oldDeclaration, newDeclaration);
            this.this$0.getContext().getMapping().getCapturedConstructors().set((IrConstructor)((IrDeclaration)oldDeclaration), newDeclaration);
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrField> createFieldsForCapturedValues(LocalClassContext localClassContext) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            IrClass classDeclaration = localClassContext.getDeclaration();
            Set generatedNames = new LinkedHashSet();
            Map<IrValueDeclaration, PotentiallyUnusedField> map = localClassContext.getCapturedValueToField();
            LocalDeclarationsLowering localDeclarationsLowering = this.this$0;
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                IrField irField;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry entry = element$iv$iv;
                boolean bl2 = false;
                IrValueDeclaration capturedValue = (IrValueDeclaration)entry.getKey();
                PotentiallyUnusedField field = (PotentiallyUnusedField)entry.getValue();
                if (field.getSymbolIfUsed() == null) {
                    irField = null;
                } else {
                    IrFieldSymbol symbol;
                    IrField irField2;
                    IrDeclarationOriginImpl origin = capturedValue instanceof IrValueParameter && ((IrValueParameter)capturedValue).isCrossinline() ? Companion.getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE() : Companion.getDECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE();
                    IrField it = irField2 = localDeclarationsLowering.getContext().getIrFactory().createField(classDeclaration.getStartOffset(), classDeclaration.getEndOffset(), origin, LocalDeclarationsTransformer.suggestNameForCapturedValue$default(this, capturedValue, generatedNames, false, 4, null), localDeclarationsLowering.getVisibilityPolicy().forCapturedField(capturedValue.getSymbol()), symbol, capturedValue.getType(), true, false, false);
                    boolean bl3 = false;
                    it.setParent(classDeclaration);
                    irField = irField2;
                }
                if (irField == null) continue;
                IrField it$iv$iv = irField;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final <K, V> void putAbsentOrSame(Map<K, V> $this$putAbsentOrSame, K key, V value2) {
            V current;
            V v2;
            Map<K, V> $this$getOrPut$iv = $this$putAbsentOrSame;
            boolean $i$f$getOrPut = false;
            V value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                V answer$iv = value2;
                $this$getOrPut$iv.put(key, answer$iv);
                v2 = answer$iv;
            } else {
                v2 = value$iv;
            }
            if (!Intrinsics.areEqual(current = v2, value2)) {
                throw new IllegalStateException((current + " != " + value2).toString());
            }
        }

        private final Name suggestNameForCapturedValue(IrValueDeclaration declaration, Set<String> usedNames, boolean isExplicitLocalFunction) {
            Name name2;
            if (declaration instanceof IrValueParameter) {
                if (Intrinsics.areEqual(declaration.getName().asString(), "<this>") && this.isDispatchReceiver((IrValueParameter)declaration)) {
                    LocalDeclarationsTransformer localDeclarationsTransformer = this;
                    String initialName$iv = "this$0";
                    boolean $i$f$findFirstUnusedName = false;
                    String chosen$iv = initialName$iv;
                    int suffix$iv = 0;
                    while (!usedNames.add(chosen$iv)) {
                        int it = ++suffix$iv;
                        boolean bl = false;
                        chosen$iv = "this$" + it;
                    }
                    Name name3 = Name.identifier(chosen$iv);
                    Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
                    return name3;
                }
                if (Intrinsics.areEqual(declaration.getName().asString(), "<this>") && this.isExtensionReceiver((IrValueParameter)declaration)) {
                    String parentNameSuffix = this.getParentNameSuffixForExtensionReceiver((IrValueParameter)declaration);
                    LocalDeclarationsTransformer initialName$iv = this;
                    String initialName$iv2 = "$this_" + parentNameSuffix;
                    boolean $i$f$findFirstUnusedName = false;
                    String chosen$iv = initialName$iv2;
                    int suffix$iv = 0;
                    while (!usedNames.add(chosen$iv)) {
                        int it = ++suffix$iv;
                        boolean bl = false;
                        chosen$iv = "$this_" + parentNameSuffix + '$' + it;
                    }
                    Name name4 = Name.identifier(chosen$iv);
                    Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
                    return name4;
                }
                if (this.isCapturedReceiver((IrValueParameter)declaration)) {
                    String string2 = declaration.getName().asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                    String baseName = StringsKt.removePrefix(string2, (CharSequence)this.CAPTURED_RECEIVER_PREFIX);
                    LocalDeclarationsTransformer this_$iv = this;
                    String initialName$iv = "$this_" + baseName;
                    boolean $i$f$findFirstUnusedName = false;
                    String chosen$iv = initialName$iv;
                    int suffix$iv = 0;
                    while (!usedNames.add(chosen$iv)) {
                        int it = ++suffix$iv;
                        boolean bl = false;
                        chosen$iv = "$this_" + baseName + '$' + it;
                    }
                    Name name5 = Name.identifier(chosen$iv);
                    Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
                    return name5;
                }
            }
            Object this_$iv = declaration.getName().isSpecial() ? declaration.getName().asStringStripSpecialMarkers() : declaration.getName().asString();
            Intrinsics.checkNotNull(this_$iv);
            String base = this_$iv;
            if (isExplicitLocalFunction && declaration instanceof IrVariable) {
                this_$iv = this;
                boolean $i$f$findFirstUnusedName = false;
                String chosen$iv = base;
                int suffix$iv = 0;
                while (!usedNames.add(chosen$iv)) {
                    int it = ++suffix$iv;
                    boolean bl = false;
                    chosen$iv = base + '$' + it;
                }
                Name name6 = Name.identifier(chosen$iv);
                name2 = name6;
                Intrinsics.checkNotNullExpressionValue(name6, "identifier(...)");
            } else {
                this_$iv = this;
                String initialName$iv = DescriptorUtilsKt.getSynthesizedString(base);
                boolean $i$f$findFirstUnusedName = false;
                String chosen$iv = initialName$iv;
                int suffix$iv = 0;
                while (!usedNames.add(chosen$iv)) {
                    int it = ++suffix$iv;
                    boolean bl = false;
                    chosen$iv = DescriptorUtilsKt.getSynthesizedString(base + '$' + it);
                }
                Name name7 = Name.identifier(chosen$iv);
                name2 = name7;
                Intrinsics.checkNotNullExpressionValue(name7, "identifier(...)");
            }
            return name2;
        }

        static /* synthetic */ Name suggestNameForCapturedValue$default(LocalDeclarationsTransformer localDeclarationsTransformer, IrValueDeclaration irValueDeclaration, Set set, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return localDeclarationsTransformer.suggestNameForCapturedValue(irValueDeclaration, set, bl);
        }

        private final boolean isDispatchReceiver(IrValueParameter $this$isDispatchReceiver) {
            IrDeclarationParent parent2 = $this$isDispatchReceiver.getParent();
            return parent2 instanceof IrFunction ? Intrinsics.areEqual(((IrFunction)parent2).getDispatchReceiverParameter(), $this$isDispatchReceiver) : (parent2 instanceof IrClass ? Intrinsics.areEqual(((IrClass)parent2).getThisReceiver(), $this$isDispatchReceiver) : false);
        }

        private final boolean isExtensionReceiver(IrValueParameter $this$isExtensionReceiver) {
            IrDeclarationParent irDeclarationParent = $this$isExtensionReceiver.getParent();
            IrFunction irFunction = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
            if (irFunction == null) {
                return false;
            }
            IrFunction parentFun = irFunction;
            return Intrinsics.areEqual(parentFun.getExtensionReceiverParameter(), $this$isExtensionReceiver);
        }

        private final boolean isCapturedReceiver(IrValueParameter $this$isCapturedReceiver) {
            String string2 = $this$isCapturedReceiver.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            return StringsKt.startsWith$default(string2, this.CAPTURED_RECEIVER_PREFIX, false, 2, null);
        }

        private final String getParentNameSuffixForExtensionReceiver(IrValueParameter $this$parentNameSuffixForExtensionReceiver) {
            String string2;
            IrDeclarationParent irDeclarationParent = $this$parentNameSuffixForExtensionReceiver.getParent();
            IrSimpleFunction irSimpleFunction = irDeclarationParent instanceof IrSimpleFunction ? (IrSimpleFunction)irDeclarationParent : null;
            if (irSimpleFunction == null) {
                throw new AssertionError((Object)("Extension receiver parent is not a simple function: " + RenderIrElementKt.render$default($this$parentNameSuffixForExtensionReceiver.getParent(), null, 1, null)));
            }
            IrSimpleFunction parentFun = irSimpleFunction;
            IrPropertySymbol irPropertySymbol = parentFun.getCorrespondingPropertySymbol();
            IrProperty correspondingProperty = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (correspondingProperty != null) {
                String string3 = correspondingProperty.getName().asStringStripSpecialMarkers();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "asStringStripSpecialMarkers(...)");
            } else {
                String string4 = parentFun.getName().asStringStripSpecialMarkers();
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "asStringStripSpecialMarkers(...)");
            }
            return string2;
        }

        private final void collectClosureForLocalDeclarations() {
            LocalContext context2;
            IrDeclarationBase declaration;
            Map.Entry<IrFunction, LocalFunctionContext> entry;
            Map.Entry<IrDeclarationBase, LocalContext> element$iv;
            ClosureAnnotator annotator = new ClosureAnnotator(this.irElement, this.container);
            Map<IrDeclarationBase, LocalContext> $this$forEach$iv = this.localFunctions;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<IrDeclarationBase, LocalContext>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = element$iv = iterator2.next();
                boolean bl = false;
                declaration = entry.getKey();
                context2 = entry.getValue();
                ((LocalFunctionContext)context2).setClosure(annotator.getFunctionClosure((IrFunction)declaration));
            }
            $this$forEach$iv = this.localClasses;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = element$iv = iterator2.next();
                boolean bl = false;
                declaration = (IrClass)((Object)entry.getKey());
                context2 = (LocalClassContext)((Object)entry.getValue());
                ((LocalClassContext)context2).setClosure(annotator.getClassClosure((IrClass)declaration));
            }
        }

        private final void collectLocalDeclarations() {
            IrDeclarationParent currentParent;
            IrPackageFragment enclosingPackageFragment = IrUtilsKt.getPackageFragment(this.container);
            LocalDeclarationsTransformer $this$collectLocalDeclarations_u24lambda_u2456 = this;
            boolean bl = false;
            IrDeclaration irDeclaration2 = $this$collectLocalDeclarations_u24lambda_u2456.container;
            IrClass irClass = irDeclaration2 instanceof IrClass ? (IrClass)irDeclaration2 : null;
            IrDeclarationParent irDeclarationParent = currentParent = irClass != null ? (IrDeclarationParent)irClass : $this$collectLocalDeclarations_u24lambda_u2456.container.getParent();
            while (currentParent instanceof IrDeclaration && !(currentParent instanceof IrClass)) {
                currentParent = ((IrDeclaration)((Object)currentParent)).getParent();
            }
            IrDeclarationParent irDeclarationParent2 = currentParent;
            IrClass enclosingClass = irDeclarationParent2 instanceof IrClass ? (IrClass)irDeclarationParent2 : null;
            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0011"}, d2={"org/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$collectLocalDeclarations$Data", "", "currentClass", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$ScopeWithCounter;", "isInInlineFunction", "", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$ScopeWithCounter;Z)V", "getCurrentClass", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$ScopeWithCounter;", "()Z", "withCurrentClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$collectLocalDeclarations$Data;", "withInline", "isInline", "(Z)Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$collectLocalDeclarations$Data;", "ir.backend.common"})
            public final class Data {
                private final ScopeWithCounter currentClass;
                private final boolean isInInlineFunction;

                public Data(ScopeWithCounter currentClass, boolean isInInlineFunction) {
                    this.currentClass = currentClass;
                    this.isInInlineFunction = isInInlineFunction;
                }

                public final ScopeWithCounter getCurrentClass() {
                    return this.currentClass;
                }

                public final boolean isInInlineFunction() {
                    return this.isInInlineFunction;
                }

                public final Data withCurrentClass(IrClass currentClass) {
                    Intrinsics.checkNotNullParameter(currentClass, "currentClass");
                    return new Data(new ScopeWithCounter(currentClass), this.isInInlineFunction);
                }

                public final Data withInline(boolean isInline) {
                    return isInline && !this.isInInlineFunction ? new Data(this.currentClass, true) : this;
                }
            }
            this.irElement.accept((IrElementVisitor)new IrVisitor<Unit, Data>(this, enclosingClass, this.this$0, enclosingPackageFragment){
                final /* synthetic */ LocalDeclarationsTransformer this$0;
                final /* synthetic */ IrClass $enclosingClass;
                final /* synthetic */ LocalDeclarationsLowering this$1;
                final /* synthetic */ IrPackageFragment $enclosingPackageFragment;
                {
                    this.this$0 = $receiver;
                    this.$enclosingClass = $enclosingClass;
                    this.this$1 = $receiver2;
                    this.$enclosingPackageFragment = $enclosingPackageFragment;
                }

                public void visitElement(IrElement element, Data data) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    Intrinsics.checkNotNullParameter(data, "data");
                    element.acceptChildren(this, data);
                }

                public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Data data) {
                    Intrinsics.checkNotNullParameter(inlinedBlock, "inlinedBlock");
                    Intrinsics.checkNotNullParameter(data, "data");
                    super.visitInlinedFunctionBlock(inlinedBlock, data.withInline(IrInlineUtilsKt.isFunctionInlining(inlinedBlock)));
                }

                public void visitFunctionExpression(IrFunctionExpression expression2, Data data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    Intrinsics.checkNotNullParameter(data, "data");
                    expression2.getFunction().acceptChildren(this, data);
                }

                public void visitRichFunctionReference(IrRichFunctionReference expression2, Data data) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    Intrinsics.checkNotNullParameter(data, "data");
                    Iterable $this$forEach$iv = expression2.getBoundValues();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        IrExpression it = (IrExpression)element$iv;
                        boolean bl = false;
                        it.accept(this, data);
                    }
                    expression2.getInvokeFunction().acceptChildren(this, data);
                }

                public void visitRichPropertyReference(IrRichPropertyReference expression2, Data data) {
                    block1: {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        Intrinsics.checkNotNullParameter(data, "data");
                        Iterable $this$forEach$iv = expression2.getBoundValues();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            IrExpression it = (IrExpression)element$iv;
                            boolean bl = false;
                            it.accept(this, data);
                        }
                        expression2.getGetterFunction().acceptChildren(this, data);
                        IrSimpleFunction irSimpleFunction = expression2.getSetterFunction();
                        if (irSimpleFunction == null) break block1;
                        irSimpleFunction.acceptChildren(this, data);
                    }
                }

                public void visitSimpleFunction(IrSimpleFunction declaration, Data data) {
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Intrinsics.checkNotNullParameter(data, "data");
                    Set<IrSimpleFunction> set = this.this$0.getFunctionsToSkip();
                    boolean bl = set != null ? set.contains(declaration) : false;
                    if (bl) {
                        return;
                    }
                    super.visitSimpleFunction(declaration, data.withInline(declaration.isInline()));
                    if (Intrinsics.areEqual(declaration.getVisibility(), DescriptorVisibilities.LOCAL)) {
                        OwnerForLoweredDeclaration ownerForLoweredDeclaration;
                        int n2;
                        ScopeWithCounter enclosingScope;
                        IrClass irClass;
                        ScopeWithCounter scopeWithCounter = data.getCurrentClass();
                        if (scopeWithCounter == null && (scopeWithCounter = (irClass = this.$enclosingClass) != null ? LocalDeclarationsLowering.access$getScopeWithCounter(this.this$1, irClass) : null) == null) {
                            scopeWithCounter = enclosingScope = LocalDeclarationsLowering.access$getScopeWithCounter(this.this$1, this.$enclosingPackageFragment);
                        }
                        if (declaration.getName().isSpecial() || enclosingScope.getUsedLocalFunctionNames().contains(declaration.getName())) {
                            int n3 = enclosingScope.getCounter();
                            enclosingScope.setCounter(n3 + 1);
                            n2 = n3;
                        } else {
                            n2 = -1;
                        }
                        int index = n2;
                        ScopeWithCounter scopeWithCounter2 = data.getCurrentClass();
                        if (scopeWithCounter2 != null) {
                            ScopeWithCounter it = scopeWithCounter2;
                            boolean bl2 = false;
                            IrElement irElement = it.getIrElement();
                            Intrinsics.checkNotNull(irElement, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                            ownerForLoweredDeclaration = new OwnerForLoweredDeclaration.DeclarationContainer((IrDeclarationContainer)irElement);
                        } else {
                            IrElement irElement = this.this$0.getIrElement();
                            IrBlock irBlock = irElement instanceof IrBlock ? (IrBlock)irElement : null;
                            if (irBlock != null) {
                                irElement = irBlock;
                                LocalDeclarationsTransformer localDeclarationsTransformer = this.this$0;
                                IrElement it = irElement;
                                boolean bl3 = false;
                                IrBlock irBlock2 = (IrBlock)localDeclarationsTransformer.getIrElement();
                                IrDeclarationParent irDeclarationParent = localDeclarationsTransformer.getClosestParent();
                                Intrinsics.checkNotNull(irDeclarationParent);
                                ownerForLoweredDeclaration = new OwnerForLoweredDeclaration.Block(irBlock2, irDeclarationParent);
                            } else {
                                IrElement irElement2 = enclosingScope.getIrElement();
                                Intrinsics.checkNotNull(irElement2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                                ownerForLoweredDeclaration = new OwnerForLoweredDeclaration.DeclarationContainer((IrDeclarationContainer)irElement2);
                            }
                        }
                        OwnerForLoweredDeclaration ownerForLoweredDeclaration2 = ownerForLoweredDeclaration;
                        this.this$0.getLocalFunctions().put(declaration, new LocalFunctionContext(declaration, index, ownerForLoweredDeclaration2));
                        enclosingScope.getUsedLocalFunctionNames().add(declaration.getName());
                    }
                }

                public void visitConstructor(IrConstructor declaration, Data data) {
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Intrinsics.checkNotNullParameter(data, "data");
                    super.visitConstructor(declaration, data);
                    if (!LocalDeclarationsLoweringKt.isLocalNotInner(AdditionalIrUtilsKt.getConstructedClass(declaration))) {
                        return;
                    }
                    this.this$0.getLocalClassConstructors().put(declaration, new LocalClassConstructorContext(declaration, this.getInInlineFunctionScope(data)));
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitClass(IrClass declaration, Data data) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Intrinsics.checkNotNullParameter(data, "data");
                    Set<IrClass> set = this.this$0.getClassesToLower();
                    boolean bl = set != null ? !set.contains(declaration) : false;
                    if (bl) {
                        return;
                    }
                    super.visitClass(declaration, data.withCurrentClass(declaration));
                    if (!LocalDeclarationsLoweringKt.isLocalNotInner(declaration)) {
                        return;
                    }
                    Iterable<IrConstructor> iterable = this.this$1.getConstructorsThatCouldCaptureParamsWithoutFieldCreating(declaration);
                    LocalDeclarationsTransformer localDeclarationsTransformer = this.this$0;
                    boolean $i$f$mapNotNull = false;
                    void var7_6 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        LocalClassConstructorContext it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        IrConstructor it = (IrConstructor)element$iv$iv;
                        boolean bl3 = false;
                        if (localDeclarationsTransformer.getLocalClassConstructors().get(it) == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    LocalClassConstructorContext constructorContext = (LocalClassConstructorContext)CollectionsKt.singleOrNull((List)destination$iv$iv);
                    this.this$0.getLocalClasses().put(declaration, this.this$1.new LocalClassContext(declaration, this.getInInlineFunctionScope(data), constructorContext));
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private final boolean getInInlineFunctionScope(Data $this$inInlineFunctionScope) {
                    boolean bl;
                    if ($this$inInlineFunctionScope.isInInlineFunction()) return true;
                    Sequence<IrDeclaration> $this$any$iv = SequencesKt.generateSequence(this.this$0.getContainer(), collectLocalDeclarations.1::_get_inInlineFunctionScope_$lambda$5);
                    boolean $i$f$any = false;
                    Iterator<IrDeclaration> iterator2 = $this$any$iv.iterator();
                    do {
                        IrDeclaration element$iv;
                        if (!iterator2.hasNext()) return false;
                        IrDeclaration it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (it instanceof IrFunction && ((IrFunction)it).isInline()) {
                            return true;
                        }
                        bl = false;
                    } while (!bl);
                    return true;
                }

                private static final IrDeclaration _get_inInlineFunctionScope_$lambda$5(IrDeclaration it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    IrDeclarationParent irDeclarationParent = it.getParent();
                    return irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
                }
            }, new Data(null, false));
        }

        private static final LocalClassConstructorContext rewriteClassMembers$lambda$4(LocalDeclarationsTransformer this$0, IrConstructor it) {
            Intrinsics.checkNotNullParameter(it, "it");
            LocalClassConstructorContext localClassConstructorContext = this$0.localClassConstructors.get(it);
            Intrinsics.checkNotNull(localClassConstructorContext);
            return localClassConstructorContext;
        }

        private static final boolean cleanUpLocalFunctionsForUnboundSymbols$lambda$20(IrDeclaration declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            return declaration instanceof IrFunction && Intrinsics.areEqual(declaration.getOrigin(), IrDeclarationOrigin.Companion.getFILLED_FOR_UNBOUND_SYMBOL()) && Intrinsics.areEqual(((IrFunction)declaration).getVisibility(), DescriptorVisibilities.LOCAL);
        }

        private static final boolean generateNameForLiftedDeclaration$lambda$22(IrDeclarationParent $newOwner, IrDeclarationParent it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return !Intrinsics.areEqual(it, $newOwner);
        }

        private static final CharSequence generateNameForLiftedDeclaration$lambda$23(LocalDeclarationsTransformer this$0, IrDeclarationParent it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return this$0.suggestLocalName((IrDeclarationWithName)((Object)it));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020$H\u0016JA\u0010%\u001a\u0002H&\"\f\b\u0000\u0010&*\u0006\u0012\u0002\b\u00030'*\u0002H&2\u0006\u0010(\u001a\u00020\u000f2\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020+\u0012\u0006\u0012\u0004\u0018\u00010\u001a0*H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J3\u0010-\u001a\u0002H&\"\f\b\u0000\u0010&*\u0006\u0012\u0002\b\u00030'*\u0002H&2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\t2\u0006\u0010\n\u001a\u00020;H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "localContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer;Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;)V", "getLocalContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "visitLocalDelegatedProperty", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitAnonymousInitializer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitMember", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitWithTheSingleConstructorContext", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "mapValueParameters", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "newTarget", "transform", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "fillArguments2", "oldExpression", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitRichFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRichFunctionReference;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "visitDeclarationReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "ir.backend.common"})
        @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1158:1\n462#1,5:1165\n1#2:1159\n774#3:1160\n865#3,2:1161\n1869#3,2:1163\n*S KotlinDebug\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter\n*L\n472#1:1165,5\n385#1:1160\n385#1:1161,2\n385#1:1163,2\n*E\n"})
        private final class FunctionBodiesRewriter
        extends IrElementTransformerVoid {
            @Nullable
            private final LocalContext localContext;

            public FunctionBodiesRewriter(LocalContext localContext) {
                this.localContext = localContext;
            }

            @Nullable
            public final LocalContext getLocalContext() {
                return this.localContext;
            }

            @Override
            @NotNull
            public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                return IrElementsKt.transformStatement(declaration.getDelegate(), this);
            }

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Object object = LocalDeclarationsTransformer.this.getLocalClasses().get(declaration);
                if (object != null && (object = ((LocalClassContext)object).getDeclaration()) != null) {
                    irStatement = (IrStatement)object;
                } else {
                    irStatement = this.visitMember(declaration);
                    if (irStatement == null) {
                        irStatement = super.visitClass(declaration);
                    }
                }
                return irStatement;
            }

            @Override
            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                if (LocalDeclarationsTransformer.this.getLocalFunctions().containsKey(declaration)) {
                    irStatement = BuildersKt.IrCompositeImpl$default(declaration.getStartOffset(), declaration.getEndOffset(), LocalDeclarationsTransformer.this.this$0.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
                } else {
                    irStatement = this.visitMember(declaration);
                    if (irStatement == null) {
                        irStatement = super.visitFunction(declaration);
                    }
                }
                return irStatement;
            }

            @Override
            @NotNull
            public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                IrStatement irStatement = this.visitWithTheSingleConstructorContext(declaration);
                if (irStatement == null && (irStatement = this.visitMember(declaration)) == null) {
                    irStatement = super.visitAnonymousInitializer(declaration);
                }
                return irStatement;
            }

            @Override
            @NotNull
            public IrStatement visitField(@NotNull IrField declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                IrStatement irStatement = this.visitWithTheSingleConstructorContext(declaration);
                if (irStatement == null && (irStatement = this.visitMember(declaration)) == null) {
                    irStatement = super.visitField(declaration);
                }
                return irStatement;
            }

            private final IrStatement visitMember(IrDeclaration declaration) {
                IrStatement irStatement;
                if (this.localContext instanceof LocalClassContext && Intrinsics.areEqual(declaration.getParent(), ((LocalClassContext)this.localContext).getDeclaration())) {
                    LocalClassMemberContext classMemberLocalContext = new LocalClassMemberContext(declaration, (LocalClassContext)this.localContext);
                    IrDeclaration irDeclaration2 = declaration;
                    LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                    IrDeclaration $this$visitMember_u24lambda_u240 = irDeclaration2;
                    boolean bl = false;
                    IrElementTransformerVoidKt.transformChildrenVoid($this$visitMember_u24lambda_u240, localDeclarationsTransformer.new FunctionBodiesRewriter(classMemberLocalContext));
                    irStatement = irDeclaration2;
                } else {
                    irStatement = null;
                }
                return irStatement;
            }

            private final IrStatement visitWithTheSingleConstructorContext(IrDeclaration declaration) {
                IrStatement irStatement;
                if (this.localContext instanceof LocalClassContext && Intrinsics.areEqual(declaration.getParent(), ((LocalClassContext)this.localContext).getDeclaration())) {
                    LocalContext localContext = ((LocalClassContext)this.localContext).getConstructorContext();
                    if (localContext == null) {
                        return null;
                    }
                    LocalContext constructorContext = localContext;
                    IrDeclaration irDeclaration2 = declaration;
                    LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                    IrDeclaration $this$visitWithTheSingleConstructorContext_u24lambda_u241 = irDeclaration2;
                    boolean bl = false;
                    IrElementTransformerVoidKt.transformChildrenVoid($this$visitWithTheSingleConstructorContext_u24lambda_u241, localDeclarationsTransformer.new FunctionBodiesRewriter(constructorContext));
                    irStatement = irDeclaration2;
                } else {
                    irStatement = null;
                }
                return irStatement;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                LocalClassConstructorContext localClassConstructorContext = LocalDeclarationsTransformer.this.getLocalClassConstructors().get(declaration);
                if (localClassConstructorContext == null) {
                    return super.visitConstructor(declaration);
                }
                LocalClassConstructorContext constructorContext = localClassConstructorContext;
                IrConstructor irConstructor = constructorContext.getTransformedDeclaration();
                LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                IrConstructor $this$visitConstructor_u24lambda_u244 = irConstructor;
                boolean bl = false;
                IrBody irBody = declaration.getBody();
                Intrinsics.checkNotNull(irBody);
                $this$visitConstructor_u24lambda_u244.setBody(irBody);
                Iterable $this$filter$iv = declaration.getValueParameters();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getDefaultValue() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter argument = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    IrValueParameter irValueParameter = localDeclarationsTransformer.getOldParameterToNew().get(argument);
                    Intrinsics.checkNotNull(irValueParameter);
                    irValueParameter.setDefaultValue(argument.getDefaultValue());
                }
                $this$visitConstructor_u24lambda_u244.acceptChildren(SetDeclarationsParentVisitor.INSTANCE, $this$visitConstructor_u24lambda_u244);
                return irConstructor;
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrValueDeclaration declaration = expression2.getSymbol().getOwner();
                Object object = this.localContext;
                if (object != null && (object = ((LocalContext)object).irGet(expression2.getStartOffset(), expression2.getEndOffset(), declaration)) != null) {
                    Object it = object;
                    boolean bl = false;
                    return it;
                }
                IrValueParameter irValueParameter = LocalDeclarationsTransformer.this.getOldParameterToNew().get(declaration);
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    return BuildersKt.IrGetValueImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), null, 16, null);
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrValueDeclaration declaration = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter = LocalDeclarationsTransformer.this.getOldParameterToNew().get(declaration);
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    return BuildersKt.IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getValue(), expression2.getOrigin());
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrSimpleFunction oldCallee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                IrFunction irFunction = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction == null) {
                    return expression2;
                }
                IrSimpleFunction newCallee = (IrSimpleFunction)irFunction;
                return this.fillArguments2((IrMemberAccessExpression)LocalDeclarationsTransformer.this.createNewCall(expression2, newCallee), expression2, newCallee);
            }

            @Override
            @NotNull
            public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor oldCallee = (IrConstructor)expression2.getSymbol().getOwner();
                IrFunction irFunction = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction == null) {
                    return expression2;
                }
                IrConstructor newCallee = (IrConstructor)irFunction;
                return this.fillArguments2((IrMemberAccessExpression)LocalDeclarationsTransformer.this.createNewCall(expression2, newCallee), expression2, newCallee);
            }

            @Override
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor oldCallee = (IrConstructor)expression2.getSymbol().getOwner();
                IrConstructor irConstructor = (IrConstructor)LocalDeclarationsTransformer.this.getTransformedDeclarations().get(oldCallee);
                if (irConstructor == null) {
                    return expression2;
                }
                IrConstructor newCallee = irConstructor;
                IrDelegatingConstructorCallImpl it = irDelegatingConstructorCallImpl = BuildersKt.IrDelegatingConstructorCallImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), LocalDeclarationsTransformer.this.this$0.getContext().getIrBuiltIns().getUnitType(), newCallee.getSymbol(), expression2.getTypeArguments().size(), null, 32, null);
                boolean bl = false;
                this.fillArguments2((IrMemberAccessExpression)it, expression2, newCallee);
                IrExpressionsKt.copyTypeArgumentsFrom$default(it, expression2, 0, 2, null);
                return irDelegatingConstructorCallImpl;
            }

            @NotNull
            public final <T extends IrMemberAccessExpression<?>> T mapValueParameters(@NotNull T $this$mapValueParameters, @NotNull IrFunction newTarget, @NotNull Function1<? super IrValueParameter, ? extends IrExpression> transform2) {
                T t2;
                Intrinsics.checkNotNullParameter($this$mapValueParameters, "<this>");
                Intrinsics.checkNotNullParameter(newTarget, "newTarget");
                Intrinsics.checkNotNullParameter(transform2, "transform");
                boolean $i$f$mapValueParameters = false;
                T $this$mapValueParameters_u24lambda_u249 = t2 = $this$mapValueParameters;
                boolean bl = false;
                for (IrValueParameter p2 : newTarget.getValueParameters()) {
                    $this$mapValueParameters_u24lambda_u249.putValueArgument(p2.getIndexInOldValueParameters(), transform2.invoke(p2));
                }
                return t2;
            }

            /*
             * WARNING - void declaration
             */
            private final <T extends IrMemberAccessExpression<?>> T fillArguments2(T $this$fillArguments2, IrMemberAccessExpression<?> oldExpression, IrFunction newTarget) {
                void $this$mapValueParameters$iv;
                void var8_8;
                FunctionBodiesRewriter functionBodiesRewriter = this;
                T t2 = $this$fillArguments2;
                LocalDeclarationsTransformer localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                boolean $i$f$mapValueParameters = false;
                void $this$mapValueParameters_u24lambda_u249$iv = var8_8 = $this$mapValueParameters$iv;
                boolean bl = false;
                Iterator<IrValueParameter> iterator2 = newTarget.getValueParameters().iterator();
                while (iterator2.hasNext()) {
                    Object object;
                    void newValueParameterDeclaration;
                    IrValueParameter p$iv;
                    IrValueParameter irValueParameter = p$iv = iterator2.next();
                    int n2 = p$iv.getIndexInOldValueParameters();
                    void var21_21 = $this$mapValueParameters_u24lambda_u249$iv;
                    boolean bl2 = false;
                    IrValueParameter oldParameter = localDeclarationsTransformer.getNewParameterToOld().get(newValueParameterDeclaration);
                    if (oldParameter != null) {
                        object = oldExpression.getValueArgument(oldParameter.getIndexInOldValueParameters());
                    } else {
                        IrValueSymbol capturedValueSymbol;
                        if (localDeclarationsTransformer.getNewParameterToCaptured().get(newValueParameterDeclaration) == null) {
                            throw new AssertionError((Object)("Non-mapped parameter " + newValueParameterDeclaration));
                        }
                        IrValueDeclaration capturedValue = capturedValueSymbol.getOwner();
                        object = this.localContext;
                        if (object == null || (object = ((LocalContext)object).irGet(oldExpression.getStartOffset(), oldExpression.getEndOffset(), capturedValue)) == null) {
                            T $this$fillArguments2_u24lambda_u2411_u24lambda_u2410 = $this$fillArguments2;
                            boolean bl3 = false;
                            IrValueParameter irValueParameter2 = localDeclarationsTransformer.getOldParameterToNew().get(capturedValue);
                            IrValueDeclaration value2 = irValueParameter2 != null ? (IrValueDeclaration)irValueParameter2 : capturedValue;
                            object = BuildersKt.IrGetValueImpl$default(oldExpression.getStartOffset(), oldExpression.getEndOffset(), value2.getSymbol(), null, 8, null);
                        }
                    }
                    IrExpression irExpression = object;
                    var21_21.putValueArgument(n2, irExpression);
                }
                $this$fillArguments2.setDispatchReceiver(oldExpression.getDispatchReceiver());
                $this$fillArguments2.setExtensionReceiver(oldExpression.getExtensionReceiver());
                return $this$fillArguments2;
            }

            @Override
            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrFunction irFunction;
                LocalDeclarationsTransformer localDeclarationsTransformer;
                Object object;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrFunction oldCallee = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
                IrFunction irFunction2 = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction2 == null) {
                    return expression2;
                }
                IrFunction newCallee = irFunction2;
                IrFunctionSymbol irFunctionSymbol = expression2.getReflectionTarget();
                if (irFunctionSymbol != null) {
                    object = irFunctionSymbol;
                    localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                    IrFunctionSymbol $this$visitFunctionReference_u24lambda_u2412 = object;
                    boolean bl = false;
                    irFunction = localDeclarationsTransformer.getTransformed($this$visitFunctionReference_u24lambda_u2412.getOwner());
                    if (irFunction == null) {
                        irFunction = $this$visitFunctionReference_u24lambda_u2412.getOwner();
                    }
                } else {
                    irFunction = null;
                }
                IrFunction newReflectionTarget = irFunction;
                List<IrTypeParameter> typeParameters2 = newCallee instanceof IrConstructor ? IrUtilsKt.getParentAsClass(newCallee).getTypeParameters() : newCallee.getTypeParameters();
                IrFunction irFunction3 = newReflectionTarget;
                object = BuildersKt.IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), newCallee.getSymbol(), typeParameters2.size(), irFunction3 != null ? irFunction3.getSymbol() : null, expression2.getOrigin());
                localDeclarationsTransformer = LocalDeclarationsTransformer.this;
                Object it = object;
                boolean bl = false;
                this.fillArguments2((IrMemberAccessExpression)it, expression2, newCallee);
                localDeclarationsTransformer.setLocalTypeArguments((IrMemberAccessExpression)it, oldCallee);
                IrExpressionsKt.copyTypeArgumentsFrom((IrMemberAccessExpression)it, expression2, typeParameters2.size() - expression2.getTypeArguments().size());
                IrDeclarationsKt.copyAttributes((IrElement)it, (IrElement)expression2);
                return (IrExpression)object;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            @NotNull
            public IrExpression visitRichFunctionReference(@NotNull IrRichFunctionReference expression) {
                Intrinsics.checkNotNullParameter(expression, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression, this);
                v0 = expression;
                v1 = expression.getReflectionTargetSymbol();
                if (v1 == null) ** GOTO lbl-1000
                var2_2 = v1;
                var3_3 = LocalDeclarationsTransformer.this;
                var4_4 = var2_2;
                var6_5 = v0;
                $i$a$-run-LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter$visitRichFunctionReference$1 = false;
                v2 = var3_3.getTransformed($this$visitRichFunctionReference_u24lambda_u2414.getOwner());
                if (v2 == null) {
                    v2 = $this$visitRichFunctionReference_u24lambda_u2414.getOwner();
                }
                v0 = var6_5;
                v1 = v2;
                if (v2 != null) {
                    v3 = v1.getSymbol();
                } else lbl-1000:
                // 2 sources

                {
                    v3 = null;
                }
                v0.setReflectionTargetSymbol(v3);
                return expression;
            }

            @Override
            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrReturnTarget irReturnTarget = expression2.getReturnTargetSymbol().getOwner();
                IrFunction irFunction = irReturnTarget instanceof IrFunction ? (IrFunction)irReturnTarget : null;
                if (irFunction == null) {
                    return expression2;
                }
                IrFunction oldReturnTarget = irFunction;
                IrFunction irFunction2 = LocalDeclarationsTransformer.this.getTransformed(oldReturnTarget);
                if (irFunction2 == null) {
                    return expression2;
                }
                IrFunction newReturnTarget = irFunction2;
                return new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), LocalDeclarationsTransformer.this.this$0.getContext().getIrBuiltIns().getNothingType(), newReturnTarget.getSymbol(), expression2.getValue());
            }

            @Override
            @NotNull
            public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrFunction oldFunction = expression2.getSymbol().getOwner();
                IrFunction newFunction = LocalDeclarationsTransformer.this.getTransformed(oldFunction);
                if (newFunction != null) {
                    if (!(newFunction.getValueParameters().size() == oldFunction.getValueParameters().size())) {
                        boolean bl = false;
                        String string2 = "Capturing variables is not supported for raw function references";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    expression2.setSymbol(newFunction.getSymbol());
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                if (LocalDeclarationsTransformer.this.getTransformedDeclarations().containsKey(expression2.getSymbol().getOwner())) {
                    String string2 = "Unsupported reference type " + Reflection.getOrCreateKotlinClass(expression2.getClass()) + " for local declaration";
                    throw new NotImplementedError("An operation is not implemented: " + string2);
                }
                return super.visitDeclarationReference(expression2);
            }

            @Override
            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                if (LocalDeclarationsTransformer.this.getTransformedDeclarations().containsKey(declaration)) {
                    throw new NotImplementedError(null, 1, null);
                }
                return super.visitDeclaration(declaration);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalFunctionContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "index", "", "ownerForLoweredDeclaration", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;ILorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getIndex", "()I", "getOwnerForLoweredDeclaration", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration;", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getClosure", "()Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "setClosure", "(Lorg/jetbrains/kotlin/backend/common/lower/Closure;)V", "transformedDeclaration", "getTransformedDeclaration", "setTransformedDeclaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)V", "ir.backend.common"})
    public static final class LocalFunctionContext
    extends LocalContextWithClosureAsParameters {
        @NotNull
        private final IrSimpleFunction declaration;
        private final int index;
        @NotNull
        private final OwnerForLoweredDeclaration ownerForLoweredDeclaration;
        public Closure closure;
        public IrSimpleFunction transformedDeclaration;

        public LocalFunctionContext(@NotNull IrSimpleFunction declaration, int index, @NotNull OwnerForLoweredDeclaration ownerForLoweredDeclaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(ownerForLoweredDeclaration, "ownerForLoweredDeclaration");
            this.declaration = declaration;
            this.index = index;
            this.ownerForLoweredDeclaration = ownerForLoweredDeclaration;
        }

        @Override
        @NotNull
        public IrSimpleFunction getDeclaration() {
            return this.declaration;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final OwnerForLoweredDeclaration getOwnerForLoweredDeclaration() {
            return this.ownerForLoweredDeclaration;
        }

        @NotNull
        public final Closure getClosure() {
            Closure closure = this.closure;
            if (closure != null) {
                return closure;
            }
            Intrinsics.throwUninitializedPropertyAccessException("closure");
            return null;
        }

        public final void setClosure(@NotNull Closure closure) {
            Intrinsics.checkNotNullParameter(closure, "<set-?>");
            this.closure = closure;
        }

        @Override
        @NotNull
        public IrSimpleFunction getTransformedDeclaration() {
            IrSimpleFunction irSimpleFunction = this.transformedDeclaration;
            if (irSimpleFunction != null) {
                return irSimpleFunction;
            }
            Intrinsics.throwUninitializedPropertyAccessException("transformedDeclaration");
            return null;
        }

        public void setTransformedDeclaration(@NotNull IrSimpleFunction irSimpleFunction) {
            Intrinsics.checkNotNullParameter(irSimpleFunction, "<set-?>");
            this.transformedDeclaration = irSimpleFunction;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalScopeWithCounterMap;", "", "<init>", "()V", "scopeMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$ScopeWithCounter;", "getScopeMap", "()Ljava/util/Map;", "ir.backend.common"})
    public static final class LocalScopeWithCounterMap {
        @NotNull
        private final Map<IrSymbolOwner, ScopeWithCounter> scopeMap = new HashMap();

        @NotNull
        public final Map<IrSymbolOwner, ScopeWithCounter> getScopeMap() {
            return this.scopeMap;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration;", "", "isLocal", "", "<init>", "(Z)V", "()Z", "addChild", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "closestDeclarationParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "DeclarationContainer", "Block", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration$Block;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration$DeclarationContainer;", "ir.backend.common"})
    public static abstract class OwnerForLoweredDeclaration {
        private final boolean isLocal;

        private OwnerForLoweredDeclaration(boolean isLocal) {
            this.isLocal = isLocal;
        }

        public final boolean isLocal() {
            return this.isLocal;
        }

        public abstract void addChild(@NotNull IrDeclaration var1);

        @NotNull
        public abstract IrDeclarationParent closestDeclarationParent();

        public /* synthetic */ OwnerForLoweredDeclaration(boolean isLocal, DefaultConstructorMarker $constructor_marker) {
            this(isLocal);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration$Block;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration;", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "irDeclarationParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrBlock;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "initialStatementsCount", "", "addChild", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "closestDeclarationParent", "ir.backend.common"})
        public static final class Block
        extends OwnerForLoweredDeclaration {
            @NotNull
            private final IrBlock irBlock;
            @NotNull
            private final IrDeclarationParent irDeclarationParent;
            private final int initialStatementsCount;

            public Block(@NotNull IrBlock irBlock, @NotNull IrDeclarationParent irDeclarationParent) {
                Intrinsics.checkNotNullParameter(irBlock, "irBlock");
                Intrinsics.checkNotNullParameter(irDeclarationParent, "irDeclarationParent");
                super(true, null);
                this.irBlock = irBlock;
                this.irDeclarationParent = irDeclarationParent;
                this.initialStatementsCount = this.irBlock.getStatements().size();
            }

            @Override
            public void addChild(@NotNull IrDeclaration declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                this.irBlock.getStatements().add(this.irBlock.getStatements().size() - this.initialStatementsCount, declaration);
            }

            @Override
            @NotNull
            public IrDeclarationParent closestDeclarationParent() {
                return this.irDeclarationParent;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration$DeclarationContainer;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$OwnerForLoweredDeclaration;", "irDeclarationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;)V", "addChild", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "closestDeclarationParent", "ir.backend.common"})
        public static final class DeclarationContainer
        extends OwnerForLoweredDeclaration {
            @NotNull
            private final IrDeclarationContainer irDeclarationContainer;

            public DeclarationContainer(@NotNull IrDeclarationContainer irDeclarationContainer) {
                Intrinsics.checkNotNullParameter(irDeclarationContainer, "irDeclarationContainer");
                super(false, null);
                this.irDeclarationContainer = irDeclarationContainer;
            }

            @Override
            public void addChild(@NotNull IrDeclaration declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                IrUtilsKt.addChild(this.irDeclarationContainer, declaration);
            }

            @Override
            @NotNull
            public IrDeclarationContainer closestDeclarationParent() {
                return this.irDeclarationContainer;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$PotentiallyUnusedField;", "", "<init>", "()V", "value", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "symbolIfUsed", "getSymbolIfUsed", "()Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "symbol", "getSymbol", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$PotentiallyUnusedField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1158:1\n1#2:1159\n*E\n"})
    private static final class PotentiallyUnusedField {
        @Nullable
        private IrFieldSymbol symbolIfUsed;

        @Nullable
        public final IrFieldSymbol getSymbolIfUsed() {
            return this.symbolIfUsed;
        }

        @NotNull
        public final IrFieldSymbol getSymbol() {
            IrFieldSymbol irFieldSymbol = this.symbolIfUsed;
            if (irFieldSymbol == null) {
                IrFieldSymbolImpl irFieldSymbolImpl;
                IrFieldSymbolImpl it = irFieldSymbolImpl = new IrFieldSymbolImpl(null, null, 3, null);
                boolean bl = false;
                this.symbolIfUsed = it;
                irFieldSymbol = irFieldSymbolImpl;
            }
            return irFieldSymbol;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$ScopeWithCounter;", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;)V", "getIrElement", "()Lorg/jetbrains/kotlin/ir/IrElement;", "counter", "", "getCounter", "()I", "setCounter", "(I)V", "usedLocalFunctionNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getUsedLocalFunctionNames", "()Ljava/util/Set;", "ir.backend.common"})
    public static final class ScopeWithCounter {
        @NotNull
        private final IrElement irElement;
        private int counter;
        @NotNull
        private final Set<Name> usedLocalFunctionNames;

        public ScopeWithCounter(@NotNull IrElement irElement) {
            Intrinsics.checkNotNullParameter(irElement, "irElement");
            this.irElement = irElement;
            this.usedLocalFunctionNames = new HashSet();
        }

        @NotNull
        public final IrElement getIrElement() {
            return this.irElement;
        }

        public final int getCounter() {
            return this.counter;
        }

        public final void setCounter(int n2) {
            this.counter = n2;
        }

        @NotNull
        public final Set<Name> getUsedLocalFunctionNames() {
            return this.usedLocalFunctionNames;
        }
    }
}

