/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyClass;
import org.jetbrains.kotlin.ir.declarations.lazy.IrMaybeDeserializedClass;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0006\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0006H\u0002\u001a\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u0001\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0006*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006\u00a8\u0006\u0016"}, d2={"isSimpleFunctionCompiledToJvmDefault", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "isCompiledToJvmDefault", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "hasJvmDefault", "hasJvmDefaultNoCompatibilityAnnotation", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "hasJvmDefaultWithCompatibilityAnnotation", "hasPlatformDependent", "isDefinitelyNotDefaultImplsMethod", "implementation", "isCloneableClone", "findInterfaceImplementation", "allowJvmDefault", "isFakeOverrideOrDefaultImplsBridge", "f", "createDefaultImplsRedirection", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "fakeOverride", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmDefaultUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDefaultUtils.kt\norg/jetbrains/kotlin/backend/jvm/ir/JvmDefaultUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,129:1\n1761#2,3:130\n1#3:133\n238#4,4:134\n*S KotlinDebug\n*F\n+ 1 JvmDefaultUtils.kt\norg/jetbrains/kotlin/backend/jvm/ir/JvmDefaultUtilsKt\n*L\n87#1:130,3\n104#1:134,4\n*E\n"})
public final class JvmDefaultUtilsKt {
    public static final boolean isSimpleFunctionCompiledToJvmDefault(@NotNull IrFunction $this$isSimpleFunctionCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefaultMode) {
        Intrinsics.checkNotNullParameter($this$isSimpleFunctionCompiledToJvmDefault, "<this>");
        Intrinsics.checkNotNullParameter((Object)jvmDefaultMode, "jvmDefaultMode");
        IrSimpleFunction irSimpleFunction = $this$isSimpleFunctionCompiledToJvmDefault instanceof IrSimpleFunction ? (IrSimpleFunction)$this$isSimpleFunctionCompiledToJvmDefault : null;
        return irSimpleFunction != null ? JvmDefaultUtilsKt.isCompiledToJvmDefault(irSimpleFunction, jvmDefaultMode) : false;
    }

    public static final boolean isCompiledToJvmDefault(@NotNull IrSimpleFunction $this$isCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefaultMode) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isCompiledToJvmDefault, "<this>");
        Intrinsics.checkNotNullParameter((Object)jvmDefaultMode, "jvmDefaultMode");
        boolean bl2 = bl = !$this$isCompiledToJvmDefault.isFakeOverride() && IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass($this$isCompiledToJvmDefault)) && $this$isCompiledToJvmDefault.getModality() != Modality.ABSTRACT;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "`isCompiledToJvmDefault` should be called on non-fakeoverrides and non-abstract methods from interfaces " + IrUtilsKt.ir2string($this$isCompiledToJvmDefault);
            throw new AssertionError((Object)string2);
        }
        if (Intrinsics.areEqual($this$isCompiledToJvmDefault.getOrigin(), IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB())) {
            return false;
        }
        if (JvmDefaultUtilsKt.hasJvmDefault($this$isCompiledToJvmDefault)) {
            return true;
        }
        IrClass klass = IrUtilsKt.getParentAsClass($this$isCompiledToJvmDefault);
        if (klass instanceof IrLazyClass) {
            ProtoBuf.Class clazz = ((IrLazyClass)klass).getClassProto();
            if (clazz != null) {
                ProtoBuf.Class it = clazz;
                boolean bl4 = false;
                return JvmProtoBufUtil.isNewPlaceForBodyGeneration(it);
            }
        } else if (klass instanceof IrMaybeDeserializedClass) {
            return ((IrMaybeDeserializedClass)((Object)klass)).isNewPlaceForBodyGeneration();
        }
        return jvmDefaultMode.isEnabled();
    }

    public static final boolean hasJvmDefault(@NotNull IrFunction $this$hasJvmDefault) {
        Intrinsics.checkNotNullParameter($this$hasJvmDefault, "<this>");
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)IrUtilsKt.getPropertyIfAccessor($this$hasJvmDefault), JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_FQ_NAME());
    }

    public static final boolean hasJvmDefaultNoCompatibilityAnnotation(@NotNull IrClass $this$hasJvmDefaultNoCompatibilityAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasJvmDefaultNoCompatibilityAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$hasJvmDefaultNoCompatibilityAnnotation, JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME());
    }

    public static final boolean hasJvmDefaultWithCompatibilityAnnotation(@NotNull IrClass $this$hasJvmDefaultWithCompatibilityAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasJvmDefaultWithCompatibilityAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$hasJvmDefaultWithCompatibilityAnnotation, JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME());
    }

    public static final boolean hasPlatformDependent(@NotNull IrFunction $this$hasPlatformDependent) {
        Intrinsics.checkNotNullParameter($this$hasPlatformDependent, "<this>");
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)IrUtilsKt.getPropertyIfAccessor($this$hasPlatformDependent), PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME());
    }

    public static final boolean isDefinitelyNotDefaultImplsMethod(@NotNull IrSimpleFunction $this$isDefinitelyNotDefaultImplsMethod, @NotNull JvmDefaultMode jvmDefaultMode, @Nullable IrSimpleFunction implementation2) {
        Intrinsics.checkNotNullParameter($this$isDefinitelyNotDefaultImplsMethod, "<this>");
        Intrinsics.checkNotNullParameter((Object)jvmDefaultMode, "jvmDefaultMode");
        return implementation2 == null || Intrinsics.areEqual(implementation2.getOrigin(), IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) || JvmDefaultUtilsKt.isCompiledToJvmDefault(implementation2, jvmDefaultMode) || Intrinsics.areEqual($this$isDefinitelyNotDefaultImplsMethod.getOrigin(), IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER()) || IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isDefinitelyNotDefaultImplsMethod, PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME()) || JvmDefaultUtilsKt.isCloneableClone($this$isDefinitelyNotDefaultImplsMethod);
    }

    private static final boolean isCloneableClone(IrSimpleFunction $this$isCloneableClone) {
        IrDeclarationParent irDeclarationParent;
        Object object;
        return Intrinsics.areEqual($this$isCloneableClone.getName().asString(), "clone") && Intrinsics.areEqual((object = (irDeclarationParent = $this$isCloneableClone.getParent()) instanceof IrClass ? (IrClass)irDeclarationParent : null) != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null ? ((FqName)object).asString() : null, "kotlin.Cloneable") && $this$isCloneableClone.getValueParameters().isEmpty();
    }

    @Nullable
    public static final IrSimpleFunction findInterfaceImplementation(@NotNull IrSimpleFunction $this$findInterfaceImplementation, @NotNull JvmDefaultMode jvmDefaultMode, boolean allowJvmDefault) {
        boolean bl;
        IrSimpleFunction implementation2;
        block9: {
            Intrinsics.checkNotNullParameter($this$findInterfaceImplementation, "<this>");
            Intrinsics.checkNotNullParameter((Object)jvmDefaultMode, "jvmDefaultMode");
            if (!$this$findInterfaceImplementation.isFakeOverride()) {
                return null;
            }
            IrDeclarationParent parent2 = $this$findInterfaceImplementation.getParent();
            if (parent2 instanceof IrClass && (JvmIrUtilsKt.isJvmInterface((IrClass)parent2) || IrUtilsKt.isFromJava((IrDeclaration)((Object)parent2)))) {
                return null;
            }
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride((IrOverridableDeclaration)$this$findInterfaceImplementation, findInterfaceImplementation.implementation.1.INSTANCE);
            if (irSimpleFunction == null) {
                return null;
            }
            implementation2 = irSimpleFunction;
            if (!IrUtilsKt.hasInterfaceParent(implementation2) || DescriptorVisibilities.isPrivate(implementation2.getVisibility()) || IrUtilsKt.isMethodOfAny(implementation2)) {
                return null;
            }
            if (!allowJvmDefault && JvmDefaultUtilsKt.isDefinitelyNotDefaultImplsMethod(implementation2, jvmDefaultMode, implementation2)) {
                return null;
            }
            Iterable $this$any$iv = $this$findInterfaceImplementation.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl2 = false;
                    if (!(!IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass((IrDeclaration)it.getOwner())) && ((IrSimpleFunction)it.getOwner()).getModality() != Modality.ABSTRACT && Intrinsics.areEqual(IrFakeOverrideUtilsKt.resolveFakeOverride((IrOverridableDeclaration)it.getOwner(), findInterfaceImplementation.1.1.INSTANCE), implementation2))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return implementation2;
    }

    public static /* synthetic */ IrSimpleFunction findInterfaceImplementation$default(IrSimpleFunction irSimpleFunction, JvmDefaultMode jvmDefaultMode, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return JvmDefaultUtilsKt.findInterfaceImplementation(irSimpleFunction, jvmDefaultMode, bl);
    }

    private static final boolean isFakeOverrideOrDefaultImplsBridge(IrSimpleFunction f2) {
        return f2.isFakeOverride() || Intrinsics.areEqual(f2.getOrigin(), JvmLoweredDeclarationOrigin.INSTANCE.getSUPER_INTERFACE_METHOD_BRIDGE());
    }

    @NotNull
    public static final IrSimpleFunction createDefaultImplsRedirection(@NotNull IrFactory $this$createDefaultImplsRedirection, @NotNull IrSimpleFunction fakeOverride) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter($this$createDefaultImplsRedirection, "<this>");
        Intrinsics.checkNotNullParameter(fakeOverride, "fakeOverride");
        boolean bl = fakeOverride.isFakeOverride();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JvmDefaultUtilsKt$createDefaultImplsRedirection$22 = false;
            String $i$a$-assert-JvmDefaultUtilsKt$createDefaultImplsRedirection$22 = "Function should be a fake override: " + RenderIrElementKt.render$default(fakeOverride, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-JvmDefaultUtilsKt$createDefaultImplsRedirection$22);
        }
        IrClass irClass = IrUtilsKt.getParentAsClass(fakeOverride);
        IrFactory $this$buildFun$iv = $this$createDefaultImplsRedirection;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean bl2 = false;
        IrFunctionBuilder $this$createDefaultImplsRedirection_u24lambda_u244 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl3 = false;
        $this$createDefaultImplsRedirection_u24lambda_u244.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getSUPER_INTERFACE_METHOD_BRIDGE());
        $this$createDefaultImplsRedirection_u24lambda_u244.setName(fakeOverride.getName());
        $this$createDefaultImplsRedirection_u24lambda_u244.setVisibility(fakeOverride.getVisibility());
        $this$createDefaultImplsRedirection_u24lambda_u244.setModality(fakeOverride.getModality());
        $this$createDefaultImplsRedirection_u24lambda_u244.setReturnType(fakeOverride.getReturnType());
        $this$createDefaultImplsRedirection_u24lambda_u244.setInline(fakeOverride.isInline());
        $this$createDefaultImplsRedirection_u24lambda_u244.setExternal(false);
        $this$createDefaultImplsRedirection_u24lambda_u244.setTailrec(false);
        $this$createDefaultImplsRedirection_u24lambda_u244.setSuspend(fakeOverride.isSuspend());
        $this$createDefaultImplsRedirection_u24lambda_u244.setOperator(fakeOverride.isOperator());
        $this$createDefaultImplsRedirection_u24lambda_u244.setInfix(fakeOverride.isInfix());
        $this$createDefaultImplsRedirection_u24lambda_u244.setExpect(false);
        $this$createDefaultImplsRedirection_u24lambda_u244.setFakeOverride(false);
        IrSimpleFunction $this$createDefaultImplsRedirection_u24lambda_u245 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        boolean bl4 = false;
        $this$createDefaultImplsRedirection_u24lambda_u245.setParent(irClass);
        $this$createDefaultImplsRedirection_u24lambda_u245.setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)fakeOverride.getOverriddenSymbols());
        IrUtilsKt.copyValueAndTypeParametersFrom($this$createDefaultImplsRedirection_u24lambda_u245, fakeOverride);
        IrValueParameter irValueParameter = $this$createDefaultImplsRedirection_u24lambda_u245.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            irValueParameter.setType(IrUtilsKt.getDefaultType(irClass));
        }
        $this$createDefaultImplsRedirection_u24lambda_u245.setAnnotations(fakeOverride.getAnnotations());
        JvmIrUtilsKt.copyCorrespondingPropertyFrom($this$createDefaultImplsRedirection_u24lambda_u245, fakeOverride);
        return irSimpleFunction;
    }

    public static final /* synthetic */ boolean access$isFakeOverrideOrDefaultImplsBridge(IrSimpleFunction f2) {
        return JvmDefaultUtilsKt.isFakeOverrideOrDefaultImplsBridge(f2);
    }
}

