/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.dwarf;

import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.dwarf.AbbreviationRef;
import org.jetbrains.kotlin.backend.wasm.dwarf.AbbreviationTable;
import org.jetbrains.kotlin.backend.wasm.dwarf.DebugLinesStringTable;
import org.jetbrains.kotlin.backend.wasm.dwarf.DebugStringTable;
import org.jetbrains.kotlin.backend.wasm.dwarf.DebuggingSection;
import org.jetbrains.kotlin.backend.wasm.dwarf.DebuggingSections;
import org.jetbrains.kotlin.backend.wasm.dwarf.LineProgram;
import org.jetbrains.kotlin.backend.wasm.dwarf.entries.CompileUnit;
import org.jetbrains.kotlin.backend.wasm.dwarf.entries.Subprogram;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf;", "", "encoding", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Encoding;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Encoding;)V", "strings", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebugStringTable;", "getStrings", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebugStringTable;", "lineStrings", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebugLinesStringTable;", "getLineStrings", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebugLinesStringTable;", "lines", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram;", "getLines", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram;", "abbreviations", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/AbbreviationTable;", "getAbbreviations", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/AbbreviationTable;", "mainCompileUnit", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/entries/CompileUnit;", "getMainCompileUnit", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/entries/CompileUnit;", "generate", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebuggingSections;", "Format", "Encoding", "backend.wasm"})
public final class Dwarf {
    @NotNull
    private final DebugStringTable strings;
    @NotNull
    private final DebugLinesStringTable lineStrings;
    @NotNull
    private final LineProgram lines;
    @NotNull
    private final AbbreviationTable abbreviations;
    @NotNull
    private final CompileUnit mainCompileUnit;

    public Dwarf(@NotNull Encoding encoding) {
        Intrinsics.checkNotNullParameter(encoding, "encoding");
        this.strings = new DebugStringTable();
        this.lineStrings = new DebugLinesStringTable();
        this.lines = new LineProgram(encoding, null, 2, null);
        this.abbreviations = new AbbreviationTable();
        this.mainCompileUnit = new CompileUnit(((DebugStringTable.StringRef)this.strings.add("main")).unbox-impl(), ((DebugStringTable.StringRef)this.strings.add("Kotlin/Wasm Compiler")).unbox-impl(), ((DebugStringTable.StringRef)this.strings.add(".")).unbox-impl(), encoding, null);
    }

    public /* synthetic */ Dwarf(Encoding encoding, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            encoding = Encoding.Default.INSTANCE;
        }
        this(encoding);
    }

    @NotNull
    public final DebugStringTable getStrings() {
        return this.strings;
    }

    @NotNull
    public final DebugLinesStringTable getLineStrings() {
        return this.lineStrings;
    }

    @NotNull
    public final LineProgram getLines() {
        return this.lines;
    }

    @NotNull
    public final AbbreviationTable getAbbreviations() {
        return this.abbreviations;
    }

    @NotNull
    public final CompileUnit getMainCompileUnit() {
        return this.mainCompileUnit;
    }

    @NotNull
    public final DebuggingSections generate() {
        DebuggingSections debuggingSections;
        DebuggingSections $this$generate_u24lambda_u240 = debuggingSections = new DebuggingSections();
        boolean bl = false;
        int compileUnitAbbreviation = ((AbbreviationRef)this.abbreviations.add(CompileUnit.Companion.getAbbreviation())).unbox-impl();
        int subprogramAbbreviation = ((AbbreviationRef)this.abbreviations.add(Subprogram.Companion.getAbbreviation())).unbox-impl();
        List<Integer> stringOffsets = this.strings.write((DebuggingSection.DebuggingStringPoolSection)$this$generate_u24lambda_u240.getDebugStrings());
        List<Integer> debugLinesStringOffsets = this.lineStrings.write((DebuggingSection.DebuggingStringPoolSection)$this$generate_u24lambda_u240.getDebugLinesStrings());
        this.lines.write($this$generate_u24lambda_u240.getDebugLines(), debugLinesStringOffsets);
        this.mainCompileUnit.write-7tMiTvw(compileUnitAbbreviation, subprogramAbbreviation, $this$generate_u24lambda_u240.getDebugInfo(), stringOffsets);
        this.abbreviations.write($this$generate_u24lambda_u240.getDebugAbbreviations());
        return debuggingSections;
    }

    public Dwarf() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0001\fR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Encoding;", "", "addressSize", "", "getAddressSize", "()I", "format", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Format;", "getFormat", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Format;", "version", "getVersion", "Default", "backend.wasm"})
    public static interface Encoding {
        public int getAddressSize();

        @NotNull
        public Format getFormat();

        public int getVersion();

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Encoding$Default;", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Encoding;", "<init>", "()V", "addressSize", "", "getAddressSize", "()I", "format", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Format;", "getFormat", "()Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Format;", "version", "getVersion", "backend.wasm"})
        public static final class Default
        implements Encoding {
            @NotNull
            public static final Default INSTANCE = new Default();
            private static final int addressSize = 4;
            @NotNull
            private static final Format format = Format.DWARF_32;
            private static final int version = 5;

            private Default() {
            }

            @Override
            public int getAddressSize() {
                return addressSize;
            }

            @Override
            @NotNull
            public Format getFormat() {
                return format;
            }

            @Override
            public int getVersion() {
                return version;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Format;", "", "wordSize", "", "<init>", "(Ljava/lang/String;II)V", "getWordSize", "()I", "DWARF_32", "DWARF_64", "backend.wasm"})
    public static final class Format
    extends Enum<Format> {
        private final int wordSize;
        public static final /* enum */ Format DWARF_32 = new Format(4);
        public static final /* enum */ Format DWARF_64 = new Format(8);
        private static final /* synthetic */ Format[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Format(int wordSize) {
            this.wordSize = wordSize;
        }

        public final int getWordSize() {
            return this.wordSize;
        }

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String value2) {
            return Enum.valueOf(Format.class, value2);
        }

        @NotNull
        public static EnumEntries<Format> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = formatArray = new Format[]{Format.DWARF_32, Format.DWARF_64};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

