/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsUsageLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003*\u0002\u0013\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "nestedExternalToNewTopLevelFunctions", "Lorg/jetbrains/kotlin/backend/common/Mapping$DeclarationMapping;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "objectToGetInstanceFunctions", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "declarationTransformer", "org/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$declarationTransformer$1", "Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$declarationTransformer$1;", "usagesTransformer", "org/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$usagesTransformer$1", "Lorg/jetbrains/kotlin/backend/wasm/lower/ComplexExternalDeclarationsUsageLowering$usagesTransformer$1;", "backend.wasm"})
public final class ComplexExternalDeclarationsUsageLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final Mapping.DeclarationMapping<IrFunction, IrSimpleFunction> nestedExternalToNewTopLevelFunctions;
    @NotNull
    private final Mapping.DeclarationMapping<IrClass, IrSimpleFunction> objectToGetInstanceFunctions;
    @NotNull
    private final declarationTransformer.1 declarationTransformer;
    @NotNull
    private final usagesTransformer.1 usagesTransformer;

    public ComplexExternalDeclarationsUsageLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.nestedExternalToNewTopLevelFunctions = this.context.getMapping().getWasmNestedExternalToNewTopLevelFunction();
        this.objectToGetInstanceFunctions = this.context.getMapping().getWasmExternalObjectToGetInstanceFunction();
        this.declarationTransformer = new IrVisitorVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsUsageLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitFile(IrFile declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                this.process(declaration);
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                if (!declaration.isExternal()) {
                    this.process(declaration);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void process(IrDeclarationContainer container) {
                void $this$transformFlat$iv;
                List<IrDeclaration> list = container.getDeclarations();
                ComplexExternalDeclarationsUsageLowering complexExternalDeclarationsUsageLowering = this.this$0;
                boolean $i$f$transformFlat = false;
                int i$iv = 0;
                while (i$iv < $this$transformFlat$iv.size()) {
                    List<T> list2;
                    void member;
                    E item$iv = $this$transformFlat$iv.get(i$iv);
                    IrDeclaration irDeclaration2 = (IrDeclaration)item$iv;
                    void var9_9 = $this$transformFlat$iv;
                    boolean bl = false;
                    if (member instanceof IrFunction && ComplexExternalDeclarationsUsageLowering.access$getNestedExternalToNewTopLevelFunctions$p(complexExternalDeclarationsUsageLowering).get(member) != null) {
                        list2 = CollectionsKt.emptyList();
                    } else {
                        IrVisitorsKt.acceptVoid((IrElement)member, this);
                        list2 = null;
                    }
                    i$iv = TransformKt.replaceInPlace(var9_9, list2, i$iv);
                }
            }

            public void visitBody(IrBody body2) {
                Intrinsics.checkNotNullParameter(body2, "body");
                IrElementTransformerVoidKt.transformChildrenVoid(body2, ComplexExternalDeclarationsUsageLowering.access$getUsagesTransformer$p(this.this$0));
            }
        };
        this.usagesTransformer = new IrElementTransformerVoid(this){
            final /* synthetic */ ComplexExternalDeclarationsUsageLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.transformChildrenVoid(expression2);
                return this.transformCall(expression2);
            }

            public IrExpression visitConstructorCall(IrConstructorCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.transformChildrenVoid(expression2);
                return this.transformCall(expression2);
            }

            public IrExpression visitGetObjectValue(IrGetObjectValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)ComplexExternalDeclarationsUsageLowering.access$getObjectToGetInstanceFunctions$p(this.this$0).get((IrDeclaration)expression2.getSymbol().getOwner());
                if (irSimpleFunction == null) {
                    return expression2;
                }
                IrSimpleFunction externalGetInstance = irSimpleFunction;
                return BuildersKt.IrCallImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), externalGetInstance.getSymbol(), 0, null, null, 96, null);
            }

            /*
             * WARNING - void declaration
             */
            public final IrExpression transformCall(IrFunctionAccessExpression call2) {
                int n2;
                void $this$filterIndexedTo$iv$iv;
                void $this$filterIndexed$iv;
                Intrinsics.checkNotNullParameter(call2, "call");
                IrFunction oldFun = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)ComplexExternalDeclarationsUsageLowering.access$getNestedExternalToNewTopLevelFunctions$p(this.this$0).get((IrDeclaration)oldFun);
                if (irSimpleFunction == null) {
                    return call2;
                }
                IrSimpleFunction newFun2 = irSimpleFunction;
                IrCall newCall = IrUtilsKt.irCall$default(call2, newFun2, true, false, null, null, 56, null);
                int numDefaultParameters = ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.access$numDefaultParametersForExternalFunction(oldFun);
                int firstDefaultFlagArgumentIdx = newFun2.getParameters().size() - numDefaultParameters;
                Iterable iterable = call2.getArguments();
                boolean $i$f$filterIndexed22 = false;
                void var10_12 = $this$filterIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIndexedTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (T item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    void element$iv$iv;
                    int n3;
                    if ((n3 = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    T t2 = item$iv$iv$iv;
                    int index$iv$iv = n3;
                    boolean bl = false;
                    IrExpression cfr_ignored_0 = (IrExpression)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl2 = false;
                    if (!(((IrFunctionSymbol)call2.getSymbol()).getOwner().getParameters().get(index).getKind() == IrParameterKind.Regular)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List valueArguments = (List)destination$iv$iv;
                int firstOldDefaultArgumentIdx = valueArguments.size() - numDefaultParameters;
                ComplexExternalDeclarationsUsageLowering $i$f$filterIndexed22 = this.this$0;
                for (n2 = 0; n2 < numDefaultParameters; ++n2) {
                    int it = n2;
                    boolean bl = false;
                    int value2 = valueArguments.get(firstOldDefaultArgumentIdx + it) == null ? 1 : 0;
                    newCall.getArguments().set(firstDefaultFlagArgumentIdx + it, IrConstImpl.Companion.int(-1, -1, $i$f$filterIndexed22.getContext().getIrBuiltIns().getIntType(), value2));
                }
                n2 = newFun2.getParameters().size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    IrValueParameter parameter = newFun2.getParameters().get(i2);
                    if (AdditionalIrUtilsKt.isVararg(parameter) || newCall.getArguments().get(i2) != null) continue;
                    newCall.getArguments().set(i2, IrUtilsKt.defaultValueForType(IrConstImpl.Companion, -1, -1, parameter.getType()));
                }
                return newCall;
            }
        };
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrVisitorsKt.acceptVoid((IrElement)irFile, this.declarationTransformer);
    }

    public static final /* synthetic */ usagesTransformer.1 access$getUsagesTransformer$p(ComplexExternalDeclarationsUsageLowering $this) {
        return $this.usagesTransformer;
    }

    public static final /* synthetic */ Mapping.DeclarationMapping access$getNestedExternalToNewTopLevelFunctions$p(ComplexExternalDeclarationsUsageLowering $this) {
        return $this.nestedExternalToNewTopLevelFunctions;
    }

    public static final /* synthetic */ Mapping.DeclarationMapping access$getObjectToGetInstanceFunctions$p(ComplexExternalDeclarationsUsageLowering $this) {
        return $this.objectToGetInstanceFunctions;
    }
}

