/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.lower.ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\tR\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "jsRelatedSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsRelatedSymbols;", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getJsRelatedSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols$JsRelatedSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformFunction", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "transformProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getJsCode", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nJsCodeCallsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeCallsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,128:1\n1761#2,3:129\n1563#2:132\n1634#2,3:133\n1878#2,3:147\n1878#2,3:150\n427#3,10:136\n76#4:146\n77#4:153\n*S KotlinDebug\n*F\n+ 1 JsCodeCallsLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/JsCodeCallsLowering\n*L\n70#1:129,3\n83#1:132\n83#1:133,3\n86#1:147,3\n89#1:150,3\n84#1:136,10\n84#1:146\n84#1:153\n*E\n"})
public final class JsCodeCallsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public JsCodeCallsLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final WasmSymbols.JsRelatedSymbols getJsRelatedSymbols() {
        return this.context.getWasmSymbols().getJsRelatedSymbols();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (!this.context.isWasmJsTarget()) {
            return;
        }
        TransformKt.transformDeclarationsFlat(irFile, arg_0 -> JsCodeCallsLowering.lower$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrDeclaration> transformFunction(IrSimpleFunction function2) {
        void it;
        IrConstructorCall irConstructorCall;
        boolean bl;
        String jsFunCode;
        block18: {
            StringBuilder stringBuilder;
            IrBody irBody = function2.getBody();
            if (irBody == null) {
                return null;
            }
            IrBody body2 = irBody;
            IrBody irBody2 = body2;
            IrStatement statement = irBody2 instanceof IrExpressionBody ? (IrStatement)((IrExpressionBody)body2).getExpression() : (irBody2 instanceof IrBlockBody ? CollectionsKt.singleOrNull(((IrBlockBody)body2).getStatements()) : null);
            boolean isSingleExpressionJsCode = false;
            String jsCode = null;
            IrStatement irStatement = statement;
            if (irStatement instanceof IrReturn) {
                String string2 = this.getJsCode(((IrReturn)statement).getValue());
                if (string2 == null) {
                    return null;
                }
                jsCode = string2;
                isSingleExpressionJsCode = true;
            } else if (irStatement instanceof IrCall) {
                String string3 = this.getJsCode((IrExpression)statement);
                if (string3 == null) {
                    return null;
                }
                jsCode = string3;
                isSingleExpressionJsCode = false;
            } else {
                return null;
            }
            List<IrValueParameter> valueParameters = function2.getParameters();
            StringBuilder $this$transformFunction_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$transformFunction_u24lambda_u242.append('(');
            $this$transformFunction_u24lambda_u242.append(CollectionsKt.joinToString$default(valueParameters, null, null, null, 0, null, JsCodeCallsLowering::transformFunction$lambda$2$lambda$1, 31, null));
            $this$transformFunction_u24lambda_u242.append(") => ");
            if (!isSingleExpressionJsCode) {
                $this$transformFunction_u24lambda_u242.append("{ ");
            }
            $this$transformFunction_u24lambda_u242.append(jsCode);
            if (!isSingleExpressionJsCode) {
                $this$transformFunction_u24lambda_u242.append(" }");
            }
            jsFunCode = stringBuilder.toString();
            Iterable $this$any$iv = function2.getParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it2 = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    if (!(it2.getDefaultValue() != null)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        if (bl) {
            IrTypeParameter parameter;
            int index;
            int n2;
            void $this$transformFunction_u24lambda_u248;
            void this_$iv$iv;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv;
            IrSimpleFunction externalFun = this.context.getIrFactory().getStageController().restrictTo(function2, () -> JsCodeCallsLowering.transformFunction$lambda$4(this, function2, jsFunCode));
            IrUtilsKt.copyTypeParametersFrom$default(externalFun, function2, null, null, 6, null);
            Iterable $i$f$any = function2.getParameters();
            IrSimpleFunction irSimpleFunction = externalFun;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it3;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it3, externalFun, null, 0, 0, null, null, null, null, null, false, false, false, null, 7934, null));
            }
            irSimpleFunction.setParameters((List)destination$iv$iv);
            IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder $i$f$mapTo22 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            item$iv$iv2 = this_$iv$iv;
            irSimpleFunction = function2;
            boolean bl5 = false;
            IrCall call2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$transformFunction_u24lambda_u248, externalFun.getSymbol());
            Iterable $this$forEachIndexed$iv = function2.getParameters();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv;
                index = n2;
                boolean bl6 = false;
                call2.getArguments().set(index, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$transformFunction_u24lambda_u248, (IrValueDeclaration)((Object)parameter)));
            }
            $this$forEachIndexed$iv = function2.getTypeParameters();
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void typeParameter;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                parameter = (IrTypeParameter)item$iv;
                index = n2;
                boolean bl7 = false;
                call2.getTypeArguments().set(index, IrTypesKt.getDefaultType((IrTypeParameter)typeParameter));
            }
            $this$transformFunction_u24lambda_u248.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformFunction_u24lambda_u248, call2));
            irSimpleFunction.setBody(this_$iv$iv.doBuild());
            IrSimpleFunction[] irSimpleFunctionArray = new IrSimpleFunction[]{function2, externalFun};
            return CollectionsKt.listOf(irSimpleFunctionArray);
        }
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        IrConstructorCall startOffset$iv = irConstructorCall = ExpressionHelpersKt.irCallConstructor(builder, this.getJsRelatedSymbols().getJsFunConstructor(), CollectionsKt.emptyList());
        Collection collection = function2.getAnnotations();
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl8 = false;
        it.getArguments().set(0, ExpressionHelpersKt.irString(builder, jsFunCode));
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setAnnotations(CollectionsKt.plus(collection, irConstructorCall));
        function2.setBody(null);
        return null;
    }

    private final List<IrDeclaration> transformProperty(IrProperty property2) {
        IrField irField = property2.getBackingField();
        if (irField == null) {
            return null;
        }
        IrField field = irField;
        IrExpressionBody irExpressionBody = field.getInitializer();
        if (irExpressionBody == null) {
            return null;
        }
        IrExpressionBody initializer = irExpressionBody;
        String string2 = this.getJsCode(initializer.getExpression());
        if (string2 == null) {
            return null;
        }
        String jsCode = string2;
        IrSimpleFunction externalFun = this.context.getIrFactory().getStageController().restrictTo(field, () -> JsCodeCallsLowering.transformProperty$lambda$10(this, property2, field, jsCode));
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)field.getSymbol(), 0, 0, 6, null);
        initializer.setExpression(ExpressionHelpersKt.irCall((IrBuilderWithScope)builder, externalFun));
        IrDeclaration[] irDeclarationArray = new IrDeclaration[]{property2, externalFun};
        return CollectionsKt.listOf(irDeclarationArray);
    }

    private final String getJsCode(IrExpression $this$getJsCode) {
        IrCall irCall = $this$getJsCode instanceof IrCall ? (IrCall)$this$getJsCode : null;
        if (irCall == null) {
            return null;
        }
        IrCall call2 = irCall;
        if (!Intrinsics.areEqual(call2.getSymbol(), this.getJsRelatedSymbols().getJsCode())) {
            return null;
        }
        Object e2 = call2.getArguments().get(0);
        Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
        Object object = ((IrConst)e2).getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    private static final List lower$lambda$0(JsCodeCallsLowering this$0, IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrDeclaration irDeclaration2 = declaration;
        return irDeclaration2 instanceof IrSimpleFunction ? this$0.transformFunction((IrSimpleFunction)declaration) : (irDeclaration2 instanceof IrProperty ? this$0.transformProperty((IrProperty)declaration) : null);
    }

    private static final CharSequence transformFunction$lambda$2$lambda$1(IrValueParameter it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = it.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
        return string2;
    }

    private static final IrSimpleFunction transformFunction$lambda$4(JsCodeCallsLowering this$0, IrSimpleFunction $function, String $jsFunCode) {
        return ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this$0.context, $function.getName(), "_js_code", $function.getReturnType(), $jsFunCode);
    }

    private static final IrSimpleFunction transformProperty$lambda$10(JsCodeCallsLowering this$0, IrProperty $property, IrField $field, String $jsCode) {
        return ComplexExternalDeclarationsToTopLevelFunctionsLoweringKt.createExternalJsFunction(this$0.context, $property.getName(), "_js_code", $field.getType(), "() => (" + $jsCode + ')');
    }
}

