/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 *\u00020!2\u0006\u0010\"\u001a\u00020\u0015H\u0002J\f\u0010#\u001a\u00020\u001e*\u00020$H\u0002J\u001e\u0010%\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150 2\u0006\u0010'\u001a\u00020$H\u0002J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00152\u0006\u0010'\u001a\u00020$H\u0002J \u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0018\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u001eH\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u00100\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00152\u0006\u0010'\u001a\u00020$H\u0002J\u0018\u00101\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00152\u0006\u0010'\u001a\u00020$H\u0002J\u0018\u00102\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00152\u0006\u0010'\u001a\u00020$H\u0002J\u0018\u00103\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00152\u0006\u00104\u001a\u000205H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "jsToKotlinAnyAdapter", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getJsToKotlinAnyAdapter", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "kotlinToJsAnyAdapter", "getKotlinToJsAnyAdapter", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVariable", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "lowerInstanceOf", "inverted", "", "cacheValue", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "value", "isInlined", "Lorg/jetbrains/kotlin/ir/types/IrType;", "generateTypeCheck", "valueProvider", "toType", "lowerIntegerCoercion", "generateTypeCheckNonNull", "argument", "narrowType", "fromType", "lowerCast", "isSafe", "lowerImplicitCast", "generateTypeCheckWithTypeParameter", "generateIsInterface", "generateIsSubClass", "generateIsExternalClass", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmTypeOperatorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmTypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,359:1\n413#2,13:360\n413#2,13:375\n413#2,13:390\n413#2,13:405\n134#3,2:373\n134#3,2:388\n134#3,2:403\n134#3,2:418\n1803#4,3:420\n17#5,16:423\n33#5:440\n19#6:439\n*S KotlinDebug\n*F\n+ 1 WasmTypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmBaseTypeOperatorTransformer\n*L\n83#1:360,13\n172#1:375,13\n243#1:390,13\n278#1:405,13\n83#1:373,2\n172#1:388,2\n243#1:403,2\n278#1:418,2\n311#1:420,3\n96#1:423,16\n96#1:440\n96#1:439\n*E\n"})
public final class WasmBaseTypeOperatorTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private final IrBuiltIns builtIns;
    private DeclarationIrBuilder builder;

    public WasmBaseTypeOperatorTransformer(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.symbols = this.context.getWasmSymbols();
        this.builtIns = this.context.getIrBuiltIns();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunctionSymbol getJsToKotlinAnyAdapter() {
        return this.symbols.getJsRelatedSymbols().getJsInteropAdapters().getJsToKotlinAnyAdapter();
    }

    private final IrSimpleFunctionSymbol getKotlinToJsAnyAdapter() {
        return this.symbols.getJsRelatedSymbols().getJsInteropAdapters().getKotlinToJsAnyAdapter();
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitTypeOperator(expression2);
        LoweringContext loweringContext = this.context;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull(scopeWithIr);
        this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null), expression2);
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 2: {
                throw new IllegalStateException("Dynamic casts are not supported in Wasm backend".toString());
            }
            case 3: {
                irExpression = expression2;
                break;
            }
            case 4: {
                irExpression = this.lowerIntegerCoercion(expression2);
                break;
            }
            case 5: {
                irExpression = this.lowerImplicitCast(expression2);
                break;
            }
            case 6: {
                irExpression = this.lowerInstanceOf(expression2, false);
                break;
            }
            case 7: {
                irExpression = this.lowerInstanceOf(expression2, true);
                break;
            }
            case 8: {
                irExpression = this.lowerCast(expression2, false);
                break;
            }
            case 9: {
                irExpression = this.lowerCast(expression2, true);
                break;
            }
            case 10: {
                String string2 = "SAM conversion: " + RenderIrElementKt.render$default(expression2, null, 1, null);
                throw new NotImplementedError("An operation is not implemented: " + string2);
            }
            case 11: {
                irExpression = expression2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrExpression initializer = declaration.getInitializer();
        if (initializer != null && !Intrinsics.areEqual(initializer.getType(), declaration.getType())) {
            LoweringContext loweringContext = this.context;
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull(scopeWithIr);
            this.builder = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null), declaration);
            declaration.setInitializer(this.narrowType(initializer.getType(), declaration.getType(), initializer));
        }
        return super.visitVariable(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerInstanceOf(IrTypeOperatorCall expression2, boolean inverted) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
        IrType resultType$iv = this.builtIns.getBooleanType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerInstanceOf_u24lambda_u240 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument = this.cacheValue((IrBlockBuilder)$this$lowerInstanceOf_u24lambda_u240, expression2.getArgument());
        IrExpression check2 = this.generateTypeCheck(argument, expression2.getTypeOperand());
        if (inverted) {
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            $this$lowerInstanceOf_u24lambda_u240.unaryPlus(LowerUtilsKt.irNot(declarationIrBuilder2, check2));
        } else {
            $this$lowerInstanceOf_u24lambda_u240.unaryPlus(check2);
        }
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final Function0<IrExpression> cacheValue(IrBlockBuilder $this$cacheValue, IrExpression value2) {
        if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(value2, true, false, null, 6, null) && IrUtilsKt.isTrivial(value2)) {
            return () -> WasmBaseTypeOperatorTransformer.cacheValue$lambda$1(value2);
        }
        IrVariable tmpVal = IrBuilderKt.createTmpVariable$default($this$cacheValue, value2, null, false, null, null, 30, null);
        return () -> WasmBaseTypeOperatorTransformer.cacheValue$lambda$2(this, tmpVal);
    }

    private final boolean isInlined(IrType $this$isInlined) {
        return this.context.getInlineClassesUtils().isTypeInlined($this$isInlined);
    }

    private final IrExpression generateTypeCheck(Function0<? extends IrExpression> valueProvider, IrType toType) {
        IrExpression irExpression;
        IrType toNotNullable = IrTypesKt.makeNotNull(toType);
        IrExpression valueInstance = valueProvider.invoke();
        IrType fromType = valueInstance.getType();
        if (this.isInlined(fromType)) {
            boolean result2 = IrUtilsKt.isSubclassOf(IrTypeErasureUtilsKt.getErasedUpperBound(fromType), IrTypeErasureUtilsKt.getErasedUpperBound(toType));
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irBoolean(declarationIrBuilder, result2);
        }
        IrExpression instanceCheck = this.generateTypeCheckNonNull(valueInstance, toNotNullable);
        boolean isFromNullable = IrTypeUtilsKt.isNullable(valueInstance.getType());
        boolean isToNullable = IrTypeUtilsKt.isNullable(toType);
        if (!isFromNullable) {
            irExpression = instanceCheck;
        } else {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
            IrType irType = this.builtIns.getBooleanType();
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            IrExpression irExpression2 = ExpressionHelpersKt.irEqualsNull(declarationIrBuilder2, valueProvider.invoke());
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder3 = null;
            }
            irExpression = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope, irType, irExpression2, ExpressionHelpersKt.irBoolean(declarationIrBuilder3, isToNullable), instanceCheck, null, 16, null);
        }
        return irExpression;
    }

    private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        IrType irType = expression2.getTypeOperand();
        if (Intrinsics.areEqual(irType, this.builtIns.getByteType()) || Intrinsics.areEqual(irType, this.builtIns.getShortType())) {
            irExpression = expression2.getArgument();
        } else if (Intrinsics.areEqual(irType, this.builtIns.getLongType())) {
            IrCall irCall;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrCall $this$lowerIntegerCoercion_u24lambda_u243 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getIntToLong());
            boolean bl = false;
            $this$lowerIntegerCoercion_u24lambda_u243.getArguments().set(0, expression2.getArgument());
            irExpression = irCall;
        } else {
            throw new IllegalStateException("Unreachable execution (coercion to non-Integer type".toString());
        }
        return irExpression;
    }

    private final IrExpression generateTypeCheckNonNull(IrExpression argument, IrType toType) {
        IrExpression irExpression;
        boolean bl;
        boolean bl2 = bl = !IrTypePredicatesKt.isMarkedNullable(toType);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrClass classOrInterface = IrTypeErasureUtilsKt.getErasedUpperBound(toType);
        if (classOrInterface.isExternal()) {
            if (classOrInterface.getKind() == ClassKind.INTERFACE) {
                DeclarationIrBuilder declarationIrBuilder = this.builder;
                if (declarationIrBuilder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("builder");
                    declarationIrBuilder = null;
                }
                irExpression = ExpressionHelpersKt.irTrue(declarationIrBuilder);
            } else {
                irExpression = this.generateIsExternalClass(argument, classOrInterface);
            }
        } else if (IrTypePredicatesKt.isNothing(toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            irExpression = ExpressionHelpersKt.irFalse(declarationIrBuilder);
        } else {
            irExpression = IrTypeUtilsKt.isTypeParameter(toType) ? this.generateTypeCheckWithTypeParameter(argument, toType) : (IrTypeUtilsKt.isInterface(toType) ? this.generateIsInterface(argument, toType) : this.generateIsSubClass(argument, toType));
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression narrowType(IrType fromType, IrType toType, IrExpression value2) {
        IrCall irCall;
        if (Intrinsics.areEqual(fromType, toType)) {
            return value2;
        }
        if (Intrinsics.areEqual(toType, this.builtIns.getNothingNType())) {
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
            IrType resultType$iv = this.builtIns.getNothingNType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u244 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u244.unaryPlus(value2);
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            $this$narrowType_u24lambda_u244.unaryPlus(ExpressionHelpersKt.irNull(declarationIrBuilder2));
            return (IrExpression)this_$iv$iv.doBuild();
        }
        if (Intrinsics.areEqual(toType, this.builtIns.getAnyNType()) && Intrinsics.areEqual(fromType, this.builtIns.getNothingNType()) && value2 instanceof IrConst && Intrinsics.areEqual(((IrConst)value2).getKind(), IrConstKind.Null.INSTANCE)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irNull(declarationIrBuilder, this.builtIns.getNothingNType());
        }
        if (this.isInlined(toType) && !this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            Object $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            Object it = $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getUnboxIntrinsic(), toType, CollectionsKt.listOf($this$irComposite_u24default$iv));
            boolean bl = false;
            ((IrMemberAccessExpression)it).getArguments().set(0, value2);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        if (!this.isInlined(toType) && this.isInlined(fromType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            Object $this$irComposite_u24default$iv = new IrType[]{fromType, toType};
            Object it = $this$irComposite_u24default$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getBoxIntrinsic(), toType, CollectionsKt.listOf($this$irComposite_u24default$iv));
            boolean bl = false;
            ((IrMemberAccessExpression)it).getArguments().set(0, value2);
            return (IrExpression)$this$irComposite_u24default$iv;
        }
        IrClass fromClass = IrTypeErasureUtilsKt.getErasedUpperBound(fromType);
        IrClass toClass = IrTypeErasureUtilsKt.getErasedUpperBound(toType);
        if (fromClass.isExternal() && toClass.isExternal()) {
            return value2;
        }
        if (IrUtilsKt.isNullConst(value2) && fromClass.isExternal() != toClass.isExternal()) {
            value2.setType(toType);
            return value2;
        }
        if (fromClass.isExternal() && !toClass.isExternal()) {
            IrCall origin$iv;
            if (!this.context.isWasmJsTarget()) {
                String bl = "Implement externalize adapter for wasi mode";
                throw new NotImplementedError("An operation is not implemented: " + bl);
            }
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrCall it = origin$iv = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.getJsToKotlinAnyAdapter());
            boolean bl = false;
            it.getArguments().set(0, value2);
            IrCall narrowingToAny2 = origin$iv;
            return this.narrowType(this.context.getIrBuiltIns().getAnyType(), toType, narrowingToAny2);
        }
        if (toClass.isExternal() && !fromClass.isExternal()) {
            IrCall narrowingToAny2;
            if (!this.context.isWasmJsTarget()) {
                String narrowingToAny2 = "Implement internalize adapter for wasi mode";
                throw new NotImplementedError("An operation is not implemented: " + narrowingToAny2);
            }
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrCall it = narrowingToAny2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.getKotlinToJsAnyAdapter());
            boolean bl = false;
            it.getArguments().set(0, value2);
            return narrowingToAny2;
        }
        if (IrUtilsKt.isSubclassOf(fromClass, toClass)) {
            return value2;
        }
        if (IrTypePredicatesKt.isNothing(toType)) {
            void this_$iv$iv;
            void $this$irComposite_u24default$iv;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrBuilderWithScope narrowingToAny2 = declarationIrBuilder;
            IrType resultType$iv = this.context.getIrBuiltIns().getNothingType();
            int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            boolean $i$f$irComposite = false;
            IrBlockBuilder $this$narrowType_u24lambda_u244 = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
            boolean $i$f$block = false;
            void $this$narrowType_u24lambda_u249 = this_$iv$iv;
            boolean bl = false;
            $this$narrowType_u24lambda_u249.unaryPlus(value2);
            $this$narrowType_u24lambda_u249.unaryPlus(ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$narrowType_u24lambda_u249, this.symbols.getWasmUnreachable()));
            return (IrExpression)this_$iv$iv.doBuild();
        }
        if (Intrinsics.areEqual(toType, this.symbols.getVoidType())) {
            IrCall irCall2;
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            IrCall $this$narrowType_u24lambda_u2410 = irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.findVoidConsumer(value2.getType()));
            boolean bl = false;
            $this$narrowType_u24lambda_u2410.getArguments().set(0, value2);
            return irCall2;
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrCall $this$narrowType_u24lambda_u2411 = irCall = ExpressionHelpersKt.irCall$default(declarationIrBuilder, this.symbols.getRefCastNull(), toType, 0, null, 12, null);
        boolean bl = false;
        $this$narrowType_u24lambda_u2411.getTypeArguments().set(0, toType);
        $this$narrowType_u24lambda_u2411.getArguments().set(0, value2);
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerCast(IrTypeOperatorCall expression2, boolean isSafe) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrExpression failResult;
        IrExpression irExpression;
        IrType toType = expression2.getTypeOperand();
        IrType fromType = expression2.getArgument().getType();
        if (IrUtilsKt.isSubclassOf(IrTypeErasureUtilsKt.getErasedUpperBound(fromType), IrTypeErasureUtilsKt.getErasedUpperBound(expression2.getType()))) {
            return this.narrowType(fromType, expression2.getType(), expression2.getArgument());
        }
        if (isSafe) {
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            irExpression = ExpressionHelpersKt.irNull(declarationIrBuilder2);
        } else {
            DeclarationIrBuilder declarationIrBuilder3 = this.builder;
            if (declarationIrBuilder3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder3 = null;
            }
            irExpression = failResult = (IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder3, this.context.getIr().getSymbols().getThrowTypeCastException());
        }
        if ((declarationIrBuilder = this.builder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrBuilderWithScope irBuilderWithScope = declarationIrBuilder;
        IrType resultType$iv = expression2.getType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$lowerCast_u24lambda_u2412 = this_$iv$iv;
        boolean bl = false;
        Function0<IrExpression> argument = this.cacheValue((IrBlockBuilder)$this$lowerCast_u24lambda_u2412, expression2.getArgument());
        IrExpression narrowArg = this.narrowType(fromType, expression2.getType(), argument.invoke());
        IrExpression check2 = this.generateTypeCheck(argument, toType);
        if (check2 instanceof IrConst) {
            Object object = ((IrConst)check2).getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
            boolean value2 = (Boolean)object;
            if (value2) {
                $this$lowerCast_u24lambda_u2412.unaryPlus(narrowArg);
            } else {
                $this$lowerCast_u24lambda_u2412.unaryPlus(failResult);
            }
        } else {
            DeclarationIrBuilder declarationIrBuilder4 = this.builder;
            if (declarationIrBuilder4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder4 = null;
            }
            $this$lowerCast_u24lambda_u2412.unaryPlus(ExpressionHelpersKt.irIfThenElse$default(declarationIrBuilder4, expression2.getType(), check2, narrowArg, failResult, null, 16, null));
        }
        return (IrExpression)this_$iv$iv.doBuild();
    }

    private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2) {
        return this.narrowType(expression2.getArgument().getType(), expression2.getTypeOperand(), expression2.getArgument());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateTypeCheckWithTypeParameter(IrExpression argument, IrType toType) {
        void $this$fold$iv;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(toType);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        IrTypeParameter irTypeParameter = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        if (irTypeParameter == null) {
            throw new IllegalStateException(("expected type parameter, but got " + toType).toString());
        }
        IrTypeParameter typeParameter = irTypeParameter;
        Iterable iterable = typeParameter.getSuperTypes();
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrConstImpl irConstImpl = ExpressionHelpersKt.irTrue(declarationIrBuilder);
        Intrinsics.checkNotNull(irConstImpl, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        IrExpression initial$iv = irConstImpl;
        boolean $i$f$fold = false;
        IrExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            IrCall irCall;
            void t2;
            IrType irType = (IrType)element$iv;
            IrExpression r2 = accumulator$iv;
            boolean bl = false;
            IrExpression check2 = this.generateTypeCheckNonNull(IrUtilsKt.shallowCopy(argument), IrTypesKt.makeNotNull((IrType)t2));
            DeclarationIrBuilder declarationIrBuilder2 = this.builder;
            if (declarationIrBuilder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder2 = null;
            }
            IrCall $this$generateTypeCheckWithTypeParameter_u24lambda_u2414_u24lambda_u2413 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder2, this.symbols.getBooleanAnd());
            boolean bl2 = false;
            $this$generateTypeCheckWithTypeParameter_u24lambda_u2414_u24lambda_u2413.getArguments().set(0, r2);
            $this$generateTypeCheckWithTypeParameter_u24lambda_u2414_u24lambda_u2413.getArguments().set(1, check2);
            accumulator$iv = irCall;
        }
        return accumulator$iv;
    }

    private final IrExpression generateIsInterface(IrExpression argument, IrType toType) {
        IrCall irCall;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrCall $this$generateIsInterface_u24lambda_u2415 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getWasmIsInterface());
        boolean bl = false;
        $this$generateIsInterface_u24lambda_u2415.getArguments().set(0, argument);
        $this$generateIsInterface_u24lambda_u2415.getTypeArguments().set(0, toType);
        return irCall;
    }

    private final IrExpression generateIsSubClass(IrExpression argument, IrType toType) {
        IrCall irCall;
        IrClass toTypeErased;
        if (IrTypePredicatesKt.isAny(toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irTrue(declarationIrBuilder);
        }
        IrType fromType = argument.getType();
        if (TypeTransformerKt.isExternalType(fromType) != TypeTransformerKt.isExternalType(toType)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irFalse(declarationIrBuilder);
        }
        IrClass fromTypeErased = TypeTransformerKt.getRuntimeClass(fromType, this.context.getIrBuiltIns());
        if (IrUtilsKt.isSubclassOf(fromTypeErased, toTypeErased = TypeTransformerKt.getRuntimeClass(toType, this.context.getIrBuiltIns()))) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irTrue(declarationIrBuilder);
        }
        if (!IrUtilsKt.isSubclassOf(toTypeErased, fromTypeErased)) {
            DeclarationIrBuilder declarationIrBuilder = this.builder;
            if (declarationIrBuilder == null) {
                Intrinsics.throwUninitializedPropertyAccessException("builder");
                declarationIrBuilder = null;
            }
            return ExpressionHelpersKt.irFalse(declarationIrBuilder);
        }
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrCall $this$generateIsSubClass_u24lambda_u2416 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, this.symbols.getRefTest());
        boolean bl = false;
        $this$generateIsSubClass_u24lambda_u2416.getArguments().set(0, argument);
        $this$generateIsSubClass_u24lambda_u2416.getTypeArguments().set(0, toType);
        return irCall;
    }

    private final IrExpression generateIsExternalClass(IrExpression argument, IrClass klass) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrSimpleFunction irSimpleFunction = this.context.getMapping().getWasmExternalClassToInstanceCheck().get((IrClass)((IrDeclaration)klass));
        Intrinsics.checkNotNull(irSimpleFunction);
        IrSimpleFunction instanceCheckFunction = irSimpleFunction;
        DeclarationIrBuilder declarationIrBuilder = this.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        IrFunctionAccessExpression it = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)declarationIrBuilder, instanceCheckFunction);
        boolean bl = false;
        it.getArguments().set(0, this.narrowType(argument.getType(), this.context.getIrBuiltIns().getAnyType(), argument));
        return irFunctionAccessExpression;
    }

    private static final IrExpression cacheValue$lambda$1(IrExpression $value) {
        IrElement $this$deepCopyWithSymbols_u24default$iv = $value;
        IrDeclarationParent initialParent$iv = null;
        boolean $i$f$deepCopyWithSymbols = false;
        IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
        boolean $i$f$deepCopyImpl = false;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
        boolean bl = false;
        ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
        TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
        IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
        if (irElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        }
        return (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrExpression)irElement), initialParent$iv);
    }

    private static final IrGetValueImpl cacheValue$lambda$2(WasmBaseTypeOperatorTransformer this$0, IrVariable $tmpVal) {
        DeclarationIrBuilder declarationIrBuilder = this$0.builder;
        if (declarationIrBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("builder");
            declarationIrBuilder = null;
        }
        return ExpressionHelpersKt.irGet(declarationIrBuilder, $tmpVal);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_DYNAMIC_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

