/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.lower.WasmVarargExpressionLoweringKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002,-B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\u0016\u001a\u00020\f*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0010H\u0016J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0010H\u0002J\u001c\u0010&\u001a\u00020\u0013*\u00020\u00112\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006.\u00b2\u0006\n\u0010 \u001a\u00020!X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irCreateArray", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "size", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "arrDescr", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$ArrayDescr;", "irCopyInto", "destArr", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "indexVar", "segment", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder;", "irSize", "tryVisitWithNoSpread", "irVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "visitVararg", "expression", "visitFunctionAccess", "transformFunctionAccessExpression", "irIntPlus", "rhs", "lhs", "isImmediatelyCreatedArray", "", "expr", "ArrayDescr", "VarargSegmentBuilder", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmVarargExpressionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmVarargExpressionLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,315:1\n2746#2,3:316\n1563#2:319\n1634#2,3:320\n1869#2,2:336\n1563#2:338\n1634#2,3:339\n2851#2,7:342\n1869#2,2:349\n88#3,6:323\n234#4,6:329\n134#5:335\n135#5:351\n*S KotlinDebug\n*F\n+ 1 WasmVarargExpressionLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering\n*L\n199#1:316,3\n206#1:319\n206#1:320,3\n234#1:336,2\n237#1:338\n237#1:339,3\n238#1:342,7\n245#1:349,2\n231#1:323,6\n231#1:329,6\n231#1:335\n231#1:351\n*E\n"})
public final class WasmVarargExpressionLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final WasmSymbols symbols;

    public WasmVarargExpressionLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmSymbols getSymbols() {
        return this.symbols;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    private final IrFunctionAccessExpression irCreateArray(IrBlockBuilder $this$irCreateArray, IrExpression size, ArrayDescr arrDescr) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression $this$irCreateArray_u24lambda_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irCreateArray, arrDescr.getPrimaryConstructor());
        boolean bl = false;
        $this$irCreateArray_u24lambda_u240.getArguments().set(0, size);
        if (!((Collection)$this$irCreateArray_u24lambda_u240.getTypeArguments()).isEmpty()) {
            if (!($this$irCreateArray_u24lambda_u240.getTypeArguments().size() == 1 && arrDescr.getArrayClass().getTypeParameters().size() == 1)) {
                throw new IllegalStateException("Check failed.");
            }
            $this$irCreateArray_u24lambda_u240.getTypeArguments().set(0, arrDescr.getElementType());
        }
        $this$irCreateArray_u24lambda_u240.setType(arrDescr.getArrayType());
        return irFunctionAccessExpression;
    }

    private final void irCopyInto(IrBlockBuilder $this$irCopyInto, IrVariable destArr, IrVariable indexVar, VarargSegmentBuilder segment) {
        VarargSegmentBuilder $this$irCopyInto_u24lambda_u241 = segment;
        boolean bl = false;
        $this$irCopyInto_u24lambda_u241.irCopyInto($this$irCopyInto, destArr, indexVar);
    }

    private final IrExpression irSize(IrBlockBuilder $this$irSize, VarargSegmentBuilder segment) {
        VarargSegmentBuilder $this$irSize_u24lambda_u242 = segment;
        boolean bl = false;
        return $this$irSize_u24lambda_u242.irSize($this$irSize);
    }

    private final IrExpression tryVisitWithNoSpread(IrVararg irVararg, DeclarationIrBuilder builder) {
        IrConstructorCall irConstructorCall;
        IrType irVarargType = irVararg.getType();
        if (!IrTypeUtilsKt.isUnsignedArray(irVarargType)) {
            return irVararg;
        }
        IrClass irClass = IrTypesKt.getClass(irVarargType);
        Intrinsics.checkNotNull(irClass);
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(irClass);
        Intrinsics.checkNotNull(irConstructor);
        IrConstructor unsignedConstructor = irConstructor;
        IrType constructorParameterType = unsignedConstructor.getParameters().get(0).getType();
        IrType signedElementType = IrTypeUtilsKt.getArrayElementType(constructorParameterType, this.context.getIrBuiltIns());
        irVararg.setType(constructorParameterType);
        irVararg.setVarargElementType(signedElementType);
        IrConstructorCall it = irConstructorCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)builder, unsignedConstructor.getSymbol(), irVarargType, null, 4, null);
        boolean bl = false;
        it.getArguments().set(0, irVararg);
        return irConstructorCall;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        IrExpression irExpression;
        Object v7;
        void $this$reduceOrNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        IrVariable it;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irComposite$iv$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Object element$iv2;
        boolean bl;
        DeclarationIrBuilder builder;
        IrVararg irVararg;
        block15: {
            IrExpression spreadExpr;
            IrSpreadElement singleSpreadElement;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrVarargElement irVarargElement = CollectionsKt.singleOrNull(expression2.getElements());
            IrSpreadElement irSpreadElement = singleSpreadElement = irVarargElement instanceof IrSpreadElement ? (IrSpreadElement)irVarargElement : null;
            if (singleSpreadElement != null && this.isImmediatelyCreatedArray(spreadExpr = singleSpreadElement.getExpression())) {
                return spreadExpr.transform((IrElementTransformer)this, (Object)null);
            }
            IrExpression irExpression2 = super.visitVararg(expression2);
            Intrinsics.checkNotNull(irExpression2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrVararg");
            irVararg = (IrVararg)irExpression2;
            LoweringContext loweringContext = this.context;
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull(scopeWithIr);
            builder = LowerUtilsKt.createIrBuilder$default(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null);
            Iterable $this$none$iv = irVararg.getElements();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    IrVarargElement it2 = (IrVarargElement)element$iv2;
                    boolean bl2 = false;
                    if (!(it2 instanceof IrSpreadElement)) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        if (bl) {
            return this.tryVisitWithNoSpread(irVararg, builder);
        }
        Iterable $i$f$none = irVararg.getElements();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            IrExpression irExpression3;
            void it3;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            if (it3 instanceof IrSpreadElement) {
                irExpression3 = ((IrSpreadElement)it3).getExpression();
            } else {
                Intrinsics.checkNotNull(it3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                irExpression3 = (IrExpression)it3;
            }
            IrExpression exp = irExpression3;
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull(scopeWithIr);
            collection.add(Scope.createTemporaryVariable$default(scopeWithIr.getScope(), exp, "vararg_temp", false, null, null, 0, 0, 124, null));
        }
        List elementVars = (List)destination$iv$iv;
        List segments2 = SequencesKt.toList(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super VarargSegmentBuilder>, Continuation<? super Unit>, Object>(irVararg, (List<? extends IrVariable>)elementVars, this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ IrVararg $irVararg;
            final /* synthetic */ List<IrVariable> $elementVars;
            final /* synthetic */ WasmVarargExpressionLowering this$0;
            {
                this.$irVararg = $irVararg;
                this.$elementVars = $elementVars;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        currentElements = new ArrayList<E>();
                        var4_5 = CollectionsKt.zip((Iterable)this.$irVararg.getElements(), (Iterable)this.$elementVars).iterator();
lbl8:
                        // 5 sources

                        while (var4_5.hasNext()) {
                            var5_6 = var4_5.next();
                            el = (IrVarargElement)var5_6.component1();
                            tempVar = (IrVariable)var5_6.component2();
                            var8_9 = el;
                            if (var8_9 instanceof IrExpression) {
                                currentElements.add(tempVar);
                                continue;
                            }
                            if (!(var8_9 instanceof IrSpreadElement)) continue;
                            if (!(((Collection)currentElements).isEmpty() == false)) ** GOTO lbl37
                            this.L$0 = $this$sequence;
                            this.L$1 = currentElements;
                            this.L$2 = var4_5;
                            this.L$3 = tempVar;
                            this.label = 1;
                            v0 = $this$sequence.yield(new VarargSegmentBuilder.Plain(CollectionsKt.toList(currentElements), WasmVarargExpressionLowering.access$getContext$p(this.this$0)), this);
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl36
                        }
                        break;
                    }
                    case 1: {
                        tempVar = (IrVariable)this.L$3;
                        var4_5 = (Iterator)this.L$2;
                        currentElements = (List)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl36:
                        // 2 sources

                        currentElements.clear();
lbl37:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = currentElements;
                        this.L$2 = var4_5;
                        this.L$3 = null;
                        this.label = 2;
                        v1 = $this$sequence.yield(new VarargSegmentBuilder.Spread(tempVar, WasmVarargExpressionLowering.access$getContext$p(this.this$0)), this);
                        if (v1 != var9_2) ** GOTO lbl8
                        return var9_2;
                    }
                    case 2: {
                        var4_5 = (Iterator<Pair<T, R>>)this.L$2;
                        currentElements = (List)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        ** GOTO lbl8
                    }
                }
                if (((Collection)currentElements).isEmpty() == false) {
                    this.L$0 = null;
                    this.L$1 = null;
                    this.L$2 = null;
                    this.label = 3;
                    v2 = $this$sequence.yield(new VarargSegmentBuilder.Plain(CollectionsKt.toList(currentElements), WasmVarargExpressionLowering.access$getContext$p(this.this$0)), this);
                    if (v2 == var9_2) {
                        return var9_2;
                    }
                }
                ** GOTO lbl64
                {
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl64:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                Function2<SequenceScope<? super VarargSegmentBuilder>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super VarargSegmentBuilder> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        ArrayDescr destArrayDescr = new ArrayDescr(irVararg.getType(), this.context);
        IrGeneratorWithScope $this$irComposite_u24default$iv = builder;
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = ((IrExpression)irVararg).getType();
        boolean $i$f$irComposite = false;
        item$iv$iv2 = $this$irComposite_u24default$iv;
        int it3 = ((IrExpression)irVararg).getStartOffset();
        int endOffset$iv$iv = ((IrExpression)irVararg).getEndOffset();
        boolean $i$f$irComposite2 = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite$iv$iv.getContext(), $this$irComposite$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$visitVararg_u24lambda_u2410 = this_$iv$iv$iv;
        boolean bl4 = false;
        Iterable $this$forEach$iv = elementVars;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            it = (IrVariable)element$iv3;
            boolean bl5 = false;
            $this$visitVararg_u24lambda_u2410.unaryPlus(it);
        }
        Iterable iterable = segments2;
        boolean $i$f$map2 = false;
        it = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it4;
            VarargSegmentBuilder varargSegmentBuilder = (VarargSegmentBuilder)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl6 = false;
            collection.add(this.irSize((IrBlockBuilder)$this$visitVararg_u24lambda_u2410, (VarargSegmentBuilder)it4));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v7 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void exp;
                IrExpression $i$f$mapTo22 = (IrExpression)iterator$iv.next();
                IrExpression acc = (IrExpression)accumulator$iv;
                boolean bl7 = false;
                accumulator$iv = this.irIntPlus((IrBlockBuilder)$this$visitVararg_u24lambda_u2410, acc, (IrExpression)exp);
            }
            v7 = accumulator$iv;
        }
        if ((irExpression = (IrExpression)v7) == null) {
            irExpression = ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$visitVararg_u24lambda_u2410, 0, null, 2, null);
        }
        IrExpression arrayLength = irExpression;
        IrVariable arrayTempVariable = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$visitVararg_u24lambda_u2410, this.irCreateArray((IrBlockBuilder)$this$visitVararg_u24lambda_u2410, arrayLength, destArrayDescr), "vararg_array", null, false, null, 28, null);
        IrVariable indexVar = segments2.size() >= 2 ? ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$visitVararg_u24lambda_u2410, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$visitVararg_u24lambda_u2410, 0, null, 2, null), "vararg_idx", null, false, null, 28, null) : null;
        Iterable $this$forEach$iv2 = segments2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv4 : $this$forEach$iv2) {
            VarargSegmentBuilder it5 = (VarargSegmentBuilder)element$iv4;
            boolean bl8 = false;
            this.irCopyInto((IrBlockBuilder)$this$visitVararg_u24lambda_u2410, arrayTempVariable, indexVar, it5);
            if (indexVar == null) continue;
            $this$visitVararg_u24lambda_u2410.unaryPlus(ExpressionHelpersKt.irSet$default((IrBuilderWithScope)$this$visitVararg_u24lambda_u2410, indexVar, this.irIntPlus((IrBlockBuilder)$this$visitVararg_u24lambda_u2410, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitVararg_u24lambda_u2410, indexVar), this.irSize((IrBlockBuilder)$this$visitVararg_u24lambda_u2410, it5)), null, 4, null));
        }
        $this$visitVararg_u24lambda_u2410.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitVararg_u24lambda_u2410, arrayTempVariable));
        return (IrExpression)this_$iv$iv$iv.doBuild();
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return this.transformFunctionAccessExpression(expression2);
    }

    private final IrExpression transformFunctionAccessExpression(IrFunctionAccessExpression expression2) {
        this.transformChildrenVoid(expression2);
        Lazy<DeclarationIrBuilder> builder$delegate = LazyKt.lazy(() -> WasmVarargExpressionLowering.transformFunctionAccessExpression$lambda$11(this));
        int n2 = expression2.getArguments().size();
        for (int argumentIdx = 0; argumentIdx < n2; ++argumentIdx) {
            IrConstructor primaryConstructor;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrExpression argument = (IrExpression)expression2.getArguments().get(argumentIdx);
            IrValueParameter parameter = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getParameters().get(argumentIdx);
            IrType varargElementType = parameter.getVarargElementType();
            if (argument != null || varargElementType == null) continue;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(parameter.getType());
            Intrinsics.checkNotNull(irClassSymbol);
            IrClass arrayClass = (IrClass)irClassSymbol.getOwner();
            Intrinsics.checkNotNull(IrUtilsKt.getPrimaryConstructor(arrayClass));
            DeclarationIrBuilder $this$transformFunctionAccessExpression_u24lambda_u2414 = WasmVarargExpressionLowering.transformFunctionAccessExpression$lambda$12(builder$delegate);
            boolean bl = false;
            IrFunctionAccessExpression $this$transformFunctionAccessExpression_u24lambda_u2414_u24lambda_u2413 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$transformFunctionAccessExpression_u24lambda_u2414, primaryConstructor);
            boolean bl2 = false;
            $this$transformFunctionAccessExpression_u24lambda_u2414_u24lambda_u2413.getArguments().set(0, ExpressionHelpersKt.irInt$default($this$transformFunctionAccessExpression_u24lambda_u2414, 0, null, 2, null));
            if (!((Collection)primaryConstructor.getTypeParameters()).isEmpty()) {
                if (!(primaryConstructor.getTypeParameters().size() == 1)) {
                    throw new IllegalStateException("Check failed.");
                }
                $this$transformFunctionAccessExpression_u24lambda_u2414_u24lambda_u2413.getTypeArguments().set(0, parameter.getVarargElementType());
            }
            IrFunctionAccessExpression emptyArrayCall = irFunctionAccessExpression;
            expression2.getArguments().set(argumentIdx, emptyArrayCall);
        }
        return expression2;
    }

    private final IrExpression irIntPlus(IrBlockBuilder $this$irIntPlus, IrExpression rhs, IrExpression lhs) {
        return WasmVarargExpressionLoweringKt.access$irIntPlus($this$irIntPlus, rhs, lhs, this.context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isImmediatelyCreatedArray(IrExpression expr) {
        IrExpression irExpression = expr;
        if (irExpression instanceof IrFunctionAccessExpression) {
            ArrayDescr arrDescr = new ArrayDescr(expr.getType(), this.context);
            if (SequencesKt.contains(arrDescr.getConstructors(), ((IrFunctionSymbol)((IrFunctionAccessExpression)expr).getSymbol()).getOwner())) return true;
            if (!Intrinsics.areEqual(((IrFunctionAccessExpression)expr).getSymbol(), this.context.getWasmSymbols().getArrayOfNulls())) return false;
            return true;
        }
        if (!(irExpression instanceof IrTypeOperatorCall)) {
            if (irExpression instanceof IrComposite) {
                if (((IrComposite)expr).getStatements().size() != 1) return false;
                if (!(((IrComposite)expr).getStatements().get(0) instanceof IrExpression)) return false;
                IrStatement irStatement = ((IrComposite)expr).getStatements().get(0);
                Intrinsics.checkNotNull(irStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                if (!this.isImmediatelyCreatedArray((IrExpression)irStatement)) return false;
                return true;
            }
            if (!(irExpression instanceof IrVararg)) return false;
            return true;
        }
        boolean bl = this.isImmediatelyCreatedArray(((IrTypeOperatorCall)expr).getArgument());
        return bl;
    }

    private static final DeclarationIrBuilder transformFunctionAccessExpression$lambda$11(WasmVarargExpressionLowering this$0) {
        LoweringContext loweringContext = this$0.context;
        ScopeWithIr scopeWithIr = this$0.getCurrentScope();
        Intrinsics.checkNotNull(scopeWithIr);
        return LowerUtilsKt.createIrBuilder$default(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null);
    }

    private static final DeclarationIrBuilder transformFunctionAccessExpression$lambda$12(Lazy<DeclarationIrBuilder> $builder$delegate) {
        Lazy<DeclarationIrBuilder> lazy = $builder$delegate;
        return lazy.getValue();
    }

    public static final /* synthetic */ WasmBackendContext access$getContext$p(WasmVarargExpressionLowering $this) {
        return $this.context;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0011\u0010#\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\tR\u0011\u0010%\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001e\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$ArrayDescr;", "", "arrayType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getArrayType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "arrayClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getArrayClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isUnsigned", "", "()Z", "primaryConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getPrimaryConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "constructors", "Lkotlin/sequences/Sequence;", "getConstructors", "()Lkotlin/sequences/Sequence;", "setMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getSetMethod", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getMethod", "getGetMethod", "sizeMethod", "getSizeMethod", "elementType", "getElementType", "copyInto", "getCopyInto", "backend.wasm"})
    @SourceDebugExtension(value={"SMAP\nWasmVarargExpressionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmVarargExpressionLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$ArrayDescr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n1#2:316\n*E\n"})
    private static final class ArrayDescr {
        @NotNull
        private final IrType arrayType;
        @NotNull
        private final WasmBackendContext context;
        @NotNull
        private final IrClass arrayClass;

        public ArrayDescr(@NotNull IrType arrayType, @NotNull WasmBackendContext context2) {
            Intrinsics.checkNotNullParameter(arrayType, "arrayType");
            Intrinsics.checkNotNullParameter(context2, "context");
            this.arrayType = arrayType;
            this.context = context2;
            IrClass irClass = IrTypesKt.getClass(this.arrayType);
            if (irClass == null) {
                throw new IllegalArgumentException("Argument " + RenderIrElementKt.render$default(this.arrayType, null, 1, null) + " must have a class");
            }
            this.arrayClass = irClass;
            if (!this.context.getWasmSymbols().getArrays().contains(this.arrayClass.getSymbol())) {
                boolean bl = false;
                String string2 = "Argument " + IrUtilsKt.ir2string(this.arrayClass) + " must be an array";
                throw new IllegalStateException(string2.toString());
            }
        }

        @NotNull
        public final IrType getArrayType() {
            return this.arrayType;
        }

        @NotNull
        public final WasmBackendContext getContext() {
            return this.context;
        }

        @NotNull
        public final IrClass getArrayClass() {
            return this.arrayClass;
        }

        public final boolean isUnsigned() {
            return this.context.getWasmSymbols().getUnsignedTypesToUnsignedArrays().values().contains(this.arrayClass.getSymbol());
        }

        @NotNull
        public final IrConstructor getPrimaryConstructor() {
            IrConstructor irConstructor;
            if (this.isUnsigned()) {
                IrConstructor irConstructor2;
                block3: {
                    Sequence<IrConstructor> sequence2 = IrUtilsKt.getConstructors(this.arrayClass);
                    Iterator<IrConstructor> iterator2 = sequence2.iterator();
                    while (iterator2.hasNext()) {
                        IrConstructor irConstructor3;
                        IrConstructor it = irConstructor3 = iterator2.next();
                        boolean bl = false;
                        IrValueParameter irValueParameter = CollectionsKt.singleOrNull(it.getParameters());
                        if (!Intrinsics.areEqual(irValueParameter != null ? irValueParameter.getType() : null, this.context.getIrBuiltIns().getIntType())) continue;
                        irConstructor2 = irConstructor3;
                        break block3;
                    }
                    irConstructor2 = null;
                }
                Intrinsics.checkNotNull(irConstructor2);
                irConstructor = irConstructor2;
            } else {
                IrConstructor irConstructor4 = IrUtilsKt.getPrimaryConstructor(this.arrayClass);
                irConstructor = irConstructor4;
                Intrinsics.checkNotNull(irConstructor4);
            }
            return irConstructor;
        }

        @NotNull
        public final Sequence<IrConstructor> getConstructors() {
            return IrUtilsKt.getConstructors(this.arrayClass);
        }

        @NotNull
        public final IrSimpleFunction getSetMethod() {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(this.arrayClass, "set");
            Intrinsics.checkNotNull(irSimpleFunctionSymbol);
            return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        }

        @NotNull
        public final IrSimpleFunction getGetMethod() {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(this.arrayClass, "get");
            Intrinsics.checkNotNull(irSimpleFunctionSymbol);
            return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        }

        @NotNull
        public final IrSimpleFunction getSizeMethod() {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(this.arrayClass, "size");
            Intrinsics.checkNotNull(irSimpleFunctionSymbol);
            return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        }

        @NotNull
        public final IrType getElementType() {
            if (IrTypeUtilsKt.isBoxedArray(this.arrayType)) {
                return IrTypeUtilsKt.getArrayElementType(this.arrayType, this.context.getIrBuiltIns());
            }
            return this.getGetMethod().getReturnType();
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final IrSimpleFunction getCopyInto() {
            block4: {
                var2_1 = this.context.getWasmSymbols().getArraysCopyInto();
                var3_2 = var2_1.iterator();
                while (var3_2.hasNext()) {
                    symbol = var4_3 = var3_2.next();
                    $i$a$-find-WasmVarargExpressionLowering$ArrayDescr$copyInto$func$1 = false;
                    it = (IrSimpleFunction)symbol.getOwner();
                    $i$a$-let-WasmVarargExpressionLowering$ArrayDescr$copyInto$func$1$1 = false;
                    if (!IrUtilsKt.hasShape$default(it, false, true, 0, 4, null, 21, null)) ** GOTO lbl-1000
                    v0 = IrTypesKt.getClassOrNull(it.getParameters().get(0).getType());
                    if (Intrinsics.areEqual(v0 != null ? (IrClass)v0.getOwner() : null, this.arrayClass)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = var4_3;
                    break block4;
                }
                v2 = null;
            }
            if ((v3 = (func = (IrSimpleFunctionSymbol)v2)) == null || (v3 = (IrSimpleFunction)v3.getOwner()) == null) {
                throw new IllegalArgumentException("copyInto is not found for " + RenderIrElementKt.render$default(this.arrayType, null, 1, null));
            }
            return v3;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\b\u001a\u00020\t*\u00020\nH&J\u001e\u0010\u000b\u001a\u00020\f*\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder;", "", "wasmContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getWasmContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "irSize", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "irCopyInto", "", "destArr", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "indexVar", "Plain", "Spread", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder$Plain;", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder$Spread;", "backend.wasm"})
    private static abstract class VarargSegmentBuilder {
        @NotNull
        private final WasmBackendContext wasmContext;

        private VarargSegmentBuilder(WasmBackendContext wasmContext) {
            this.wasmContext = wasmContext;
        }

        @NotNull
        public final WasmBackendContext getWasmContext() {
            return this.wasmContext;
        }

        @NotNull
        public abstract IrExpression irSize(@NotNull IrBlockBuilder var1);

        public abstract void irCopyInto(@NotNull IrBlockBuilder var1, @NotNull IrVariable var2, @Nullable IrVariable var3);

        public /* synthetic */ VarargSegmentBuilder(WasmBackendContext wasmContext, DefaultConstructorMarker $constructor_marker) {
            this(wasmContext);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder$Plain;", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder;", "exprs", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "wasmContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getExprs", "()Ljava/util/List;", "irSize", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "irCopyInto", "", "destArr", "indexVar", "backend.wasm"})
        public static final class Plain
        extends VarargSegmentBuilder {
            @NotNull
            private final List<IrVariable> exprs;

            public Plain(@NotNull List<? extends IrVariable> exprs, @NotNull WasmBackendContext wasmContext) {
                Intrinsics.checkNotNullParameter(exprs, "exprs");
                Intrinsics.checkNotNullParameter(wasmContext, "wasmContext");
                super(wasmContext, null);
                this.exprs = exprs;
            }

            @NotNull
            public final List<IrVariable> getExprs() {
                return this.exprs;
            }

            @Override
            @NotNull
            public IrConstImpl irSize(@NotNull IrBlockBuilder $this$irSize) {
                Intrinsics.checkNotNullParameter($this$irSize, "<this>");
                return ExpressionHelpersKt.irInt$default($this$irSize, this.exprs.size(), null, 2, null);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void irCopyInto(@NotNull IrBlockBuilder $this$irCopyInto, @NotNull IrVariable destArr, @Nullable IrVariable indexVar) {
                Intrinsics.checkNotNullParameter($this$irCopyInto, "<this>");
                Intrinsics.checkNotNullParameter(destArr, "destArr");
                ArrayDescr destArrDescr = new ArrayDescr(destArr.getType(), this.getWasmContext());
                Sequence<IrConstImpl> seq = SequencesKt.map(SequencesKt.generateSequence(0, Plain::irCopyInto$lambda$0), arg_0 -> Plain.irCopyInto$lambda$1($this$irCopyInto, arg_0));
                boolean bl = false;
                Sequence<IrConstImpl> indexes = indexVar != null ? SequencesKt.map(seq, arg_0 -> Plain.irCopyInto$lambda$3$lambda$2($this$irCopyInto, indexVar, this, arg_0)) : seq;
                Iterator iterator2 = SequencesKt.zip(CollectionsKt.asSequence((Iterable)this.exprs), indexes).iterator();
                while (iterator2.hasNext()) {
                    void $this$irCopyInto_u24lambda_u244;
                    IrFunctionAccessExpression irFunctionAccessExpression;
                    Pair pair = iterator2.next();
                    IrVariable element = (IrVariable)pair.component1();
                    IrExpression index = pair.component2();
                    IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irCopyInto, destArrDescr.getSetMethod());
                    IrBlockBuilder irBlockBuilder = $this$irCopyInto;
                    boolean bl2 = false;
                    $this$irCopyInto_u24lambda_u244.setDispatchReceiver(ExpressionHelpersKt.irGet($this$irCopyInto, destArr));
                    $this$irCopyInto_u24lambda_u244.getArguments().set(1, index);
                    $this$irCopyInto_u24lambda_u244.getArguments().set(2, ExpressionHelpersKt.irGet($this$irCopyInto, element));
                    irBlockBuilder.unaryPlus(irFunctionAccessExpression);
                }
            }

            private static final Integer irCopyInto$lambda$0(int it) {
                return it + 1;
            }

            private static final IrConstImpl irCopyInto$lambda$1(IrBlockBuilder $this_irCopyInto, int it) {
                return ExpressionHelpersKt.irInt$default($this_irCopyInto, it, null, 2, null);
            }

            private static final IrExpression irCopyInto$lambda$3$lambda$2(IrBlockBuilder $this_irCopyInto, IrVariable $indexVar, Plain this$0, IrConstImpl it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return WasmVarargExpressionLoweringKt.access$irIntPlus($this_irCopyInto, ExpressionHelpersKt.irGet($this_irCopyInto, $indexVar), it, this$0.getWasmContext());
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u0012*\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder$Spread;", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder;", "exprVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "wasmContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getExprVar", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "srcArrDescr", "Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$ArrayDescr;", "getSrcArrDescr", "()Lorg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$ArrayDescr;", "irSize", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBuilder;", "irCopyInto", "", "destArr", "indexVar", "backend.wasm"})
        @SourceDebugExtension(value={"SMAP\nWasmVarargExpressionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmVarargExpressionLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmVarargExpressionLowering$VarargSegmentBuilder$Spread\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n1#2:316\n*E\n"})
        public static final class Spread
        extends VarargSegmentBuilder {
            @NotNull
            private final IrVariable exprVar;
            @NotNull
            private final ArrayDescr srcArrDescr;

            public Spread(@NotNull IrVariable exprVar, @NotNull WasmBackendContext wasmContext) {
                Intrinsics.checkNotNullParameter(exprVar, "exprVar");
                Intrinsics.checkNotNullParameter(wasmContext, "wasmContext");
                super(wasmContext, null);
                this.exprVar = exprVar;
                this.srcArrDescr = new ArrayDescr(this.exprVar.getType(), wasmContext);
            }

            @NotNull
            public final IrVariable getExprVar() {
                return this.exprVar;
            }

            @NotNull
            public final ArrayDescr getSrcArrDescr() {
                return this.srcArrDescr;
            }

            @Override
            @NotNull
            public IrExpression irSize(@NotNull IrBlockBuilder $this$irSize) {
                IrFunctionAccessExpression irFunctionAccessExpression;
                Intrinsics.checkNotNullParameter($this$irSize, "<this>");
                IrFunctionAccessExpression $this$irSize_u24lambda_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irSize, this.srcArrDescr.getSizeMethod());
                boolean bl = false;
                $this$irSize_u24lambda_u240.setDispatchReceiver(ExpressionHelpersKt.irGet($this$irSize, this.exprVar));
                return irFunctionAccessExpression;
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public void irCopyInto(@NotNull IrBlockBuilder $this$irCopyInto, @NotNull IrVariable destArr, @Nullable IrVariable indexVar) {
                Intrinsics.checkNotNullParameter($this$irCopyInto, "<this>");
                Intrinsics.checkNotNullParameter(destArr, "destArr");
                var4_4 = Intrinsics.areEqual(this.srcArrDescr.getArrayClass(), IrTypesKt.getClass(destArr.getType()));
                if (_Assertions.ENABLED && !var4_4) {
                    $i$a$-assert-WasmVarargExpressionLowering$VarargSegmentBuilder$Spread$irCopyInto$1 = false;
                    var5_7 = "type checker failure?";
                    throw new AssertionError((Object)var5_7);
                }
                v0 /* !! */  = indexVar;
                if (v0 /* !! */  == null) ** GOTO lbl-1000
                it = v0 /* !! */ ;
                $i$a$-let-WasmVarargExpressionLowering$VarargSegmentBuilder$Spread$irCopyInto$destIdx$1 = false;
                v1 = ExpressionHelpersKt.irGet($this$irCopyInto, it);
                v0 /* !! */  = v1;
                if (v1 != null) {
                    v2 = (IrExpression)v0 /* !! */ ;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = ExpressionHelpersKt.irInt$default($this$irCopyInto, 0, null, 2, null);
                }
                destIdx = v2;
                var6_12 = var5_8 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irCopyInto, this.srcArrDescr.getCopyInto());
                var9_13 = $this$irCopyInto;
                $i$a$-apply-WasmVarargExpressionLowering$VarargSegmentBuilder$Spread$irCopyInto$2 = false;
                if (((Collection)$this$irCopyInto_u24lambda_u243.getTypeArguments()).isEmpty() == false) {
                    if (!($this$irCopyInto_u24lambda_u243.getTypeArguments().size() == 1 && this.srcArrDescr.getArrayClass().getTypeParameters().size() == 1)) {
                        throw new IllegalStateException("Check failed.");
                    }
                    $this$irCopyInto_u24lambda_u243.getTypeArguments().set(0, this.srcArrDescr.getElementType());
                }
                $this$irCopyInto_u24lambda_u243.getArguments().set(0, ExpressionHelpersKt.irGet($this$irCopyInto, this.exprVar));
                $this$irCopyInto_u24lambda_u243.getArguments().set(1, ExpressionHelpersKt.irGet($this$irCopyInto, destArr));
                $this$irCopyInto_u24lambda_u243.getArguments().set(2, destIdx);
                $this$irCopyInto_u24lambda_u243.getArguments().set(3, ExpressionHelpersKt.irInt$default($this$irCopyInto, 0, null, 2, null));
                $this$irCopyInto_u24lambda_u243.getArguments().set(4, this.irSize($this$irCopyInto));
                var9_13.unaryPlus(var5_8);
            }
        }
    }
}

