/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WhenBranchOptimiserTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "createElse", "Lorg/jetbrains/kotlin/ir/expressions/IrElseBranch;", "startOffset", "", "endOffset", "result", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "branchConditionValue", "Lorg/jetbrains/kotlin/backend/wasm/lower/WhenBranchOptimiserTransformer$ConditionValue;", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "visitWhen", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "ConditionValue", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWhenBranchOptimiserLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhenBranchOptimiserLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WhenBranchOptimiserTransformer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,198:1\n37#2:199\n36#2,3:200\n*S KotlinDebug\n*F\n+ 1 WhenBranchOptimiserLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WhenBranchOptimiserTransformer\n*L\n154#1:199\n154#1:200,3\n*E\n"})
final class WhenBranchOptimiserTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final WasmBackendContext context;

    public WhenBranchOptimiserTransformer(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrElseBranch createElse(int startOffset, int endOffset, IrExpression result2) {
        return BuildersKt.IrElseBranchImpl(startOffset, endOffset, IrUtilsKt.toIrConst$default(true, this.context.getIrBuiltIns().getBooleanType(), 0, 0, 6, null), result2);
    }

    private final ConditionValue branchConditionValue(IrBranch branch) {
        if (branch instanceof IrElseBranch) {
            return ConditionValue.CONST_TRUE;
        }
        IrExpression currentExpression = branch.getCondition();
        boolean falseCondition = false;
        boolean trueCondition = false;
        boolean complexCondition = false;
        while (currentExpression != null) {
            IrStatement irStatement;
            IrComposite expressionAsComposite;
            if (IrUtilsKt.isFalseConst(currentExpression)) {
                falseCondition = true;
                break;
            }
            if (IrUtilsKt.isTrueConst(currentExpression)) {
                trueCondition = true;
                break;
            }
            if (Intrinsics.areEqual(currentExpression.getType(), this.context.getIrBuiltIns().getNothingType())) {
                return ConditionValue.UNREACHABLE;
            }
            IrExpression irExpression = currentExpression;
            IrComposite irComposite = irExpression instanceof IrComposite ? (IrComposite)irExpression : null;
            if (irComposite == null || (expressionAsComposite = irComposite).getStatements().isEmpty()) break;
            if (expressionAsComposite.getStatements().size() > 1) {
                complexCondition = true;
            }
            currentExpression = (irStatement = CollectionsKt.last(expressionAsComposite.getStatements())) instanceof IrExpression ? (IrExpression)irStatement : null;
        }
        return trueCondition ? (complexCondition ? ConditionValue.COMPLEX_TRUE : ConditionValue.CONST_TRUE) : (falseCondition ? (complexCondition ? ConditionValue.COMPLEX_FALSE : ConditionValue.CONST_FALSE) : ConditionValue.OTHER);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.transformChildrenVoid(expression2);
        Collection $this$toTypedArray$iv = expression2.getBranches();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IrBranch[] iterate = thisCollection$iv.toArray(new IrBranch[0]);
        expression2.getBranches().clear();
        block8: for (IrBranch branch : iterate) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.branchConditionValue(branch).ordinal()]) {
                case 1: {
                    IrElseBranch elseBranch = this.createElse(branch.getStartOffset(), branch.getEndOffset(), branch.getResult());
                    expression2.getBranches().add(elseBranch);
                    return expression2;
                }
                case 2: {
                    IrCompositeImpl irCompositeImpl;
                    IrCompositeImpl it = irCompositeImpl = BuildersKt.IrCompositeImpl$default(-1, -1, branch.getResult().getType(), null, 8, null);
                    boolean bl = false;
                    it.getStatements().add(branch.getCondition());
                    it.getStatements().add(branch.getResult());
                    IrCompositeImpl result2 = irCompositeImpl;
                    IrElseBranch elseBranch = this.createElse(branch.getStartOffset(), branch.getEndOffset(), result2);
                    expression2.getBranches().add(elseBranch);
                    return expression2;
                }
                case 3: {
                    IrElseBranch elseBranch = this.createElse(branch.getStartOffset(), branch.getEndOffset(), branch.getCondition());
                    expression2.getBranches().add(elseBranch);
                    return expression2;
                }
                case 4: {
                    continue block8;
                }
                case 5: {
                    IrCallImpl unreachable = BuildersKt.IrCallImpl$default(-1, -1, this.context.getIrBuiltIns().getNothingType(), this.context.getWasmSymbols().getWasmUnreachable(), 0, null, null, 96, null);
                    branch.setResult(unreachable);
                    boolean bl = expression2.getBranches().add(branch);
                    continue block8;
                }
                case 6: {
                    boolean bl = expression2.getBranches().add(branch);
                    continue block8;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return expression2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WhenBranchOptimiserTransformer$ConditionValue;", "", "<init>", "(Ljava/lang/String;I)V", "CONST_TRUE", "COMPLEX_TRUE", "CONST_FALSE", "COMPLEX_FALSE", "UNREACHABLE", "OTHER", "backend.wasm"})
    private static final class ConditionValue
    extends Enum<ConditionValue> {
        public static final /* enum */ ConditionValue CONST_TRUE = new ConditionValue();
        public static final /* enum */ ConditionValue COMPLEX_TRUE = new ConditionValue();
        public static final /* enum */ ConditionValue CONST_FALSE = new ConditionValue();
        public static final /* enum */ ConditionValue COMPLEX_FALSE = new ConditionValue();
        public static final /* enum */ ConditionValue UNREACHABLE = new ConditionValue();
        public static final /* enum */ ConditionValue OTHER = new ConditionValue();
        private static final /* synthetic */ ConditionValue[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConditionValue[] values() {
            return (ConditionValue[])$VALUES.clone();
        }

        public static ConditionValue valueOf(String value2) {
            return Enum.valueOf(ConditionValue.class, value2);
        }

        @NotNull
        public static EnumEntries<ConditionValue> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = conditionValueArray = new ConditionValue[]{ConditionValue.CONST_TRUE, ConditionValue.COMPLEX_TRUE, ConditionValue.CONST_FALSE, ConditionValue.COMPLEX_FALSE, ConditionValue.UNREACHABLE, ConditionValue.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConditionValue.values().length];
            try {
                nArray[ConditionValue.CONST_TRUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConditionValue.COMPLEX_TRUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConditionValue.UNREACHABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConditionValue.CONST_FALSE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConditionValue.COMPLEX_FALSE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConditionValue.OTHER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

