/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmAbiStability;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a,\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0003\u001a\u00020\u0004\u001ag\u0010\u0014\u001a\u00020\u0001\"\b\b\u0000\u0010\u0017*\u00020\u0018*\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u001b0\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u001b0\u001a2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001e\u001a\n\u0010\u001f\u001a\u00020\u0006*\u00020\u0002\u001a$\u0010 \u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\u001b\u001a\u0012\u0010#\u001a\u00020\u0006*\u00020$2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010%\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0012\u0010+\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\b\u0010,\u001a\u00020'H\u0002\u00a8\u0006-"}, d2={"setupJvmSpecificArguments", "", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "isCompatibleJvmTargetAndRelease", "", "jvmTarget", "", "release", "handleClosureGenerationSchemeArgument", "flag", "value", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "Lorg/jetbrains/kotlin/config/JvmClosureGenerationScheme;", "configureJdkHome", "configureJdkHomeFromSystemProperty", "configureJavaModulesContentRoots", "configureContentRootsFromClassPath", "configureStandardLibs", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "PathProvider", "", "stdlibPath", "Lkotlin/Function1;", "Ljava/io/File;", "scriptRuntimePath", "reflectPath", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;)V", "isModularJava", "addModularRootIfNotNull", "moduleName", "file", "registerJavacIfNeeded", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "configureAdvancedJvmOptions", "parseBackendThreads", "", "stringValue", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "configureKlibPaths", "getJavaVersion", "cli"})
@SourceDebugExtension(value={"SMAP\njvmArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jvmArguments.kt\norg/jetbrains/kotlin/cli/jvm/JvmArgumentsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n1563#2:350\n1634#2,3:351\n1563#2:354\n1634#2,3:355\n827#2:359\n855#2,2:360\n1#3:358\n*S KotlinDebug\n*F\n+ 1 jvmArguments.kt\norg/jetbrains/kotlin/cli/jvm/JvmArgumentsKt\n*L\n266#1:350\n266#1:351,3\n299#1:354\n299#1:355,3\n344#1:359\n344#1:360,2\n*E\n"})
public final class JvmArgumentsKt {
    /*
     * Unable to fully structure code
     */
    public static final void setupJvmSpecificArguments(@NotNull CompilerConfiguration $this$setupJvmSpecificArguments, @NotNull K2JVMCompilerArguments arguments) {
        block40: {
            block39: {
                block37: {
                    Intrinsics.checkNotNullParameter($this$setupJvmSpecificArguments, "<this>");
                    Intrinsics.checkNotNullParameter(arguments, "arguments");
                    $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.INCLUDE_RUNTIME, arguments.getIncludeRuntime());
                    $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.NO_REFLECT, arguments.getNoReflect());
                    v0 = arguments.getFriendPaths();
                    $this$setupJvmSpecificArguments.putIfNotNull(JVMConfigurationKeys.FRIEND_PATHS, v0 != null ? ArraysKt.asList(v0) : null);
                    releaseTargetArg = arguments.getJdkRelease();
                    jvmTargetArg = arguments.getJvmTarget();
                    if (releaseTargetArg == null) break block37;
                    var5_4 = releaseTargetArg;
                    tmp = -1;
                    switch (var5_4.hashCode()) {
                        case 48569: {
                            if (var5_4.equals("1.6")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 48570: {
                            if (var5_4.equals("1.7")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 48571: {
                            if (var5_4.equals("1.8")) {
                                tmp = 3;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v1 = 6;
                            break;
                        }
                        case 2: {
                            v1 = 7;
                            break;
                        }
                        case 3: {
                            v1 = 8;
                            break;
                        }
                        default: {
                            v1 = value = StringsKt.toIntOrNull(releaseTargetArg);
                        }
                    }
                    if (value == null || value < 6) {
                        MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown JDK release version: " + releaseTargetArg, null, 4, null);
                    } else {
                        var5_5 = JvmArgumentsKt.getJavaVersion();
                        if (value != var5_5 || arguments.getJdkHome() != null) {
                            $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.JDK_RELEASE, value);
                        }
                        if (jvmTargetArg != null && !JvmArgumentsKt.isCompatibleJvmTargetAndRelease(jvmTargetArg, releaseTargetArg)) {
                            suggestion = value < 8 ? "Please change the value of the 'jvm-target' option to 1.8" : "Please remove the '-jvm-target' option";
                            MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "'-Xjdk-release=" + releaseTargetArg + "' option conflicts with '-jvm-target " + jvmTargetArg + "'. " + suggestion, null, 4, null);
                        }
                    }
                }
                v2 = suggestion = releaseTargetArg;
                if (v2 == null) break block39;
                switch (v2.hashCode()) {
                    case 54: {
                        if (!suggestion.equals("6")) {
                            ** break;
                        }
                        ** GOTO lbl72
                    }
                    case 55: {
                        if (!suggestion.equals("7")) {
                            ** break;
                        }
                        ** GOTO lbl72
                    }
                    case 56: {
                        if (suggestion.equals("8")) break;
                        ** break;
                    }
                    case 48569: {
                        if (!suggestion.equals("1.6")) {
                            ** break;
                        }
                        ** GOTO lbl72
                    }
                    case 48570: {
                        if (!suggestion.equals("1.7")) ** break;
lbl72:
                        // 4 sources

                        if (jvmTargetArg == null) {
                            MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "'-Xjdk-release=" + releaseTargetArg + "' option requires JVM target explicitly set to 1.8. Please specify the '-jvm-target' option", null, 4, null);
                        }
                        v3 = jvmTargetArg;
                        break block40;
                    }
                }
                v3 = "1.8";
                break block40;
            }
            v3 = jvmTargetArg;
            break block40;
lbl81:
            // 6 sources

            v3 = jvmTargetValue = releaseTargetArg;
        }
        if (jvmTargetValue != null) {
            jvmTarget = JvmTarget.Companion.fromString(jvmTargetValue);
            if (jvmTarget != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
                if (jvmTarget == JvmTarget.JVM_1_6) {
                    MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "JVM target 1.6 is no longer supported. Please migrate to JVM target 1.8 or above", null, 4, null);
                }
            } else {
                MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + jvmTargetValue + "\nSupported versions: " + CollectionsKt.joinToString$default(JvmTarget.Companion.supportedValues(), null, null, null, 0, null, (Function1<JvmTarget, CharSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, setupJvmSpecificArguments$lambda$0(org.jetbrains.kotlin.config.JvmTarget ), (Lorg/jetbrains/kotlin/config/JvmTarget;)Ljava/lang/CharSequence;)(), 31, null), null, 4, null);
            }
        }
        if ((v4 = $this$setupJvmSpecificArguments.get(JVMConfigurationKeys.JVM_TARGET)) == null) {
            v4 = jvmTarget = JvmTarget.DEFAULT;
        }
        if ((stringConcat = arguments.getStringConcat()) != null) {
            runtimeStringConcat = JvmStringConcat.Companion.fromString(stringConcat);
            if (runtimeStringConcat != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.STRING_CONCAT, runtimeStringConcat);
                if (jvmTarget.getMajorVersion() < JvmTarget.JVM_9.getMajorVersion() && runtimeStringConcat != JvmStringConcat.INLINE) {
                    MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.WARNING, "`-Xstring-concat=" + stringConcat + "` does nothing with JVM target `" + jvmTarget.getDescription() + "`.", null, 4, null);
                }
            } else {
                MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown `-Xstring-concat` mode: " + stringConcat + "\nSupported modes: " + CollectionsKt.joinToString$default(JvmStringConcat.getEntries(), null, null, null, 0, null, (Function1<JvmStringConcat, CharSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, setupJvmSpecificArguments$lambda$1(org.jetbrains.kotlin.config.JvmStringConcat ), (Lorg/jetbrains/kotlin/config/JvmStringConcat;)Ljava/lang/CharSequence;)(), 31, null), null, 4, null);
            }
        }
        JvmArgumentsKt.handleClosureGenerationSchemeArgument($this$setupJvmSpecificArguments, "-Xsam-conversions", arguments.getSamConversions(), JVMConfigurationKeys.SAM_CONVERSIONS);
        JvmArgumentsKt.handleClosureGenerationSchemeArgument($this$setupJvmSpecificArguments, "-Xlambdas", arguments.getLambdas(), JVMConfigurationKeys.LAMBDAS);
        v5 = arguments.getAdditionalJavaModules();
        $this$setupJvmSpecificArguments.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, (Collection)(v5 != null ? ArraysKt.asList(v5) : null));
    }

    private static final boolean isCompatibleJvmTargetAndRelease(String jvmTarget, String release) {
        if (Intrinsics.areEqual(jvmTarget, "1.8")) {
            String[] stringArray = new String[]{"6", "1.6", "7", "1.7", "8", "1.8"};
            return CollectionsKt.listOf(stringArray).contains(release);
        }
        return Intrinsics.areEqual(jvmTarget, release);
    }

    private static final void handleClosureGenerationSchemeArgument(CompilerConfiguration $this$handleClosureGenerationSchemeArgument, String flag, String value2, CompilerConfigurationKey<JvmClosureGenerationScheme> key) {
        if (value2 == null) {
            return;
        }
        JvmClosureGenerationScheme parsedValue = JvmClosureGenerationScheme.Companion.fromString(value2);
        if (parsedValue != null) {
            $this$handleClosureGenerationSchemeArgument.put(key, parsedValue);
        } else {
            MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$handleClosureGenerationSchemeArgument), CompilerMessageSeverity.ERROR, "Unknown `" + flag + "` argument: " + value2 + "\n.Supported arguments: " + CollectionsKt.joinToString$default(JvmClosureGenerationScheme.getEntries(), null, null, null, 0, null, JvmArgumentsKt::handleClosureGenerationSchemeArgument$lambda$2, 31, null), null, 4, null);
        }
    }

    public static final boolean configureJdkHome(@NotNull CompilerConfiguration $this$configureJdkHome, @NotNull K2JVMCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter($this$configureJdkHome, "<this>");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        if (arguments.getNoJdk()) {
            $this$configureJdkHome.put(JVMConfigurationKeys.NO_JDK, true);
            if (arguments.getJdkHome() != null) {
                MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
            }
            return true;
        }
        if (arguments.getJdkHome() != null) {
            String string2 = arguments.getJdkHome();
            Intrinsics.checkNotNull(string2);
            File jdkHome = new File(string2);
            if (!jdkHome.exists()) {
                MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.ERROR, "JDK home directory does not exist: " + jdkHome, null, 4, null);
                return false;
            }
            MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.LOGGING, "Using JDK home directory " + jdkHome, null, 4, null);
            $this$configureJdkHome.put(JVMConfigurationKeys.JDK_HOME, jdkHome);
        } else {
            JvmArgumentsKt.configureJdkHomeFromSystemProperty($this$configureJdkHome);
        }
        return true;
    }

    public static final void configureJdkHomeFromSystemProperty(@NotNull CompilerConfiguration $this$configureJdkHomeFromSystemProperty) {
        Intrinsics.checkNotNullParameter($this$configureJdkHomeFromSystemProperty, "<this>");
        File javaHome = new File(System.getProperty("java.home"));
        MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$configureJdkHomeFromSystemProperty), CompilerMessageSeverity.LOGGING, "Using JDK home inferred from java.home: " + javaHome, null, 4, null);
        $this$configureJdkHomeFromSystemProperty.put(JVMConfigurationKeys.JDK_HOME, javaHome);
    }

    public static final void configureJavaModulesContentRoots(@NotNull CompilerConfiguration $this$configureJavaModulesContentRoots, @NotNull K2JVMCompilerArguments arguments) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter($this$configureJavaModulesContentRoots, "<this>");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        String string2 = arguments.getJavaModulePath();
        if (string2 != null) {
            char[] cArray = new char[]{File.pathSeparatorChar};
            list2 = StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        for (String modularRoot : list) {
            $this$configureJavaModulesContentRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(modularRoot)));
        }
    }

    public static final void configureContentRootsFromClassPath(@NotNull CompilerConfiguration $this$configureContentRootsFromClassPath, @NotNull K2JVMCompilerArguments arguments) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter($this$configureContentRootsFromClassPath, "<this>");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        String string2 = arguments.getClasspath();
        if (string2 != null) {
            char[] cArray = new char[]{File.pathSeparatorChar};
            list2 = StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        for (String path : list) {
            $this$configureContentRootsFromClassPath.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(path)));
        }
    }

    public static final void configureStandardLibs(@NotNull CompilerConfiguration $this$configureStandardLibs, @Nullable KotlinPaths paths2, @NotNull K2JVMCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter($this$configureStandardLibs, "<this>");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        JvmArgumentsKt.configureStandardLibs($this$configureStandardLibs, paths2, configureStandardLibs.1.INSTANCE, configureStandardLibs.2.INSTANCE, configureStandardLibs.3.INSTANCE, arguments);
    }

    public static final <PathProvider> void configureStandardLibs(@NotNull CompilerConfiguration $this$configureStandardLibs, @Nullable PathProvider paths2, @NotNull Function1<? super PathProvider, ? extends File> stdlibPath, @NotNull Function1<? super PathProvider, ? extends File> scriptRuntimePath, @NotNull Function1<? super PathProvider, ? extends File> reflectPath, @NotNull K2JVMCompilerArguments arguments) {
        boolean isModularJava;
        Intrinsics.checkNotNullParameter($this$configureStandardLibs, "<this>");
        Intrinsics.checkNotNullParameter(stdlibPath, "stdlibPath");
        Intrinsics.checkNotNullParameter(scriptRuntimePath, "scriptRuntimePath");
        Intrinsics.checkNotNullParameter(reflectPath, "reflectPath");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        Integer jdkRelease = $this$configureStandardLibs.get(JVMConfigurationKeys.JDK_RELEASE);
        boolean bl = isModularJava = JvmArgumentsKt.isModularJava($this$configureStandardLibs) && (jdkRelease == null || jdkRelease >= 9);
        if (!arguments.getNoStdlib()) {
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths2, "kotlin.stdlib", "kotlin-stdlib.jar", stdlibPath, "'-no-stdlib'");
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths2, "kotlin.script.runtime", "kotlin-script-runtime.jar", scriptRuntimePath, "'-no-stdlib'");
        }
        if (!arguments.getNoReflect() && !arguments.getNoStdlib()) {
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths2, "kotlin.reflect", "kotlin-reflect.jar", reflectPath, "'-no-reflect' or '-no-stdlib'");
        }
    }

    public static final boolean isModularJava(@NotNull CompilerConfiguration $this$isModularJava) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isModularJava, "<this>");
        File file2 = $this$isModularJava.get(JVMConfigurationKeys.JDK_HOME);
        if (file2 != null) {
            File it = file2;
            boolean bl2 = false;
            bl = CoreJrtFileSystem.Companion.isModularJdk(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final void addModularRootIfNotNull(@NotNull CompilerConfiguration $this$addModularRootIfNotNull, boolean isModularJava, @NotNull String moduleName2, @Nullable File file2) {
        Intrinsics.checkNotNullParameter($this$addModularRootIfNotNull, "<this>");
        Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
        if (file2 != null) {
            if (isModularJava) {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file2));
                $this$addModularRootIfNotNull.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName2);
            } else {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file2));
            }
        }
    }

    public static final boolean registerJavacIfNeeded(@NotNull KotlinCoreEnvironment $this$registerJavacIfNeeded, @NotNull K2JVMCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter($this$registerJavacIfNeeded, "<this>");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        if (arguments.getUseJavac()) {
            $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            if (arguments.getCompileJava()) {
                $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, true);
            }
            return KotlinCoreEnvironment.registerJavac$default($this$registerJavacIfNeeded, null, null, arguments.getJavacArguments(), null, null, 27, null);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureAdvancedJvmOptions(@NotNull CompilerConfiguration $this$configureAdvancedJvmOptions, @NotNull K2JVMCompilerArguments arguments) {
        int nThreadsRaw;
        int nThreads;
        JVMAssertionsMode jVMAssertionsMode;
        Collection<String> collection;
        Collection destination$iv$iv;
        MessageCollector messageCollector;
        CompilerMessageSeverity compilerMessageSeverity;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$configureAdvancedJvmOptions, "<this>");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments.getJavaParameters());
        JvmAbiStability abiStability = JvmAbiStability.Companion.fromStringOrNull(arguments.getAbiStability());
        if (arguments.getAbiStability() != null) {
            if (abiStability == null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = JvmAbiStability.getEntries();
                stringBuilder = new StringBuilder().append("Unknown ABI stability mode: ").append(arguments.getAbiStability()).append(", supported modes: ");
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                messageCollector = CommonConfigurationKeysKt.getMessageCollector($this$configureAdvancedJvmOptions);
                boolean $i$f$map = false;
                void var5_9 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JvmAbiStability jvmAbiStability = (JvmAbiStability)((Object)item$iv$iv);
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getDescription());
                }
                collection = (List)destination$iv$iv;
                MessageCollector.report$default(messageCollector, compilerMessageSeverity, stringBuilder.append(collection).toString(), null, 4, null);
            } else {
                $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ABI_STABILITY, abiStability);
            }
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DO_NOT_CLEAR_BINDING_CONTEXT, arguments.getDoNotClearBindingContext());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments.getNoCallAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_RECEIVER_ASSERTIONS, arguments.getNoReceiverAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments.getNoParamAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments.getNoOptimize());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS, arguments.getEmitJvmTypeAnnotations());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_RESET_JAR_TIMESTAMPS, arguments.getNoResetJarTimestamps());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS, arguments.getNoUnifiedNullChecks());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_SOURCE_DEBUG_EXTENSION, arguments.getNoSourceDebugExtension());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.SERIALIZE_IR, JvmSerializeIrMode.Companion.fromString(arguments.getSerializeIr()));
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.VALIDATE_BYTECODE, arguments.getValidateBytecode());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.LINK_VIA_SIGNATURES, arguments.getLinkViaSignatures());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_DEBUG_MODE, arguments.getEnableDebugMode());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_NEW_JAVA_ANNOTATION_TARGETS, arguments.getNoNewJavaAnnotationTargets());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_IR_INLINER, arguments.getEnableIrInliner());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_INLINE_SCOPES_NUMBERS, arguments.getUseInlineScopesNumbers());
        JVMAssertionsMode assertionsMode = JVMAssertionsMode.Companion.fromStringOrNull(arguments.getAssertionsMode());
        if (assertionsMode == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $i$f$map = JVMAssertionsMode.getEntries();
            stringBuilder = new StringBuilder().append("Unknown assertions mode: ").append(arguments.getAssertionsMode()).append(", supported modes: ");
            compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            messageCollector = CommonConfigurationKeysKt.getMessageCollector($this$configureAdvancedJvmOptions);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JVMAssertionsMode bl = (JVMAssertionsMode)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getDescription());
            }
            collection = (List)destination$iv$iv2;
            MessageCollector.report$default(messageCollector, compilerMessageSeverity, stringBuilder.append(collection).toString(), null, 4, null);
        }
        if ((jVMAssertionsMode = assertionsMode) == null) {
            jVMAssertionsMode = JVMAssertionsMode.DEFAULT;
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ASSERTIONS_MODE, jVMAssertionsMode);
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_TYPE_TABLE, arguments.getUseTypeTable());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, arguments.getUseOldClassFilesReading());
        Boolean bl = arguments.getUseFastJarFileSystem();
        if (bl != null) {
            boolean it = bl;
            boolean bl3 = false;
            $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_FAST_JAR_FILE_SYSTEM, it);
        }
        if (arguments.getUseOldClassFilesReading()) {
            MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments.getAllowKotlinPackage());
        $this$configureAdvancedJvmOptions.put(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME, arguments.getRenderInternalDiagnosticNames());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME, arguments.getUseOldInlineClassesManglingScheme());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_JVM_PREVIEW, arguments.getEnableJvmPreview());
        if (arguments.getEnableJvmPreview()) {
            MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using preview Java language features", null, 4, null);
        }
        int n2 = nThreads = (nThreadsRaw = JvmArgumentsKt.parseBackendThreads(arguments.getBackendThreads(), CommonConfigurationKeysKt.getMessageCollector($this$configureAdvancedJvmOptions))) == 0 ? Runtime.getRuntime().availableProcessors() : nThreadsRaw;
        if (nThreads > 1) {
            MessageCollector.report$default(CommonConfigurationKeysKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.LOGGING, "Running backend in parallel with " + nThreads + " threads", null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(CommonConfigurationKeys.PARALLEL_BACKEND_THREADS, nThreads);
    }

    private static final int parseBackendThreads(String stringValue, MessageCollector messageCollector) {
        Integer value2 = StringsKt.toIntOrNull(stringValue);
        if (value2 == null) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cannot parse -Xbackend-threads value: \"" + stringValue + "\". Please use an integer number", null, 4, null);
            return 1;
        }
        if (value2 < 0) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "-Xbackend-threads value cannot be negative", null, 4, null);
            return 1;
        }
        return value2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureKlibPaths(@NotNull CompilerConfiguration $this$configureKlibPaths, @NotNull K2JVMCompilerArguments arguments) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter($this$configureKlibPaths, "<this>");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        String string2 = arguments.getKlibLibraries();
        if (string2 == null) {
            return;
        }
        String libraries = string2;
        Object object = libraries;
        String string3 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue(string3, "pathSeparator");
        Object object2 = string3;
        object2 = new Regex((String)object2);
        int n2 = 0;
        object = ((Regex)object2).split((CharSequence)object, n2);
        CompilerConfigurationKey<List<String>> compilerConfigurationKey = JVMConfigurationKeys.KLIB_PATHS;
        CompilerConfiguration compilerConfiguration = $this$configureKlibPaths;
        boolean $i$f$filterNot = false;
        void var5_7 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)p0).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        compilerConfiguration.put(compilerConfigurationKey, list);
    }

    private static final int getJavaVersion() {
        Object object = System.getProperty("java.specification.version");
        return object != null && (object = StringsKt.substringAfter$default((String)object, '.', null, 2, null)) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 6;
    }

    private static final CharSequence setupJvmSpecificArguments$lambda$0(JvmTarget it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDescription();
    }

    private static final CharSequence setupJvmSpecificArguments$lambda$1(JvmStringConcat it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getDescription();
    }

    private static final CharSequence handleClosureGenerationSchemeArgument$lambda$2(JvmClosureGenerationScheme it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getDescription();
    }

    private static final <PathProvider> void configureStandardLibs$addRoot(CompilerConfiguration $this_configureStandardLibs, boolean isModularJava, PathProvider $paths, String moduleName2, String libraryName2, Function1<? super PathProvider, ? extends File> getLibrary, String noLibraryArgument) {
        JvmArgumentsKt.addModularRootIfNotNull($this_configureStandardLibs, isModularJava, moduleName2, UtilsKt.getLibraryFromHome($paths, getLibrary, libraryName2, CommonConfigurationKeysKt.getMessageCollector($this_configureStandardLibs), noLibraryArgument));
    }
}

