/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.AbstractFirMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.AbstractMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.K1LegacyMetadataSerializerKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.comparators.FirMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirAdditionalMetadataProvider;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareSerializableStringTable;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.serialization.FirSerializerExtensionBase;
import org.jetbrains.kotlin.fir.serialization.TypeApproximatorForMetadataSerializer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.SerializableStringTable;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\"\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0014H\u0004R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer;", "Lorg/jetbrains/kotlin/cli/metadata/AbstractFirMetadataSerializer;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "totalSize", "", "getTotalSize", "()I", "setTotalSize", "(I)V", "totalFiles", "getTotalFiles", "setTotalFiles", "serialize", "Lorg/jetbrains/kotlin/cli/metadata/AbstractMetadataSerializer$OutputInfo;", "analysisResult", "", "Lorg/jetbrains/kotlin/fir/pipeline/ModuleCompilerAnalyzedOutput;", "destDir", "Ljava/io/File;", "collectPackagesContent", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageContent;", "firFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "PackageContent", "PackageSerializer", "FirLegacySerializerExtension", "cli"})
@SourceDebugExtension(value={"SMAP\nFirLegacyMetadataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,210:1\n384#2,7:211\n384#2,7:218\n384#2,7:225\n*S KotlinDebug\n*F\n+ 1 FirLegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer\n*L\n74#1:211,7\n102#1:218,7\n106#1:225,7\n*E\n"})
public class FirLegacyMetadataSerializer
extends AbstractFirMetadataSerializer {
    private int totalSize;
    private int totalFiles;

    public FirLegacyMetadataSerializer(@NotNull CompilerConfiguration configuration2, @NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(environment, "environment");
        super(configuration2, environment);
    }

    protected final int getTotalSize() {
        return this.totalSize;
    }

    protected final void setTotalSize(int n2) {
        this.totalSize = n2;
    }

    protected final int getTotalFiles() {
        return this.totalFiles;
    }

    protected final void setTotalFiles(int n2) {
        this.totalFiles = n2;
    }

    @Override
    @Nullable
    protected AbstractMetadataSerializer.OutputInfo serialize(@NotNull List<ModuleCompilerAnalyzedOutput> analysisResult, @NotNull File destDir) {
        JvmModuleProtoBuf.Module.Builder builder;
        Intrinsics.checkNotNullParameter(analysisResult, "analysisResult");
        Intrinsics.checkNotNullParameter(destDir, "destDir");
        ModuleCompilerAnalyzedOutput moduleCompilerAnalyzedOutput = CollectionsKt.single(analysisResult);
        FirSession session2 = moduleCompilerAnalyzedOutput.component1();
        ScopeSession scopeSession = moduleCompilerAnalyzedOutput.component2();
        List<FirFile> firFiles2 = moduleCompilerAnalyzedOutput.component3();
        Map<FqName, PackageContent> contentPerPackage = this.collectPackagesContent(firFiles2);
        Map packageTable = new LinkedHashMap();
        for (Map.Entry<FqName, PackageContent> entry : contentPerPackage.entrySet()) {
            FqName packageFqName = entry.getKey();
            PackageContent content = entry.getValue();
            List<FirRegularClass> classes = content.component1();
            Map<FirFile, List<FirMemberDeclaration>> membersPerFile = content.component2();
            for (FirRegularClass firRegularClass : classes) {
                File destFile = new File(destDir, K1LegacyMetadataSerializerKt.getClassFilePath(FirDeclarationUtilKt.getClassId(firRegularClass)));
                new PackageSerializer(packageFqName, CollectionsKt.listOf(firRegularClass), CollectionsKt.emptyList(), destFile, session2, scopeSession, this.getMetadataVersion()).serialize();
            }
            for (Map.Entry entry2 : membersPerFile.entrySet()) {
                Object object;
                FirFile file2 = (FirFile)entry2.getKey();
                List members = (List)entry2.getValue();
                File destFile = new File(destDir, K1LegacyMetadataSerializerKt.getPackageFilePath(packageFqName, file2.getName()));
                new PackageSerializer(packageFqName, CollectionsKt.emptyList(), members, destFile, session2, scopeSession, this.getMetadataVersion()).serialize();
                Map $this$getOrPut$iv = packageTable;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(packageFqName);
                if (value$iv == null) {
                    boolean bl = false;
                    PackageParts answer$iv = new PackageParts(packageFqName.asString());
                    $this$getOrPut$iv.put(packageFqName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((PackageParts)object).addMetadataPart(FilesKt.getNameWithoutExtension(destFile));
            }
        }
        File kotlinModuleFile = new File(destDir, JvmCodegenUtil.getMappingFileName(JvmCodegenUtil.prepareModuleName(FirModuleDataKt.getModuleData(session2).getName())));
        JvmModuleProtoBuf.Module.Builder $this$serialize_u24lambda_u241 = builder = JvmModuleProtoBuf.Module.newBuilder();
        boolean bl = false;
        for (PackageParts packageParts : packageTable.values()) {
            Intrinsics.checkNotNull($this$serialize_u24lambda_u241);
            packageParts.addTo($this$serialize_u24lambda_u241);
        }
        JvmModuleProtoBuf.Module module2 = builder.build();
        Intrinsics.checkNotNullExpressionValue(module2, "build(...)");
        byte[] packageTableBytes = ModuleMappingKt.serializeToByteArray(module2, MetadataVersion.INSTANCE, 0);
        kotlinModuleFile.getParentFile().mkdirs();
        FilesKt.writeBytes(kotlinModuleFile, packageTableBytes);
        return new AbstractMetadataSerializer.OutputInfo(this.totalSize, this.totalFiles);
    }

    @NotNull
    protected final Map<FqName, PackageContent> collectPackagesContent(@NotNull List<? extends FirFile> firFiles2) {
        Intrinsics.checkNotNullParameter(firFiles2, "firFiles");
        Map contentPerPackage = new LinkedHashMap();
        for (FirFile firFile : firFiles2) {
            FqName packageFqName = UtilsKt.getPackageFqName(firFile);
            for (FirDeclaration declaration : firFile.getDeclarations()) {
                Object object;
                Map $this$getOrPut$iv = contentPerPackage;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(packageFqName);
                if (value$iv == null) {
                    boolean bl = false;
                    PackageContent answer$iv = new PackageContent(null, null, 3, null);
                    $this$getOrPut$iv.put(packageFqName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                PackageContent content = (PackageContent)object;
                FirDeclaration firDeclaration = declaration;
                if (firDeclaration instanceof FirCallableDeclaration || firDeclaration instanceof FirTypeAlias) {
                    List list;
                    Map<FirFile, List<FirMemberDeclaration>> $this$getOrPut$iv2 = content.getMembersPerFile();
                    boolean $i$f$getOrPut2 = false;
                    List value$iv2 = $this$getOrPut$iv2.get(firFile);
                    if (value$iv2 == null) {
                        boolean bl = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(firFile, answer$iv);
                        list = answer$iv;
                    } else {
                        list = value$iv2;
                    }
                    Collection collection = list;
                    collection.add(declaration);
                    continue;
                }
                if (firDeclaration instanceof FirRegularClass) {
                    ((Collection)content.getClasses()).add(declaration);
                    continue;
                }
                throw new IllegalStateException(("Unexpected declaration: " + UtilsKt.render(declaration)).toString());
            }
        }
        return contentPerPackage;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$FirLegacySerializerExtension;", "Lorg/jetbrains/kotlin/fir/serialization/FirSerializerExtensionBase;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "getConstValueProvider", "()Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "additionalMetadataProvider", "Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "getAdditionalMetadataProvider", "()Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "shouldUseTypeTable", "", "cli"})
    public static final class FirLegacySerializerExtension
    extends FirSerializerExtensionBase {
        @NotNull
        private final FirSession session;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final BinaryVersion metadataVersion;

        public FirLegacySerializerExtension(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull BinaryVersion metadataVersion) {
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
            super(BuiltInSerializerProtocol.INSTANCE);
            this.session = session2;
            this.scopeSession = scopeSession;
            this.metadataVersion = metadataVersion;
        }

        @Override
        @NotNull
        public FirSession getSession() {
            return this.session;
        }

        @Override
        @NotNull
        public ScopeSession getScopeSession() {
            return this.scopeSession;
        }

        @Override
        @NotNull
        public BinaryVersion getMetadataVersion() {
            return this.metadataVersion;
        }

        @Override
        @Nullable
        public ConstValueProvider getConstValueProvider() {
            return null;
        }

        @Override
        @Nullable
        public FirAdditionalMetadataProvider getAdditionalMetadataProvider() {
            return null;
        }

        @Override
        public boolean shouldUseTypeTable() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B3\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001b\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006H\u00c6\u0003J5\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageContent;", "", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "membersPerFile", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "getClasses", "()Ljava/util/List;", "getMembersPerFile", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cli"})
    protected static final class PackageContent {
        @NotNull
        private final List<FirRegularClass> classes;
        @NotNull
        private final Map<FirFile, List<FirMemberDeclaration>> membersPerFile;

        public PackageContent(@NotNull List<FirRegularClass> classes, @NotNull Map<FirFile, List<FirMemberDeclaration>> membersPerFile) {
            Intrinsics.checkNotNullParameter(classes, "classes");
            Intrinsics.checkNotNullParameter(membersPerFile, "membersPerFile");
            this.classes = classes;
            this.membersPerFile = membersPerFile;
        }

        public /* synthetic */ PackageContent(List list, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                list = new ArrayList();
            }
            if ((n2 & 2) != 0) {
                map = new LinkedHashMap();
            }
            this(list, map);
        }

        @NotNull
        public final List<FirRegularClass> getClasses() {
            return this.classes;
        }

        @NotNull
        public final Map<FirFile, List<FirMemberDeclaration>> getMembersPerFile() {
            return this.membersPerFile;
        }

        @NotNull
        public final List<FirRegularClass> component1() {
            return this.classes;
        }

        @NotNull
        public final Map<FirFile, List<FirMemberDeclaration>> component2() {
            return this.membersPerFile;
        }

        @NotNull
        public final PackageContent copy(@NotNull List<FirRegularClass> classes, @NotNull Map<FirFile, List<FirMemberDeclaration>> membersPerFile) {
            Intrinsics.checkNotNullParameter(classes, "classes");
            Intrinsics.checkNotNullParameter(membersPerFile, "membersPerFile");
            return new PackageContent(classes, membersPerFile);
        }

        public static /* synthetic */ PackageContent copy$default(PackageContent packageContent, List list, Map map, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = packageContent.classes;
            }
            if ((n2 & 2) != 0) {
                map = packageContent.membersPerFile;
            }
            return packageContent.copy(list, map);
        }

        @NotNull
        public String toString() {
            return "PackageContent(classes=" + this.classes + ", membersPerFile=" + this.membersPerFile + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.classes).hashCode();
            result2 = result2 * 31 + ((Object)this.membersPerFile).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageContent)) {
                return false;
            }
            PackageContent packageContent = (PackageContent)other;
            if (!Intrinsics.areEqual(this.classes, packageContent.classes)) {
                return false;
            }
            return Intrinsics.areEqual(this.membersPerFile, packageContent.membersPerFile);
        }

        public PackageContent() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010)\u001a\u00020*J\u001e\u0010+\u001a\u00020*2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010,\u001a\u00020(H\u0002J\b\u0010-\u001a\u00020*H\u0002J\b\u0010.\u001a\u00020*H\u0002J\b\u0010/\u001a\u00020*H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u00101\u001a\u000202H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageSerializer;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "members", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "destFile", "Ljava/io/File;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "<init>", "(Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer;Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;Ljava/util/List;Ljava/io/File;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getClasses", "()Ljava/util/List;", "getMembers", "getDestFile", "()Ljava/io/File;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "extension", "Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$FirLegacySerializerExtension;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment$Builder;", "kotlin.jvm.PlatformType", "typeApproximator", "Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "rootSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "serialize", "", "serializeClasses", "parentSerializer", "serializeMembers", "serializeStringTable", "serializeBuiltInsFile", "write", "stream", "Ljava/io/ByteArrayOutputStream;", "cli"})
    @SourceDebugExtension(value={"SMAP\nFirLegacyMetadataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1563#2:211\n1634#2,3:212\n13493#3,2:215\n1#4:217\n*S KotlinDebug\n*F\n+ 1 FirLegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageSerializer\n*L\n151#1:211\n151#1:212,3\n183#1:215,2\n*E\n"})
    protected final class PackageSerializer {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final List<FirRegularClass> classes;
        @NotNull
        private final List<FirMemberDeclaration> members;
        @NotNull
        private final File destFile;
        @NotNull
        private final FirSession session;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final FirLegacySerializerExtension extension;
        private final ProtoBuf.PackageFragment.Builder proto;
        @NotNull
        private final TypeApproximatorForMetadataSerializer typeApproximator;
        @NotNull
        private final FirElementSerializer rootSerializer;

        public PackageSerializer(@NotNull FqName packageFqName, @NotNull List<? extends FirRegularClass> classes, @NotNull List<? extends FirMemberDeclaration> members, @NotNull File destFile, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, BinaryVersion metadataVersion) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(classes, "classes");
            Intrinsics.checkNotNullParameter(members, "members");
            Intrinsics.checkNotNullParameter(destFile, "destFile");
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
            this.packageFqName = packageFqName;
            this.classes = classes;
            this.members = members;
            this.destFile = destFile;
            this.session = session2;
            this.scopeSession = scopeSession;
            this.extension = new FirLegacySerializerExtension(this.session, this.scopeSession, metadataVersion);
            this.proto = ProtoBuf.PackageFragment.newBuilder();
            this.typeApproximator = new TypeApproximatorForMetadataSerializer(this.session);
            this.rootSerializer = FirElementSerializer.Companion.createTopLevel$default(FirElementSerializer.Companion, this.session, this.scopeSession, this.extension, this.typeApproximator, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session), false, 32, null);
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final List<FirRegularClass> getClasses() {
            return this.classes;
        }

        @NotNull
        public final List<FirMemberDeclaration> getMembers() {
            return this.members;
        }

        @NotNull
        public final File getDestFile() {
            return this.destFile;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final ScopeSession getScopeSession() {
            return this.scopeSession;
        }

        @NotNull
        public final TypeApproximatorForMetadataSerializer getTypeApproximator() {
            return this.typeApproximator;
        }

        public final void serialize() {
            this.serializeClasses(this.classes, this.rootSerializer);
            this.serializeMembers();
            this.serializeStringTable();
            this.serializeBuiltInsFile();
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeClasses(List<? extends FirRegularClass> classes, FirElementSerializer parentSerializer) {
            for (FirRegularClass klass : CollectionsKt.sortedWith((Iterable)classes, FirMemberDeclarationComparator.INSTANCE)) {
                void $this$mapTo$iv$iv;
                FirElementSerializer classSerializer = FirElementSerializer.Companion.create$default(FirElementSerializer.Companion, this.session, this.scopeSession, klass, this.extension, parentSerializer, this.typeApproximator, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session), false, 128, null);
                Iterable $this$map$iv = classSerializer.computeNestedClassifiersForClass(klass.getSymbol());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirClassifierSymbol firClassifierSymbol = (FirClassifierSymbol)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object e2 = it.getFir();
                    Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
                    collection.add((FirRegularClass)e2);
                }
                List nestedClasses = (List)destination$iv$iv;
                if (!((Collection)nestedClasses).isEmpty()) {
                    this.serializeClasses(nestedClasses, classSerializer);
                }
                FirFile file2 = FirProviderKt.getFirProvider(this.session).getFirClassifierContainerFileIfAny(klass.getSymbol());
                ProtoBuf.Class.Builder classProto = classSerializer.classProto(klass, file2);
                this.proto.addClass_(classProto.build());
            }
        }

        private final void serializeMembers() {
            ProtoBuf.Package.Builder packagePartProto2 = this.rootSerializer.packagePartProto(this.packageFqName, CollectionsKt.sortedWith((Iterable)this.members, FirMemberDeclarationComparator.INSTANCE), null);
            this.proto.setPackage(packagePartProto2.build());
        }

        private final void serializeStringTable() {
            FirElementAwareSerializableStringTable firElementAwareSerializableStringTable = this.extension.getStringTable();
            Object object = firElementAwareSerializableStringTable instanceof SerializableStringTable ? (SerializableStringTable)firElementAwareSerializableStringTable : null;
            if (object == null || (object = ((SerializableStringTable)object).buildProto()) == null) {
                return;
            }
            Object object2 = object;
            ProtoBuf.StringTable strings2 = (ProtoBuf.StringTable)((Pair)object2).component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)((Pair)object2).component2();
            this.proto.setStrings(strings2);
            this.proto.setQualifiedNames(qualifiedNames);
        }

        private final void serializeBuiltInsFile() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream $this$serializeBuiltInsFile_u24lambda_u242 = new DataOutputStream(stream);
            boolean bl = false;
            int[] version2 = this.extension.getMetadataVersion().toArray();
            $this$serializeBuiltInsFile_u24lambda_u242.writeInt(version2.length);
            int[] $this$forEach$iv = version2;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int element$iv;
                int it = element$iv = $this$forEach$iv[i2];
                boolean bl2 = false;
                $this$serializeBuiltInsFile_u24lambda_u242.writeInt(it);
            }
            this.proto.build().writeTo(stream);
            this.write(stream);
        }

        private final void write(ByteArrayOutputStream stream) {
            FirLegacyMetadataSerializer.this.setTotalSize(FirLegacyMetadataSerializer.this.getTotalSize() + stream.size());
            int n2 = FirLegacyMetadataSerializer.this.getTotalFiles();
            FirLegacyMetadataSerializer.this.setTotalFiles(n2 + 1);
            int n3 = n2 = !this.destFile.isDirectory() ? 1 : 0;
            if (_Assertions.ENABLED && n2 == 0) {
                boolean bl = false;
                String string2 = "Cannot write because output destination is a directory: " + this.destFile;
                throw new AssertionError((Object)string2);
            }
            this.destFile.getParentFile().mkdirs();
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            FilesKt.writeBytes(this.destFile, byArray);
        }
    }
}

