/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInfixFunctionDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasExtensionOrDispatchReceiver", "", "function", "checkers"})
public final class FirInfixFunctionDeclarationChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirInfixFunctionDeclarationChecker INSTANCE = new FirInfixFunctionDeclarationChecker();

    private FirInfixFunctionDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!declaration.getStatus().isInfix()) {
            return;
        }
        if (declaration.getValueParameters().size() != 1 || !this.hasExtensionOrDispatchReceiver(declaration, context2) || CollectionsKt.single(declaration.getValueParameters()).isVararg()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_INFIX_MODIFIER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean hasExtensionOrDispatchReceiver(FirFunction function2, CheckerContext context2) {
        if (function2.getReceiverParameter() != null) {
            return true;
        }
        return CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirClass;
    }
}

