/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.experimental;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/experimental/EmptyRangeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "rangeLeft", "", "getRangeLeft", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Ljava/lang/Long;", "rangeRight", "getRangeRight", "checkers"})
public final class EmptyRangeChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final EmptyRangeChecker INSTANCE = new EmptyRangeChecker();

    private EmptyRangeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean needReport;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Long l2 = this.getRangeLeft(expression2);
        if (l2 == null) {
            return;
        }
        long left = l2;
        Long l3 = this.getRangeRight(expression2);
        if (l3 == null) {
            return;
        }
        long right = l3;
        switch (expression2.getCalleeReference().getName().asString()) {
            case "rangeTo": {
                boolean bl;
                if (left > right) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "downTo": {
                boolean bl;
                if (right > left) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "until": {
                boolean bl;
                if (left >= right) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = needReport = false;
            }
        }
        if (needReport) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getEMPTY_RANGE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final Long getRangeLeft(FirFunctionCall $this$rangeLeft) {
        FirExpression firExpression = $this$rangeLeft.getExplicitReceiver();
        FirLiteralExpression firLiteralExpression = firExpression instanceof FirLiteralExpression ? (FirLiteralExpression)firExpression : null;
        Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        return object instanceof Long ? (Long)object : null;
    }

    private final Long getRangeRight(FirFunctionCall $this$rangeRight) {
        FirLiteralExpression arg;
        Object object = CollectionsKt.getOrNull($this$rangeRight.getArgumentList().getArguments(), 0);
        FirLiteralExpression firLiteralExpression = arg = object instanceof FirLiteralExpression ? (FirLiteralExpression)object : null;
        object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
        return object instanceof Long ? (Long)object : null;
    }
}

