/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.JvmFieldApplicabilityProblem;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u000e*\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u000e*\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u0002H\u0002J\u0014\u0010\u0017\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0019\u001a\u00020\u000e*\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isInlineClassThatRequiresMangling", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isDontMangleClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "isOverridable", "containingClass", "hasCustomAccessor", "isInsideCompanionObjectOfInterface", "isInterfaceCompanionWithPublicJvmFieldProperties", "hasJvmFieldAnnotation", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "isInsideJvmMultifileClassFile", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmFieldApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmFieldApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n21#2:157\n37#2:158\n55#2:159\n54#2:160\n21#2:166\n11#2:167\n59#3:161\n53#3,4:162\n42#3:168\n65#3:169\n18#3:170\n13#3:171\n1761#4,3:172\n*S KotlinDebug\n*F\n+ 1 FirJvmFieldApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmFieldApplicabilityChecker\n*L\n53#1:157\n55#1:158\n56#1:159\n57#1:160\n112#1:166\n112#1:167\n104#1:161\n104#1:162,4\n113#1:168\n122#1:169\n134#1:170\n134#1:171\n151#1:172,3\n*E\n"})
public final class FirJvmFieldApplicabilityChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirJvmFieldApplicabilityChecker INSTANCE = new FirJvmFieldApplicabilityChecker();

    private FirJvmFieldApplicabilityChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtDiagnosticFactory1<String> ktDiagnosticFactory1;
        JvmFieldApplicabilityProblem jvmFieldApplicabilityProblem;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSession session2 = context2.getSession();
        FirPureAbstractElement firPureAbstractElement = declaration.getBackingField();
        if (firPureAbstractElement == null || (firPureAbstractElement = FirAnnotationUtilsKt.getAnnotationByClassId((FirAnnotationContainer)((Object)firPureAbstractElement), JvmAbi.JVM_FIELD_ANNOTATION_CLASS_ID, session2)) == null) {
            return;
        }
        FirPureAbstractElement annotation = firPureAbstractElement;
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(declaration);
        FirRegularClassSymbol containingClassSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, session2) : null;
        if (declaration.getDelegate() != null) {
            jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.DELEGATE;
        } else {
            if (!DeclarationAttributesKt.getHasBackingField(declaration)) {
                return;
            }
            if (this.isOverridable(declaration, containingClassSymbol)) {
                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.NOT_FINAL;
            } else {
                FirMemberDeclaration $this$visibility$iv = declaration;
                boolean $i$f$getVisibility = false;
                if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.PRIVATE;
                } else if (this.hasCustomAccessor(declaration)) {
                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.CUSTOM_ACCESSOR;
                } else {
                    FirMemberDeclaration $this$isOverride$iv = declaration;
                    boolean $i$f$isOverride = false;
                    if ($this$isOverride$iv.getStatus().isOverride()) {
                        jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.OVERRIDES;
                    } else {
                        FirMemberDeclaration $this$isLateInit$iv = declaration;
                        boolean $i$f$isLateInit = false;
                        if ($this$isLateInit$iv.getStatus().isLateInit()) {
                            jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.LATEINIT;
                        } else {
                            FirMemberDeclaration $this$isConst$iv = declaration;
                            boolean $i$f$isConst = false;
                            if ($this$isConst$iv.getStatus().isConst()) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.CONST;
                            } else if (containingClassSymbol != null && this.isInsideCompanionObjectOfInterface(containingClassSymbol, session2)) {
                                if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.JvmFieldInInterface)) {
                                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.INSIDE_COMPANION_OF_INTERFACE;
                                } else {
                                    if (this.isInterfaceCompanionWithPublicJvmFieldProperties(containingClassSymbol, session2)) return;
                                    jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.NOT_PUBLIC_VAL_WITH_JVMFIELD;
                                }
                            } else if (containingClassSymbol == null && this.isInsideJvmMultifileClassFile(context2)) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
                            } else if (this.isInlineClassThatRequiresMangling(declaration.getReturnTypeRef(), session2)) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.RETURN_TYPE_IS_VALUE_CLASS;
                            } else if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(declaration.getReturnTypeRef(), session2)) {
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.RETURN_TYPE_IS_VALUE_CLASS;
                            } else {
                                FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol;
                                if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) != ClassKind.ANNOTATION_CLASS) return;
                                jvmFieldApplicabilityProblem = JvmFieldApplicabilityProblem.ANNOTATION;
                            }
                        }
                    }
                }
            }
        }
        JvmFieldApplicabilityProblem problem = jvmFieldApplicabilityProblem;
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        if (Intrinsics.areEqual(DeclarationAttributesKt.getFromPrimaryConstructor(declaration), true) && !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitJvmFieldOnOverrideFromInterfaceInPrimaryConstructor)) {
            ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD_WARNING();
        } else if (problem == JvmFieldApplicabilityProblem.ANNOTATION) {
            if (!languageVersionSettings.supportsFeature(LanguageFeature.ForbidJvmAnnotationsOnAnnotationParameters)) {
                ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD_WARNING();
            } else {
                if (languageVersionSettings.supportsFeature(LanguageFeature.ForbidFieldAnnotationsOnAnnotationParameters)) {
                    return;
                }
                ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD();
            }
        } else {
            ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_FIELD();
        }
        KtDiagnosticFactory1<String> factory = ktDiagnosticFactory1;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirAnnotation)annotation).getSource(), factory, (Object)problem.getErrorMessage(), (DiagnosticContext)context2, null, 16, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInlineClassThatRequiresMangling(FirTypeRef $this$isInlineClassThatRequiresMangling, FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType($this$isInlineClassThatRequiresMangling), session2);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$isInlineOrValue$iv = symbol;
        boolean $i$f$isInlineOrValue = false;
        FirClassLikeSymbol $this$isInline$iv$iv = $this$isInlineOrValue$iv;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv$iv.getRawStatus().isInline()) {
            FirClassLikeSymbol $this$isValue$iv$iv = $this$isInlineOrValue$iv;
            boolean $i$f$isValue = false;
            if (!$this$isValue$iv$iv.getRawStatus().isValue()) return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (this.isDontMangleClass(symbol)) return false;
        return true;
    }

    private final boolean isDontMangleClass(FirRegularClassSymbol $this$isDontMangleClass) {
        return Intrinsics.areEqual($this$isDontMangleClass.getClassId(), StandardClassIds.INSTANCE.getResult());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOverridable(FirProperty $this$isOverridable, FirRegularClassSymbol containingClass) {
        FirMemberDeclaration $this$visibility$iv = $this$isOverridable;
        boolean $i$f$getVisibility = false;
        if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) return false;
        FirMemberDeclaration $this$modality$iv = $this$isOverridable;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) return false;
        FirRegularClassSymbol firRegularClassSymbol = containingClass;
        if (firRegularClassSymbol == null) return true;
        FirClassLikeSymbol $this$isFinal$iv = firRegularClassSymbol;
        boolean $i$f$isFinal = false;
        if ($this$isFinal$iv.getResolvedStatus().getModality() != Modality.FINAL) return true;
        return false;
    }

    private final boolean hasCustomAccessor(FirProperty $this$hasCustomAccessor) {
        Object object;
        Object object2;
        return $this$hasCustomAccessor.getGetter() != null && !(((object2 = $this$hasCustomAccessor.getGetter()) != null && (object2 = ((FirPropertyAccessor)object2).getSource()) != null ? ((KtSourceElement)object2).getKind() : null) instanceof KtFakeSourceElementKind) || $this$hasCustomAccessor.getSetter() != null && !(((object = $this$hasCustomAccessor.getSetter()) != null && (object = ((FirPropertyAccessor)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtFakeSourceElementKind);
    }

    private final boolean isInsideCompanionObjectOfInterface(FirRegularClassSymbol $this$isInsideCompanionObjectOfInterface, FirSession session2) {
        FirClassLikeSymbol $this$isCompanion$iv = $this$isInsideCompanionObjectOfInterface;
        boolean $i$f$isCompanion = false;
        if (!$this$isCompanion$iv.getRawStatus().isCompanion()) {
            return false;
        }
        FirClassLikeSymbol<FirClassLikeDeclaration> firClassLikeSymbol = org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt.getContainingDeclaration($this$isInsideCompanionObjectOfInterface, session2);
        ClassKind outerClassKind = firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null;
        return outerClassKind == ClassKind.INTERFACE || outerClassKind == ClassKind.ANNOTATION_CLASS;
    }

    private final boolean isInterfaceCompanionWithPublicJvmFieldProperties(FirRegularClassSymbol containingClass, FirSession session2) {
        for (FirBasedSymbol<?> symbol : containingClass.getDeclarationSymbols()) {
            block4: {
                block3: {
                    if (!(symbol instanceof FirPropertySymbol)) continue;
                    FirCallableSymbol $this$visibility$iv = (FirCallableSymbol)symbol;
                    boolean $i$f$getVisibility = false;
                    if (!Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Public.INSTANCE) || ((FirPropertySymbol)symbol).isVar()) break block3;
                    FirCallableSymbol $this$modality$iv = (FirCallableSymbol)symbol;
                    boolean $i$f$getModality = false;
                    if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) break block4;
                }
                return false;
            }
            if (this.hasJvmFieldAnnotation((FirPropertySymbol)symbol, session2)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasJvmFieldAnnotation(FirPropertySymbol $this$hasJvmFieldAnnotation, FirSession session2) {
        FirBackingFieldSymbol firBackingFieldSymbol = $this$hasJvmFieldAnnotation.getBackingFieldSymbol();
        return (firBackingFieldSymbol != null ? FirAnnotationUtilsKt.getAnnotationByClassId(firBackingFieldSymbol, JvmAbi.JVM_FIELD_ANNOTATION_CLASS_ID, session2) : null) != null;
    }

    private final boolean isInsideJvmMultifileClassFile(CheckerContext context2) {
        boolean bl;
        Object object = context2.getContainingFile();
        if (object != null && (object = ((FirFile)object).getAnnotations()) != null) {
            boolean bl2;
            block5: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef())), JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS_ID())) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }
}

