/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.RequiresOptIn;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0012\u001a\u00020\u0011H\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "", "<init>", "()V", "remapper", "Lorg/jetbrains/kotlin/ir/util/SymbolRemapper;", "value", "", "generation", "getGeneration", "()I", "remapFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "symbol", "remapPropertySymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "initializeRemapper", "", "unregisterRemapper", "SymbolRemapperInternals", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrSymbolsMappingForLazyClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrSymbolsMappingForLazyClasses.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class Fir2IrSymbolsMappingForLazyClasses {
    @Nullable
    private SymbolRemapper remapper;
    private int generation;

    public final int getGeneration() {
        return this.generation;
    }

    @NotNull
    public final IrSimpleFunctionSymbol remapFunctionSymbol(@NotNull IrSimpleFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Object object = this.remapper;
        if (object == null || (object = object.getReferencedSimpleFunction(symbol)) == null) {
            object = symbol;
        }
        return object;
    }

    @NotNull
    public final IrPropertySymbol remapPropertySymbol(@NotNull IrPropertySymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Object object = this.remapper;
        if (object == null || (object = object.getReferencedProperty(symbol)) == null) {
            object = symbol;
        }
        return object;
    }

    @SymbolRemapperInternals
    public final void initializeRemapper(@NotNull SymbolRemapper remapper2) {
        Intrinsics.checkNotNullParameter(remapper2, "remapper");
        if (!(this.remapper == null)) {
            boolean bl = false;
            String string2 = "Remapper already initialized";
            throw new IllegalArgumentException(string2.toString());
        }
        this.remapper = remapper2;
        int n2 = this.generation;
        this.generation = n2 + 1;
    }

    @SymbolRemapperInternals
    public final void unregisterRemapper() {
        if (this.remapper == null) {
            boolean bl = false;
            String string2 = "Remapper was already disposed";
            throw new IllegalArgumentException(string2.toString());
        }
        this.remapper = null;
        int n2 = this.generation;
        this.generation = n2 + 1;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses$SymbolRemapperInternals;", "", "fir2ir"})
    @RequiresOptIn
    public static @interface SymbolRemapperInternals {
    }
}

