/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.RequiresOptIn;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirSmartCastExpressionBuilder;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirThisOwnerSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.types.SmartcastStability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0006\u0012\u0002\b\u00030\u00032\u00020\u0004:\u0001%B\u0019\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H$J\u0006\u0010\u001e\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010$\u001a\u00020\bH&R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001b\u0010\u0017\u001a\u00020\u00168DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002&'\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue;", "S", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirThisOwnerSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "mutable", "", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Z)V", "getMutable", "()Z", "boundSymbol", "getBoundSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "value", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "originalType", "getOriginalType", "computeOriginalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "originalExpression", "getOriginalExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "originalExpression$delegate", "Lkotlin/Lazy;", "isSmartCasted", "cachedCurrentExpression", "computeExpression", "isSameImplicitReceiverInstance", "other", "updateTypeFromSmartcast", "", "createSnapshot", "keepMutable", "ImplicitValueInternals", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitContextParameterValue;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "providers"})
@SourceDebugExtension(value={"SMAP\nImplicitValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImplicitValue.kt\norg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSmartCastExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSmartCastExpressionBuilderKt\n+ 4 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 5 FirReferenceUtils.kt\norg/jetbrains/kotlin/fir/references/FirReferenceUtilsKt\n*L\n1#1,146:1\n1#2:147\n62#3:148\n49#4:149\n24#5,8:150\n*S KotlinDebug\n*F\n+ 1 ImplicitValue.kt\norg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue\n*L\n81#1:148\n83#1:149\n103#1:150,8\n*E\n"})
public abstract class ImplicitValue<S extends FirBasedSymbol<?>> {
    private final boolean mutable;
    @NotNull
    private ConeKotlinType type;
    @NotNull
    private final ConeKotlinType originalType;
    @NotNull
    private final Lazy originalExpression$delegate;
    private boolean isSmartCasted;
    @Nullable
    private FirExpression cachedCurrentExpression;

    private ImplicitValue(ConeKotlinType type2, boolean mutable) {
        this.mutable = mutable;
        this.type = type2;
        this.originalType = type2;
        this.originalExpression$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)new Function0<FirExpression>((Object)this){

            public final FirExpression invoke() {
                return ((ImplicitValue)this.receiver).computeOriginalExpression();
            }
        });
    }

    protected final boolean getMutable() {
        return this.mutable;
    }

    @NotNull
    public abstract S getBoundSymbol();

    @NotNull
    public final ConeKotlinType getType() {
        return this.type;
    }

    @NotNull
    public final ConeKotlinType getOriginalType() {
        return this.originalType;
    }

    @NotNull
    protected abstract FirExpression computeOriginalExpression();

    @NotNull
    protected final FirExpression getOriginalExpression() {
        Lazy lazy = this.originalExpression$delegate;
        return (FirExpression)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirExpression computeExpression() {
        FirExpression firExpression;
        FirExpression firExpression2 = this.cachedCurrentExpression;
        if (firExpression2 != null) {
            FirExpression it = firExpression2;
            boolean bl = false;
            return it;
        }
        if (this.isSmartCasted) {
            void $this$computeExpression_u24lambda_u242_u24lambda_u241;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirSmartCastExpressionBuilder firSmartCastExpressionBuilder;
            boolean $i$f$buildSmartCastExpression = false;
            FirSmartCastExpressionBuilder $this$computeExpression_u24lambda_u242 = firSmartCastExpressionBuilder = new FirSmartCastExpressionBuilder();
            boolean bl = false;
            $this$computeExpression_u24lambda_u242.setOriginalExpression(this.getOriginalExpression());
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            FirSmartCastExpressionBuilder firSmartCastExpressionBuilder2 = $this$computeExpression_u24lambda_u242;
            boolean bl2 = false;
            KtSourceElement ktSourceElement = this.getOriginalExpression().getSource();
            $this$computeExpression_u24lambda_u242_u24lambda_u241.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.SmartCastedTypeRef.INSTANCE, 0, 0, 6, null) : null);
            $this$computeExpression_u24lambda_u242_u24lambda_u241.setConeType(this.type);
            firSmartCastExpressionBuilder2.setSmartcastType(firResolvedTypeRefBuilder.build());
            $this$computeExpression_u24lambda_u242.setTypesFromSmartCast((Collection<? extends ConeKotlinType>)CollectionsKt.listOf(this.type));
            $this$computeExpression_u24lambda_u242.setSmartcastStability(SmartcastStability.STABLE_VALUE);
            $this$computeExpression_u24lambda_u242.setConeTypeOrNull(this.type);
            firExpression = firSmartCastExpressionBuilder.build();
        } else {
            firExpression = this.getOriginalExpression();
        }
        FirExpression it = firExpression2 = firExpression;
        boolean bl = false;
        this.cachedCurrentExpression = it;
        return firExpression2;
    }

    public final boolean isSameImplicitReceiverInstance(@NotNull FirExpression other) {
        FirBasedSymbol<Object> firBasedSymbol;
        FirExpression otherOriginal;
        Intrinsics.checkNotNullParameter(other, "other");
        FirExpression firExpression = otherOriginal = FirExpressionUtilKt.unwrapSmartcastExpression(other);
        if (firExpression instanceof FirThisReceiverExpression) {
            firBasedSymbol = ((FirThisReceiverExpression)otherOriginal).getCalleeReference().getBoundSymbol();
        } else if (firExpression instanceof FirPropertyAccessExpression) {
            FirReference $this$toResolvedSymbol_u24default$iv = ((FirPropertyAccessExpression)otherOriginal).getCalleeReference();
            boolean discardErrorReference$iv = false;
            boolean $i$f$toResolvedSymbol = false;
            FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$toResolvedSymbol_u24default$iv);
            firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            if (!(firBasedSymbol instanceof FirBasedSymbol)) {
                firBasedSymbol = null;
            }
        } else {
            firBasedSymbol = null;
        }
        FirThisOwnerSymbol<?> otherBoundSymbol = firBasedSymbol;
        return this.getBoundSymbol() == otherBoundSymbol;
    }

    @ImplicitValueInternals
    public void updateTypeFromSmartcast(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (Intrinsics.areEqual(type2, this.type)) {
            return;
        }
        if (!this.mutable) {
            throw new IllegalStateException("Cannot mutate an immutable ImplicitReceiverValue".toString());
        }
        this.type = type2;
        this.isSmartCasted = !Intrinsics.areEqual(type2, this.originalType);
        this.cachedCurrentExpression = null;
    }

    @NotNull
    public abstract ImplicitValue<S> createSnapshot(boolean var1);

    public /* synthetic */ ImplicitValue(ConeKotlinType type2, boolean mutable, DefaultConstructorMarker $constructor_marker) {
        this(type2, mutable);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue$ImplicitValueInternals;", "", "providers"})
    @RequiresOptIn
    public static @interface ImplicitValueInternals {
    }
}

