/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.AbiSnapshotImpl;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.util.ExceptionLocation;
import org.jetbrains.kotlin.incremental.util.MessageCollectorUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildInfo;", "Ljava/io/Serializable;", "startTS", "", "dependencyToAbiSnapshot", "", "", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "<init>", "(JLjava/util/Map;)V", "getStartTS", "()J", "getDependencyToAbiSnapshot", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "incremental-compilation-impl"})
public final class BuildInfo
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long startTS;
    @NotNull
    private final Map<String, AbiSnapshot> dependencyToAbiSnapshot;

    public BuildInfo(long startTS, @NotNull Map<String, ? extends AbiSnapshot> dependencyToAbiSnapshot) {
        Intrinsics.checkNotNullParameter(dependencyToAbiSnapshot, "dependencyToAbiSnapshot");
        this.startTS = startTS;
        this.dependencyToAbiSnapshot = dependencyToAbiSnapshot;
    }

    public /* synthetic */ BuildInfo(long l2, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(l2, map);
    }

    public final long getStartTS() {
        return this.startTS;
    }

    @NotNull
    public final Map<String, AbiSnapshot> getDependencyToAbiSnapshot() {
        return this.dependencyToAbiSnapshot;
    }

    public final long component1() {
        return this.startTS;
    }

    @NotNull
    public final Map<String, AbiSnapshot> component2() {
        return this.dependencyToAbiSnapshot;
    }

    @NotNull
    public final BuildInfo copy(long startTS, @NotNull Map<String, ? extends AbiSnapshot> dependencyToAbiSnapshot) {
        Intrinsics.checkNotNullParameter(dependencyToAbiSnapshot, "dependencyToAbiSnapshot");
        return new BuildInfo(startTS, dependencyToAbiSnapshot);
    }

    public static /* synthetic */ BuildInfo copy$default(BuildInfo buildInfo, long l2, Map map, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l2 = buildInfo.startTS;
        }
        if ((n2 & 2) != 0) {
            map = buildInfo.dependencyToAbiSnapshot;
        }
        return buildInfo.copy(l2, map);
    }

    @NotNull
    public String toString() {
        return "BuildInfo(startTS=" + this.startTS + ", dependencyToAbiSnapshot=" + this.dependencyToAbiSnapshot + ')';
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.startTS);
        result2 = result2 * 31 + ((Object)this.dependencyToAbiSnapshot).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildInfo)) {
            return false;
        }
        BuildInfo buildInfo = (BuildInfo)other;
        if (this.startTS != buildInfo.startTS) {
            return false;
        }
        return Intrinsics.areEqual(this.dependencyToAbiSnapshot, buildInfo.dependencyToAbiSnapshot);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildInfo$Companion;", "", "<init>", "()V", "readBuildInfo", "Lorg/jetbrains/kotlin/incremental/BuildInfo;", "Ljava/io/ObjectInputStream;", "writeBuildInfo", "", "Ljava/io/ObjectOutputStream;", "buildInfo", "read", "file", "Ljava/io/File;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "write", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        private final BuildInfo readBuildInfo(ObjectInputStream $this$readBuildInfo) {
            long ts = $this$readBuildInfo.readLong();
            int size = $this$readBuildInfo.readInt();
            HashMap<String, AbiSnapshotImpl> abiSnapshots = new HashMap<String, AbiSnapshotImpl>(size);
            int n2 = 0;
            while (n2 < size) {
                int it = n2++;
                boolean bl = false;
                String identifier = $this$readBuildInfo.readUTF();
                AbiSnapshotImpl snapshot = AbiSnapshotImpl.Companion.readAbiSnapshot($this$readBuildInfo);
                abiSnapshots.put(identifier, snapshot);
            }
            return new BuildInfo(ts, (Map<String, ? extends AbiSnapshot>)abiSnapshots);
        }

        private final void writeBuildInfo(ObjectOutputStream $this$writeBuildInfo, BuildInfo buildInfo) {
            $this$writeBuildInfo.writeLong(buildInfo.getStartTS());
            $this$writeBuildInfo.writeInt(buildInfo.getDependencyToAbiSnapshot().size());
            for (Map.Entry<String, AbiSnapshot> entry : buildInfo.getDependencyToAbiSnapshot().entrySet()) {
                String identifier = entry.getKey();
                AbiSnapshot abiSnapshot2 = entry.getValue();
                $this$writeBuildInfo.writeUTF(identifier);
                AbiSnapshotImpl.Companion.writeAbiSnapshot($this$writeBuildInfo, abiSnapshot2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final BuildInfo read(@NotNull File file2, @NotNull MessageCollector messageCollector) {
            Object object;
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
            try {
                BuildInfo buildInfo;
                object = new ObjectInputStream(new FileInputStream(file2));
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl = false;
                    buildInfo = Companion.readBuildInfo(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                }
                object = buildInfo;
            }
            catch (Exception e2) {
                MessageCollectorUtilKt.reportException(messageCollector, e2, ExceptionLocation.INCREMENTAL_COMPILATION);
                object = null;
            }
            return object;
        }

        public final void write(@NotNull IncrementalCompilationContext icContext, @NotNull BuildInfo buildInfo, @NotNull File file2) {
            Intrinsics.checkNotNullParameter(icContext, "icContext");
            Intrinsics.checkNotNullParameter(buildInfo, "buildInfo");
            Intrinsics.checkNotNullParameter(file2, "file");
            CompilationTransaction compilationTransaction = icContext.getTransaction();
            Path path = file2.toPath();
            Intrinsics.checkNotNullExpressionValue(path, "toPath(...)");
            CompilationTransactionKt.write(compilationTransaction, path, () -> Companion.write$lambda$3(file2, buildInfo));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit write$lambda$3(File $file, BuildInfo $buildInfo) {
            Closeable closeable = new ObjectOutputStream(new FileOutputStream($file));
            Throwable throwable = null;
            try {
                ObjectOutputStream it = (ObjectOutputStream)closeable;
                boolean bl = false;
                Companion.writeBuildInfo(it, $buildInfo);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

