/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorBoxParameterOptimizationLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getOrCreateReplacementWithoutBoxParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isSuperCallWithBoxParameter", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "replaceCalleeIfNeeded", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6ConstructorBoxParameterOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6ConstructorBoxParameterOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,231:1\n1#2:232\n2746#3,3:233\n739#3,9:240\n238#4,4:236\n*S KotlinDebug\n*F\n+ 1 ES6ConstructorBoxParameterOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering\n*L\n95#1:233,3\n109#1:240,9\n98#1:236,4\n*E\n"})
public final class ES6ConstructorBoxParameterOptimizationLowering
implements FileLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public ES6ConstructorBoxParameterOptimizationLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (!this.context.getEs6mode()) {
            return;
        }
        irFile.transformChildren(new IrElementTransformerVoid(this){
            final /* synthetic */ ES6ConstructorBoxParameterOptimizationLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrStatement visitSimpleFunction(IrSimpleFunction declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                IrSimpleFunction irSimpleFunction = ES6ConstructorBoxParameterOptimizationLowering.access$getOrCreateReplacementWithoutBoxParameter(this.this$0, declaration);
                if (irSimpleFunction == null) {
                    irSimpleFunction = declaration;
                }
                return super.visitSimpleFunction(irSimpleFunction);
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                return super.visitCall(ES6ConstructorBoxParameterOptimizationLowering.access$replaceCalleeIfNeeded(this.this$0, expression2));
            }
        }, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction getOrCreateReplacementWithoutBoxParameter(IrSimpleFunction $this$getOrCreateReplacementWithoutBoxParameter) {
        List list;
        void $this$dropLastWhile$iv;
        IrClass constructedClass;
        block16: {
            block15: {
                boolean bl;
                block14: {
                    IrSimpleFunction irSimpleFunction = ES6ConstructorBoxParameterOptimizationLoweringKt.access$getReplacementWithoutBoxParameter($this$getOrCreateReplacementWithoutBoxParameter);
                    if (irSimpleFunction != null) {
                        IrSimpleFunction it = irSimpleFunction;
                        boolean bl2 = false;
                        return it;
                    }
                    if (!ES6ConstructorLoweringKt.isEs6ConstructorReplacement($this$getOrCreateReplacementWithoutBoxParameter)) {
                        return null;
                    }
                    constructedClass = IrUtilsKt.getParentAsClass($this$getOrCreateReplacementWithoutBoxParameter);
                    if (JsIrAttributesKt.getNeedsBoxParameter(constructedClass)) break block15;
                    Iterable $this$none$iv = $this$getOrCreateReplacementWithoutBoxParameter.getValueParameters();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            IrValueParameter it = (IrValueParameter)element$iv;
                            boolean bl3 = false;
                            if (!ES6AddBoxParameterLoweringKt.isBoxParameter(it)) continue;
                            bl = false;
                            break block14;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block16;
            }
            return null;
        }
        IrSimpleFunction original = $this$getOrCreateReplacementWithoutBoxParameter;
        Object $this$buildFun$iv = $this$getOrCreateReplacementWithoutBoxParameter.getFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
        IrFunctionBuilder $this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u242 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl = false;
        $this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u242.updateFrom(original);
        $this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u242.setName(original.getName());
        $this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u242.setReturnType(original.getReturnType());
        Object $this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244 = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        boolean bl4 = false;
        ((IrDeclarationBase)$this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244).setParent(original.getParent());
        IrDeclarationsKt.copyAttributes((IrElement)$this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244, (IrElement)original);
        $this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244.setAnnotations(original.getAnnotations());
        $this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244.setTypeParameters(original.getTypeParameters());
        ((IrFunction)$this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244).setDispatchReceiverParameter(original.getDispatchReceiverParameter());
        ((IrFunction)$this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244).setExtensionReceiverParameter(original.getExtensionReceiverParameter());
        List<IrValueParameter> $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = original.getValueParameters();
        Object object = $this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                IrValueParameter it = (IrValueParameter)iterator$iv.previous();
                boolean bl5 = false;
                if (ES6AddBoxParameterLoweringKt.isBoxParameter(it)) continue;
                list = kotlin.collections.CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        ((IrFunction)object).setValueParameters(CollectionsKt.compactIfPossible(list));
        ((IrFunction)$this$getOrCreateReplacementWithoutBoxParameter_u24lambda_u244).setBody(original.getBody());
        Object newReplacement = $this$buildFun$iv;
        ES6ConstructorBoxParameterOptimizationLoweringKt.access$setReplacementWithoutBoxParameter(original, (IrSimpleFunction)newReplacement);
        IrBody irBody = ((IrFunction)newReplacement).getBody();
        if (irBody != null) {
            irBody.transformChildren(new IrElementTransformerVoid(this, original, (IrSimpleFunction)newReplacement){
                final /* synthetic */ ES6ConstructorBoxParameterOptimizationLowering this$0;
                final /* synthetic */ IrSimpleFunction $original;
                final /* synthetic */ IrSimpleFunction $newReplacement;
                {
                    this.this$0 = $receiver;
                    this.$original = $original;
                    this.$newReplacement = $newReplacement;
                }

                public IrExpression visitWhen(IrWhen expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    return ES6AddBoxParameterLoweringKt.isBoxParameterDefaultResolution(expression2) ? IrJsUtilsKt.irEmpty(ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0)) : super.visitWhen(expression2);
                }

                public IrExpression visitReturn(IrReturn expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    return Intrinsics.areEqual(expression2.getReturnTargetSymbol(), this.$original.getSymbol()) ? (IrExpression)new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.$newReplacement.getSymbol(), expression2.getValue()) : super.visitReturn(expression2);
                }

                public IrExpression visitCall(IrCall expression2) {
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    if (ES6ConstructorBoxParameterOptimizationLowering.access$isSuperCallWithBoxParameter(this.this$0, expression2)) {
                        expression2.putValueArgument(expression2.getValueArgumentsCount() - 1, IrJsUtilsKt.getVoid(ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0)));
                    }
                    return super.visitCall(expression2);
                }
            }, null);
        }
        IrConstructor defaultConstructor = JsIrAttributesKt.getDefaultConstructorForReflection(constructedClass);
        if (defaultConstructor != null && Intrinsics.areEqual(JsIrAttributesKt.getConstructorFactory(defaultConstructor), original)) {
            JsIrAttributesKt.setConstructorFactory(defaultConstructor, (IrSimpleFunction)newReplacement);
        }
        return newReplacement;
    }

    private final boolean isSuperCallWithBoxParameter(IrCall $this$isSuperCallWithBoxParameter) {
        return Intrinsics.areEqual($this$isSuperCallWithBoxParameter.getSymbol(), this.context.getIntrinsics().getJsCreateThisSymbol()) || Intrinsics.areEqual($this$isSuperCallWithBoxParameter.getSymbol(), this.context.getIntrinsics().getJsCreateExternalThisSymbol()) || ES6ConstructorLoweringKt.isEs6ConstructorReplacement((IrDeclaration)$this$isSuperCallWithBoxParameter.getSymbol().getOwner()) && ES6AddBoxParameterLoweringKt.getBoxParameter($this$isSuperCallWithBoxParameter.getSymbol().getOwner()) != null;
    }

    private final IrCall replaceCalleeIfNeeded(IrCall $this$replaceCalleeIfNeeded) {
        IrCallImpl irCallImpl;
        IrSimpleFunction replacementWithBoxParameter = (IrSimpleFunction)$this$replaceCalleeIfNeeded.getSymbol().getOwner();
        Object object = this.getOrCreateReplacementWithoutBoxParameter(replacementWithBoxParameter);
        if (object == null || (object = ((IrSimpleFunction)object).getSymbol()) == null) {
            return $this$replaceCalleeIfNeeded;
        }
        Object replacementWithoutBoxParameter = object;
        IrCall original = $this$replaceCalleeIfNeeded;
        IrCallImpl $this$replaceCalleeIfNeeded_u24lambda_u245 = irCallImpl = BuildersKt.IrCallImpl($this$replaceCalleeIfNeeded.getStartOffset(), $this$replaceCalleeIfNeeded.getEndOffset(), $this$replaceCalleeIfNeeded.getType(), (IrSimpleFunctionSymbol)replacementWithoutBoxParameter, $this$replaceCalleeIfNeeded.getTypeArguments().size(), $this$replaceCalleeIfNeeded.getOrigin(), $this$replaceCalleeIfNeeded.getSuperQualifierSymbol());
        boolean bl = false;
        IrDeclarationsKt.copyAttributes($this$replaceCalleeIfNeeded_u24lambda_u245, (IrElement)original);
        IrExpressionsKt.copyTypeArgumentsFrom$default($this$replaceCalleeIfNeeded_u24lambda_u245, original, 0, 2, null);
        $this$replaceCalleeIfNeeded_u24lambda_u245.setDispatchReceiver(original.getDispatchReceiver());
        $this$replaceCalleeIfNeeded_u24lambda_u245.setExtensionReceiver(original.getExtensionReceiver());
        int n2 = original.getValueArgumentsCount() - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            $this$replaceCalleeIfNeeded_u24lambda_u245.putValueArgument(i2, original.getValueArgument(i2));
        }
        return irCallImpl;
    }

    public static final /* synthetic */ IrSimpleFunction access$getOrCreateReplacementWithoutBoxParameter(ES6ConstructorBoxParameterOptimizationLowering $this, IrSimpleFunction $receiver) {
        return $this.getOrCreateReplacementWithoutBoxParameter($receiver);
    }

    public static final /* synthetic */ IrCall access$replaceCalleeIfNeeded(ES6ConstructorBoxParameterOptimizationLowering $this, IrCall $receiver) {
        return $this.replaceCalleeIfNeeded($receiver);
    }

    public static final /* synthetic */ JsIrBackendContext access$getContext$p(ES6ConstructorBoxParameterOptimizationLowering $this) {
        return $this.context;
    }

    public static final /* synthetic */ boolean access$isSuperCallWithBoxParameter(ES6ConstructorBoxParameterOptimizationLowering $this, IrCall $receiver) {
        return $this.isSuperCallWithBoxParameter($receiver);
    }
}

